[![Electron Logo](https://electron.atom.io/images/electron-logo.svg)](https://electron.atom.io/)

[![Travis Build Status](https://travis-ci.org/electron/electron.svg?branch=master)](https://travis-ci.org/electron/electron)
[![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/kvxe4byi7jcxbe26/branch/master?svg=true)](https://ci.appveyor.com/project/Atom/electron)
[![devDependency Status](https://david-dm.org/electron/electron/dev-status.svg)](https://david-dm.org/electron/electron#info=devDependencies)
[![Join the Electron Community on Slack](http://atom-slack.herokuapp.com/badge.svg)](http://atom-slack.herokuapp.com/)

:memo: Available Translations: [Korean](https://github.com/electron/electron/tree/master/docs-translations/ko-KR/project/README.md) | [Simplified Chinese](https://github.com/electron/electron/tree/master/docs-translations/zh-CN/project/README.md) | [Brazilian Portuguese](https://github.com/electron/electron/tree/master/docs-translations/pt-BR/project/README.md)

O framework Electron permite escrever aplicações desktop multi-plataforma usando JavaScript, HTML e CSS. Baseia-se em [Node.js](https://nodejs.org/) e [Chromium](http://www.chromium.org) e é usado pelo [editor Atom](https://github.com/atom/atom) e muitas outras [aplicações](https://electron.atom.io/apps).

Siga [@ElectronJS](https://twitter.com/electronjs) no Twitter para anúncios importantes.

Este projeto adere ao código do Pacto do Colaborador [código de conduta](CODE_OF_CONDUCT.md). Ao participar, espera-se que você siga esse código. Por favor, reporte o comportamento inaceitável para electron@github.com.

## Downloads

Binários pré-construídos e símbolos de depuração do Electron para Linux, Windows e macOS podem ser encontrados na página de [releases](https://github.com/electron/electron/releases).

Você também pode usar [`npm`](https://docs.npmjs.com/) para instalar os binários do electron:

```sh
# Install the `electron` command globally in your $PATH
npm install electron -g

# Install as a development dependency
npm install electron --save-dev
```

### Mirrors

- [China](https://npm.taobao.org/mirrors/electron)

## Documentação

Guias de referência da API estão localizados no diretório [docs](https://github.com/electron/electron/tree/master/docs). Ele também contém documentos que descrevem como construir e contribuir para o Electron.

## Documentos Traduzidos

- [Brazilian Portuguese](https://github.com/electron/electron/tree/master/docs-translations/pt-BR)
- [Korean](https://github.com/electron/electron/tree/master/docs-translations/ko-KR)
- [Japanese](https://github.com/electron/electron/tree/master/docs-translations/jp)
- [Spanish](https://github.com/electron/electron/tree/master/docs-translations/es)
- [Simplified Chinese](https://github.com/electron/electron/tree/master/docs-translations/zh-CN)
- [Traditional Chinese](https://github.com/electron/electron/tree/master/docs-translations/zh-TW)
- [Turkish](https://github.com/electron/electron/tree/master/docs-translations/tr-TR)
- [Ukrainian](https://github.com/electron/electron/tree/master/docs-translations/uk-UA)
- [Russian](https://github.com/electron/electron/tree/master/docs-translations/ru-RU)
- [French](https://github.com/electron/electron/tree/master/docs-translations/fr-FR)

## Começo Rápido

Clone o repositório e execute o [`electron/electron-quick-start`](https://github.com/electron/electron-quick-start) para ver um pequeno aplicativo Electron em ação.

## Comunidade

Você pode fazer perguntas e interagir com a comunidade nos seguintes locais:
- [`electron`](http://discuss.atom.io/c/electron) categoria nos fóruns Atom
- `#atom-shell` canal na Freenode
- [`Atom`](http://atom-slack.herokuapp.com/) canal no Slack
- [`electron-br`](https://electron-br.slack.com) *(Brazilian Portuguese)*
- [`electron-kr`](http://www.meetup.com/electron-kr/) *(Korean)*
- [`electron-jp`](https://electron-jp-slackin.herokuapp.com/) *(Japanese)*
- [`electron-tr`](http://www.meetup.com/Electron-JS-Istanbul/) *(Turkish)*
- [`electron-id`](https://electron-id.slack.com) *(Indonesia)*

Confira [awesome-electron](https://github.com/sindresorhus/awesome-electron) para uma lista mantida pela comunidade de exemplos de aplicativos úteis, ferramentas e recursos.
