# Instruções de Build (Linux)

Siga as orientações abaixo pra fazer o build do Electron no Linux.

## Pré-requisitos

* Python 2.7.x. Algumas distribuições como CentOS 6.x ainda usam Python 2.6.x,
  então você precisa checar a sua versão do Python com `python -V`.
* Node.js v0.12.x. Há várias maneiras de instalar o Node. Você pode baixar o
  código fonte do [Node.js](http://nodejs.org) e compilar a partir dele.
  Fazer isto permite que você instale o Node no seu próprio diretório home
  como um usuário comum.
  Ou tente repositórios como [NodeSource](https://nodesource.com/blog/nodejs-v012-iojs-and-the-nodesource-linux-repositories).
* Clang 3.4 ou mais recente.
* Cabeçalhos de desenvolvimento do GTK+ e libnotify.

No Ubuntu, instale as seguintes bibliotecas:

```bash
$ sudo apt-get install build-essential clang libdbus-1-dev libgtk2.0-dev \
                       libnotify-dev libgnome-keyring-dev libgconf2-dev \
                       libasound2-dev libcap-dev libcups2-dev libxtst-dev \
                       libxss1 libnss3-dev gcc-multilib g++-multilib
```

No RHEL / CentOS, instale as seguintes bibliotecas:

```bash
$ sudo yum install clang dbus-devel gtk2-devel libnotify-devel \
                   libgnome-keyring-devel xorg-x11-server-utils libcap-devel \
                   cups-devel libXtst-devel alsa-lib-devel libXrandr-devel \
                   GConf2-devel nss-devel
```

No Fedora, instale as seguintes bibliotecas:

```bash
$ sudo dnf install clang dbus-devel gtk2-devel libnotify-devel \
                   libgnome-keyring-devel xorg-x11-server-utils libcap-devel \
                   cups-devel libXtst-devel alsa-lib-devel libXrandr-devel \
                   GConf2-devel nss-devel
```

Outras distribuições podem oferecer pacotes similares para instalação através
do gerenciador de pacotes como o pacman. Ou você pode compilar a partir do
código fonte.

## Se Você Utilizar Máquinas Virtuais Para Fazer O Build

Se você planeja fazer o build do Electron numa máquina virtual, você vai precisar
de um container de tamanho fixo de pelo menos 25 gigabytes.

## Baixando o Código

```bash
$ git clone https://github.com/electron/electron.git
```

## Bootstrapping

O script de *boostrap* irá baixar todas as dependências de build necessárias
e criar os arquivos de projeto do build. Você deve ter o Python 2.7.x para
executar o script com sucesso.
Baixar certos arquivos pode demorar bastante. Note que estamos utilizando
`ninja` para fazer o build do Electron, então não há um `Makefile` gerado.

```bash
$ cd electron
$ ./script/bootstrap.py -v
```

### Compilação Cruzada

Se você quer fazer o build para `arm`, você também deve instalar as seguintes
dependências:

```bash
$ sudo apt-get install libc6-dev-armhf-cross linux-libc-dev-armhf-cross \
                       g++-arm-linux-gnueabihf
```

E para fazer a compilação cruzada para `arm` ou `ia32`, você deve passar
o parâmetro `--target_arch` para o script `bootstrap.py`:

```bash
$ ./script/bootstrap.py -v --target_arch=arm
```

## Building

Se você quiser fazer o build para `Release` e `Debug`:

```bash
$ ./script/build.py
```

Este script irá fazer com que um executável bem pesado do Electron seja
criado no diretório `out/R`. O arquivo possui mais de 1.3 gigabytes.
Isso acontece por que o binário do Release contém símbolos de debugging.
Para reduzir o tamanho do arquivo, rode o script `create-dist.py`:

```bash
$ ./script/create-dist.py
```

Isso irá colocar uma distribuição funcional com arquivos muito menores
no diretório `dist`. Depois de rodar o script `create-dist.py`, talvez
você queira remover o binário de 1.3+ gigabytes que ainda está em `out/R`.

Você também pode fazer apenas o build de `Debug`:

```bash
$ ./script/build.py -c D
```

Depois de completar o build, você pode encontrar o binário de debug do `electron`
em `out/D`.

## Limpando

Para limpar os arquivos de build:

```bash
$ ./script/clean.py
```

## Troubleshooting

Certifique-se de que você tenha instalado todas as dependências do build.

### Error While Loading Shared Libraries: libtinfo.so.5

O `clang` prebuilt irá tentar fazer o link com `libtinfo.so.5`. Dependendo
da arquitetura do host, faça um link simbólico para o `libncurses` apropriado:

```bash
$ sudo ln -s /usr/lib/libncurses.so.5 /usr/lib/libtinfo.so.5
```

## Testes

Teste suas modificações conforme o estilo de código do projeto utilizando:

```bash
$ ./script/cpplint.py
```

Teste funcionalidade utilizando:

```bash
$ ./script/test.py
```
