# Electron 버전 관리

노련한 Node 개발자라면, `semver` (유의적 버전)에 대해 확실히 알고 있을 것입니다 -
그리고 제공된 의존성 관리 시스템은 고정된 버전 숫자 대신 견고한 가이드라인을 따릅니다.
Electron은 Node와 Chromium에 큰 의존성을 지니고 있는 만큼, 유의적 버전을 그대로
따르지 않습니다. 따라서 항상 Electron의 특정 버전을 참조해야 합니다.

버전 숫자는 다음과 같은 규칙으로 올라갑니다:

* Major: Electron API의 주요 변경 사항을 반영합니다 - 만약 `0.37.0`에서 `1.0.0`로
  업그레이드하는 경우, 애플리케이션을 업데이트해야 합니다.
* Minor: 주요 Chrome과 Node 버전의 업그레이드를 반영하거나; Electron의 중요한 변경
  사항을 반영합니다 - 만약 `1.0.0`에서 `1.1.0`로 업그레이드하는 경우, 애플리케이션은
  여전히 작동하겠지만, 약간의 업데이트가 필요할 수 있습니다.
* Patch: 새로운 기능과 버그 수정을 반영합니다 - 만약 `1.0.0`에서 `1.0.1`로
  업그레이드하는 경우, 애플리케이션은 잘 작동할 것입니다.

`electron` 또는 `electron-prebuilt`를 사용하고 있다면, Electron의 변경 사항을
확실하게 인지하고 개발자 스스로 업그레이드를 적용하기 위해 고정된 버전 숫자를 사용하는
것을 권장합니다. (`^1.1.0` 대신 `1.1.0` 사용)
