# セキュリティ・ネイティブ実行で出来ること・あなたの責任

Web開発者として、通常私たちはブラウザの強力なセキュリティ機能の恩恵を受けていますーそのため、書いたコードによる危険性は比較的小さいものです。
ウェブサイトはサンドボックス内で限定された能力のみを使用することが許されていて、また、新しく見つかったセキュリティ脆弱性に素早く対処してくれるたくさんのプログラマチームによって作られたブラウザをユーザーが使ってくれています。

Electronを使用するにあたって、「Electronはウェブブラウザではない」ということを理解するのが大切です。使い慣れたWebテクノロジで豊富な機能を持ったデスクトップアプリケーションを作ることができますが、書いたコードはより強力な力を行使することのできるものです。JavaScriptでファイルシステム・シェルなどにアクセスすることができます。これによって、高機能なネイティブアプリケーションを作ることができますが、コードが許された力に比例して、受けるセキュリティリスクも大きいものになります。

そのことを頭に入れて、信頼できないソースから得られた任意の内容を表示することは、Electronが意図しない重要なセキュリティリスクを生み出すことに注意してください。
実際、多くのElectronアプリケーション(Atom, Slack, Visual Studio Code など)は主としてローカルにあるファイルの内容(やNode integration外の信頼できる内容)を表示します。もしアプリケーション上でオンライン上から得られるコードを実行する場合、内容が悪意のあるものでないことを確認するのはあなたの責任です。


# Chromium のセキュリティ問題とアップグレード

Electronは新しいバージョンのChromiumを出来るだけ早くサポートするように努力をしてはいますが、アップグレードは数十、時には数百のファイルの編集を含む大変な左表であることを後理解ください。たくさんのリソースと貢献を受けていますが、ElectronはChromium最新版に追いついてないこともあり、数日・数週間遅れることがあります。

現在のChromiumコンポーネントのアップデートシステムは、使用できるリソースとほとんどのアプリケーションの需要を満たす、適切なバランスの場所にあると思います。我々は、Electronを使用する個々のケースに関する意見をいただきたいと思っています。この件に関するPull requestと貢献をいつでも歓迎します。


## 上記の忠告を無視した場合
リモートで得られたコードをローカルで実行した場合、セキュリティ問題が発生することになります。
例えば、ブラウザでリモートのウェブサイトを表示することを考えてみてください。
もし攻撃者がどうにかして(情報源そのものの攻撃や中間者攻撃によって)得られる内容を変更した場合、ユーザーのPC上でネイティブコードを実行できることになります。

> :warning: Node integration有効な環境で、リモートコードの読み込みと実行を行うべきではありません。代わりに、Nodeコードの実行にはローカルのファイルを使用してください。
リモートのデータの内容を表示するには`webview`を使用して、`nodeIntegration`を無効にしてください。

#### チェックリスト
このリストは、防弾チョッキのように攻撃を防げるものではないですが、最低限あなたがしなければいけないことを記載しています。

* セキュア(https)な内容のみを表示してください。
* リモートの内容を表示する全てのレンダラでNode integrationを無効にしてください (`webPreferences`を使用)
* `webSecurity`を無効にしないください。無効にすると、same-origin policyが無効になります。
* [`Content-Security-Policy`](http://www.html5rocks.com/en/tutorials/security/content-security-policy/)を定義して、スクリプトの読み込み元を制限してください。(例: `script-src 'self'`)
* [`eval`を無効にしてください。](https://github.com/nylas/N1/blob/0abc5d5defcdb057120d726b271933425b75b415/static/index.js#L6) evalは文字列をコードとして実行してしまいます。
* `allowRunningInsecureContent` を有効にしないでください。
* しっかり理解していない限りは`experimentalFeatures`や`experimentalCanvasFeatures`を有効にしないでください。
* しっかり理解していない限りは`blinkFeatures`を有効にしないでください。
* WebView: `nodeintegration`を無効にしてください。
* WebView: `disablewebsecurity`を使用しないでください。
* WebView: `allowpopups`を使用しないでください。
* WebView: `insertCSS`や`executeJavaScript`を外部のCSS/JSに使用しないでください。

再確認ですが、このリストは単にリスクを小さくするもので、リスクをなくすものではありません。もしウェブサイトを表示することが目的なら、ブラウザを使うのがより安全な選択肢です。
