# Electronのバージョン管理

もしあなたが経験豊富なNodeプログラマなら、`semver`(セマンティックバージョニング)のことはご存知でしょうし、バージョン番号をきっちり固定するのではなく、大まかな指針をパッケージの依存管理システムに指定していることと思います。ElectronはNodeとChromiumに強く依存しているので、少し難しい位置付けにあってsemverにきっちり従っていません。そのため、いつでも特定バージョンのElectronを参照しないといけません。

バージョン番号は次のルールに沿ってあげられます。

 * メジャーバージョン: ElectronのAPIに大きな変更があった時- 例えば、`0.37.0`から`1.0.0`にアップグレードした時は、あなたはアプリケーションのアップデートをしなければなりません。
 * マイナーバージョン: ChromeのメジャーバージョンまたはNodeのマイナーバージョンのアップデート、またはElectronの重大な変更 - 例えば`1.0.0`から`1.1.0`にアップグレードした時は、あなたのアプリは多分動きますが、もしかしたら少々の変更をしないといけないかもしれません。
 * パッチ: 新しい機能やバグフィックス - `1.0.0`から`1.0.1`へのアップグレードでは、あなたのアプリはそのまま動くはずです。
 
もし、`electron-prebuilt`を使用しているのであれば、Electronのすべてのアップデートが開発者であるあなたによって手動で行われることを保証するために、固定バージョンを指定(`^1.1.0`ではなく`1.1.0`)することをお勧めします。 
