Sii certo di usare la documentazione che corrisponde alla tua versione di
Electron. Il numero della versione dovrebbe fare parte dell'URL della pagina.
Se cos� non fosse, stai probabilmente utilizzando una documentazione facente
parte di una branch di sviluppo che potrebbe contenere modifiche all'API che non
sono compatibili con la tua versione di Electron. In questo caso, puoi passare a
una differente versione della documentazione dalla lista di
[versioni disponibili](https://electron.atom.io/docs/) su atom.io, o nel caso tu
stia usando l'interfaccia di GitHub, apri il menu a tendina "Switch
branches/tags" e seleziona il tag che corrisponde alla tua versione.

## FAQ

Ci sono domande che vengono chieste abbastanza spesso, quindi controlla questa
sezione prima di creare una issue:

* [Electron FAQ](faq.md)

## Guide

* [Piattaforme Supportate](tutorial/piattaforme-supportate.md)
* [Sicurezza](tutorial/sicurezza.md)
* [Versionamento Electron](tutorial/versionamento-electron.md)
* [Distribuzione dell'Applicazione](tutorial/distribuzione-applicazione.md)
* [Guida Mac App Store](tutorial/guida-mac-app-store.md)
* [Guida Windows Store](tutorial/guida-windows-store.md)
* [Packaging Applicazione](tutorial/packaging-applicazione.md)
* [Usare Moduli Node Nativi](tutorial/usare-moduli-node-nativi.md)
* [Debugging Processo Principale](tutorial/debugging-processo-principale.md)
* [Usare Selenium e WebDriver](tutorial/usare-selenium-e-webdriver.md)
* [Estensioni DevTools](tutorial/estensioni-devtools.md)
* [Usare Plugin Pepper Flash](tutorial/usare-plugin-pepper-flash.md)
* [Usare Plugin Widevine CDM](tutorial/usare-plugin-widevine-cdm.md)
* [Testare su Sistemi Headless CI (Travis, Jenkins)](tutorial/testare-su-sistemi-headless-ci.md)
* [Rendering Offscreen](tutorial/rendering-offscreen.md)

## Tutorial

* [Guida Rapida](tutorial/guida-rapida.md)
* [Integrazione Ambiente Desktop](tutorial/integrazione-ambiente-desktop.md)
* [Rilevazione Eventi Online/Offline](tutorial/eventi-online-offline.md)

## Documentazione API

* [Sinossi](api/sinossi.md)
* [Oggetto Process](api/process.md)
* [Parametri Linea di Comando Chrome Supportati](api/parametri-linea-comando-chrome.md)
* [Variabili di Ambiente](api/variabili-ambiente.md)

### Elementi personalizzati DOM:

* [Oggetto `File`](api/oggetto-file.md)
* [Tag `<webview>`](api/webview-tag.md)
* [Funzione `window.open`](api/window-open.md)

### Moduli per il Processo Main:

* [app](api/app.md)
* [autoUpdater](api/auto-updater.md)
* [BrowserWindow](api/browser-window.md)
* [contentTracing](api/content-tracing.md)
* [dialog](api/dialog.md)
* [globalShortcut](api/global-shortcut.md)
* [ipcMain](api/ipc-main.md)
* [Menu](api/menu.md)
* [MenuItem](api/menu-item.md)
* [powerMonitor](api/power-monitor.md)
* [powerSaveBlocker](api/power-save-blocker.md)
* [protocol](api/protocol.md)
* [session](api/session.md)
* [systemPreferences](api/system-preferences.md)
* [Tray](api/tray.md)
* [webContents](api/web-contents.md)

### Moduli per il Processo di Rendering (Pagina Web):

* [desktopCapturer](api/desktop-capturer.md)
* [ipcRenderer](api/ipc-renderer.md)
* [remote](api/remote.md)
* [webFrame](api/web-frame.md)

### Moduli per Entrambi i Processi:

* [clipboard](api/clipboard.md)
* [crashReporter](api/crash-reporter.md)
* [nativeImage](api/native-image.md)
* [screen](api/screen.md)
* [shell](api/shell.md)

## Sviluppo

* [Stile Codice](development/stile-codice.md)
* [Struttura Cartella Codice Sorgente](development/struttura-cartella-codice-sorgente.md)
* [Differenze Tecniche da NW.js (precedentemente node-webkit)](development/atom-shell-vs-node-webkit.md)
* [Panoramica Sistema di Build](development/panoramica-sistema-build.md)
* [Istruzioni Build (macOS)](development/istruzioni-build-macos.md)
* [Istruzioni Build (Windows)](development/istruzioni-build-windows.md)
* [Istruzioni Build (Linux)](development/istruzioni-build-linux.md)
* [Istruzioni Debug (macOS)](development/istruzioni-debug-macos.md)
* [Istruzioni Debug (Windows)](development/istruzioni-debug-windows.md)
* [Impostare Symbol Server nel debugger](development/impostare-symbol-server.md)
