[![Electron Logo](https://electron.atom.io/images/electron-logo.svg)](https://electron.atom.io/)

[![Travis Build Status](https://travis-ci.org/electron/electron.svg?branch=master)](https://travis-ci.org/electron/electron)
[![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/kvxe4byi7jcxbe26/branch/master?svg=true)](https://ci.appveyor.com/project/Atom/electron)
[![devDependency Status](https://david-dm.org/electron/electron/dev-status.svg)](https://david-dm.org/electron/electron?type=dev)
[![Join the Electron Community on Slack](http://atom-slack.herokuapp.com/badge.svg)](http://atom-slack.herokuapp.com/)

:memo: Traducciones disponibles: [Koreano](https://github.com/electron/electron/tree/master/docs-translations/ko-KR/project/README.md) | [Chino Simplificado](https://github.com/electron/electron/tree/master/docs-translations/zh-CN/project/README.md) | [Portugués Brasileño](https://github.com/electron/electron/tree/master/docs-translations/pt-BR/project/README.md) | [Chino Tradicional](https://github.com/electron/electron/tree/master/docs-translations/zh-TW/project/README.md)

Electron es un framework que permite escribir aplicaciones de escritorio multiplataforma 
usando JavaScript, HTML y CSS. Está basado en [Node.js](https://nodejs.org/) con 
[Chromium](http://www.chromium.org). Es usado por [Atom
editor](https://github.com/atom/atom) y muchas otras [aplicaciones](https://electron.atom.io/apps).

Sigue a [@ElectronJS](https://twitter.com/electronjs) en Twitter para estar informado de anuncios 
importantes.

Este proyecto se adhiere al [Código de Conducta convenido para Colaboradores](CODE_OF_CONDUCT.md).
Si desea participar, debes seguir este código de conducta. Por favor reporta un comportamiento
no aceptado a electron@github.com.

## Downloads

Para instalar binarios precompilados, usa
[`npm`](https://docs.npmjs.com/):

```sh
# Instalación de las dependencias de desarrollo
npm install electron --save-dev

# Instalación de `electron` de manera global a tu $PATH
npm install electron -g
```

Mira la [página de lanzamientos](https://github.com/electron/electron/releases) para
los prebuilt binaries, debug symbols, y más.

### Mirrors

- [China](https://npm.taobao.org/mirrors/electron)

## Documentación

Las guías y API de referencia están disponibles en el directorio 
[docs](https://github.com/electron/electron/tree/master/docs). Ahí también
puedes encontrar documentos que describen cómo construir y contribuir en Electron.

## Traducciones de la Documentación

- [Portugués Brasileño](https://github.com/electron/electron/tree/master/docs-translations/pt-BR)
- [Koreano](https://github.com/electron/electron/tree/master/docs-translations/ko-KR)
- [Japonés](https://github.com/electron/electron/tree/master/docs-translations/jp)
- [Español](https://github.com/electron/electron/tree/master/docs-translations/es)
- [Chino Simplificado](https://github.com/electron/electron/tree/master/docs-translations/zh-CN)
- [Chino Tradicional](https://github.com/electron/electron/tree/master/docs-translations/zh-TW)
- [Turco](https://github.com/electron/electron/tree/master/docs-translations/tr-TR)
- [Thai](https://github.com/electron/electron/tree/master/docs-Translations/th-TH)
- [Ucraniano](https://github.com/electron/electron/tree/master/docs-translations/uk-UA)
- [Ruso](https://github.com/electron/electron/tree/master/docs-translations/ru-RU)
- [Francés](https://github.com/electron/electron/tree/master/docs-translations/fr-FR)

## Inicio rápido

Clona y ejecuta el repositorio [`electron/electron-quick-start`](https://github.com/electron/electron-quick-start)
para ver una aplicación mínima en acción.

## Comunidad

Puedes preguntar y interactuar con la comunidad en los siguientes lugares:
- [`electron`](http://discuss.atom.io/c/electron) Categoría en los Foros de 
Atom.
- `#atom-shell` canal de IRC en Freenode
- [`Atom`](http://atom-slack.herokuapp.com/) canales en Slack
- [`electron-br`](https://electron-br.slack.com) *(Portugués Brasileño)*
- [`electron-kr`](http://www.meetup.com/electron-kr/) *(Koreano)*
- [`electron-jp`](https://electron-jp.slack.com) *(Japonés)*
- [`electron-tr`](http://www.meetup.com/Electron-JS-Istanbul/) *(Turco)*
- [`electron-id`](https://electron-id.slack.com) *(Indonés*

Mira [awesome-electron](https://github.com/sindresorhus/awesome-electron)
donde la comunidad mantiene una lista útil de ejemplos de aplicaciones, herramientas y recursos.

## Licencia

[MIT](https://github.com/electron/electron/blob/master/LICENSE)

Si usas los logos de Electron ó GitHub, asegúrate de seguir las [GitHub logo guidelines](https://github.com/logos).
