# Copyright 2013-2020 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class Swarm(MakefilePackage):
    """A robust and fast clustering method for amplicon-based studies."""

    homepage = "https://github.com/torognes/swarm"
    url      = "https://github.com/torognes/swarm/archive/v2.1.13.tar.gz"

    version('2.1.13', sha256='ec4b22cc1874ec6d2c89fe98e23a2fb713aec500bc4a784f0556389d22c02650')

    build_directory = 'src'

    def install(self, spec, prefix):
        install_tree('bin', prefix.bin)
        install_tree('scripts', prefix.scripts)
        install_tree('man', prefix.share.man)
