# Copyright 2013-2020 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class Kbproto(AutotoolsPackage):
    """X Keyboard Extension.

    This extension defines a protcol to provide a number of new capabilities
    and controls for text keyboards."""

    homepage = "https://cgit.freedesktop.org/xorg/proto/kbproto"
    url      = "https://www.x.org/archive/individual/proto/kbproto-1.0.7.tar.gz"

    version('1.0.7', sha256='828cb275b91268b1a3ea950d5c0c5eb076c678fdf005d517411f89cc8c3bb416')

    depends_on('pkgconfig', type='build')
    depends_on('util-macros', type='build')
