# Copyright 2013-2019 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class Rsync(AutotoolsPackage):
    """An open source utility that provides fast incremental file transfer."""
    homepage = "https://rsync.samba.org"
    url      = "https://download.samba.org/pub/rsync/src/rsync-3.1.2.tar.gz"

    version('3.1.3', sha256='55cc554efec5fdaad70de921cd5a5eeb6c29a95524c715f3bbf849235b0800c0')
    version('3.1.2', sha256='ecfa62a7fa3c4c18b9eccd8c16eaddee4bd308a76ea50b5c02a5840f09c0a1c2')
    version('3.1.1', sha256='7de4364fcf5fe42f3bdb514417f1c40d10bbca896abe7e7f2c581c6ea08a2621')
