# Copyright 2013-2019 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class Readline(AutotoolsPackage):
    """The GNU Readline library provides a set of functions for use by
    applications that allow users to edit command lines as they are typed in.
    Both Emacs and vi editing modes are available. The Readline library
    includes additional functions to maintain a list of previously-entered
    command lines, to recall and perhaps reedit those lines, and perform
    csh-like history expansion on previous commands."""

    homepage = "http://cnswww.cns.cwru.edu/php/chet/readline/rltop.html"
    # URL must remain http:// so Spack can bootstrap curl
    url      = "http://ftpmirror.gnu.org/readline/readline-8.0.tar.gz"

    version('8.0', sha256='e339f51971478d369f8a053a330a190781acb9864cf4c541060f12078948e461')
    version('7.0', sha256='750d437185286f40a369e1e4f4764eda932b9459b5ec9a731628393dd3d32334')
    version('6.3', sha256='56ba6071b9462f980c5a72ab0023893b65ba6debb4eeb475d7a563dc65cafd43')

    depends_on('ncurses')
    # from url=http://www.linuxfromscratch.org/patches/downloads/readline/readline-6.3-upstream_fixes-1.patch
    # this fixes a bug that could lead to seg faults in ipython
    patch('readline-6.3-upstream_fixes-1.patch', when='@6.3')

    def build(self, spec, prefix):
        options = [
            'SHLIB_LIBS=-L{0} -lncursesw'.format(spec['ncurses'].prefix.lib)
        ]

        make(*options)
