# Copyright 2013-2019 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class PyFuture(PythonPackage):
    """Clean single-source support for Python 3 and 2"""

    homepage = "https://python-future.org/"
    url = "https://pypi.io/packages/source/f/future/future-0.16.0.tar.gz"

    version('0.17.1', sha256='67045236dcfd6816dc439556d009594abf643e5eb48992e36beac09c2ca659b8')
    version('0.17.0', sha256='eb6d4df04f1fb538c99f69c9a28b255d1ee4e825d479b9c62fc38c0cf38065a4')
    version('0.16.0', sha256='e39ced1ab767b5936646cedba8bcce582398233d6a627067d4c6a454c90cfedb')
    version('0.15.2', sha256='3d3b193f20ca62ba7d8782589922878820d0a023b885882deec830adbf639b97')

    depends_on('py-setuptools', type='build')
    depends_on('py-importlib', type=('build', 'run'), when='^python@:2.6')
    depends_on('py-argparse', type=('build', 'run'), when='^python@:2.6')
