# Copyright 2013-2018 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class RAffxparser(RPackage):
    """Package for parsing Affymetrix files (CDF, CEL, CHP, BPMAP, BAR).
    It provides methods for fast and memory efficient parsing of
    Affymetrix files using the Affymetrix' Fusion SDK. Both ASCII-
    and binary-based files are supported. Currently, there are methods
    for reading chip definition file (CDF) and a cell intensity file (CEL).
    These files can be read either in full or in part. For example,
    probe signals from a few probesets can be extracted very quickly
    from a set of CEL files into a convenient list structure."""

    homepage = "https://www.bioconductor.org/packages/affxparser/"
    git      = "https://git.bioconductor.org/packages/affxparser.git"

    version('1.48.0', commit='2461ea88f310b59c4a9a997a4b3dadedbd65a4aa')

    depends_on('r@3.4.0:3.4.9', when='@1.48.0')
