# Copyright 2013-2018 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class PyCertifi(PythonPackage):
    """Certifi: A carefully curated collection of Root Certificates for validating
    the trustworthiness of SSL certificates while verifying the identity of TLS
    hosts."""
    homepage = "http://certifi.io/"
    url      = "https://pypi.io/packages/source/c/certifi/certifi-2017.1.23.tar.gz"

    import_modules = ['certifi']

    version('2017.1.23',  'b72521a8badff5e89a8eabea586d79ab')
    version('2016.02.28', '5ccfc23bd5e931863f0b01ef3e9d2dbd3bef0e1b')

    depends_on('py-setuptools', type='build')
