# Copyright 2013-2018 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class Maq(AutotoolsPackage):
    """Maq is a software that builds mapping assemblies from short reads
       generated by the next-generation sequencing machines."""

    homepage = "http://maq.sourceforge.net/"
    url      = "https://downloads.sourceforge.net/project/maq/maq/0.7.1/maq-0.7.1.tar.bz2"
    list_url = "https://sourceforge.net/projects/maq/files/maq/"

    version('0.7.1', '51130f6c8257c133719adacdd1433f35')
    version('0.5.0', '854e2bee32d5237236d4c68c0ed7c52d')

    conflicts('%gcc@4.7.0:', when='@0.7.1')
