# Copyright 2013-2018 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class Halc(MakefilePackage):
    """HALC is software that makes error correction for long reads with
     high throughput."""

    homepage = "https://github.com/lanl001/halc"
    url      = "https://github.com/lanl001/halc/archive/v1.1.tar.gz"

    version('1.1', '4b289b366f6a5400ca481993aa68dd9c')

    depends_on('blasr', type='run')
    depends_on('lordec', type='run')
    depends_on('dos2unix', type='build')
    depends_on('python', type='run')

    parallel = False

    def install(self, spec, prefix):
        install_tree('bin', prefix.bin)
        install('runHALC.py', prefix.bin)
        dos2unix = which('dos2unix')
        dos2unix(join_path(self.prefix.bin, 'runHALC.py'))
