# Copyright 2013-2018 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

#
# Based on Homebrew's formula:
# https://github.com/Homebrew/homebrew-core/blob/master/Formula/cask.rb
#
from spack import *
from glob import glob


class Cask(Package):
    """Cask is a project management tool for Emacs Lisp to automate the package
       development cycle; development, dependencies, testing, building,
       packaging and more."""
    homepage = "http://cask.readthedocs.io/en/latest/"
    url      = "https://github.com/cask/cask/archive/v0.7.4.tar.gz"

    version('0.8.1', '25196468a7ce634cfff14733678be6ba')
    # version 0.8.0 is broken
    version('0.7.4', 'c973a7db43bc980dd83759a5864a1260')

    depends_on('emacs', type=('build', 'run'))

    def install(self, spec, prefix):
        mkdirp(prefix.bin)
        install('bin/cask', prefix.bin)
        install_tree('templates', join_path(prefix, 'templates'))
        for el_file in glob("*.el"):
            install(el_file, prefix)
        for misc_file in ['COPYING', 'cask.png', 'README.md']:
            install(misc_file, prefix)
        # disable cask's automatic upgrading feature
        touch(join_path(prefix, ".no-upgrade"))
