﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Windows.Forms
{
    /// <summary>
    ///  Specifies how items in a list are sorted.
    /// </summary>
    public enum SortOrder
    {
        /// <summary>
        ///  The items are not sorted.
        /// </summary>
        None = 0,

        /// <summary>
        ///  The items are sorted in ascending order.
        /// </summary>
        Ascending = 1,

        /// <summary>
        ///  The items are sorted in descending order.
        /// </summary>
        Descending = 2,
    }
}
