﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Windows.Forms
{
    /// <summary>
    ///  Describes the set of locations that an error icon can appear in
    ///  relation to the control with the error.
    /// </summary>
    public enum ErrorIconAlignment
    {
        /// <summary>
        ///  The icon appears aligned with the top of the control, and to the
        ///  left of the control.
        /// </summary>
        TopLeft,

        /// <summary>
        ///  The icon appears aligned with the top of the control, and to the
        ///  right of the control.
        /// </summary>
        TopRight,

        /// <summary>
        ///  The icon appears aligned with the middle of the control, and the
        ///  left of the control.
        /// </summary>
        MiddleLeft,

        /// <summary>
        ///  The icon appears aligned with the middle of the control, and the
        ///  right of the control.
        /// </summary>
        MiddleRight,

        /// <summary>
        ///  The icon appears aligned with the bottom of the control, and the
        ///  left of the control.
        /// </summary>
        BottomLeft,

        /// <summary>
        ///  The icon appears aligned with the bottom of the control, and the
        ///  right of the control.
        /// </summary>
        BottomRight
    }
}
