/**
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.jboss.forge.addon.resource;

/**
 * Defines the mechanism for registering new {@link Resource} types.
 * 
 * @author <a href="mailto:lincolnbaxter@gmail.com">Lincoln Baxter, III</a>
 * 
 * @param <RESOURCETYPE> The {@link Resource} type generated by this implementation.
 * @param <UNDERLYINGTYPE> The {@link Class} type of underlying object handled by {@link Resource} instances produced by
 *           this implementation.
 */
public interface ResourceGenerator<RESOURCETYPE, UNDERLYINGTYPE>
{
   /**
    * Returns true if the given object instance and {@link Class} type are handled by this {@link ResourceGenerator}
    */
   public boolean handles(Class<?> type, final Object resource);

   /**
    * Get an instance of a {@link Resource} to handle the given {@link Class} type and object instance.
    */
   public <T extends Resource<UNDERLYINGTYPE>> T getResource(final ResourceFactory factory, Class<RESOURCETYPE> type,
            final UNDERLYINGTYPE resource);

   /**
    * Get the {@link Resource} type that will be generated for the given {@link Class} type and object instance.
    * @param factory TODO
    */
   public <T extends Resource<UNDERLYINGTYPE>> Class<?> getResourceType(ResourceFactory factory,
            Class<RESOURCETYPE> type, final UNDERLYINGTYPE resource);

}