/**
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.jboss.forge.addon.templates;

import org.jboss.forge.addon.resource.Resource;

/**
 * Generator for {@link Template} instances.
 * 
 * @author <a href="ggastald@redhat.com">George Gastaldi</a>
 * @author <a href="mailto:lincolnbaxter@gmail.com">Lincoln Baxter, III</a>
 */
public interface TemplateGenerator
{
   /**
    * Returns <code>true</code> if the given template can be generated by this {@link TemplateGenerator}
    */
   public boolean handles(Class<? extends Template> type);

   /**
    * Returns a {@link Template} instance for the requested {@link Resource} and template {@link Class} type.
    */
   public Template create(Resource<?> template, Class<? extends Template> type);
}
