/**
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.jboss.forge.addon.maven.archetype;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.forge.arquillian.AddonDependencies;
import org.jboss.forge.arquillian.AddonDependency;
import org.jboss.forge.arquillian.archive.AddonArchive;
import org.jboss.forge.furnace.container.simple.Service;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * 
 * @author <a href="ggastald@redhat.com">George Gastaldi</a>
 */
@RunWith(Arquillian.class)
public class EmptyArchetypeRegistryTest
{
   @Deployment
   @AddonDependencies({
            @AddonDependency(name = "org.jboss.forge.addon:projects"),
            @AddonDependency(name = "org.jboss.forge.addon:maven"),
            @AddonDependency(name = "org.jboss.forge.furnace.container:simple")
   })
   public static AddonArchive getDeployment()
   {
      AddonArchive archive = ShrinkWrap
               .create(AddonArchive.class)
               .addClass(TestArchetypeCatalogFactory.class)
               .addAsServiceProvider(Service.class, EmptyArchetypeRegistryTest.class);

      return archive;
   }

   private ArchetypeCatalogFactoryRegistry archetypeRegistry;

   @Before
   public void setUp()
   {
      archetypeRegistry = SimpleContainer
               .getServices(getClass().getClassLoader(), ArchetypeCatalogFactoryRegistry.class).get();
   }

   @Test
   public void testDoesNotHaveArchetypeCatalogFactories()
   {
      Assert.assertFalse(archetypeRegistry.hasArchetypeCatalogFactories());
   }
}
