/**
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.jboss.forge.addon.devtools.java;

import javax.inject.Inject;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.forge.arquillian.AddonDependencies;
import org.jboss.forge.arquillian.archive.AddonArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(Arquillian.class)
public class DevToolsPresenceTest
{
   @Deployment
   @AddonDependencies
   public static AddonArchive getDeployment()
   {
      AddonArchive archive = ShrinkWrap.create(AddonArchive.class)
               .addBeansXML();

      return archive;
   }

   @Inject
   private RegisterAsServiceCommand command;

   @Inject
   private JavaEqualsHashcodeCommand ehCommand;

   @Test
   public void testCommandInjection() throws Exception
   {
      Assert.assertNotNull(command);
      Assert.assertNotNull(command.toString());

      Assert.assertNotNull(ehCommand);
      Assert.assertNotNull(ehCommand.toString());
   }
}