---
title: Azure ML Service
---

# Microsoft Azure Machine Learning Service

A collection of tasks for interacting with Azure Machine Learning Service resources.

## DatasetCreateFromDelimitedFiles <Badge text="task"/>

Task for creating a TabularDataset from delimited files for use in a Azure Machine Learning service Workspace.

[API Reference](/api/latest/tasks/azureml.html#prefect-tasks-azureml-dataset-datasetcreatefromdelimitedfiles)

## DatasetCreateFromParquetFiles <Badge text="task"/>

Task for creating a TabularDataset from Parquet files for use in a Azure Machine Learning service Workspace. 

[API Reference](/api/latest/tasks/azureml.html#prefect-tasks-azureml-dataset-datasetcreatefromparquetfiles)

## DatasetCreateFromFiles <Badge text="task"/>

Task for creating a FileDataset from files for use in a Azure Machine Learning service Workspace.

[API Reference](/api/latest/tasks/azureml.html#prefect-tasks-azureml-dataset-datasetcreatefromfiles)


## DatastoreRegisterBlobContainer <Badge text="task"/>

Task for registering Azure Blob Storage container as a Datastore in a Azure ML service Workspace. 

[API Reference](/api/latest/tasks/azureml.html#prefect-tasks-azureml-datastore-datastoreregisterblobcontainer)


## DatastoreList <Badge text="task"/>

Task for listing the Datastores in a Workspace.

[API Reference](/api/latest/tasks/azureml.html#prefect-tasks-azureml-datastore-datastorelist)

## DatastoreGet <Badge text="task"/>

Task for getting a Datastore registered to a given Workspace.

[API Reference](/api/latest/tasks/azureml.html#prefect-tasks-azureml-datastore-datastoreget)


## DatastoreUpload <Badge text="task"/>

Task for uploading local files to a Datastore.

[API Reference](/api/latest/tasks/azureml.html#prefect-tasks-azureml-datastore-datastoreupload)
