---
sidebarDepth: 2
editLink: false
---
# Agent
---
 ## Agent
 <div class='class-sig' id='prefect-agent-agent-agent'><p class="prefect-sig">class </p><p class="prefect-class">prefect.agent.agent.Agent</p>(name=None, labels=None, env_vars=None, max_polls=None, agent_address=None, no_cloud_logs=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L77">[source]</a></span></div>

Base class for Agents. Information on using the Prefect agents can be found at https://docs.prefect.io/orchestration/agents/overview.html

This Agent class is a standard point for executing Flows in Prefect Cloud. It is meant to have subclasses which inherit functionality from this class. The only piece that the subclasses should implement is the `deploy_flows` function, which specifies how to run a Flow on the given platform. It is built in this way to keep Prefect Cloud logic standard but allows for platform specific customizability.

In order for this to operate `PREFECT__CLOUD__AGENT__AUTH_TOKEN` must be set as an environment variable or in your user configuration file.

**Args**:     <ul class="args"><li class="args">`name (str, optional)`: An optional name to give this agent. Can also be set through         the environment variable `PREFECT__CLOUD__AGENT__NAME`. Defaults to "agent"     </li><li class="args">`labels (List[str], optional)`: a list of labels, which are arbitrary string         identifiers used by Prefect Agents when polling for work     </li><li class="args">`env_vars (dict, optional)`: a dictionary of environment variables and values that will         be set on each flow run that this agent submits for execution     </li><li class="args">`max_polls (int, optional)`: maximum number of times the agent will poll Prefect Cloud         for flow runs; defaults to infinite     </li><li class="args">`agent_address (str, optional)`: Address to serve internal api at. Currently this is         just health checks for use by an orchestration layer. Leave blank for no api server         (default).     </li><li class="args">`no_cloud_logs (bool, optional)`: Disable logging to a Prefect backend for this agent         and all deployed flow runs</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-agent-agent-agent-agent-connect'><p class="prefect-class">prefect.agent.agent.Agent.agent_connect</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L308">[source]</a></span></div>
<p class="methods">Verify agent connection to Prefect API by querying</p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-agent-process'><p class="prefect-class">prefect.agent.agent.Agent.agent_process</p>(executor)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L397">[source]</a></span></div>
<p class="methods">Full process for finding flow runs, updating states, and deploying.<br><br>**Args**:     <ul class="args"><li class="args">`executor (ThreadPoolExecutor)`: the interface to submit flow deployments in         background threads</li></ul>**Returns**:     <ul class="args"><li class="args">`bool`: whether or not flow runs were found</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-cleanup'><p class="prefect-class">prefect.agent.agent.Agent.cleanup</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L277">[source]</a></span></div>
<p class="methods"></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-deploy-and-update-flow-run'><p class="prefect-class">prefect.agent.agent.Agent.deploy_and_update_flow_run</p>(flow_run)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L333">[source]</a></span></div>
<p class="methods">Deploy a flow run and update Cloud with the resulting deployment info. If any errors occur when submitting the flow run, capture the error and log to Cloud.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run (GraphQLResult)`: The specific flow run to deploy</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-deploy-flow'><p class="prefect-class">prefect.agent.agent.Agent.deploy_flow</p>(flow_run)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L599">[source]</a></span></div>
<p class="methods">Meant to be overridden by a platform specific deployment option<br><br>**Args**:     <ul class="args"><li class="args">`flow_run (GraphQLResult)`: A GraphQLResult flow run object</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: Information about the deployment</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if deployment attempted on unsupported Storage type</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-heartbeat'><p class="prefect-class">prefect.agent.agent.Agent.heartbeat</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L614">[source]</a></span></div>
<p class="methods">Meant to be overridden by a platform specific heartbeat option</p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-mark-failed'><p class="prefect-class">prefect.agent.agent.Agent.mark_failed</p>(flow_run, exc)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L583">[source]</a></span></div>
<p class="methods">Mark a flow run as `Failed`<br><br>**Args**:     <ul class="args"><li class="args">`flow_run (GraphQLResult)`: A GraphQLResult flow run object     </li><li class="args">`exc (Exception)`: An exception that was raised to use as the `Failed`         message</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-on-flow-run-deploy-attempt'><p class="prefect-class">prefect.agent.agent.Agent.on_flow_run_deploy_attempt</p>(fut, flow_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L381">[source]</a></span></div>
<p class="methods">Indicates that a flow run deployment has been deployed (successfully or otherwise). This is intended to be a future callback hook, called in the agent's main thread when the background thread has completed the deploy_and_update_flow_run() call, either successfully, in error, or cancelled. In all cases the agent should be open to attempting to deploy the flow run if the flow run id is still in the Cloud run queue.<br><br>**Args**:     <ul class="args"><li class="args">`fut (Future)`: a callback requirement, the future which has completed or been         cancelled.     </li><li class="args">`flow_run_id (str)`: the id of the flow run that the future represents.</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-on-shutdown'><p class="prefect-class">prefect.agent.agent.Agent.on_shutdown</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L302">[source]</a></span></div>
<p class="methods">Invoked when the event loop is exiting and the agent is shutting down. Intended as a hook for child classes to optionally implement.</p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-query-flow-runs'><p class="prefect-class">prefect.agent.agent.Agent.query_flow_runs</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L433">[source]</a></span></div>
<p class="methods">Query Prefect Cloud for flow runs which need to be deployed and executed<br><br>**Returns**:     <ul class="args"><li class="args">`list`: A list of GraphQLResult flow run objects</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-setup'><p class="prefect-class">prefect.agent.agent.Agent.setup</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L251">[source]</a></span></div>
<p class="methods"></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-start'><p class="prefect-class">prefect.agent.agent.Agent.start</p>(_loop_intervals=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L188">[source]</a></span></div>
<p class="methods">The main entrypoint to the agent. This function loops and constantly polls for new flow runs to deploy<br><br>**Args**:     <ul class="args"><li class="args">`_loop_intervals (dict, optional)`: Exposed for testing only.</li></ul></p>|
 | <div class='method-sig' id='prefect-agent-agent-agent-update-state'><p class="prefect-class">prefect.agent.agent.Agent.update_state</p>(flow_run)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L536">[source]</a></span></div>
<p class="methods">After a flow run is grabbed this function sets the state to Submitted so it won't be picked up by any other processes<br><br>**Args**:     <ul class="args"><li class="args">`flow_run (GraphQLResult)`: A GraphQLResult flow run object</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on August 6, 2020 at 13:56 UTC</p>