---
sidebarDepth: 2
editLink: false
---
# Google Cloud Tasks
---
Tasks that interface with various components of Google Cloud Platform.

Note that these tasks allow for a wide range of custom usage patterns, such as:

- Initialize a task with all settings for one time use
- Initialize a "template" task with default settings and override as needed
- Create a custom Task that inherits from a Prefect Task and utilizes the Prefect boilerplate
 ## GCSDownload
 <div class='class-sig' id='prefect-tasks-gcp-storage-gcsdownload'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.gcp.storage.GCSDownload</p>(bucket, blob=None, project=None, credentials_secret=None, encryption_key_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/storage.py#L95">[source]</a></span></div>

Task template for downloading data from Google Cloud Storage as a string.

**Args**:     <ul class="args"><li class="args">`bucket (str)`: default bucket name to download from     </li><li class="args">`blob (str, optional)`: default blob name to download.     </li><li class="args">`project (str, optional)`: default Google Cloud project to work within.         If not provided, will be inferred from your Google Cloud credentials     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         which stores a JSON representation of your Google Cloud credentials.     </li><li class="args">`encryption_key_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         storing an optional `encryption_key` to be used when downloading the Blob     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>Note that the design of this task allows you to initialize a _template_ with default settings.  Each inidividual occurence of the task in a Flow can overwrite any of these default settings for custom use (for example, if you want to pull different credentials for a given Task, or specify the Blob name at runtime).

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-gcp-storage-gcsdownload-run'><p class="prefect-class">prefect.tasks.gcp.storage.GCSDownload.run</p>(bucket=None, blob=None, project=None, credentials=None, encryption_key=None, credentials_secret=None, encryption_key_secret=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/storage.py#L133">[source]</a></span></div>
<p class="methods">Run method for this Task.  Invoked by _calling_ this Task after initialization within a Flow context.<br><br>Note that some arguments are required for the task to run, and must be provided _either_ at initialization _or_ as arguments.<br><br>**Args**:     <ul class="args"><li class="args">`bucket (str, optional)`: the bucket name to upload to     </li><li class="args">`blob (str, optional)`: blob name to download from     </li><li class="args">`project (str, optional)`: Google Cloud project to work within.         If not provided here or at initialization, will be inferred from your Google Cloud credentials     </li><li class="args">`credentials (dict, optional)`: a JSON document containing Google Cloud credentials.         You should provide these at runtime with an upstream Secret task.     </li><li class="args">`encryption_key (str, optional)`: an encryption key     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         that stores a JSON represenation of your Google Cloud credentials     </li><li class="args">`encryption_key_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         storing an optional `encryption_key` to be used when uploading the Blob</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the data from the blob, as a string</li></ul>**Raises**:     <ul class="args"><li class="args">`google.cloud.exception.NotFound`: if `create_bucket=False` and the bucket         name is not found     </li><li class="args">`ValueError`: if `blob` name hasn't been provided</li></ul></p>|

---
<br>

 ## GCSUpload
 <div class='class-sig' id='prefect-tasks-gcp-storage-gcsupload'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.gcp.storage.GCSUpload</p>(bucket, blob=None, project=None, credentials_secret=None, create_bucket=False, encryption_key_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/storage.py#L196">[source]</a></span></div>

Task template for uploading data to Google Cloud Storage.  Requires the data already be a string.

**Args**:     <ul class="args"><li class="args">`bucket (str)`: default bucket name to upload to     </li><li class="args">`blob (str, optional)`: default blob name to upload to; otherwise a random string         beginning with `prefect-` and containing the Task Run ID will be used     </li><li class="args">`project (str, optional)`: default Google Cloud project to work within.         If not provided, will be inferred from your Google Cloud credentials     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         which stores a JSON represenation of your Google Cloud credentials.     </li><li class="args">`create_bucket (bool, optional)`: boolean specifying whether to create the bucket if it does not exist,         otherwise an Exception is raised. Defaults to `False`.     </li><li class="args">`encryption_key_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         storing an optional `encryption_key` to be used when uploading the Blob     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>Note that the design of this task allows you to initialize a _template_ with default settings.  Each inidividual occurence of the task in a Flow can overwrite any of these default settings for custom use (for example, if you want to pull different credentials for a given Task, or specify the Blob name at runtime).

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-gcp-storage-gcsupload-run'><p class="prefect-class">prefect.tasks.gcp.storage.GCSUpload.run</p>(data, bucket=None, blob=None, project=None, credentials=None, encryption_key=None, credentials_secret=None, create_bucket=False, encryption_key_secret=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/storage.py#L241">[source]</a></span></div>
<p class="methods">Run method for this Task.  Invoked by _calling_ this Task after initialization within a Flow context.<br><br>Note that some arguments are required for the task to run, and must be provided _either_ at initialization _or_ as arguments.<br><br>**Args**:     <ul class="args"><li class="args">`data (str)`: the data to upload; must already be represented as a string     </li><li class="args">`bucket (str, optional)`: the bucket name to upload to     </li><li class="args">`blob (str, optional)`: blob name to upload to         a string beginning with `prefect-` and containing the Task Run ID will be used     </li><li class="args">`project (str, optional)`: Google Cloud project to work within. Can be inferred         from credentials if not provided.     </li><li class="args">`credentials (dict, optional)`: a JSON document containing Google Cloud credentials.         You should provide these at runtime with an upstream Secret task.     </li><li class="args">`encryption_key (str, optional)`: an encryption key     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         that stores a JSON represenation of your Google Cloud credentials     </li><li class="args">`create_bucket (bool, optional)`: boolean specifying whether to create the bucket         if it does not exist, otherwise an Exception is raised. Defaults to `False`.     </li><li class="args">`encryption_key_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         storing an optional `encryption_key` to be used when uploading the Blob.</li></ul>**Raises**:     <ul class="args"><li class="args">`google.cloud.exception.NotFound`: if `create_bucket=False` and the bucket name is not found</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the blob name that now stores the provided data</li></ul></p>|

---
<br>

 ## GCSCopy
 <div class='class-sig' id='prefect-tasks-gcp-storage-gcscopy'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.gcp.storage.GCSCopy</p>(source_bucket=None, source_blob=None, dest_bucket=None, dest_blob=None, project=None, credentials_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/storage.py#L312">[source]</a></span></div>

Task template for copying data from one Google Cloud Storage bucket to another, without downloading it locally.

Note that some arguments are required for the task to run, and must be provided _either_ at initialization _or_ as arguments.

**Args**:     <ul class="args"><li class="args">`source_bucket (str, optional)`: default source bucket name.     </li><li class="args">`source_blob (str, optional)`: default source blob name.     </li><li class="args">`dest_bucket (str, optional)`: default destination bucket name.     </li><li class="args">`dest_blob (str, optional)`: default destination blob name.     </li><li class="args">`project (str, optional)`: default Google Cloud project to work within.         If not provided, will be inferred from your Google Cloud credentials     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         which stores a JSON representation of your Google Cloud credentials.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>Note that the design of this task allows you to initialize a _template_ with default settings.  Each inidividual occurence of the task in a Flow can overwrite any of these default settings for custom use (for example, if you want to pull different credentials for a given Task, or specify the Blob name at runtime).

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-gcp-storage-gcscopy-run'><p class="prefect-class">prefect.tasks.gcp.storage.GCSCopy.run</p>(source_bucket=None, source_blob=None, dest_bucket=None, dest_blob=None, project=None, credentials=None, credentials_secret=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/storage.py#L356">[source]</a></span></div>
<p class="methods">Run method for this Task. Invoked by _calling_ this Task after initialization within a Flow context.<br><br>Note that some arguments are required for the task to run, and must be provided _either_ at initialization _or_ as arguments.<br><br>**Args**:     <ul class="args"><li class="args">`source_bucket (str, optional)`: default source bucket name.     </li><li class="args">`source_blob (str, optional)`: default source blob name.     </li><li class="args">`dest_bucket (str, optional)`: default destination bucket name.     </li><li class="args">`dest_blob (str, optional)`: default destination blob name.     </li><li class="args">`project (str, optional)`: default Google Cloud project to work within.         If not provided, will be inferred from your Google Cloud credentials     </li><li class="args">`credentials (dict, optional)`: a JSON document containing Google Cloud credentials.         You should provide these at runtime with an upstream Secret task.     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         that stores a JSON represenation of your Google Cloud credentials</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the name of the destination blob</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `source_bucket`, `source_blob`, `dest_bucket`, or `dest_blob`         are missing or point at the same object.</li></ul></p>|

---
<br>

 ## BigQueryTask
 <div class='class-sig' id='prefect-tasks-gcp-bigquery-bigquerytask'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.gcp.bigquery.BigQueryTask</p>(query=None, query_params=None, project=None, location="US", dry_run_max_bytes=None, credentials_secret=None, dataset_dest=None, table_dest=None, job_config=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L29">[source]</a></span></div>

Task for executing queries against a Google BigQuery table and (optionally) returning the results.  Note that _all_ initialization settings can be provided / overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`query (str, optional)`: a string of the query to execute     </li><li class="args">`query_params (list[tuple], optional)`: a list of 3-tuples specifying         BigQuery query parameters; currently only scalar query parameters are supported. See         [the Google documentation](https://cloud.google.com/bigquery/docs/parameterized-queries#bigquery-query-params-python)         for more details on how both the query and the query parameters should be formatted     </li><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`location (str, optional)`: location of the dataset that will be queried; defaults to "US"     </li><li class="args">`dry_run_max_bytes (int, optional)`: if provided, the maximum number of bytes the query is allowed         to process; this will be determined by executing a dry run and raising a `ValueError` if the         maximum is exceeded     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`dataset_dest (str, optional)`: the optional name of a destination dataset to write the         query results to, if you don't want them returned; if provided, `table_dest` must also be         provided     </li><li class="args">`table_dest (str, optional)`: the optional name of a destination table to write the         query results to, if you don't want them returned; if provided, `dataset_dest` must also be         provided     </li><li class="args">`job_config (dict, optional)`: an optional dictionary of job configuration parameters; note that         the parameters provided here must be pickleable (e.g., dataset references will be rejected)     </li><li class="args">`**kwargs (optional)`: additional kwargs to pass to the `Task` constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-gcp-bigquery-bigquerytask-run'><p class="prefect-class">prefect.tasks.gcp.bigquery.BigQueryTask.run</p>(query=None, query_params=None, project=None, location="US", dry_run_max_bytes=None, credentials=None, credentials_secret=None, dataset_dest=None, table_dest=None, job_config=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L83">[source]</a></span></div>
<p class="methods">Run method for this Task.  Invoked by _calling_ this Task within a Flow context, after initialization.<br><br>**Args**:     <ul class="args"><li class="args">`query (str, optional)`: a string of the query to execute     </li><li class="args">`query_params (list[tuple], optional)`: a list of 3-tuples specifying         BigQuery query parameters; currently only scalar query parameters are supported. See         [the Google documentation](https://cloud.google.com/bigquery/docs/parameterized-queries#bigquery-query-params-python)         for more details on how both the query and the query parameters should be formatted     </li><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`location (str, optional)`: location of the dataset that will be queried; defaults to "US"     </li><li class="args">`dry_run_max_bytes (int, optional)`: if provided, the maximum number of bytes the query is allowed         to process; this will be determined by executing a dry run and raising a `ValueError` if the         maximum is exceeded     </li><li class="args">`credentials (dict, optional)`: a JSON document containing Google Cloud credentials.         You should provide these at runtime with an upstream Secret task.     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`dataset_dest (str, optional)`: the optional name of a destination dataset to write the         query results to, if you don't want them returned; if provided, `table_dest` must also be         provided     </li><li class="args">`table_dest (str, optional)`: the optional name of a destination table to write the         query results to, if you don't want them returned; if provided, `dataset_dest` must also be         provided     </li><li class="args">`job_config (dict, optional)`: an optional dictionary of job configuration parameters; note that         the parameters provided here must be pickleable (e.g., dataset references will be rejected)</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the `query` is `None`     </li><li class="args">`ValueError`: if only one of `dataset_dest` / `table_dest` is provided     </li><li class="args">`ValueError`: if the query will execeed `dry_run_max_bytes`</li></ul>**Returns**:     <ul class="args"><li class="args">`list`: a fully populated list of Query results, with one item per row</li></ul></p>|

---
<br>

 ## BigQueryLoadGoogleCloudStorage
 <div class='class-sig' id='prefect-tasks-gcp-bigquery-bigqueryloadgooglecloudstorage'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.gcp.bigquery.BigQueryLoadGoogleCloudStorage</p>(uri=None, dataset_id=None, table=None, project=None, schema=None, location="US", credentials_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L300">[source]</a></span></div>

Task for insert records in a Google BigQuery table via a [load job](https://cloud.google.com/bigquery/docs/loading-data). Note that all of these settings can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`uri (str, optional)`: GCS path to load data from     </li><li class="args">`dataset_id (str, optional)`: the id of a destination dataset to write the         records to     </li><li class="args">`table (str, optional)`: the name of a destination table to write the         records to     </li><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`schema (List[bigquery.SchemaField], optional)`: the schema to use when creating the table     </li><li class="args">`location (str, optional)`: location of the dataset that will be queried; defaults to "US"     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`**kwargs (optional)`: additional kwargs to pass to the `Task` constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-gcp-bigquery-bigqueryloadgooglecloudstorage-run'><p class="prefect-class">prefect.tasks.gcp.bigquery.BigQueryLoadGoogleCloudStorage.run</p>(uri=None, dataset_id=None, table=None, project=None, schema=None, location="US", credentials=None, credentials_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L340">[source]</a></span></div>
<p class="methods">Run method for this Task.  Invoked by _calling_ this Task within a Flow context, after initialization.<br><br>**Args**:     <ul class="args"><li class="args">`uri (str, optional)`: GCS path to load data from     </li><li class="args">`dataset_id (str, optional)`: the id of a destination dataset to write the         records to; if not provided here, will default to the one provided at initialization     </li><li class="args">`table (str, optional)`: the name of a destination table to write the         records to; if not provided here, will default to the one provided at initialization     </li><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`schema (List[bigquery.SchemaField], optional)`: the schema to use when creating the table     </li><li class="args">`location (str, optional)`: location of the dataset that will be written to; defaults to "US"     </li><li class="args">`credentials (dict, optional)`: a JSON document containing Google Cloud credentials.         You should provide these at runtime with an upstream Secret task.     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`**kwargs (optional)`: additional kwargs to pass to the `bigquery.LoadJobConfig`;         see the documentation here:         https://googleapis.github.io/google-cloud-python/latest/bigquery/generated/google.cloud.bigquery.client.Client.html</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if all required arguments haven't been provided     </li><li class="args">`ValueError`: if the load job results in an error</li></ul>**Returns**:     <ul class="args"><li class="args">the response from `load_table_from_uri`</li></ul></p>|

---
<br>

 ## BigQueryStreamingInsert
 <div class='class-sig' id='prefect-tasks-gcp-bigquery-bigquerystreaminginsert'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.gcp.bigquery.BigQueryStreamingInsert</p>(dataset_id=None, table=None, project=None, location="US", credentials_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L193">[source]</a></span></div>

Task for insert records in a Google BigQuery table via [the streaming API](https://cloud.google.com/bigquery/streaming-data-into-bigquery). Note that all of these settings can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`dataset_id (str, optional)`: the id of a destination dataset to write the         records to     </li><li class="args">`table (str, optional)`: the name of a destination table to write the         records to     </li><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`location (str, optional)`: location of the dataset that will be written to; defaults to "US"     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`**kwargs (optional)`: additional kwargs to pass to the `Task` constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-gcp-bigquery-bigquerystreaminginsert-run'><p class="prefect-class">prefect.tasks.gcp.bigquery.BigQueryStreamingInsert.run</p>(records, dataset_id=None, table=None, project=None, location="US", credentials=None, credentials_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L227">[source]</a></span></div>
<p class="methods">Run method for this Task.  Invoked by _calling_ this Task within a Flow context, after initialization.<br><br>**Args**:     <ul class="args"><li class="args">`records (list[dict])`: the list of records to insert as rows into         the BigQuery table; each item in the list should be a dictionary whose keys correspond         to columns in the table     </li><li class="args">`dataset_id (str, optional)`: the id of a destination dataset to write the         records to; if not provided here, will default to the one provided at initialization     </li><li class="args">`table (str, optional)`: the name of a destination table to write the         records to; if not provided here, will default to the one provided at initialization     </li><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`location (str, optional)`: location of the dataset that will be written to; defaults to "US"     </li><li class="args">`credentials (dict, optional)`: a JSON document containing Google Cloud credentials.         You should provide these at runtime with an upstream Secret task.     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`**kwargs (optional)`: additional kwargs to pass to the         `insert_rows_json` method; see the documentation here:         https://googleapis.github.io/google-cloud-python/latest/bigquery/generated/google.cloud.bigquery.client.Client.html</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if all required arguments haven't been provided     </li><li class="args">`ValueError`: if any of the records result in errors</li></ul>**Returns**:     <ul class="args"><li class="args">the response from `insert_rows_json`</li></ul></p>|

---
<br>

 ## CreateBigQueryTable
 <div class='class-sig' id='prefect-tasks-gcp-bigquery-createbigquerytable'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.gcp.bigquery.CreateBigQueryTable</p>(project=None, credentials_secret=None, dataset=None, table=None, schema=None, clustering_fields=None, time_partitioning=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L406">[source]</a></span></div>

Ensures a BigQuery table exists; creates it otherwise. Note that most initialization keywords can optionally be provided at runtime.

**Args**:     <ul class="args"><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`dataset (str, optional)`: the name of a dataset in that the table will be created     </li><li class="args">`table (str, optional)`: the name of a table to create     </li><li class="args">`schema (List[bigquery.SchemaField], optional)`: the schema to use when creating the table     </li><li class="args">`clustering_fields (List[str], optional)`: a list of fields to cluster the table by     </li><li class="args">`time_partitioning (bigquery.TimePartitioning, optional)`: a `bigquery.TimePartitioning` object specifying         a partitioninig of the newly created table     </li><li class="args">`**kwargs (optional)`: additional kwargs to pass to the `Task` constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-gcp-bigquery-createbigquerytable-run'><p class="prefect-class">prefect.tasks.gcp.bigquery.CreateBigQueryTable.run</p>(project=None, credentials=None, credentials_secret=None, dataset=None, table=None, schema=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/gcp/bigquery.py#L445">[source]</a></span></div>
<p class="methods">Run method for this Task.  Invoked by _calling_ this Task within a Flow context, after initialization.<br><br>**Args**:     <ul class="args"><li class="args">`project (str, optional)`: the project to initialize the BigQuery Client with; if not provided,         will default to the one inferred from your credentials     </li><li class="args">`credentials (dict, optional)`: a JSON document containing Google Cloud credentials.         You should provide these at runtime with an upstream Secret task.     </li><li class="args">`credentials_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret         containing a JSON representation of your Google Application credentials     </li><li class="args">`dataset (str, optional)`: the name of a dataset in that the table will be created     </li><li class="args">`table (str, optional)`: the name of a table to create     </li><li class="args">`schema (List[bigquery.SchemaField], optional)`: the schema to use when creating the table</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul>**Raises**:     <ul class="args"><li class="args">`SUCCESS`: a `SUCCESS` signal if the table already exists</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on May 14, 2020 at 21:12 UTC</p>