---
sidebarDepth: 2
editLink: false
---
# Flow
---
 ## Flow
 <div class='class-sig' id='prefect-core-flow-flow'><p class="prefect-sig">class </p><p class="prefect-class">prefect.core.flow.Flow</p>(name, schedule=None, environment=None, storage=None, tasks=None, edges=None, reference_tasks=None, state_handlers=None, on_failure=None, validate=None, result_handler=None, result=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L78">[source]</a></span></div>

The Flow class is used as the representation of a collection of dependent Tasks. Flows track Task dependencies, parameters and provide the main API for constructing and managing workflows.

Initializing Flow example: 
```python
class MyTask(Task):
    def run(self):
        return "hello"

task_1 = MyTask()
flow = Flow(name="my_flow", tasks=[task_1])

flow.run()

```

Initializing Flow as context manager example: 
```python
@task
def my_task():
    return "hello"

with Flow("my_flow") as flow:
    task_1 = my_task()

flow.run()

```

**Args**:     <ul class="args"><li class="args">`name (str)`: The name of the flow. Cannot be `None` or an empty string     </li><li class="args">`schedule (prefect.schedules.Schedule, optional)`: A default schedule for the flow     </li><li class="args">`environment (prefect.environments.Environment, optional)`: The environment        that the flow should be run in. If `None`, a `RemoteEnvironment` will be created.     </li><li class="args">`storage (prefect.environments.storage.Storage, optional)`: The unit of storage         that the flow will be written into.     </li><li class="args">`tasks ([Task], optional)`: If provided, a list of tasks that will initialize the flow     </li><li class="args">`edges ([Edge], optional)`: A list of edges between tasks     </li><li class="args">`reference_tasks ([Task], optional)`: A list of tasks that determine the final         state of a flow     </li><li class="args">`result (Result, optional, RESERVED FOR FUTURE USE)`: the result instance used to retrieve and store task results during execution     </li><li class="args">`result_handler (ResultHandler, optional, DEPRECATED)`: the handler to use for         retrieving and storing state results during execution     </li><li class="args">`state_handlers (Iterable[Callable], optional)`: A list of state change handlers         that will be called whenever the flow changes state, providing an         opportunity to inspect or modify the new state. The handler         will be passed the flow instance, the old (prior) state, and the new         (current) state, with the following signature:             `state_handler(flow: Flow, old_state: State, new_state: State) -> Optional[State]`         If multiple functions are passed, then the `new_state` argument will be the         result of the previous handler.     </li><li class="args">`on_failure (Callable, optional)`: A function with signature `fn(flow: Flow, state: State) -> None`         which will be called anytime this Flow enters a failure state     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles and illegal keys) after adding the edges passed         in the `edges` argument. Defaults to the value of `eager_edge_validation` in         your prefect configuration file.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-core-flow-flow-add-edge'><p class="prefect-class">prefect.core.flow.Flow.add_edge</p>(upstream_task, downstream_task, key=None, mapped=False, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L437">[source]</a></span></div>
<p class="methods">Add an edge in the flow between two tasks. All edges are directed beginning with an upstream task and ending with a downstream task.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_task (Task)`: The task that the edge should start from     </li><li class="args">`downstream_task (Task)`: The task that the edge should end with     </li><li class="args">`key (str, optional)`: The key to be set for the new edge; the result of the upstream task     will be passed to the downstream task's `run()` method under this keyword argument     </li><li class="args">`mapped (bool, optional)`: Whether this edge represents a call to `Task.map()`; defaults to `False`     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles and illegal keys). Defaults to the value         of `eager_edge_validation` in your prefect configuration file.</li></ul>**Returns**:     <ul class="args"><li class="args">`prefect.core.edge.Edge`: The `Edge` object that was successfully added to the flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the `downstream_task` is of type `Parameter`     </li><li class="args">`ValueError`: if the edge exists with this `key` and `downstream_task`</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-add-task'><p class="prefect-class">prefect.core.flow.Flow.add_task</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L405">[source]</a></span></div>
<p class="methods">Add a task to the flow if the task does not already exist. The tasks are uniquely identified by their `slug`.<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: the new Task to be added to the flow</li></ul>**Returns**:     <ul class="args"><li class="args">`Task`: the `Task` object passed in if the task was successfully added</li></ul>**Raises**:     <ul class="args"><li class="args">`TypeError`: if the `task` is not of type `Task`     </li><li class="args">`ValueError`: if the `task.slug` matches that of a task already in the flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-all-downstream-edges'><p class="prefect-class">prefect.core.flow.Flow.all_downstream_edges</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L573">[source]</a></span></div>
<p class="methods">Returns a dictionary relating each task in the Flow to the set of all _downstream_ edges for the task<br><br>**Returns**:     <ul class="args"><li class="args">dict with the key as tasks and the value as a set of downstream edges</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-all-upstream-edges'><p class="prefect-class">prefect.core.flow.Flow.all_upstream_edges</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L559">[source]</a></span></div>
<p class="methods">Returns a dictionary relating each task in the Flow to the set of all _upstream_ edges for the task<br><br>**Returns**:     <ul class="args"><li class="args">dict with the key as tasks and the value as a set of upstream edges</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-chain'><p class="prefect-class">prefect.core.flow.Flow.chain</p>(*tasks, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L509">[source]</a></span></div>
<p class="methods">Adds a sequence of dependent tasks to the flow; each task should be provided as an argument (or splatted from a list).<br><br>**Args**:     <ul class="args"><li class="args">`*tasks (list)`: A list of tasks to chain together     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles).  Defaults to the value of `eager_edge_validation`         in your prefect configuration file.</li></ul>**Returns**:     <ul class="args"><li class="args">A list of Edge objects added to the flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-copy'><p class="prefect-class">prefect.core.flow.Flow.copy</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L209">[source]</a></span></div>
<p class="methods">Create and returns a copy of the current Flow.</p>|
 | <div class='method-sig' id='prefect-core-flow-flow-diagnostics'><p class="prefect-class">prefect.core.flow.Flow.diagnostics</p>(include_secret_names=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1240">[source]</a></span></div>
<p class="methods">Get flow and Prefect diagnostic information<br><br>**Args**:     <ul class="args"><li class="args">`include_secret_names (bool, optional)`: toggle output of Secret names, defaults to False.         Note: Secret values are never returned, only their names.</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-downstream-tasks'><p class="prefect-class">prefect.core.flow.Flow.downstream_tasks</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L639">[source]</a></span></div>
<p class="methods">Get all of the tasks downstream of a task<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find downstream tasks from</li></ul>**Returns**:     <ul class="args"><li class="args">set of Task objects which are downstream of `task`</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-edges-from'><p class="prefect-class">prefect.core.flow.Flow.edges_from</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L607">[source]</a></span></div>
<p class="methods">Get all of the edges leading from a task (i.e., the downstream edges)<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find edges leading from</li></ul>**Returns**:     <ul class="args"><li class="args">dict with the key as the task passed in and the value as a set of all edges     leading from that task</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `task` is not found in this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-edges-to'><p class="prefect-class">prefect.core.flow.Flow.edges_to</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L587">[source]</a></span></div>
<p class="methods">Get all of the edges leading to a task (i.e., the upstream edges)<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find edges leading to</li></ul>**Returns**:     <ul class="args"><li class="args">dict with the key as the task passed in and the value as a set of all edges     leading to that task</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `task` is not found in this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-get-tasks'><p class="prefect-class">prefect.core.flow.Flow.get_tasks</p>(name=None, slug=None, tags=None, task_type=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L223">[source]</a></span></div>
<p class="methods">Helper method for retrieving tasks from this flow based on certain attributes. The _intersection_ of all provided attributes is taken, i.e., only those tasks which match _all_ provided conditions are returned.<br><br>**Args**:     <ul class="args"><li class="args">`name (str, optional)`: the name of the task     </li><li class="args">`slug (str, optional)`: the slug of the task     </li><li class="args">`tags ([str], optional)`: an iterable of task tags     </li><li class="args">`task_type (type, optional)`: a possible task class type</li></ul>**Returns**:     <ul class="args"><li class="args">`[Task]`: a list of tasks that meet the required conditions</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-load'><p class="prefect-class">prefect.core.flow.Flow.load</p>(fpath)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1252">[source]</a></span></div>
<p class="methods">Reads a Flow from a file that was created with `flow.save()`.<br><br>**Args**:     <ul class="args"><li class="args">`fpath (str)`: either the absolute filepath where your Flow will be loaded from,         or the name of the Flow you wish to load</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-parameters'><p class="prefect-class">prefect.core.flow.Flow.parameters</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L350">[source]</a></span></div>
<p class="methods">Returns any parameters of the flow.<br><br>**Returns**:     <ul class="args"><li class="args">`set`: a set of any Parameters in this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-reference-tasks'><p class="prefect-class">prefect.core.flow.Flow.reference_tasks</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L359">[source]</a></span></div>
<p class="methods">A flow's "reference tasks" are used to determine its state when it runs. If all the reference tasks are successful, then the flow run is considered successful. However, if any of the reference tasks fail, the flow is considered to fail. (Note that skips are counted as successes; see [the state documentation](../engine/state.html) for a full description of what is considered failure, success, etc.)<br><br>By default, a flow's reference tasks are its terminal tasks. This means the state of a flow is determined by those tasks that have no downstream dependencies.<br><br>In some situations, users may want to customize this behavior; for example, if a flow's terminal tasks are "clean up" tasks for the rest of the flow that only run if certain (more relevant) tasks fail, we might not want them determining the overall state of the flow run. The `flow.set_reference_tasks()` method can be used to set such custom `reference_tasks`.<br><br>Please note that even if `reference_tasks` are provided that are not terminal tasks, the flow will not be considered "finished" until all terminal tasks have completed. Only then will state be determined, using the reference tasks.<br><br>**Returns**:     <ul class="args"><li class="args">set of Task objects which are the reference tasks in the flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-register'><p class="prefect-class">prefect.core.flow.Flow.register</p>(project_name=None, build=True, labels=None, set_schedule_active=True, version_group_id=None, no_url=False, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1320">[source]</a></span></div>
<p class="methods">Register the flow with Prefect Cloud; if no storage is present on the Flow, the default value from your config will be used and initialized with `**kwargs`.<br><br>**Args**:     <ul class="args"><li class="args">`project_name (str, optional)`: the project that should contain this flow.     </li><li class="args">`build (bool, optional)`: if `True`, the flow's environment is built         prior to serialization; defaults to `True`     </li><li class="args">`labels (List[str], optional)`: a list of labels to add to this Flow's environment; useful for         associating Flows with individual Agents; see http://docs.prefect.io/orchestration/agents/overview.html#flow-affinity-labels     </li><li class="args">`set_schedule_active (bool, optional)`: if `False`, will set the         schedule to inactive in the database to prevent auto-scheduling runs (if the Flow has a schedule).         Defaults to `True`. This can be changed later.     </li><li class="args">`version_group_id (str, optional)`: the UUID version group ID to use for versioning this Flow         in Cloud; if not provided, the version group ID associated with this Flow's project and name         will be used.     </li><li class="args">`no_url (bool, optional)`: if `True`, the stdout from this function will not contain the         URL link to the newly-registered flow in the Cloud UI     </li><li class="args">`**kwargs (Any)`: if instantiating a Storage object from default settings, these keyword arguments         will be passed to the initialization method of the default Storage class</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the ID of the flow that was registered</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-replace'><p class="prefect-class">prefect.core.flow.Flow.replace</p>(old, new, validate=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L260">[source]</a></span></div>
<p class="methods">Performs an inplace replacement of the old task with the provided new task.<br><br>**Args**:     <ul class="args"><li class="args">`old (Task)`: the old task to replace     </li><li class="args">`new (Task)`: the new task to replace the old with; if not a Prefect         Task, Prefect will attempt to convert it to one     </li><li class="args">`validate (boolean, optional)`: whether to validate the Flow after         the replace has been completed; defaults to `True`</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the `old` task is not a part of this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-root-tasks'><p class="prefect-class">prefect.core.flow.Flow.root_tasks</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L329">[source]</a></span></div>
<p class="methods">Get the tasks in the flow that have no upstream dependencies; these are the tasks that, by default, flow execution begins with.<br><br>**Returns**:     <ul class="args"><li class="args">set of Task objects that have no upstream dependencies</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-run'><p class="prefect-class">prefect.core.flow.Flow.run</p>(parameters=None, run_on_schedule=None, runner_cls=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L952">[source]</a></span></div>
<p class="methods">Run the flow on its schedule using an instance of a FlowRunner.  If the Flow has no schedule, a single stateful run will occur (including retries).<br><br>Note that this command will block and run this Flow on its schedule indefinitely (if it has one); all task states will be stored in memory, and task retries will not occur until every Task in the Flow has had a chance to run.<br><br>**Args**:     <ul class="args"><li class="args">`parameters (Dict[str, Any], optional)`: values to pass into the runner     </li><li class="args">`run_on_schedule (bool, optional)`: whether to run this flow on its schedule, or run a single execution;         if not provided, will default to the value set in your user config     </li><li class="args">`runner_cls (type)`: an optional FlowRunner class (will use the default if not provided)     </li><li class="args">`**kwargs`: additional keyword arguments; if any provided keywords         match known parameter names, they will be used as such. Otherwise they will be passed to the         `FlowRunner.run()` method</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if this Flow has a Schedule with no more scheduled runs     </li><li class="args">`ValueError`: if the `return_tasks` keyword argument is provided</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the flow after its final run</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-run-agent'><p class="prefect-class">prefect.core.flow.Flow.run_agent</p>(token=None, show_flow_logs=False, log_to_cloud=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1295">[source]</a></span></div>
<p class="methods">Runs a Cloud agent for this Flow in-process.<br><br>**Args**:     <ul class="args"><li class="args">`token (str, optional)`: A Prefect Cloud API token with a RUNNER scope;         will default to the token found in `config.cloud.agent.auth_token`     </li><li class="args">`show_flow_logs (bool, optional)`: a boolean specifying whether the agent should re-route Flow run logs         to stdout; defaults to `False`     </li><li class="args">`log_to_cloud (bool, optional)`: a boolean specifying whether Flow run logs should be sent to Prefect Cloud;         defaults to `True`</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-save'><p class="prefect-class">prefect.core.flow.Flow.save</p>(fpath=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1269">[source]</a></span></div>
<p class="methods">Saves the Flow to a file by serializing it with cloudpickle.  This method is recommended if you wish to separate out the building of your Flow from its registration.<br><br>**Args**:     <ul class="args"><li class="args">`fpath (str, optional)`: the filepath where your Flow will be saved; defaults to         `~/.prefect/flows/FLOW-NAME.prefect`</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the full location the Flow was saved to</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-serialize'><p class="prefect-class">prefect.core.flow.Flow.serialize</p>(build=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1201">[source]</a></span></div>
<p class="methods">Creates a serialized representation of the flow.<br><br>**Args**:     <ul class="args"><li class="args">`build (bool, optional)`: if `True`, the flow's environment is built         prior to serialization</li></ul>**Returns**:     <ul class="args"><li class="args">dict representing the flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `build=True` and the flow has no storage</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-set-dependencies'><p class="prefect-class">prefect.core.flow.Flow.set_dependencies</p>(task, upstream_tasks=None, downstream_tasks=None, keyword_tasks=None, mapped=False, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L749">[source]</a></span></div>
<p class="methods">Convenience function for adding task dependencies.<br><br>**Args**:     <ul class="args"><li class="args">`task (object)`: a Task that will become part of the Flow. If the task is not a         Task subclass, Prefect will attempt to convert it to one.     </li><li class="args">`upstream_tasks ([object], optional)`: Tasks that will run before the task runs. If any task         is not a Task subclass, Prefect will attempt to convert it to one.     </li><li class="args">`downstream_tasks ([object], optional)`: Tasks that will run after the task runs. If any task         is not a Task subclass, Prefect will attempt to convert it to one.     </li><li class="args">`keyword_tasks ({key: object}, optional)`: The results of these tasks         will be provided to the task under the specified keyword         arguments. If any task is not a Task subclass, Prefect will attempt to         convert it to one.     </li><li class="args">`mapped (bool, optional)`: Whether the upstream tasks (both keyed         and non-keyed) should be mapped over; defaults to `False`. If `True`, any         tasks wrapped in the `prefect.utilities.tasks.unmapped` container will         _not_ be mapped over.     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles).  Defaults to the value of `eager_edge_validation`         in your Prefect configuration file.</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-set-reference-tasks'><p class="prefect-class">prefect.core.flow.Flow.set_reference_tasks</p>(tasks)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L387">[source]</a></span></div>
<p class="methods">Sets the `reference_tasks` for the flow. See `flow.reference_tasks` for more details.<br><br>**Args**:     <ul class="args"><li class="args">`tasks ([Task])`: the tasks that should be set as a flow's reference tasks</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-sorted-tasks'><p class="prefect-class">prefect.core.flow.Flow.sorted_tasks</p>(root_tasks=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L676">[source]</a></span></div>
<p class="methods">Get the tasks in this flow in a sorted manner. This allows us to find if any cycles exist in this flow's DAG.<br><br>**Args**:     <ul class="args"><li class="args">`root_tasks ([Tasks], optional)`: an `Iterable` of `Task` objects to     start the sorting from</li></ul>**Returns**:     <ul class="args"><li class="args">tuple of task objects that were sorted</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a cycle is found in the flow's DAG</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-terminal-tasks'><p class="prefect-class">prefect.core.flow.Flow.terminal_tasks</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L340">[source]</a></span></div>
<p class="methods">Get the tasks in the flow that have no downstream dependencies<br><br>**Returns**:     <ul class="args"><li class="args">set of Task objects that have no downstream dependencies</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-update'><p class="prefect-class">prefect.core.flow.Flow.update</p>(flow, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L532">[source]</a></span></div>
<p class="methods">Take all tasks and edges in another flow and add it to this flow<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: A flow which is used to update this flow     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of the flow</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-upstream-tasks'><p class="prefect-class">prefect.core.flow.Flow.upstream_tasks</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L627">[source]</a></span></div>
<p class="methods">Get all of the tasks upstream of a task<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find upstream tasks of</li></ul>**Returns**:     <ul class="args"><li class="args">set of Task objects which are upstream of `task`</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-validate'><p class="prefect-class">prefect.core.flow.Flow.validate</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L651">[source]</a></span></div>
<p class="methods">Checks that the flow is valid.<br><br>**Returns**:     <ul class="args"><li class="args">None</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if edges refer to tasks that are not in this flow     </li><li class="args">`ValueError`: if specified reference tasks are not in this flow     </li><li class="args">`ValueError`: if any tasks do not have assigned IDs</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-visualize'><p class="prefect-class">prefect.core.flow.Flow.visualize</p>(flow_state=None, filename=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1058">[source]</a></span></div>
<p class="methods">Creates graphviz object for representing the current flow; this graphviz object will be rendered inline if called from an IPython notebook, otherwise it will be rendered in a new window.  If a `filename` is provided, the object will not be rendered and instead saved to the location specified.<br><br>**Args**:     <ul class="args"><li class="args">`flow_state (State, optional)`: flow state object used to optionally color the nodes     </li><li class="args">`filename (str, optional)`: a filename specifying a location to save this visualization to; if provided,         the visualization will not be rendered automatically</li></ul>**Raises**:     <ul class="args"><li class="args">`ImportError`: if `graphviz` is not installed</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on May 14, 2020 at 21:12 UTC</p>