// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"encoding/json"
	"fmt"
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"github.com/formancehq/ledger/pkg/client/models/components"
	"time"
)

// Order - Deprecated: Use sort param
type Order string

const (
	OrderEffective Order = "effective"
)

func (e Order) ToPointer() *Order {
	return &e
}
func (e *Order) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "effective":
		*e = Order(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Order: %v", v)
	}
}

type V2ListTransactionsRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// The maximum number of results to return per page.
	//
	PageSize *int64 `queryParam:"style=form,explode=true,name=pageSize"`
	// Parameter used in pagination requests. Maximum page size is set to 15.
	// Set to the value of next for the next page of results.
	// Set to the value of previous for the previous page of results.
	// No other parameters can be set when this parameter is set.
	//
	Cursor *string    `queryParam:"style=form,explode=true,name=cursor"`
	Expand *string    `queryParam:"style=form,explode=true,name=expand"`
	Pit    *time.Time `queryParam:"style=form,explode=true,name=pit"`
	// Deprecated: Use sort param
	//
	// Deprecated: This will be removed in a future release, please migrate away from it as soon as possible.
	Order   *Order `queryParam:"style=form,explode=true,name=order"`
	Reverse *bool  `queryParam:"style=form,explode=true,name=reverse"`
	// Sort results using a field name and order (ascending or descending).
	// Format: `<field>:<order>`, where `<field>` is the field name and `<order>` is either `asc` or `desc`.
	//
	Sort        *string        `queryParam:"style=form,explode=true,name=sort"`
	RequestBody map[string]any `request:"mediaType=application/json"`
}

func (v V2ListTransactionsRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2ListTransactionsRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2ListTransactionsRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *V2ListTransactionsRequest) GetPageSize() *int64 {
	if o == nil {
		return nil
	}
	return o.PageSize
}

func (o *V2ListTransactionsRequest) GetCursor() *string {
	if o == nil {
		return nil
	}
	return o.Cursor
}

func (o *V2ListTransactionsRequest) GetExpand() *string {
	if o == nil {
		return nil
	}
	return o.Expand
}

func (o *V2ListTransactionsRequest) GetPit() *time.Time {
	if o == nil {
		return nil
	}
	return o.Pit
}

func (o *V2ListTransactionsRequest) GetOrder() *Order {
	if o == nil {
		return nil
	}
	return o.Order
}

func (o *V2ListTransactionsRequest) GetReverse() *bool {
	if o == nil {
		return nil
	}
	return o.Reverse
}

func (o *V2ListTransactionsRequest) GetSort() *string {
	if o == nil {
		return nil
	}
	return o.Sort
}

func (o *V2ListTransactionsRequest) GetRequestBody() map[string]any {
	if o == nil {
		return map[string]any{}
	}
	return o.RequestBody
}

type V2ListTransactionsResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	V2TransactionsCursorResponse *components.V2TransactionsCursorResponse
}

func (o *V2ListTransactionsResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V2ListTransactionsResponse) GetV2TransactionsCursorResponse() *components.V2TransactionsCursorResponse {
	if o == nil {
		return nil
	}
	return o.V2TransactionsCursorResponse
}
