// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"github.com/formancehq/ledger/pkg/client/models/components"
	"time"
)

type V2ListLogsRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// The maximum number of results to return per page.
	//
	PageSize *int64 `queryParam:"style=form,explode=true,name=pageSize"`
	// Parameter used in pagination requests. Maximum page size is set to 15.
	// Set to the value of next for the next page of results.
	// Set to the value of previous for the previous page of results.
	// No other parameters can be set when this parameter is set.
	//
	Cursor *string    `queryParam:"style=form,explode=true,name=cursor"`
	Pit    *time.Time `queryParam:"style=form,explode=true,name=pit"`
	// Sort results using a field name and order (ascending or descending).
	// Format: `<field>:<order>`, where `<field>` is the field name and `<order>` is either `asc` or `desc`.
	//
	Sort        *string        `queryParam:"style=form,explode=true,name=sort"`
	RequestBody map[string]any `request:"mediaType=application/json"`
}

func (v V2ListLogsRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2ListLogsRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2ListLogsRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *V2ListLogsRequest) GetPageSize() *int64 {
	if o == nil {
		return nil
	}
	return o.PageSize
}

func (o *V2ListLogsRequest) GetCursor() *string {
	if o == nil {
		return nil
	}
	return o.Cursor
}

func (o *V2ListLogsRequest) GetPit() *time.Time {
	if o == nil {
		return nil
	}
	return o.Pit
}

func (o *V2ListLogsRequest) GetSort() *string {
	if o == nil {
		return nil
	}
	return o.Sort
}

func (o *V2ListLogsRequest) GetRequestBody() map[string]any {
	if o == nil {
		return map[string]any{}
	}
	return o.RequestBody
}

type V2ListLogsResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	V2LogsCursorResponse *components.V2LogsCursorResponse
}

func (o *V2ListLogsResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V2ListLogsResponse) GetV2LogsCursorResponse() *components.V2LogsCursorResponse {
	if o == nil {
		return nil
	}
	return o.V2LogsCursorResponse
}
