// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"github.com/formancehq/ledger/pkg/client/models/components"
	"math/big"
	"time"
)

type V2GetTransactionRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// Transaction ID.
	ID     *big.Int   `pathParam:"style=simple,explode=false,name=id"`
	Expand *string    `queryParam:"style=form,explode=true,name=expand"`
	Pit    *time.Time `queryParam:"style=form,explode=true,name=pit"`
}

func (v V2GetTransactionRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2GetTransactionRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2GetTransactionRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *V2GetTransactionRequest) GetID() *big.Int {
	if o == nil {
		return big.NewInt(0)
	}
	return o.ID
}

func (o *V2GetTransactionRequest) GetExpand() *string {
	if o == nil {
		return nil
	}
	return o.Expand
}

func (o *V2GetTransactionRequest) GetPit() *time.Time {
	if o == nil {
		return nil
	}
	return o.Pit
}

type V2GetTransactionResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	V2GetTransactionResponse *components.V2GetTransactionResponse
}

func (o *V2GetTransactionResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V2GetTransactionResponse) GetV2GetTransactionResponse() *components.V2GetTransactionResponse {
	if o == nil {
		return nil
	}
	return o.V2GetTransactionResponse
}
