// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/models/components"
)

type V2CreateTransactionRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// Set the dryRun mode. dry run mode doesn't add the logs to the database or publish a message to the message broker.
	DryRun *bool `queryParam:"style=form,explode=true,name=dryRun"`
	// Use an idempotency key
	IdempotencyKey *string `header:"style=simple,explode=false,name=Idempotency-Key"`
	// Disable balance checks when passing postings
	//
	// Deprecated: This will be removed in a future release, please migrate away from it as soon as possible.
	Force *bool `queryParam:"style=form,explode=true,name=force"`
	// The request body must contain at least one of the following objects:
	//   - `postings`: suitable for simple transactions
	//   - `script`: enabling more complex transactions with Numscript
	//
	V2PostTransaction components.V2PostTransaction `request:"mediaType=application/json"`
}

func (o *V2CreateTransactionRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *V2CreateTransactionRequest) GetDryRun() *bool {
	if o == nil {
		return nil
	}
	return o.DryRun
}

func (o *V2CreateTransactionRequest) GetIdempotencyKey() *string {
	if o == nil {
		return nil
	}
	return o.IdempotencyKey
}

func (o *V2CreateTransactionRequest) GetForce() *bool {
	if o == nil {
		return nil
	}
	return o.Force
}

func (o *V2CreateTransactionRequest) GetV2PostTransaction() components.V2PostTransaction {
	if o == nil {
		return components.V2PostTransaction{}
	}
	return o.V2PostTransaction
}

type V2CreateTransactionResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	V2CreateTransactionResponse *components.V2CreateTransactionResponse
	Headers                     map[string][]string
}

func (o *V2CreateTransactionResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V2CreateTransactionResponse) GetV2CreateTransactionResponse() *components.V2CreateTransactionResponse {
	if o == nil {
		return nil
	}
	return o.V2CreateTransactionResponse
}

func (o *V2CreateTransactionResponse) GetHeaders() map[string][]string {
	if o == nil {
		return map[string][]string{}
	}
	return o.Headers
}
