// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"math/big"
	"time"
)

type Transaction struct {
	Timestamp         time.Time                    `json:"timestamp"`
	Postings          []Posting                    `json:"postings"`
	Reference         *string                      `json:"reference,omitempty"`
	Metadata          map[string]any               `json:"metadata,omitempty"`
	Txid              *big.Int                     `json:"txid"`
	PreCommitVolumes  map[string]map[string]Volume `json:"preCommitVolumes,omitempty"`
	PostCommitVolumes map[string]map[string]Volume `json:"postCommitVolumes,omitempty"`
}

func (t Transaction) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(t, "", false)
}

func (t *Transaction) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &t, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *Transaction) GetTimestamp() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.Timestamp
}

func (o *Transaction) GetPostings() []Posting {
	if o == nil {
		return []Posting{}
	}
	return o.Postings
}

func (o *Transaction) GetReference() *string {
	if o == nil {
		return nil
	}
	return o.Reference
}

func (o *Transaction) GetMetadata() map[string]any {
	if o == nil {
		return nil
	}
	return o.Metadata
}

func (o *Transaction) GetTxid() *big.Int {
	if o == nil {
		return big.NewInt(0)
	}
	return o.Txid
}

func (o *Transaction) GetPreCommitVolumes() map[string]map[string]Volume {
	if o == nil {
		return nil
	}
	return o.PreCommitVolumes
}

func (o *Transaction) GetPostCommitVolumes() map[string]map[string]Volume {
	if o == nil {
		return nil
	}
	return o.PostCommitVolumes
}
