# CountTransactionsRequest


## Fields

| Field                                                                                                                                                                           | Type                                                                                                                                                                            | Required                                                                                                                                                                        | Description                                                                                                                                                                     | Example                                                                                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `Ledger`                                                                                                                                                                        | *string*                                                                                                                                                                        | :heavy_check_mark:                                                                                                                                                              | Name of the ledger.                                                                                                                                                             | ledger001                                                                                                                                                                       |
| `Reference`                                                                                                                                                                     | **string*                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                              | Filter transactions by reference field.                                                                                                                                         | ref:001                                                                                                                                                                         |
| `Account`                                                                                                                                                                       | **string*                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                              | Filter transactions with postings involving given account, either as source or destination (regular expression placed between ^ and $).                                         | users:001                                                                                                                                                                       |
| `Source`                                                                                                                                                                        | **string*                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                              | Filter transactions with postings involving given account at source (regular expression placed between ^ and $).                                                                | users:001                                                                                                                                                                       |
| `Destination`                                                                                                                                                                   | **string*                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                              | Filter transactions with postings involving given account at destination (regular expression placed between ^ and $).                                                           | users:001                                                                                                                                                                       |
| `StartTime`                                                                                                                                                                     | [*time.Time](https://pkg.go.dev/time#Time)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                              | Filter transactions that occurred after this timestamp.<br/>The format is RFC3339 and is inclusive (for example, "2023-01-02T15:04:01Z" includes the first second of 4th minute).<br/> |                                                                                                                                                                                 |
| `EndTime`                                                                                                                                                                       | [*time.Time](https://pkg.go.dev/time#Time)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                              | Filter transactions that occurred before this timestamp.<br/>The format is RFC3339 and is exclusive (for example, "2023-01-02T15:04:01Z" excludes the first second of 4th minute).<br/> |                                                                                                                                                                                 |
| `Metadata`                                                                                                                                                                      | [*operations.Metadata](../../models/operations/metadata.md)                                                                                                                     | :heavy_minus_sign:                                                                                                                                                              | Filter transactions by metadata key value pairs. Nested objects can be used as seen in the example below.                                                                       | metadata[key]=value1&metadata[a.nested.key]=value2                                                                                                                              |