<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# ledger

```go
import "github.com/formancehq/ledger/internal/controller/ledger"
```

Ledger Controller doc

## Index

- [Variables](<#variables>)
- [type Balance](<#Balance>)
- [type BalanceQuery](<#BalanceQuery>)
- [type Balances](<#Balances>)
- [type CacheConfiguration](<#CacheConfiguration>)
- [type CachedCompiler](<#CachedCompiler>)
  - [func NewCachedCompiler\(compiler Compiler, configuration CacheConfiguration\) \*CachedCompiler](<#NewCachedCompiler>)
  - [func \(c \*CachedCompiler\) Compile\(script string\) \(\*program.Program, error\)](<#CachedCompiler.Compile>)
- [type Compiler](<#Compiler>)
- [type CompilerFn](<#CompilerFn>)
  - [func NewDefaultCompiler\(\) CompilerFn](<#NewDefaultCompiler>)
  - [func \(fn CompilerFn\) Compile\(script string\) \(\*program.Program, error\)](<#CompilerFn.Compile>)
- [type Controller](<#Controller>)
- [type ControllerWithCache](<#ControllerWithCache>)
  - [func NewControllerWithCache\(ledger ledger.Ledger, underlying Controller, registry \*StateRegistry\) \*ControllerWithCache](<#NewControllerWithCache>)
  - [func \(c \*ControllerWithCache\) IsDatabaseUpToDate\(ctx context.Context\) \(bool, error\)](<#ControllerWithCache.IsDatabaseUpToDate>)
- [type ControllerWithEvents](<#ControllerWithEvents>)
  - [func NewControllerWithEvents\(ledger ledger.Ledger, underlying Controller, listener Listener\) \*ControllerWithEvents](<#NewControllerWithEvents>)
  - [func \(ctrl \*ControllerWithEvents\) CreateTransaction\(ctx context.Context, parameters Parameters\[RunScript\]\) \(\*ledger.CreatedTransaction, error\)](<#ControllerWithEvents.CreateTransaction>)
  - [func \(ctrl \*ControllerWithEvents\) DeleteAccountMetadata\(ctx context.Context, parameters Parameters\[DeleteAccountMetadata\]\) error](<#ControllerWithEvents.DeleteAccountMetadata>)
  - [func \(ctrl \*ControllerWithEvents\) DeleteTransactionMetadata\(ctx context.Context, parameters Parameters\[DeleteTransactionMetadata\]\) error](<#ControllerWithEvents.DeleteTransactionMetadata>)
  - [func \(ctrl \*ControllerWithEvents\) RevertTransaction\(ctx context.Context, parameters Parameters\[RevertTransaction\]\) \(\*ledger.RevertedTransaction, error\)](<#ControllerWithEvents.RevertTransaction>)
  - [func \(ctrl \*ControllerWithEvents\) SaveAccountMetadata\(ctx context.Context, parameters Parameters\[SaveAccountMetadata\]\) error](<#ControllerWithEvents.SaveAccountMetadata>)
  - [func \(ctrl \*ControllerWithEvents\) SaveTransactionMetadata\(ctx context.Context, parameters Parameters\[SaveTransactionMetadata\]\) error](<#ControllerWithEvents.SaveTransactionMetadata>)
- [type ControllerWithTraces](<#ControllerWithTraces>)
  - [func NewControllerWithTraces\(underlying Controller\) \*ControllerWithTraces](<#NewControllerWithTraces>)
  - [func \(ctrl \*ControllerWithTraces\) CountAccounts\(ctx context.Context, a ListAccountsQuery\) \(int, error\)](<#ControllerWithTraces.CountAccounts>)
  - [func \(ctrl \*ControllerWithTraces\) CountTransactions\(ctx context.Context, q ListTransactionsQuery\) \(int, error\)](<#ControllerWithTraces.CountTransactions>)
  - [func \(ctrl \*ControllerWithTraces\) CreateTransaction\(ctx context.Context, parameters Parameters\[RunScript\]\) \(\*ledger.CreatedTransaction, error\)](<#ControllerWithTraces.CreateTransaction>)
  - [func \(ctrl \*ControllerWithTraces\) DeleteAccountMetadata\(ctx context.Context, parameters Parameters\[DeleteAccountMetadata\]\) error](<#ControllerWithTraces.DeleteAccountMetadata>)
  - [func \(ctrl \*ControllerWithTraces\) DeleteTransactionMetadata\(ctx context.Context, parameters Parameters\[DeleteTransactionMetadata\]\) error](<#ControllerWithTraces.DeleteTransactionMetadata>)
  - [func \(ctrl \*ControllerWithTraces\) Export\(ctx context.Context, w ExportWriter\) error](<#ControllerWithTraces.Export>)
  - [func \(ctrl \*ControllerWithTraces\) GetAccount\(ctx context.Context, q GetAccountQuery\) \(\*ledger.Account, error\)](<#ControllerWithTraces.GetAccount>)
  - [func \(ctrl \*ControllerWithTraces\) GetAggregatedBalances\(ctx context.Context, q GetAggregatedBalanceQuery\) \(ledger.BalancesByAssets, error\)](<#ControllerWithTraces.GetAggregatedBalances>)
  - [func \(ctrl \*ControllerWithTraces\) GetMigrationsInfo\(ctx context.Context\) \(\[\]migrations.Info, error\)](<#ControllerWithTraces.GetMigrationsInfo>)
  - [func \(ctrl \*ControllerWithTraces\) GetStats\(ctx context.Context\) \(Stats, error\)](<#ControllerWithTraces.GetStats>)
  - [func \(ctrl \*ControllerWithTraces\) GetTransaction\(ctx context.Context, query GetTransactionQuery\) \(\*ledger.Transaction, error\)](<#ControllerWithTraces.GetTransaction>)
  - [func \(ctrl \*ControllerWithTraces\) GetVolumesWithBalances\(ctx context.Context, q GetVolumesWithBalancesQuery\) \(\*bunpaginate.Cursor\[ledger.VolumesWithBalanceByAssetByAccount\], error\)](<#ControllerWithTraces.GetVolumesWithBalances>)
  - [func \(ctrl \*ControllerWithTraces\) Import\(ctx context.Context, stream chan ledger.Log\) error](<#ControllerWithTraces.Import>)
  - [func \(ctrl \*ControllerWithTraces\) IsDatabaseUpToDate\(ctx context.Context\) \(bool, error\)](<#ControllerWithTraces.IsDatabaseUpToDate>)
  - [func \(ctrl \*ControllerWithTraces\) ListAccounts\(ctx context.Context, a ListAccountsQuery\) \(\*bunpaginate.Cursor\[ledger.Account\], error\)](<#ControllerWithTraces.ListAccounts>)
  - [func \(ctrl \*ControllerWithTraces\) ListLogs\(ctx context.Context, q GetLogsQuery\) \(\*bunpaginate.Cursor\[ledger.Log\], error\)](<#ControllerWithTraces.ListLogs>)
  - [func \(ctrl \*ControllerWithTraces\) ListTransactions\(ctx context.Context, q ListTransactionsQuery\) \(\*bunpaginate.Cursor\[ledger.Transaction\], error\)](<#ControllerWithTraces.ListTransactions>)
  - [func \(ctrl \*ControllerWithTraces\) RevertTransaction\(ctx context.Context, parameters Parameters\[RevertTransaction\]\) \(\*ledger.RevertedTransaction, error\)](<#ControllerWithTraces.RevertTransaction>)
  - [func \(ctrl \*ControllerWithTraces\) SaveAccountMetadata\(ctx context.Context, parameters Parameters\[SaveAccountMetadata\]\) error](<#ControllerWithTraces.SaveAccountMetadata>)
  - [func \(ctrl \*ControllerWithTraces\) SaveTransactionMetadata\(ctx context.Context, parameters Parameters\[SaveTransactionMetadata\]\) error](<#ControllerWithTraces.SaveTransactionMetadata>)
- [type DefaultController](<#DefaultController>)
  - [func NewDefaultController\(ledger ledger.Ledger, store Store, machineFactory MachineFactory\) \*DefaultController](<#NewDefaultController>)
  - [func \(ctrl \*DefaultController\) CountAccounts\(ctx context.Context, a ListAccountsQuery\) \(int, error\)](<#DefaultController.CountAccounts>)
  - [func \(ctrl \*DefaultController\) CountTransactions\(ctx context.Context, q ListTransactionsQuery\) \(int, error\)](<#DefaultController.CountTransactions>)
  - [func \(ctrl \*DefaultController\) CreateTransaction\(ctx context.Context, parameters Parameters\[RunScript\]\) \(\*ledger.CreatedTransaction, error\)](<#DefaultController.CreateTransaction>)
  - [func \(ctrl \*DefaultController\) DeleteAccountMetadata\(ctx context.Context, parameters Parameters\[DeleteAccountMetadata\]\) error](<#DefaultController.DeleteAccountMetadata>)
  - [func \(ctrl \*DefaultController\) DeleteTransactionMetadata\(ctx context.Context, parameters Parameters\[DeleteTransactionMetadata\]\) error](<#DefaultController.DeleteTransactionMetadata>)
  - [func \(ctrl \*DefaultController\) Export\(ctx context.Context, w ExportWriter\) error](<#DefaultController.Export>)
  - [func \(ctrl \*DefaultController\) GetAccount\(ctx context.Context, q GetAccountQuery\) \(\*ledger.Account, error\)](<#DefaultController.GetAccount>)
  - [func \(ctrl \*DefaultController\) GetAggregatedBalances\(ctx context.Context, q GetAggregatedBalanceQuery\) \(ledger.BalancesByAssets, error\)](<#DefaultController.GetAggregatedBalances>)
  - [func \(ctrl \*DefaultController\) GetMigrationsInfo\(ctx context.Context\) \(\[\]migrations.Info, error\)](<#DefaultController.GetMigrationsInfo>)
  - [func \(ctrl \*DefaultController\) GetStats\(ctx context.Context\) \(Stats, error\)](<#DefaultController.GetStats>)
  - [func \(ctrl \*DefaultController\) GetTransaction\(ctx context.Context, query GetTransactionQuery\) \(\*ledger.Transaction, error\)](<#DefaultController.GetTransaction>)
  - [func \(ctrl \*DefaultController\) GetVolumesWithBalances\(ctx context.Context, q GetVolumesWithBalancesQuery\) \(\*bunpaginate.Cursor\[ledger.VolumesWithBalanceByAssetByAccount\], error\)](<#DefaultController.GetVolumesWithBalances>)
  - [func \(ctrl \*DefaultController\) Import\(ctx context.Context, stream chan ledger.Log\) error](<#DefaultController.Import>)
  - [func \(ctrl \*DefaultController\) IsDatabaseUpToDate\(ctx context.Context\) \(bool, error\)](<#DefaultController.IsDatabaseUpToDate>)
  - [func \(ctrl \*DefaultController\) ListAccounts\(ctx context.Context, a ListAccountsQuery\) \(\*bunpaginate.Cursor\[ledger.Account\], error\)](<#DefaultController.ListAccounts>)
  - [func \(ctrl \*DefaultController\) ListLogs\(ctx context.Context, q GetLogsQuery\) \(\*bunpaginate.Cursor\[ledger.Log\], error\)](<#DefaultController.ListLogs>)
  - [func \(ctrl \*DefaultController\) ListTransactions\(ctx context.Context, q ListTransactionsQuery\) \(\*bunpaginate.Cursor\[ledger.Transaction\], error\)](<#DefaultController.ListTransactions>)
  - [func \(ctrl \*DefaultController\) RevertTransaction\(ctx context.Context, parameters Parameters\[RevertTransaction\]\) \(\*ledger.RevertedTransaction, error\)](<#DefaultController.RevertTransaction>)
  - [func \(ctrl \*DefaultController\) SaveAccountMetadata\(ctx context.Context, parameters Parameters\[SaveAccountMetadata\]\) error](<#DefaultController.SaveAccountMetadata>)
  - [func \(ctrl \*DefaultController\) SaveTransactionMetadata\(ctx context.Context, parameters Parameters\[SaveTransactionMetadata\]\) error](<#DefaultController.SaveTransactionMetadata>)
- [type DefaultMachineAdapter](<#DefaultMachineAdapter>)
  - [func NewDefaultMachine\(p program.Program\) \*DefaultMachineAdapter](<#NewDefaultMachine>)
  - [func \(d \*DefaultMachineAdapter\) Execute\(ctx context.Context, tx TX, vars map\[string\]string\) \(\*MachineResult, error\)](<#DefaultMachineAdapter.Execute>)
- [type DefaultMachineFactory](<#DefaultMachineFactory>)
  - [func NewDefaultMachineFactory\(compiler Compiler\) \*DefaultMachineFactory](<#NewDefaultMachineFactory>)
  - [func \(d \*DefaultMachineFactory\) Make\(script string\) \(Machine, error\)](<#DefaultMachineFactory.Make>)
- [type DeleteAccountMetadata](<#DeleteAccountMetadata>)
- [type DeleteTransactionMetadata](<#DeleteTransactionMetadata>)
- [type ErrAlreadyReverted](<#ErrAlreadyReverted>)
  - [func \(e ErrAlreadyReverted\) Error\(\) string](<#ErrAlreadyReverted.Error>)
  - [func \(e ErrAlreadyReverted\) Is\(err error\) bool](<#ErrAlreadyReverted.Is>)
- [type ErrCompilationFailed](<#ErrCompilationFailed>)
  - [func \(e ErrCompilationFailed\) Error\(\) string](<#ErrCompilationFailed.Error>)
  - [func \(e ErrCompilationFailed\) Is\(err error\) bool](<#ErrCompilationFailed.Is>)
- [type ErrIdempotencyKeyConflict](<#ErrIdempotencyKeyConflict>)
  - [func NewErrIdempotencyKeyConflict\(ik string\) ErrIdempotencyKeyConflict](<#NewErrIdempotencyKeyConflict>)
  - [func \(e ErrIdempotencyKeyConflict\) Error\(\) string](<#ErrIdempotencyKeyConflict.Error>)
  - [func \(e ErrIdempotencyKeyConflict\) Is\(err error\) bool](<#ErrIdempotencyKeyConflict.Is>)
- [type ErrImport](<#ErrImport>)
  - [func \(i ErrImport\) Error\(\) string](<#ErrImport.Error>)
  - [func \(i ErrImport\) Is\(err error\) bool](<#ErrImport.Is>)
- [type ErrInsufficientFunds](<#ErrInsufficientFunds>)
- [type ErrInvalidHash](<#ErrInvalidHash>)
  - [func \(i ErrInvalidHash\) Error\(\) string](<#ErrInvalidHash.Error>)
- [type ErrInvalidIdempotencyInput](<#ErrInvalidIdempotencyInput>)
  - [func \(e ErrInvalidIdempotencyInput\) Error\(\) string](<#ErrInvalidIdempotencyInput.Error>)
  - [func \(e ErrInvalidIdempotencyInput\) Is\(err error\) bool](<#ErrInvalidIdempotencyInput.Is>)
- [type ErrInvalidQuery](<#ErrInvalidQuery>)
  - [func NewErrInvalidQuery\(msg string, args ...any\) ErrInvalidQuery](<#NewErrInvalidQuery>)
  - [func \(e ErrInvalidQuery\) Error\(\) string](<#ErrInvalidQuery.Error>)
  - [func \(e ErrInvalidQuery\) Is\(err error\) bool](<#ErrInvalidQuery.Is>)
- [type ErrInvalidVars](<#ErrInvalidVars>)
- [type ErrMetadataOverride](<#ErrMetadataOverride>)
  - [func \(e \*ErrMetadataOverride\) Error\(\) string](<#ErrMetadataOverride.Error>)
  - [func \(e \*ErrMetadataOverride\) Is\(err error\) bool](<#ErrMetadataOverride.Is>)
- [type ErrMissingFeature](<#ErrMissingFeature>)
  - [func NewErrMissingFeature\(feature string\) ErrMissingFeature](<#NewErrMissingFeature>)
  - [func \(e ErrMissingFeature\) Error\(\) string](<#ErrMissingFeature.Error>)
  - [func \(e ErrMissingFeature\) Is\(err error\) bool](<#ErrMissingFeature.Is>)
- [type ErrTransactionReferenceConflict](<#ErrTransactionReferenceConflict>)
  - [func NewErrTransactionReferenceConflict\(reference string\) ErrTransactionReferenceConflict](<#NewErrTransactionReferenceConflict>)
  - [func \(e ErrTransactionReferenceConflict\) Error\(\) string](<#ErrTransactionReferenceConflict.Error>)
  - [func \(e ErrTransactionReferenceConflict\) Is\(err error\) bool](<#ErrTransactionReferenceConflict.Is>)
- [type ExportWriter](<#ExportWriter>)
- [type ExportWriterFn](<#ExportWriterFn>)
  - [func \(fn ExportWriterFn\) Write\(ctx context.Context, log ledger.Log\) error](<#ExportWriterFn.Write>)
- [type FiltersForVolumes](<#FiltersForVolumes>)
- [type GetAccountQuery](<#GetAccountQuery>)
  - [func NewGetAccountQuery\(addr string\) GetAccountQuery](<#NewGetAccountQuery>)
  - [func \(q GetAccountQuery\) WithExpandEffectiveVolumes\(\) GetAccountQuery](<#GetAccountQuery.WithExpandEffectiveVolumes>)
  - [func \(q GetAccountQuery\) WithExpandVolumes\(\) GetAccountQuery](<#GetAccountQuery.WithExpandVolumes>)
  - [func \(q GetAccountQuery\) WithPIT\(pit time.Time\) GetAccountQuery](<#GetAccountQuery.WithPIT>)
- [type GetAggregatedBalanceQuery](<#GetAggregatedBalanceQuery>)
  - [func NewGetAggregatedBalancesQuery\(filter PITFilter, qb query.Builder, useInsertionDate bool\) GetAggregatedBalanceQuery](<#NewGetAggregatedBalancesQuery>)
- [type GetLogsQuery](<#GetLogsQuery>)
  - [func NewListLogsQuery\(options PaginatedQueryOptions\[any\]\) GetLogsQuery](<#NewListLogsQuery>)
  - [func \(q GetLogsQuery\) WithOrder\(order bunpaginate.Order\) GetLogsQuery](<#GetLogsQuery.WithOrder>)
- [type GetTransactionQuery](<#GetTransactionQuery>)
  - [func NewGetTransactionQuery\(id int\) GetTransactionQuery](<#NewGetTransactionQuery>)
  - [func \(q GetTransactionQuery\) WithExpandEffectiveVolumes\(\) GetTransactionQuery](<#GetTransactionQuery.WithExpandEffectiveVolumes>)
  - [func \(q GetTransactionQuery\) WithExpandVolumes\(\) GetTransactionQuery](<#GetTransactionQuery.WithExpandVolumes>)
- [type GetVolumesWithBalancesQuery](<#GetVolumesWithBalancesQuery>)
  - [func NewGetVolumesWithBalancesQuery\(opts PaginatedQueryOptions\[FiltersForVolumes\]\) GetVolumesWithBalancesQuery](<#NewGetVolumesWithBalancesQuery>)
- [type ListAccountsQuery](<#ListAccountsQuery>)
  - [func NewListAccountsQuery\(opts PaginatedQueryOptions\[PITFilterWithVolumes\]\) ListAccountsQuery](<#NewListAccountsQuery>)
  - [func \(q ListAccountsQuery\) WithExpandEffectiveVolumes\(\) ListAccountsQuery](<#ListAccountsQuery.WithExpandEffectiveVolumes>)
  - [func \(q ListAccountsQuery\) WithExpandVolumes\(\) ListAccountsQuery](<#ListAccountsQuery.WithExpandVolumes>)
- [type ListLedgersQuery](<#ListLedgersQuery>)
  - [func NewListLedgersQuery\(pageSize uint64\) ListLedgersQuery](<#NewListLedgersQuery>)
- [type ListTransactionsQuery](<#ListTransactionsQuery>)
  - [func NewListTransactionsQuery\(options PaginatedQueryOptions\[PITFilterWithVolumes\]\) ListTransactionsQuery](<#NewListTransactionsQuery>)
  - [func \(q ListTransactionsQuery\) WithColumn\(column string\) ListTransactionsQuery](<#ListTransactionsQuery.WithColumn>)
- [type Listener](<#Listener>)
- [type Machine](<#Machine>)
- [type MachineFactory](<#MachineFactory>)
- [type MachineResult](<#MachineResult>)
- [type PITFilter](<#PITFilter>)
- [type PITFilterWithVolumes](<#PITFilterWithVolumes>)
- [type PaginatedQueryOptions](<#PaginatedQueryOptions>)
  - [func NewPaginatedQueryOptions\[T any\]\(options T\) PaginatedQueryOptions\[T\]](<#NewPaginatedQueryOptions>)
  - [func \(opts \*PaginatedQueryOptions\[T\]\) UnmarshalJSON\(data \[\]byte\) error](<#PaginatedQueryOptions[T].UnmarshalJSON>)
  - [func \(opts PaginatedQueryOptions\[T\]\) WithPageSize\(pageSize uint64\) PaginatedQueryOptions\[T\]](<#PaginatedQueryOptions[T].WithPageSize>)
  - [func \(opts PaginatedQueryOptions\[T\]\) WithQueryBuilder\(qb query.Builder\) PaginatedQueryOptions\[T\]](<#PaginatedQueryOptions[T].WithQueryBuilder>)
- [type Parameters](<#Parameters>)
- [type RevertTransaction](<#RevertTransaction>)
- [type RunScript](<#RunScript>)
- [type SaveAccountMetadata](<#SaveAccountMetadata>)
- [type SaveTransactionMetadata](<#SaveTransactionMetadata>)
- [type Script](<#Script>)
- [type ScriptV1](<#ScriptV1>)
- [type State](<#State>)
- [type StateRegistry](<#StateRegistry>)
  - [func NewStateRegistry\(\) \*StateRegistry](<#NewStateRegistry>)
  - [func \(r \*StateRegistry\) IsUpToDate\(name string\) bool](<#StateRegistry.IsUpToDate>)
  - [func \(r \*StateRegistry\) SetUpToDate\(name string\)](<#StateRegistry.SetUpToDate>)
  - [func \(r \*StateRegistry\) Upsert\(l ledger.Ledger\) bool](<#StateRegistry.Upsert>)
- [type Stats](<#Stats>)
- [type Store](<#Store>)
- [type TX](<#TX>)


## Variables

<a name="ErrNoPostings"></a>

```go
var ErrNoPostings = errors.New("numscript execution returned no postings")
```

<a name="ErrNotFound"></a>

```go
var ErrNotFound = postgres.ErrNotFound
```

<a name="Balance"></a>
## type [Balance](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L21-L24>)



```go
type Balance struct {
    Asset   string
    Balance *big.Int
}
```

<a name="BalanceQuery"></a>
## type [BalanceQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L26>)



```go
type BalanceQuery = vm.BalanceQuery
```

<a name="Balances"></a>
## type [Balances](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L27>)



```go
type Balances = vm.Balances
```

<a name="CacheConfiguration"></a>
## type [CacheConfiguration](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L35-L37>)



```go
type CacheConfiguration struct {
    MaxCount uint
}
```

<a name="CachedCompiler"></a>
## type [CachedCompiler](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L39-L42>)



```go
type CachedCompiler struct {
    // contains filtered or unexported fields
}
```

<a name="NewCachedCompiler"></a>
### func [NewCachedCompiler](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L68>)

```go
func NewCachedCompiler(compiler Compiler, configuration CacheConfiguration) *CachedCompiler
```



<a name="CachedCompiler.Compile"></a>
### func \(\*CachedCompiler\) [Compile](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L44>)

```go
func (c *CachedCompiler) Compile(script string) (*program.Program, error)
```



<a name="Compiler"></a>
## type [Compiler](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L16-L18>)

Compiler can return following errors:

- ErrCompilationFailed

```go
type Compiler interface {
    Compile(script string) (*program.Program, error)
}
```

<a name="CompilerFn"></a>
## type [CompilerFn](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L19>)



```go
type CompilerFn func(script string) (*program.Program, error)
```

<a name="NewDefaultCompiler"></a>
### func [NewDefaultCompiler](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L25>)

```go
func NewDefaultCompiler() CompilerFn
```



<a name="CompilerFn.Compile"></a>
### func \(CompilerFn\) [Compile](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/compiler.go#L21>)

```go
func (fn CompilerFn) Compile(script string) (*program.Program, error)
```



<a name="Controller"></a>
## type [Controller](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L15-L71>)



```go
type Controller interface {
    // IsDatabaseUpToDate check if the ledger store is up to date, including the bucket and the ledger specifics
    // It returns true if up to date
    IsDatabaseUpToDate(ctx context.Context) (bool, error)
    GetMigrationsInfo(ctx context.Context) ([]migrations.Info, error)
    GetStats(ctx context.Context) (Stats, error)

    GetAccount(ctx context.Context, query GetAccountQuery) (*ledger.Account, error)
    ListAccounts(ctx context.Context, query ListAccountsQuery) (*bunpaginate.Cursor[ledger.Account], error)
    CountAccounts(ctx context.Context, query ListAccountsQuery) (int, error)
    ListLogs(ctx context.Context, query GetLogsQuery) (*bunpaginate.Cursor[ledger.Log], error)
    CountTransactions(ctx context.Context, query ListTransactionsQuery) (int, error)
    ListTransactions(ctx context.Context, query ListTransactionsQuery) (*bunpaginate.Cursor[ledger.Transaction], error)
    GetTransaction(ctx context.Context, query GetTransactionQuery) (*ledger.Transaction, error)
    GetVolumesWithBalances(ctx context.Context, q GetVolumesWithBalancesQuery) (*bunpaginate.Cursor[ledger.VolumesWithBalanceByAssetByAccount], error)
    GetAggregatedBalances(ctx context.Context, q GetAggregatedBalanceQuery) (ledger.BalancesByAssets, error)

    // CreateTransaction accept a numscript script and returns a transaction
    // It can return following errors:
    //  * ErrCompilationFailed
    //  * ErrMetadataOverride
    //  * ErrInvalidVars
    //  * ErrTransactionReferenceConflict
    //  * ErrIdempotencyKeyConflict
    //  * ErrInsufficientFunds
    CreateTransaction(ctx context.Context, parameters Parameters[RunScript]) (*ledger.CreatedTransaction, error)
    // RevertTransaction allow to revert a transaction.
    // It can return following errors:
    //  * ErrInsufficientFunds
    //  * ErrAlreadyReverted
    //  * ErrNotFound
    // Parameter force indicate we want to force revert the transaction even if the accounts does not have funds
    // Parameter atEffectiveDate indicate we want to set the timestamp of the newly created transaction on the timestamp of the reverted transaction
    RevertTransaction(ctx context.Context, parameters Parameters[RevertTransaction]) (*ledger.RevertedTransaction, error)
    // SaveTransactionMetadata allow to add metadata to an existing transaction
    // It can return following errors:
    //  * ErrNotFound
    SaveTransactionMetadata(ctx context.Context, parameters Parameters[SaveTransactionMetadata]) error
    // SaveAccountMetadata allow to add metadata to an account
    // If the account does not exist, it is created
    SaveAccountMetadata(ctx context.Context, parameters Parameters[SaveAccountMetadata]) error
    // DeleteTransactionMetadata allow to remove metadata of a transaction
    // It can return following errors:
    //  * ErrNotFound : indicate the transaction was not found OR the metadata does not exist on the transaction
    DeleteTransactionMetadata(ctx context.Context, parameters Parameters[DeleteTransactionMetadata]) error
    // DeleteAccountMetadata allow to remove metadata of an account
    // It can return following errors:
    //  * ErrNotFound : indicate the account was not found OR the metadata does not exist on the account
    DeleteAccountMetadata(ctx context.Context, parameters Parameters[DeleteAccountMetadata]) error
    // Import allow to import the logs of an existing ledger
    // It can return following errors:
    //  * ErrImport
    // Logs hash must be valid and the ledger.Ledger must be in 'initializing' state
    Import(ctx context.Context, stream chan ledger.Log) error
    // Export allow to export the logs of a ledger
    Export(ctx context.Context, w ExportWriter) error
}
```

<a name="ControllerWithCache"></a>
## type [ControllerWithCache](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_cache.go#L9-L13>)



```go
type ControllerWithCache struct {
    Controller
    // contains filtered or unexported fields
}
```

<a name="NewControllerWithCache"></a>
### func [NewControllerWithCache](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_cache.go#L34>)

```go
func NewControllerWithCache(ledger ledger.Ledger, underlying Controller, registry *StateRegistry) *ControllerWithCache
```



<a name="ControllerWithCache.IsDatabaseUpToDate"></a>
### func \(\*ControllerWithCache\) [IsDatabaseUpToDate](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_cache.go#L15>)

```go
func (c *ControllerWithCache) IsDatabaseUpToDate(ctx context.Context) (bool, error)
```



<a name="ControllerWithEvents"></a>
## type [ControllerWithEvents](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L9-L13>)



```go
type ControllerWithEvents struct {
    Controller
    // contains filtered or unexported fields
}
```

<a name="NewControllerWithEvents"></a>
### func [NewControllerWithEvents](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L15>)

```go
func NewControllerWithEvents(ledger ledger.Ledger, underlying Controller, listener Listener) *ControllerWithEvents
```



<a name="ControllerWithEvents.CreateTransaction"></a>
### func \(\*ControllerWithEvents\) [CreateTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L23>)

```go
func (ctrl *ControllerWithEvents) CreateTransaction(ctx context.Context, parameters Parameters[RunScript]) (*ledger.CreatedTransaction, error)
```



<a name="ControllerWithEvents.DeleteAccountMetadata"></a>
### func \(\*ControllerWithEvents\) [DeleteAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L106>)

```go
func (ctrl *ControllerWithEvents) DeleteAccountMetadata(ctx context.Context, parameters Parameters[DeleteAccountMetadata]) error
```



<a name="ControllerWithEvents.DeleteTransactionMetadata"></a>
### func \(\*ControllerWithEvents\) [DeleteTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L88>)

```go
func (ctrl *ControllerWithEvents) DeleteTransactionMetadata(ctx context.Context, parameters Parameters[DeleteTransactionMetadata]) error
```



<a name="ControllerWithEvents.RevertTransaction"></a>
### func \(\*ControllerWithEvents\) [RevertTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L35>)

```go
func (ctrl *ControllerWithEvents) RevertTransaction(ctx context.Context, parameters Parameters[RevertTransaction]) (*ledger.RevertedTransaction, error)
```



<a name="ControllerWithEvents.SaveAccountMetadata"></a>
### func \(\*ControllerWithEvents\) [SaveAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L70>)

```go
func (ctrl *ControllerWithEvents) SaveAccountMetadata(ctx context.Context, parameters Parameters[SaveAccountMetadata]) error
```



<a name="ControllerWithEvents.SaveTransactionMetadata"></a>
### func \(\*ControllerWithEvents\) [SaveTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_events.go#L52>)

```go
func (ctrl *ControllerWithEvents) SaveTransactionMetadata(ctx context.Context, parameters Parameters[SaveTransactionMetadata]) error
```



<a name="ControllerWithTraces"></a>
## type [ControllerWithTraces](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L12-L14>)



```go
type ControllerWithTraces struct {
    // contains filtered or unexported fields
}
```

<a name="NewControllerWithTraces"></a>
### func [NewControllerWithTraces](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L16>)

```go
func NewControllerWithTraces(underlying Controller) *ControllerWithTraces
```



<a name="ControllerWithTraces.CountAccounts"></a>
### func \(\*ControllerWithTraces\) [CountAccounts](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L44>)

```go
func (ctrl *ControllerWithTraces) CountAccounts(ctx context.Context, a ListAccountsQuery) (int, error)
```



<a name="ControllerWithTraces.CountTransactions"></a>
### func \(\*ControllerWithTraces\) [CountTransactions](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L32>)

```go
func (ctrl *ControllerWithTraces) CountTransactions(ctx context.Context, q ListTransactionsQuery) (int, error)
```



<a name="ControllerWithTraces.CreateTransaction"></a>
### func \(\*ControllerWithTraces\) [CreateTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L98>)

```go
func (ctrl *ControllerWithTraces) CreateTransaction(ctx context.Context, parameters Parameters[RunScript]) (*ledger.CreatedTransaction, error)
```



<a name="ControllerWithTraces.DeleteAccountMetadata"></a>
### func \(\*ControllerWithTraces\) [DeleteAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L128>)

```go
func (ctrl *ControllerWithTraces) DeleteAccountMetadata(ctx context.Context, parameters Parameters[DeleteAccountMetadata]) error
```



<a name="ControllerWithTraces.DeleteTransactionMetadata"></a>
### func \(\*ControllerWithTraces\) [DeleteTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L122>)

```go
func (ctrl *ControllerWithTraces) DeleteTransactionMetadata(ctx context.Context, parameters Parameters[DeleteTransactionMetadata]) error
```



<a name="ControllerWithTraces.Export"></a>
### func \(\*ControllerWithTraces\) [Export](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L80>)

```go
func (ctrl *ControllerWithTraces) Export(ctx context.Context, w ExportWriter) error
```



<a name="ControllerWithTraces.GetAccount"></a>
### func \(\*ControllerWithTraces\) [GetAccount](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L56>)

```go
func (ctrl *ControllerWithTraces) GetAccount(ctx context.Context, q GetAccountQuery) (*ledger.Account, error)
```



<a name="ControllerWithTraces.GetAggregatedBalances"></a>
### func \(\*ControllerWithTraces\) [GetAggregatedBalances](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L62>)

```go
func (ctrl *ControllerWithTraces) GetAggregatedBalances(ctx context.Context, q GetAggregatedBalanceQuery) (ledger.BalancesByAssets, error)
```



<a name="ControllerWithTraces.GetMigrationsInfo"></a>
### func \(\*ControllerWithTraces\) [GetMigrationsInfo](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L22>)

```go
func (ctrl *ControllerWithTraces) GetMigrationsInfo(ctx context.Context) ([]migrations.Info, error)
```



<a name="ControllerWithTraces.GetStats"></a>
### func \(\*ControllerWithTraces\) [GetStats](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L134>)

```go
func (ctrl *ControllerWithTraces) GetStats(ctx context.Context) (Stats, error)
```



<a name="ControllerWithTraces.GetTransaction"></a>
### func \(\*ControllerWithTraces\) [GetTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L38>)

```go
func (ctrl *ControllerWithTraces) GetTransaction(ctx context.Context, query GetTransactionQuery) (*ledger.Transaction, error)
```



<a name="ControllerWithTraces.GetVolumesWithBalances"></a>
### func \(\*ControllerWithTraces\) [GetVolumesWithBalances](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L92>)

```go
func (ctrl *ControllerWithTraces) GetVolumesWithBalances(ctx context.Context, q GetVolumesWithBalancesQuery) (*bunpaginate.Cursor[ledger.VolumesWithBalanceByAssetByAccount], error)
```



<a name="ControllerWithTraces.Import"></a>
### func \(\*ControllerWithTraces\) [Import](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L74>)

```go
func (ctrl *ControllerWithTraces) Import(ctx context.Context, stream chan ledger.Log) error
```



<a name="ControllerWithTraces.IsDatabaseUpToDate"></a>
### func \(\*ControllerWithTraces\) [IsDatabaseUpToDate](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L86>)

```go
func (ctrl *ControllerWithTraces) IsDatabaseUpToDate(ctx context.Context) (bool, error)
```



<a name="ControllerWithTraces.ListAccounts"></a>
### func \(\*ControllerWithTraces\) [ListAccounts](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L50>)

```go
func (ctrl *ControllerWithTraces) ListAccounts(ctx context.Context, a ListAccountsQuery) (*bunpaginate.Cursor[ledger.Account], error)
```



<a name="ControllerWithTraces.ListLogs"></a>
### func \(\*ControllerWithTraces\) [ListLogs](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L68>)

```go
func (ctrl *ControllerWithTraces) ListLogs(ctx context.Context, q GetLogsQuery) (*bunpaginate.Cursor[ledger.Log], error)
```



<a name="ControllerWithTraces.ListTransactions"></a>
### func \(\*ControllerWithTraces\) [ListTransactions](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L26>)

```go
func (ctrl *ControllerWithTraces) ListTransactions(ctx context.Context, q ListTransactionsQuery) (*bunpaginate.Cursor[ledger.Transaction], error)
```



<a name="ControllerWithTraces.RevertTransaction"></a>
### func \(\*ControllerWithTraces\) [RevertTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L104>)

```go
func (ctrl *ControllerWithTraces) RevertTransaction(ctx context.Context, parameters Parameters[RevertTransaction]) (*ledger.RevertedTransaction, error)
```



<a name="ControllerWithTraces.SaveAccountMetadata"></a>
### func \(\*ControllerWithTraces\) [SaveAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L116>)

```go
func (ctrl *ControllerWithTraces) SaveAccountMetadata(ctx context.Context, parameters Parameters[SaveAccountMetadata]) error
```



<a name="ControllerWithTraces.SaveTransactionMetadata"></a>
### func \(\*ControllerWithTraces\) [SaveTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_with_traces.go#L110>)

```go
func (ctrl *ControllerWithTraces) SaveTransactionMetadata(ctx context.Context, parameters Parameters[SaveTransactionMetadata]) error
```



<a name="DefaultController"></a>
## type [DefaultController](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L30-L34>)



```go
type DefaultController struct {
    // contains filtered or unexported fields
}
```

<a name="NewDefaultController"></a>
### func [NewDefaultController](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L36-L40>)

```go
func NewDefaultController(ledger ledger.Ledger, store Store, machineFactory MachineFactory) *DefaultController
```



<a name="DefaultController.CountAccounts"></a>
### func \(\*DefaultController\) [CountAccounts](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L66>)

```go
func (ctrl *DefaultController) CountAccounts(ctx context.Context, a ListAccountsQuery) (int, error)
```



<a name="DefaultController.CountTransactions"></a>
### func \(\*DefaultController\) [CountTransactions](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L58>)

```go
func (ctrl *DefaultController) CountTransactions(ctx context.Context, q ListTransactionsQuery) (int, error)
```



<a name="DefaultController.CreateTransaction"></a>
### func \(\*DefaultController\) [CreateTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L210>)

```go
func (ctrl *DefaultController) CreateTransaction(ctx context.Context, parameters Parameters[RunScript]) (*ledger.CreatedTransaction, error)
```



<a name="DefaultController.DeleteAccountMetadata"></a>
### func \(\*DefaultController\) [DeleteAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L402>)

```go
func (ctrl *DefaultController) DeleteAccountMetadata(ctx context.Context, parameters Parameters[DeleteAccountMetadata]) error
```



<a name="DefaultController.DeleteTransactionMetadata"></a>
### func \(\*DefaultController\) [DeleteTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L381>)

```go
func (ctrl *DefaultController) DeleteTransactionMetadata(ctx context.Context, parameters Parameters[DeleteTransactionMetadata]) error
```



<a name="DefaultController.Export"></a>
### func \(\*DefaultController\) [Export](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L183>)

```go
func (ctrl *DefaultController) Export(ctx context.Context, w ExportWriter) error
```



<a name="DefaultController.GetAccount"></a>
### func \(\*DefaultController\) [GetAccount](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L74>)

```go
func (ctrl *DefaultController) GetAccount(ctx context.Context, q GetAccountQuery) (*ledger.Account, error)
```



<a name="DefaultController.GetAggregatedBalances"></a>
### func \(\*DefaultController\) [GetAggregatedBalances](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L78>)

```go
func (ctrl *DefaultController) GetAggregatedBalances(ctx context.Context, q GetAggregatedBalanceQuery) (ledger.BalancesByAssets, error)
```



<a name="DefaultController.GetMigrationsInfo"></a>
### func \(\*DefaultController\) [GetMigrationsInfo](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L50>)

```go
func (ctrl *DefaultController) GetMigrationsInfo(ctx context.Context) ([]migrations.Info, error)
```



<a name="DefaultController.GetStats"></a>
### func \(\*DefaultController\) [GetStats](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/stats.go#L13>)

```go
func (ctrl *DefaultController) GetStats(ctx context.Context) (Stats, error)
```



<a name="DefaultController.GetTransaction"></a>
### func \(\*DefaultController\) [GetTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L62>)

```go
func (ctrl *DefaultController) GetTransaction(ctx context.Context, query GetTransactionQuery) (*ledger.Transaction, error)
```



<a name="DefaultController.GetVolumesWithBalances"></a>
### func \(\*DefaultController\) [GetVolumesWithBalances](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L206>)

```go
func (ctrl *DefaultController) GetVolumesWithBalances(ctx context.Context, q GetVolumesWithBalancesQuery) (*bunpaginate.Cursor[ledger.VolumesWithBalanceByAssetByAccount], error)
```



<a name="DefaultController.Import"></a>
### func \(\*DefaultController\) [Import](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L86>)

```go
func (ctrl *DefaultController) Import(ctx context.Context, stream chan ledger.Log) error
```



<a name="DefaultController.IsDatabaseUpToDate"></a>
### func \(\*DefaultController\) [IsDatabaseUpToDate](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L202>)

```go
func (ctrl *DefaultController) IsDatabaseUpToDate(ctx context.Context) (bool, error)
```



<a name="DefaultController.ListAccounts"></a>
### func \(\*DefaultController\) [ListAccounts](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L70>)

```go
func (ctrl *DefaultController) ListAccounts(ctx context.Context, a ListAccountsQuery) (*bunpaginate.Cursor[ledger.Account], error)
```



<a name="DefaultController.ListLogs"></a>
### func \(\*DefaultController\) [ListLogs](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L82>)

```go
func (ctrl *DefaultController) ListLogs(ctx context.Context, q GetLogsQuery) (*bunpaginate.Cursor[ledger.Log], error)
```



<a name="DefaultController.ListTransactions"></a>
### func \(\*DefaultController\) [ListTransactions](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L54>)

```go
func (ctrl *DefaultController) ListTransactions(ctx context.Context, q ListTransactionsQuery) (*bunpaginate.Cursor[ledger.Transaction], error)
```



<a name="DefaultController.RevertTransaction"></a>
### func \(\*DefaultController\) [RevertTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L278>)

```go
func (ctrl *DefaultController) RevertTransaction(ctx context.Context, parameters Parameters[RevertTransaction]) (*ledger.RevertedTransaction, error)
```



<a name="DefaultController.SaveAccountMetadata"></a>
### func \(\*DefaultController\) [SaveAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L358>)

```go
func (ctrl *DefaultController) SaveAccountMetadata(ctx context.Context, parameters Parameters[SaveAccountMetadata]) error
```



<a name="DefaultController.SaveTransactionMetadata"></a>
### func \(\*DefaultController\) [SaveTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller_default.go#L343>)

```go
func (ctrl *DefaultController) SaveTransactionMetadata(ctx context.Context, parameters Parameters[SaveTransactionMetadata]) error
```



<a name="DefaultMachineAdapter"></a>
## type [DefaultMachineAdapter](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine.go#L29-L32>)



```go
type DefaultMachineAdapter struct {
    // contains filtered or unexported fields
}
```

<a name="NewDefaultMachine"></a>
### func [NewDefaultMachine](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine.go#L82>)

```go
func NewDefaultMachine(p program.Program) *DefaultMachineAdapter
```



<a name="DefaultMachineAdapter.Execute"></a>
### func \(\*DefaultMachineAdapter\) [Execute](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine.go#L34>)

```go
func (d *DefaultMachineAdapter) Execute(ctx context.Context, tx TX, vars map[string]string) (*MachineResult, error)
```



<a name="DefaultMachineFactory"></a>
## type [DefaultMachineFactory](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine_factory.go#L11-L13>)



```go
type DefaultMachineFactory struct {
    // contains filtered or unexported fields
}
```

<a name="NewDefaultMachineFactory"></a>
### func [NewDefaultMachineFactory](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine_factory.go#L23>)

```go
func NewDefaultMachineFactory(compiler Compiler) *DefaultMachineFactory
```



<a name="DefaultMachineFactory.Make"></a>
### func \(\*DefaultMachineFactory\) [Make](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine_factory.go#L15>)

```go
func (d *DefaultMachineFactory) Make(script string) (Machine, error)
```



<a name="DeleteAccountMetadata"></a>
## type [DeleteAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L98-L101>)



```go
type DeleteAccountMetadata struct {
    Address string
    Key     string
}
```

<a name="DeleteTransactionMetadata"></a>
## type [DeleteTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L93-L96>)



```go
type DeleteTransactionMetadata struct {
    TransactionID int
    Key           string
}
```

<a name="ErrAlreadyReverted"></a>
## type [ErrAlreadyReverted](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L70-L72>)



```go
type ErrAlreadyReverted struct {
    // contains filtered or unexported fields
}
```

<a name="ErrAlreadyReverted.Error"></a>
### func \(ErrAlreadyReverted\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L74>)

```go
func (e ErrAlreadyReverted) Error() string
```



<a name="ErrAlreadyReverted.Is"></a>
### func \(ErrAlreadyReverted\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L78>)

```go
func (e ErrAlreadyReverted) Is(err error) bool
```



<a name="ErrCompilationFailed"></a>
## type [ErrCompilationFailed](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L170-L172>)

ErrCompilationFailed is used for any errors returned by the numscript interpreter

```go
type ErrCompilationFailed struct {
    // contains filtered or unexported fields
}
```

<a name="ErrCompilationFailed.Error"></a>
### func \(ErrCompilationFailed\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L174>)

```go
func (e ErrCompilationFailed) Error() string
```



<a name="ErrCompilationFailed.Is"></a>
### func \(ErrCompilationFailed\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L178>)

```go
func (e ErrCompilationFailed) Is(err error) bool
```



<a name="ErrIdempotencyKeyConflict"></a>
## type [ErrIdempotencyKeyConflict](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L129-L131>)



```go
type ErrIdempotencyKeyConflict struct {
    // contains filtered or unexported fields
}
```

<a name="NewErrIdempotencyKeyConflict"></a>
### func [NewErrIdempotencyKeyConflict](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L142>)

```go
func NewErrIdempotencyKeyConflict(ik string) ErrIdempotencyKeyConflict
```



<a name="ErrIdempotencyKeyConflict.Error"></a>
### func \(ErrIdempotencyKeyConflict\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L133>)

```go
func (e ErrIdempotencyKeyConflict) Error() string
```



<a name="ErrIdempotencyKeyConflict.Is"></a>
### func \(ErrIdempotencyKeyConflict\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L137>)

```go
func (e ErrIdempotencyKeyConflict) Is(err error) bool
```



<a name="ErrImport"></a>
## type [ErrImport](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L16-L18>)



```go
type ErrImport struct {
    // contains filtered or unexported fields
}
```

<a name="ErrImport.Error"></a>
### func \(ErrImport\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L20>)

```go
func (i ErrImport) Error() string
```



<a name="ErrImport.Is"></a>
### func \(ErrImport\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L24>)

```go
func (i ErrImport) Is(err error) bool
```



<a name="ErrInsufficientFunds"></a>
## type [ErrInsufficientFunds](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L66>)

todo\(waiting\): need a more precise underlying error notes\(gfyrag\): Waiting new interpreter

```go
type ErrInsufficientFunds = machine.ErrInsufficientFund
```

<a name="ErrInvalidHash"></a>
## type [ErrInvalidHash](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L39-L43>)



```go
type ErrInvalidHash struct {
    // contains filtered or unexported fields
}
```

<a name="ErrInvalidHash.Error"></a>
### func \(ErrInvalidHash\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L45>)

```go
func (i ErrInvalidHash) Error() string
```



<a name="ErrInvalidIdempotencyInput"></a>
## type [ErrInvalidIdempotencyInput](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L211-L215>)

ErrInvalidIdempotencyInput is used when a IK is used with an inputs different from the original one. For example, try to use the same IK with a different numscript script will result with that error.

```go
type ErrInvalidIdempotencyInput struct {
    // contains filtered or unexported fields
}
```

<a name="ErrInvalidIdempotencyInput.Error"></a>
### func \(ErrInvalidIdempotencyInput\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L217>)

```go
func (e ErrInvalidIdempotencyInput) Error() string
```



<a name="ErrInvalidIdempotencyInput.Is"></a>
### func \(ErrInvalidIdempotencyInput\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L226>)

```go
func (e ErrInvalidIdempotencyInput) Is(err error) bool
```



<a name="ErrInvalidQuery"></a>
## type [ErrInvalidQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L91-L93>)



```go
type ErrInvalidQuery struct {
    // contains filtered or unexported fields
}
```

<a name="NewErrInvalidQuery"></a>
### func [NewErrInvalidQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L104>)

```go
func NewErrInvalidQuery(msg string, args ...any) ErrInvalidQuery
```



<a name="ErrInvalidQuery.Error"></a>
### func \(ErrInvalidQuery\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L95>)

```go
func (e ErrInvalidQuery) Error() string
```



<a name="ErrInvalidQuery.Is"></a>
### func \(ErrInvalidQuery\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L99>)

```go
func (e ErrInvalidQuery) Is(err error) bool
```



<a name="ErrInvalidVars"></a>
## type [ErrInvalidVars](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L167>)



```go
type ErrInvalidVars = machine.ErrInvalidVars
```

<a name="ErrMetadataOverride"></a>
## type [ErrMetadataOverride](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L190-L192>)

ErrMetadataOverride is used when a metadata is defined at numscript level AND at the input level

```go
type ErrMetadataOverride struct {
    // contains filtered or unexported fields
}
```

<a name="ErrMetadataOverride.Error"></a>
### func \(\*ErrMetadataOverride\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L194>)

```go
func (e *ErrMetadataOverride) Error() string
```



<a name="ErrMetadataOverride.Is"></a>
### func \(\*ErrMetadataOverride\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L198>)

```go
func (e *ErrMetadataOverride) Is(err error) bool
```



<a name="ErrMissingFeature"></a>
## type [ErrMissingFeature](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L110-L112>)



```go
type ErrMissingFeature struct {
    // contains filtered or unexported fields
}
```

<a name="NewErrMissingFeature"></a>
### func [NewErrMissingFeature](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L123>)

```go
func NewErrMissingFeature(feature string) ErrMissingFeature
```



<a name="ErrMissingFeature.Error"></a>
### func \(ErrMissingFeature\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L114>)

```go
func (e ErrMissingFeature) Error() string
```



<a name="ErrMissingFeature.Is"></a>
### func \(ErrMissingFeature\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L118>)

```go
func (e ErrMissingFeature) Is(err error) bool
```



<a name="ErrTransactionReferenceConflict"></a>
## type [ErrTransactionReferenceConflict](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L148-L150>)



```go
type ErrTransactionReferenceConflict struct {
    // contains filtered or unexported fields
}
```

<a name="NewErrTransactionReferenceConflict"></a>
### func [NewErrTransactionReferenceConflict](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L161>)

```go
func NewErrTransactionReferenceConflict(reference string) ErrTransactionReferenceConflict
```



<a name="ErrTransactionReferenceConflict.Error"></a>
### func \(ErrTransactionReferenceConflict\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L152>)

```go
func (e ErrTransactionReferenceConflict) Error() string
```



<a name="ErrTransactionReferenceConflict.Is"></a>
### func \(ErrTransactionReferenceConflict\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/errors.go#L156>)

```go
func (e ErrTransactionReferenceConflict) Is(err error) bool
```



<a name="ExportWriter"></a>
## type [ExportWriter](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/export.go#L9-L11>)



```go
type ExportWriter interface {
    Write(ctx context.Context, log ledger.Log) error
}
```

<a name="ExportWriterFn"></a>
## type [ExportWriterFn](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/export.go#L13>)



```go
type ExportWriterFn func(ctx context.Context, log ledger.Log) error
```

<a name="ExportWriterFn.Write"></a>
### func \(ExportWriterFn\) [Write](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/export.go#L15>)

```go
func (fn ExportWriterFn) Write(ctx context.Context, log ledger.Log) error
```



<a name="FiltersForVolumes"></a>
## type [FiltersForVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L251-L255>)



```go
type FiltersForVolumes struct {
    PITFilter
    UseInsertionDate bool
    GroupLvl         int
}
```

<a name="GetAccountQuery"></a>
## type [GetAccountQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L135-L138>)



```go
type GetAccountQuery struct {
    PITFilterWithVolumes
    Addr string
}
```

<a name="NewGetAccountQuery"></a>
### func [NewGetAccountQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L158>)

```go
func NewGetAccountQuery(addr string) GetAccountQuery
```



<a name="GetAccountQuery.WithExpandEffectiveVolumes"></a>
### func \(GetAccountQuery\) [WithExpandEffectiveVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L152>)

```go
func (q GetAccountQuery) WithExpandEffectiveVolumes() GetAccountQuery
```



<a name="GetAccountQuery.WithExpandVolumes"></a>
### func \(GetAccountQuery\) [WithExpandVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L146>)

```go
func (q GetAccountQuery) WithExpandVolumes() GetAccountQuery
```



<a name="GetAccountQuery.WithPIT"></a>
### func \(GetAccountQuery\) [WithPIT](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L140>)

```go
func (q GetAccountQuery) WithPIT(pit time.Time) GetAccountQuery
```



<a name="GetAggregatedBalanceQuery"></a>
## type [GetAggregatedBalanceQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L164-L168>)



```go
type GetAggregatedBalanceQuery struct {
    PITFilter
    QueryBuilder     query.Builder
    UseInsertionDate bool
}
```

<a name="NewGetAggregatedBalancesQuery"></a>
### func [NewGetAggregatedBalancesQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L170>)

```go
func NewGetAggregatedBalancesQuery(filter PITFilter, qb query.Builder, useInsertionDate bool) GetAggregatedBalanceQuery
```



<a name="GetLogsQuery"></a>
## type [GetLogsQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L257>)



```go
type GetLogsQuery bunpaginate.ColumnPaginatedQuery[PaginatedQueryOptions[any]]
```

<a name="NewListLogsQuery"></a>
### func [NewListLogsQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L264>)

```go
func NewListLogsQuery(options PaginatedQueryOptions[any]) GetLogsQuery
```



<a name="GetLogsQuery.WithOrder"></a>
### func \(GetLogsQuery\) [WithOrder](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L259>)

```go
func (q GetLogsQuery) WithOrder(order bunpaginate.Order) GetLogsQuery
```



<a name="GetTransactionQuery"></a>
## type [GetTransactionQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L89-L92>)



```go
type GetTransactionQuery struct {
    PITFilterWithVolumes
    ID  int
}
```

<a name="NewGetTransactionQuery"></a>
### func [NewGetTransactionQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L106>)

```go
func NewGetTransactionQuery(id int) GetTransactionQuery
```



<a name="GetTransactionQuery.WithExpandEffectiveVolumes"></a>
### func \(GetTransactionQuery\) [WithExpandEffectiveVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L100>)

```go
func (q GetTransactionQuery) WithExpandEffectiveVolumes() GetTransactionQuery
```



<a name="GetTransactionQuery.WithExpandVolumes"></a>
### func \(GetTransactionQuery\) [WithExpandVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L94>)

```go
func (q GetTransactionQuery) WithExpandVolumes() GetTransactionQuery
```



<a name="GetVolumesWithBalancesQuery"></a>
## type [GetVolumesWithBalancesQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L178>)



```go
type GetVolumesWithBalancesQuery bunpaginate.OffsetPaginatedQuery[PaginatedQueryOptions[FiltersForVolumes]]
```

<a name="NewGetVolumesWithBalancesQuery"></a>
### func [NewGetVolumesWithBalancesQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L180>)

```go
func NewGetVolumesWithBalancesQuery(opts PaginatedQueryOptions[FiltersForVolumes]) GetVolumesWithBalancesQuery
```



<a name="ListAccountsQuery"></a>
## type [ListAccountsQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L113>)



```go
type ListAccountsQuery bunpaginate.OffsetPaginatedQuery[PaginatedQueryOptions[PITFilterWithVolumes]]
```

<a name="NewListAccountsQuery"></a>
### func [NewListAccountsQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L127>)

```go
func NewListAccountsQuery(opts PaginatedQueryOptions[PITFilterWithVolumes]) ListAccountsQuery
```



<a name="ListAccountsQuery.WithExpandEffectiveVolumes"></a>
### func \(ListAccountsQuery\) [WithExpandEffectiveVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L121>)

```go
func (q ListAccountsQuery) WithExpandEffectiveVolumes() ListAccountsQuery
```



<a name="ListAccountsQuery.WithExpandVolumes"></a>
### func \(ListAccountsQuery\) [WithExpandVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L115>)

```go
func (q ListAccountsQuery) WithExpandVolumes() ListAccountsQuery
```



<a name="ListLedgersQuery"></a>
## type [ListLedgersQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L293>)



```go
type ListLedgersQuery bunpaginate.OffsetPaginatedQuery[PaginatedQueryOptions[struct{}]]
```

<a name="NewListLedgersQuery"></a>
### func [NewListLedgersQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L295>)

```go
func NewListLedgersQuery(pageSize uint64) ListLedgersQuery
```



<a name="ListTransactionsQuery"></a>
## type [ListTransactionsQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L71>)



```go
type ListTransactionsQuery bunpaginate.ColumnPaginatedQuery[PaginatedQueryOptions[PITFilterWithVolumes]]
```

<a name="NewListTransactionsQuery"></a>
### func [NewListTransactionsQuery](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L80>)

```go
func NewListTransactionsQuery(options PaginatedQueryOptions[PITFilterWithVolumes]) ListTransactionsQuery
```



<a name="ListTransactionsQuery.WithColumn"></a>
### func \(ListTransactionsQuery\) [WithColumn](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L73>)

```go
func (q ListTransactionsQuery) WithColumn(column string) ListTransactionsQuery
```



<a name="Listener"></a>
## type [Listener](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/listener.go#L11-L16>)



```go
type Listener interface {
    CommittedTransactions(ctx context.Context, ledger string, res ledger.Transaction, accountMetadata ledger.AccountMetadata)
    SavedMetadata(ctx context.Context, ledger string, targetType, id string, metadata metadata.Metadata)
    RevertedTransaction(ctx context.Context, ledger string, reverted, revert ledger.Transaction)
    DeletedMetadata(ctx context.Context, ledger string, targetType string, targetID any, key string)
}
```

<a name="Machine"></a>
## type [Machine](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine.go#L25-L27>)



```go
type Machine interface {
    Execute(context.Context, TX, map[string]string) (*MachineResult, error)
}
```

<a name="MachineFactory"></a>
## type [MachineFactory](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine_factory.go#L5-L9>)



```go
type MachineFactory interface {
    // Make can return following errors:
    //  * ErrCompilationFailed
    Make(script string) (Machine, error)
}
```

<a name="MachineResult"></a>
## type [MachineResult](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/machine.go#L18-L22>)



```go
type MachineResult struct {
    Postings        ledger.Postings   `json:"postings"`
    Metadata        metadata.Metadata `json:"metadata"`
    AccountMetadata map[string]metadata.Metadata
}
```

<a name="PITFilter"></a>
## type [PITFilter](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L240-L243>)



```go
type PITFilter struct {
    PIT *time.Time `json:"pit"`
    OOT *time.Time `json:"oot"`
}
```

<a name="PITFilterWithVolumes"></a>
## type [PITFilterWithVolumes](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L245-L249>)



```go
type PITFilterWithVolumes struct {
    PITFilter
    ExpandVolumes          bool `json:"volumes"`
    ExpandEffectiveVolumes bool `json:"effectiveVolumes"`
}
```

<a name="PaginatedQueryOptions"></a>
## type [PaginatedQueryOptions](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L188-L192>)



```go
type PaginatedQueryOptions[T any] struct {
    QueryBuilder query.Builder `json:"qb"`
    PageSize     uint64        `json:"pageSize"`
    Options      T             `json:"options"`
}
```

<a name="NewPaginatedQueryOptions"></a>
### func [NewPaginatedQueryOptions](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L233>)

```go
func NewPaginatedQueryOptions[T any](options T) PaginatedQueryOptions[T]
```



<a name="PaginatedQueryOptions[T].UnmarshalJSON"></a>
### func \(\*PaginatedQueryOptions\[T\]\) [UnmarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L194>)

```go
func (opts *PaginatedQueryOptions[T]) UnmarshalJSON(data []byte) error
```



<a name="PaginatedQueryOptions[T].WithPageSize"></a>
### func \(PaginatedQueryOptions\[T\]\) [WithPageSize](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L227>)

```go
func (opts PaginatedQueryOptions[T]) WithPageSize(pageSize uint64) PaginatedQueryOptions[T]
```



<a name="PaginatedQueryOptions[T].WithQueryBuilder"></a>
### func \(PaginatedQueryOptions\[T\]\) [WithQueryBuilder](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L221>)

```go
func (opts PaginatedQueryOptions[T]) WithQueryBuilder(qb query.Builder) PaginatedQueryOptions[T]
```



<a name="Parameters"></a>
## type [Parameters](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/parameters.go#L3-L7>)



```go
type Parameters[INPUT any] struct {
    DryRun         bool
    IdempotencyKey string
    Input          INPUT
}
```

<a name="RevertTransaction"></a>
## type [RevertTransaction](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L77-L81>)



```go
type RevertTransaction struct {
    Force           bool
    AtEffectiveDate bool
    TransactionID   int
}
```

<a name="RunScript"></a>
## type [RunScript](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L73>)



```go
type RunScript = vm.RunScript
```

<a name="SaveAccountMetadata"></a>
## type [SaveAccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L88-L91>)



```go
type SaveAccountMetadata struct {
    Address  string
    Metadata metadata.Metadata
}
```

<a name="SaveTransactionMetadata"></a>
## type [SaveTransactionMetadata](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L83-L86>)



```go
type SaveTransactionMetadata struct {
    TransactionID int
    Metadata      metadata.Metadata
}
```

<a name="Script"></a>
## type [Script](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L74>)



```go
type Script = vm.Script
```

<a name="ScriptV1"></a>
## type [ScriptV1](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/controller.go#L75>)



```go
type ScriptV1 = vm.ScriptV1
```

<a name="State"></a>
## type [State](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/state_registry.go#L9-L12>)



```go
type State struct {
    // contains filtered or unexported fields
}
```

<a name="StateRegistry"></a>
## type [StateRegistry](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/state_registry.go#L14-L17>)



```go
type StateRegistry struct {
    // contains filtered or unexported fields
}
```

<a name="NewStateRegistry"></a>
### func [NewStateRegistry](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/state_registry.go#L51>)

```go
func NewStateRegistry() *StateRegistry
```



<a name="StateRegistry.IsUpToDate"></a>
### func \(\*StateRegistry\) [IsUpToDate](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/state_registry.go#L39>)

```go
func (r *StateRegistry) IsUpToDate(name string) bool
```



<a name="StateRegistry.SetUpToDate"></a>
### func \(\*StateRegistry\) [SetUpToDate](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/state_registry.go#L32>)

```go
func (r *StateRegistry) SetUpToDate(name string)
```



<a name="StateRegistry.Upsert"></a>
### func \(\*StateRegistry\) [Upsert](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/state_registry.go#L19>)

```go
func (r *StateRegistry) Upsert(l ledger.Ledger) bool
```



<a name="Stats"></a>
## type [Stats](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/stats.go#L8-L11>)



```go
type Stats struct {
    Transactions int `json:"transactions"`
    Accounts     int `json:"accounts"`
}
```

<a name="Store"></a>
## type [Store](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L53-L69>)



```go
type Store interface {
    WithTX(context.Context, *sql.TxOptions, func(TX) (bool, error)) error
    GetDB() bun.IDB
    ListLogs(ctx context.Context, q GetLogsQuery) (*bunpaginate.Cursor[ledger.Log], error)
    ReadLogWithIdempotencyKey(ctx context.Context, ik string) (*ledger.Log, error)

    ListTransactions(ctx context.Context, q ListTransactionsQuery) (*bunpaginate.Cursor[ledger.Transaction], error)
    CountTransactions(ctx context.Context, q ListTransactionsQuery) (int, error)
    GetTransaction(ctx context.Context, query GetTransactionQuery) (*ledger.Transaction, error)
    CountAccounts(ctx context.Context, a ListAccountsQuery) (int, error)
    ListAccounts(ctx context.Context, a ListAccountsQuery) (*bunpaginate.Cursor[ledger.Account], error)
    GetAccount(ctx context.Context, q GetAccountQuery) (*ledger.Account, error)
    GetAggregatedBalances(ctx context.Context, q GetAggregatedBalanceQuery) (ledger.BalancesByAssets, error)
    GetVolumesWithBalances(ctx context.Context, q GetVolumesWithBalancesQuery) (*bunpaginate.Cursor[ledger.VolumesWithBalanceByAssetByAccount], error)
    IsUpToDate(ctx context.Context) (bool, error)
    GetMigrationsInfo(ctx context.Context) ([]migrations.Info, error)
}
```

<a name="TX"></a>
## type [TX](<https://github.com/formancehq/ledger/blob/main/internal/controller/ledger/store.go#L30-L51>)



```go
type TX interface {
    GetAccount(ctx context.Context, query GetAccountQuery) (*ledger.Account, error)
    // GetBalances must returns balance and lock account until the end of the TX
    GetBalances(ctx context.Context, query BalanceQuery) (Balances, error)
    CommitTransaction(ctx context.Context, transaction *ledger.Transaction) error
    // RevertTransaction revert the transaction with identifier id
    // It returns :
    //  * the reverted transaction
    //  * a boolean indicating if the transaction has been reverted. false indicates an already reverted transaction (unless error != nil)
    //  * an error
    RevertTransaction(ctx context.Context, id int) (*ledger.Transaction, bool, error)
    UpdateTransactionMetadata(ctx context.Context, transactionID int, m metadata.Metadata) (*ledger.Transaction, bool, error)
    DeleteTransactionMetadata(ctx context.Context, transactionID int, key string) (*ledger.Transaction, bool, error)
    UpdateAccountsMetadata(ctx context.Context, m map[string]metadata.Metadata) error
    // UpsertAccount returns a boolean indicating if the account was upserted
    UpsertAccount(ctx context.Context, account *ledger.Account) (bool, error)
    DeleteAccountMetadata(ctx context.Context, address, key string) error
    InsertLog(ctx context.Context, log *ledger.Log) error

    LockLedger(ctx context.Context) error
    ListLogs(ctx context.Context, q GetLogsQuery) (*bunpaginate.Cursor[ledger.Log], error)
}
```

Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
