<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# ledger

```go
import "github.com/formancehq/ledger/internal"
```

## Index

- [Constants](<#constants>)
- [Variables](<#variables>)
- [func ComputeIdempotencyHash\(inputs any\) string](<#ComputeIdempotencyHash>)
- [func ComputeMetadata\(key, value string\) metadata.Metadata](<#ComputeMetadata>)
- [func MarkReverts\(m metadata.Metadata, txID uint64\) metadata.Metadata](<#MarkReverts>)
- [func RevertMetadata\(txID uint64\) metadata.Metadata](<#RevertMetadata>)
- [func RevertMetadataSpecKey\(\) string](<#RevertMetadataSpecKey>)
- [func SpecMetadata\(name string\) string](<#SpecMetadata>)
- [type Account](<#Account>)
  - [func \(a Account\) GetAddress\(\) string](<#Account.GetAddress>)
- [type AccountMetadata](<#AccountMetadata>)
- [type AccountsVolumes](<#AccountsVolumes>)
- [type AggregatedVolumes](<#AggregatedVolumes>)
- [type Balances](<#Balances>)
- [type BalancesByAssets](<#BalancesByAssets>)
- [type BalancesByAssetsByAccounts](<#BalancesByAssetsByAccounts>)
- [type Configuration](<#Configuration>)
  - [func NewDefaultConfiguration\(\) Configuration](<#NewDefaultConfiguration>)
  - [func \(c \*Configuration\) SetDefaults\(\)](<#Configuration.SetDefaults>)
  - [func \(c \*Configuration\) Validate\(\) error](<#Configuration.Validate>)
- [type CreatedTransaction](<#CreatedTransaction>)
  - [func \(p CreatedTransaction\) GetMemento\(\) any](<#CreatedTransaction.GetMemento>)
  - [func \(p CreatedTransaction\) Type\(\) LogType](<#CreatedTransaction.Type>)
- [type DeletedMetadata](<#DeletedMetadata>)
  - [func \(s DeletedMetadata\) Type\(\) LogType](<#DeletedMetadata.Type>)
  - [func \(s \*DeletedMetadata\) UnmarshalJSON\(data \[\]byte\) error](<#DeletedMetadata.UnmarshalJSON>)
- [type ErrAlreadyStarted](<#ErrAlreadyStarted>)
  - [func NewErrAlreadyStarted\(id string\) ErrAlreadyStarted](<#NewErrAlreadyStarted>)
  - [func \(e ErrAlreadyStarted\) Error\(\) string](<#ErrAlreadyStarted.Error>)
  - [func \(e ErrAlreadyStarted\) Is\(err error\) bool](<#ErrAlreadyStarted.Is>)
- [type ErrInvalidBucketName](<#ErrInvalidBucketName>)
  - [func \(e ErrInvalidBucketName\) Error\(\) string](<#ErrInvalidBucketName.Error>)
  - [func \(e ErrInvalidBucketName\) Is\(err error\) bool](<#ErrInvalidBucketName.Is>)
- [type ErrInvalidLedgerName](<#ErrInvalidLedgerName>)
  - [func \(e ErrInvalidLedgerName\) Error\(\) string](<#ErrInvalidLedgerName.Error>)
  - [func \(e ErrInvalidLedgerName\) Is\(err error\) bool](<#ErrInvalidLedgerName.Is>)
- [type ErrPipelineAlreadyExists](<#ErrPipelineAlreadyExists>)
  - [func NewErrPipelineAlreadyExists\(pipelineConfiguration PipelineConfiguration\) ErrPipelineAlreadyExists](<#NewErrPipelineAlreadyExists>)
  - [func \(e ErrPipelineAlreadyExists\) Error\(\) string](<#ErrPipelineAlreadyExists.Error>)
  - [func \(e ErrPipelineAlreadyExists\) Is\(err error\) bool](<#ErrPipelineAlreadyExists.Is>)
- [type ErrPipelineNotFound](<#ErrPipelineNotFound>)
  - [func NewErrPipelineNotFound\(id string\) ErrPipelineNotFound](<#NewErrPipelineNotFound>)
  - [func \(e ErrPipelineNotFound\) Error\(\) string](<#ErrPipelineNotFound.Error>)
  - [func \(e ErrPipelineNotFound\) Is\(err error\) bool](<#ErrPipelineNotFound.Is>)
- [type Exporter](<#Exporter>)
  - [func NewExporter\(configuration ExporterConfiguration\) Exporter](<#NewExporter>)
- [type ExporterConfiguration](<#ExporterConfiguration>)
  - [func NewExporterConfiguration\(driver string, config json.RawMessage\) ExporterConfiguration](<#NewExporterConfiguration>)
- [type Ledger](<#Ledger>)
  - [func MustNewWithDefault\(name string\) Ledger](<#MustNewWithDefault>)
  - [func New\(name string, configuration Configuration\) \(\*Ledger, error\)](<#New>)
  - [func NewWithDefaults\(name string\) \(\*Ledger, error\)](<#NewWithDefaults>)
  - [func \(l Ledger\) HasFeature\(feature, value string\) bool](<#Ledger.HasFeature>)
  - [func \(l Ledger\) WithMetadata\(m metadata.Metadata\) Ledger](<#Ledger.WithMetadata>)
- [type Log](<#Log>)
  - [func NewLog\(payload LogPayload\) Log](<#NewLog>)
  - [func \(l Log\) ChainLog\(previous \*Log\) Log](<#Log.ChainLog>)
  - [func \(l \*Log\) ComputeHash\(previous \*Log\)](<#Log.ComputeHash>)
  - [func \(l \*Log\) UnmarshalJSON\(data \[\]byte\) error](<#Log.UnmarshalJSON>)
  - [func \(l Log\) WithDate\(date time.Time\) Log](<#Log.WithDate>)
  - [func \(l Log\) WithID\(i uint64\) Log](<#Log.WithID>)
  - [func \(l Log\) WithIdempotencyKey\(key string\) Log](<#Log.WithIdempotencyKey>)
- [type LogPayload](<#LogPayload>)
  - [func HydrateLog\(\_type LogType, data \[\]byte\) \(LogPayload, error\)](<#HydrateLog>)
- [type LogType](<#LogType>)
  - [func LogTypeFromString\(logType string\) LogType](<#LogTypeFromString>)
  - [func \(lt LogType\) MarshalJSON\(\) \(\[\]byte, error\)](<#LogType.MarshalJSON>)
  - [func \(lt \*LogType\) Scan\(src interface\{\}\) error](<#LogType.Scan>)
  - [func \(lt LogType\) String\(\) string](<#LogType.String>)
  - [func \(lt \*LogType\) UnmarshalJSON\(data \[\]byte\) error](<#LogType.UnmarshalJSON>)
  - [func \(lt LogType\) Value\(\) \(driver.Value, error\)](<#LogType.Value>)
- [type Memento](<#Memento>)
- [type Move](<#Move>)
- [type Moves](<#Moves>)
  - [func \(m Moves\) ComputePostCommitEffectiveVolumes\(\) PostCommitVolumes](<#Moves.ComputePostCommitEffectiveVolumes>)
- [type Pipeline](<#Pipeline>)
  - [func NewPipeline\(pipelineConfiguration PipelineConfiguration\) Pipeline](<#NewPipeline>)
- [type PipelineConfiguration](<#PipelineConfiguration>)
  - [func NewPipelineConfiguration\(ledger, exporterID string\) PipelineConfiguration](<#NewPipelineConfiguration>)
  - [func \(p PipelineConfiguration\) String\(\) string](<#PipelineConfiguration.String>)
- [type PostCommitVolumes](<#PostCommitVolumes>)
  - [func \(a PostCommitVolumes\) AddInput\(account, asset string, input \*big.Int\)](<#PostCommitVolumes.AddInput>)
  - [func \(a PostCommitVolumes\) AddOutput\(account, asset string, output \*big.Int\)](<#PostCommitVolumes.AddOutput>)
  - [func \(a PostCommitVolumes\) Copy\(\) PostCommitVolumes](<#PostCommitVolumes.Copy>)
  - [func \(a PostCommitVolumes\) Merge\(volumes PostCommitVolumes\) PostCommitVolumes](<#PostCommitVolumes.Merge>)
  - [func \(a PostCommitVolumes\) SubtractPostings\(postings Postings\) PostCommitVolumes](<#PostCommitVolumes.SubtractPostings>)
- [type Posting](<#Posting>)
  - [func NewPosting\(source string, destination string, asset string, amount \*big.Int\) Posting](<#NewPosting>)
  - [func \(p Posting\) GetDestination\(\) string](<#Posting.GetDestination>)
  - [func \(p Posting\) GetSource\(\) string](<#Posting.GetSource>)
- [type Postings](<#Postings>)
  - [func \(p Postings\) Reverse\(\) Postings](<#Postings.Reverse>)
  - [func \(p Postings\) Validate\(\) \(int, error\)](<#Postings.Validate>)
- [type RevertedTransaction](<#RevertedTransaction>)
  - [func \(r RevertedTransaction\) GetMemento\(\) any](<#RevertedTransaction.GetMemento>)
  - [func \(r RevertedTransaction\) Type\(\) LogType](<#RevertedTransaction.Type>)
- [type SavedMetadata](<#SavedMetadata>)
  - [func \(s SavedMetadata\) Type\(\) LogType](<#SavedMetadata.Type>)
  - [func \(s \*SavedMetadata\) UnmarshalJSON\(data \[\]byte\) error](<#SavedMetadata.UnmarshalJSON>)
- [type Transaction](<#Transaction>)
  - [func NewTransaction\(\) Transaction](<#NewTransaction>)
  - [func \(tx Transaction\) InvolvedAccounts\(\) \[\]string](<#Transaction.InvolvedAccounts>)
  - [func \(tx Transaction\) InvolvedDestinations\(\) map\[string\]\[\]string](<#Transaction.InvolvedDestinations>)
  - [func \(tx Transaction\) IsReverted\(\) bool](<#Transaction.IsReverted>)
  - [func \(Transaction\) JSONSchemaExtend\(schema \*jsonschema.Schema\)](<#Transaction.JSONSchemaExtend>)
  - [func \(tx Transaction\) MarshalJSON\(\) \(\[\]byte, error\)](<#Transaction.MarshalJSON>)
  - [func \(tx Transaction\) Reverse\(\) Transaction](<#Transaction.Reverse>)
  - [func \(tx Transaction\) VolumeUpdates\(\) \[\]AccountsVolumes](<#Transaction.VolumeUpdates>)
  - [func \(tx Transaction\) WithID\(id uint64\) Transaction](<#Transaction.WithID>)
  - [func \(tx Transaction\) WithInsertedAt\(date time.Time\) Transaction](<#Transaction.WithInsertedAt>)
  - [func \(tx Transaction\) WithMetadata\(m metadata.Metadata\) Transaction](<#Transaction.WithMetadata>)
  - [func \(tx Transaction\) WithPostCommitEffectiveVolumes\(volumes PostCommitVolumes\) Transaction](<#Transaction.WithPostCommitEffectiveVolumes>)
  - [func \(tx Transaction\) WithPostCommitVolumes\(volumes PostCommitVolumes\) Transaction](<#Transaction.WithPostCommitVolumes>)
  - [func \(tx Transaction\) WithPostings\(postings ...Posting\) Transaction](<#Transaction.WithPostings>)
  - [func \(tx Transaction\) WithReference\(ref string\) Transaction](<#Transaction.WithReference>)
  - [func \(tx Transaction\) WithRevertedAt\(timestamp time.Time\) Transaction](<#Transaction.WithRevertedAt>)
  - [func \(tx Transaction\) WithTimestamp\(ts time.Time\) Transaction](<#Transaction.WithTimestamp>)
  - [func \(tx Transaction\) WithUpdatedAt\(at time.Time\) Transaction](<#Transaction.WithUpdatedAt>)
- [type TransactionData](<#TransactionData>)
  - [func NewTransactionData\(\) TransactionData](<#NewTransactionData>)
  - [func \(data TransactionData\) WithPostings\(postings ...Posting\) TransactionData](<#TransactionData.WithPostings>)
- [type Transactions](<#Transactions>)
- [type Volumes](<#Volumes>)
  - [func NewEmptyVolumes\(\) Volumes](<#NewEmptyVolumes>)
  - [func NewVolumesInt64\(input, output int64\) Volumes](<#NewVolumesInt64>)
  - [func \(v Volumes\) Balance\(\) \*big.Int](<#Volumes.Balance>)
  - [func \(v Volumes\) Copy\(\) Volumes](<#Volumes.Copy>)
  - [func \(Volumes\) JSONSchemaExtend\(schema \*jsonschema.Schema\)](<#Volumes.JSONSchemaExtend>)
  - [func \(v Volumes\) MarshalJSON\(\) \(\[\]byte, error\)](<#Volumes.MarshalJSON>)
  - [func \(v \*Volumes\) Scan\(src interface\{\}\) error](<#Volumes.Scan>)
  - [func \(v Volumes\) Value\(\) \(driver.Value, error\)](<#Volumes.Value>)
- [type VolumesByAssets](<#VolumesByAssets>)
  - [func \(v VolumesByAssets\) Balances\(\) BalancesByAssets](<#VolumesByAssets.Balances>)
- [type VolumesWithBalance](<#VolumesWithBalance>)
- [type VolumesWithBalanceByAssetByAccount](<#VolumesWithBalanceByAssetByAccount>)
- [type VolumesWithBalanceByAssets](<#VolumesWithBalanceByAssets>)


## Constants

<a name="StateInitializing"></a>

```go
const (
    StateInitializing = "initializing"
    StateInUse        = "in-use"
)
```

<a name="MetaTargetTypeAccount"></a>

```go
const (
    MetaTargetTypeAccount     = "ACCOUNT"
    MetaTargetTypeTransaction = "TRANSACTION"
)
```

<a name="DefaultBucket"></a>

```go
const (
    DefaultBucket = "_default"
)
```

<a name="WORLD"></a>

```go
const (
    WORLD = "world"
)
```

## Variables

<a name="Zero"></a>

```go
var Zero = big.NewInt(0)
```

<a name="ComputeIdempotencyHash"></a>
## func [ComputeIdempotencyHash](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L390>)

```go
func ComputeIdempotencyHash(inputs any) string
```



<a name="ComputeMetadata"></a>
## func [ComputeMetadata](<https://github.com/formancehq/ledger/blob/main/internal/metadata.go#L28>)

```go
func ComputeMetadata(key, value string) metadata.Metadata
```



<a name="MarkReverts"></a>
## func [MarkReverts](<https://github.com/formancehq/ledger/blob/main/internal/metadata.go#L20>)

```go
func MarkReverts(m metadata.Metadata, txID uint64) metadata.Metadata
```



<a name="RevertMetadata"></a>
## func [RevertMetadata](<https://github.com/formancehq/ledger/blob/main/internal/metadata.go#L34>)

```go
func RevertMetadata(txID uint64) metadata.Metadata
```



<a name="RevertMetadataSpecKey"></a>
## func [RevertMetadataSpecKey](<https://github.com/formancehq/ledger/blob/main/internal/metadata.go#L24>)

```go
func RevertMetadataSpecKey() string
```



<a name="SpecMetadata"></a>
## func [SpecMetadata](<https://github.com/formancehq/ledger/blob/main/internal/metadata.go#L16>)

```go
func SpecMetadata(name string) string
```



<a name="Account"></a>
## type [Account](<https://github.com/formancehq/ledger/blob/main/internal/account.go#L14-L24>)



```go
type Account struct {
    bun.BaseModel `bun:"table:accounts"`

    Address          string            `json:"address" bun:"address"`
    Metadata         metadata.Metadata `json:"metadata" bun:"metadata,type:jsonb,default:'{}'"`
    FirstUsage       time.Time         `json:"firstUsage" bun:"first_usage,nullzero"`
    InsertionDate    time.Time         `json:"insertionDate" bun:"insertion_date,nullzero"`
    UpdatedAt        time.Time         `json:"updatedAt" bun:"updated_at,nullzero"`
    Volumes          VolumesByAssets   `json:"volumes,omitempty" bun:"volumes,scanonly"`
    EffectiveVolumes VolumesByAssets   `json:"effectiveVolumes,omitempty" bun:"effective_volumes,scanonly"`
}
```

<a name="Account.GetAddress"></a>
### func \(Account\) [GetAddress](<https://github.com/formancehq/ledger/blob/main/internal/account.go#L26>)

```go
func (a Account) GetAddress() string
```



<a name="AccountMetadata"></a>
## type [AccountMetadata](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L197>)



```go
type AccountMetadata map[string]metadata.Metadata
```

<a name="AccountsVolumes"></a>
## type [AccountsVolumes](<https://github.com/formancehq/ledger/blob/main/internal/account.go#L30-L37>)



```go
type AccountsVolumes struct {
    bun.BaseModel `bun:"accounts_volumes"`

    Account string   `bun:"accounts_address,type:varchar"`
    Asset   string   `bun:"asset,type:varchar"`
    Input   *big.Int `bun:"input,type:numeric"`
    Output  *big.Int `bun:"output,type:numeric"`
}
```

<a name="AggregatedVolumes"></a>
## type [AggregatedVolumes](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L170-L172>)



```go
type AggregatedVolumes struct {
    Aggregated VolumesByAssets `bun:"aggregated,type:jsonb"`
}
```

<a name="Balances"></a>
## type [Balances](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L174>)



```go
type Balances = map[string]map[string]*big.Int
```

<a name="BalancesByAssets"></a>
## type [BalancesByAssets](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L96>)



```go
type BalancesByAssets map[string]*big.Int
```

<a name="BalancesByAssetsByAccounts"></a>
## type [BalancesByAssetsByAccounts](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L100>)



```go
type BalancesByAssetsByAccounts map[string]BalancesByAssets
```

<a name="Configuration"></a>
## type [Configuration](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L92-L96>)



```go
type Configuration struct {
    Bucket   string              `json:"bucket" bun:"bucket,type:varchar(255)"`
    Metadata metadata.Metadata   `json:"metadata" bun:"metadata,type:jsonb,nullzero"`
    Features features.FeatureSet `json:"features" bun:"features,type:jsonb"`
}
```

<a name="NewDefaultConfiguration"></a>
### func [NewDefaultConfiguration](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L123>)

```go
func NewDefaultConfiguration() Configuration
```



<a name="Configuration.SetDefaults"></a>
### func \(\*Configuration\) [SetDefaults](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L98>)

```go
func (c *Configuration) SetDefaults()
```



<a name="Configuration.Validate"></a>
### func \(\*Configuration\) [Validate](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L113>)

```go
func (c *Configuration) Validate() error
```



<a name="CreatedTransaction"></a>
## type [CreatedTransaction](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L199-L202>)



```go
type CreatedTransaction struct {
    Transaction     Transaction     `json:"transaction"`
    AccountMetadata AccountMetadata `json:"accountMetadata"`
}
```

<a name="CreatedTransaction.GetMemento"></a>
### func \(CreatedTransaction\) [GetMemento](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L210>)

```go
func (p CreatedTransaction) GetMemento() any
```



<a name="CreatedTransaction.Type"></a>
### func \(CreatedTransaction\) [Type](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L204>)

```go
func (p CreatedTransaction) Type() LogType
```



<a name="DeletedMetadata"></a>
## type [DeletedMetadata](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L284-L288>)



```go
type DeletedMetadata struct {
    TargetType string `json:"targetType"`
    TargetID   any    `json:"targetId"`
    Key        string `json:"key"`
}
```

<a name="DeletedMetadata.Type"></a>
### func \(DeletedMetadata\) [Type](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L290>)

```go
func (s DeletedMetadata) Type() LogType
```



<a name="DeletedMetadata.UnmarshalJSON"></a>
### func \(\*DeletedMetadata\) [UnmarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L296>)

```go
func (s *DeletedMetadata) UnmarshalJSON(data []byte) error
```



<a name="ErrAlreadyStarted"></a>
## type [ErrAlreadyStarted](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L75>)



```go
type ErrAlreadyStarted string
```

<a name="NewErrAlreadyStarted"></a>
### func [NewErrAlreadyStarted](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L86>)

```go
func NewErrAlreadyStarted(id string) ErrAlreadyStarted
```



<a name="ErrAlreadyStarted.Error"></a>
### func \(ErrAlreadyStarted\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L77>)

```go
func (e ErrAlreadyStarted) Error() string
```



<a name="ErrAlreadyStarted.Is"></a>
### func \(ErrAlreadyStarted\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L81>)

```go
func (e ErrAlreadyStarted) Is(err error) bool
```



<a name="ErrInvalidBucketName"></a>
## type [ErrInvalidBucketName](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L25-L28>)



```go
type ErrInvalidBucketName struct {
    // contains filtered or unexported fields
}
```

<a name="ErrInvalidBucketName.Error"></a>
### func \(ErrInvalidBucketName\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L30>)

```go
func (e ErrInvalidBucketName) Error() string
```



<a name="ErrInvalidBucketName.Is"></a>
### func \(ErrInvalidBucketName\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L34>)

```go
func (e ErrInvalidBucketName) Is(err error) bool
```



<a name="ErrInvalidLedgerName"></a>
## type [ErrInvalidLedgerName](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L7-L10>)



```go
type ErrInvalidLedgerName struct {
    // contains filtered or unexported fields
}
```

<a name="ErrInvalidLedgerName.Error"></a>
### func \(ErrInvalidLedgerName\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L12>)

```go
func (e ErrInvalidLedgerName) Error() string
```



<a name="ErrInvalidLedgerName.Is"></a>
### func \(ErrInvalidLedgerName\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L16>)

```go
func (e ErrInvalidLedgerName) Is(err error) bool
```



<a name="ErrPipelineAlreadyExists"></a>
## type [ErrPipelineAlreadyExists](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L45>)

ErrPipelineAlreadyExists denotes a pipeline already created The store is in charge of returning this error on a failing call on Store.CreatePipeline

```go
type ErrPipelineAlreadyExists PipelineConfiguration
```

<a name="NewErrPipelineAlreadyExists"></a>
### func [NewErrPipelineAlreadyExists](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L56>)

```go
func NewErrPipelineAlreadyExists(pipelineConfiguration PipelineConfiguration) ErrPipelineAlreadyExists
```



<a name="ErrPipelineAlreadyExists.Error"></a>
### func \(ErrPipelineAlreadyExists\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L47>)

```go
func (e ErrPipelineAlreadyExists) Error() string
```



<a name="ErrPipelineAlreadyExists.Is"></a>
### func \(ErrPipelineAlreadyExists\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L51>)

```go
func (e ErrPipelineAlreadyExists) Is(err error) bool
```



<a name="ErrPipelineNotFound"></a>
## type [ErrPipelineNotFound](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L60>)



```go
type ErrPipelineNotFound string
```

<a name="NewErrPipelineNotFound"></a>
### func [NewErrPipelineNotFound](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L71>)

```go
func NewErrPipelineNotFound(id string) ErrPipelineNotFound
```



<a name="ErrPipelineNotFound.Error"></a>
### func \(ErrPipelineNotFound\) [Error](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L62>)

```go
func (e ErrPipelineNotFound) Error() string
```



<a name="ErrPipelineNotFound.Is"></a>
### func \(ErrPipelineNotFound\) [Is](<https://github.com/formancehq/ledger/blob/main/internal/errors.go#L66>)

```go
func (e ErrPipelineNotFound) Is(err error) bool
```



<a name="Exporter"></a>
## type [Exporter](<https://github.com/formancehq/ledger/blob/main/internal/exporter.go#L23-L29>)



```go
type Exporter struct {
    bun.BaseModel `bun:"table:_system.exporters"`

    ID        string    `json:"id" bun:"id,pk"`
    CreatedAt time.Time `json:"createdAt" bun:"created_at"`
    ExporterConfiguration
}
```

<a name="NewExporter"></a>
### func [NewExporter](<https://github.com/formancehq/ledger/blob/main/internal/exporter.go#L31>)

```go
func NewExporter(configuration ExporterConfiguration) Exporter
```



<a name="ExporterConfiguration"></a>
## type [ExporterConfiguration](<https://github.com/formancehq/ledger/blob/main/internal/exporter.go#L11-L14>)



```go
type ExporterConfiguration struct {
    Driver string          `json:"driver" bun:"driver"`
    Config json.RawMessage `json:"config" bun:"config"`
}
```

<a name="NewExporterConfiguration"></a>
### func [NewExporterConfiguration](<https://github.com/formancehq/ledger/blob/main/internal/exporter.go#L16>)

```go
func NewExporterConfiguration(driver string, config json.RawMessage) ExporterConfiguration
```



<a name="Ledger"></a>
## type [Ledger](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L18-L26>)



```go
type Ledger struct {
    bun.BaseModel `bun:"_system.ledgers,alias:ledgers"`

    Configuration
    ID      int       `json:"id" bun:"id,type:int,scanonly"`
    Name    string    `json:"name" bun:"name,type:varchar(255),pk"`
    AddedAt time.Time `json:"addedAt" bun:"added_at,type:timestamp,nullzero"`
    State   string    `json:"-" bun:"state,type:varchar(255),nullzero"`
}
```

<a name="MustNewWithDefault"></a>
### func [MustNewWithDefault](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L68>)

```go
func MustNewWithDefault(name string) Ledger
```



<a name="New"></a>
### func [New](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L41>)

```go
func New(name string, configuration Configuration) (*Ledger, error)
```



<a name="NewWithDefaults"></a>
### func [NewWithDefaults](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L64>)

```go
func NewWithDefaults(name string) (*Ledger, error)
```



<a name="Ledger.HasFeature"></a>
### func \(Ledger\) [HasFeature](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L28>)

```go
func (l Ledger) HasFeature(feature, value string) bool
```



<a name="Ledger.WithMetadata"></a>
### func \(Ledger\) [WithMetadata](<https://github.com/formancehq/ledger/blob/main/internal/ledger.go#L36>)

```go
func (l Ledger) WithMetadata(m metadata.Metadata) Ledger
```



<a name="Log"></a>
## type [Log](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L84-L96>)

Log represents atomic actions made on the ledger.

```go
type Log struct {
    bun.BaseModel `bun:"table:logs,alias:logs"`

    Type           LogType    `json:"type" bun:"type,type:log_type"`
    Data           LogPayload `json:"data" bun:"data,type:jsonb"`
    Date           time.Time  `json:"date" bun:"date,type:timestamptz,nullzero"`
    IdempotencyKey string     `json:"idempotencyKey" bun:"idempotency_key,type:varchar(256),unique,nullzero"`
    // IdempotencyHash is a signature used when using IdempotencyKey.
    // It allows checking if the usage of IdempotencyKey matches inputs given on the first idempotency key usage.
    IdempotencyHash string  `json:"idempotencyHash" bun:"idempotency_hash,unique,nullzero"`
    ID              *uint64 `json:"id" bun:"id,unique,type:numeric"`
    Hash            []byte  `json:"hash" bun:"hash,type:bytea"`
}
```

<a name="NewLog"></a>
### func [NewLog](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L182>)

```go
func NewLog(payload LogPayload) Log
```



<a name="Log.ChainLog"></a>
### func \(Log\) [ChainLog](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L109>)

```go
func (l Log) ChainLog(previous *Log) Log
```



<a name="Log.ComputeHash"></a>
### func \(\*Log\) [ComputeHash](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L140>)

```go
func (l *Log) ComputeHash(previous *Log)
```



<a name="Log.UnmarshalJSON"></a>
### func \(\*Log\) [UnmarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L120>)

```go
func (l *Log) UnmarshalJSON(data []byte) error
```



<a name="Log.WithDate"></a>
### func \(Log\) [WithDate](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L98>)

```go
func (l Log) WithDate(date time.Time) Log
```



<a name="Log.WithID"></a>
### func \(Log\) [WithID](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L177>)

```go
func (l Log) WithID(i uint64) Log
```



<a name="Log.WithIdempotencyKey"></a>
### func \(Log\) [WithIdempotencyKey](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L104>)

```go
func (l Log) WithIdempotencyKey(key string) Log
```



<a name="LogPayload"></a>
## type [LogPayload](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L189-L191>)



```go
type LogPayload interface {
    Type() LogType
}
```

<a name="HydrateLog"></a>
### func [HydrateLog](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L368>)

```go
func HydrateLog(_type LogType, data []byte) (LogPayload, error)
```



<a name="LogType"></a>
## type [LogType](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L27>)



```go
type LogType int16
```

<a name="SetMetadataLogType"></a>

```go
const (
    SetMetadataLogType         LogType = iota // "SET_METADATA"
    NewTransactionLogType                     // "NEW_TRANSACTION"
    RevertedTransactionLogType                // "REVERTED_TRANSACTION"
    DeleteMetadataLogType
)
```

<a name="LogTypeFromString"></a>
### func [LogTypeFromString](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L68>)

```go
func LogTypeFromString(logType string) LogType
```



<a name="LogType.MarshalJSON"></a>
### func \(LogType\) [MarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L38>)

```go
func (lt LogType) MarshalJSON() ([]byte, error)
```



<a name="LogType.Scan"></a>
### func \(\*LogType\) [Scan](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L33>)

```go
func (lt *LogType) Scan(src interface{}) error
```



<a name="LogType.String"></a>
### func \(LogType\) [String](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L53>)

```go
func (lt LogType) String() string
```



<a name="LogType.UnmarshalJSON"></a>
### func \(\*LogType\) [UnmarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L42>)

```go
func (lt *LogType) UnmarshalJSON(data []byte) error
```



<a name="LogType.Value"></a>
### func \(LogType\) [Value](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L29>)

```go
func (lt LogType) Value() (driver.Value, error)
```



<a name="Memento"></a>
## type [Memento](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L193-L195>)



```go
type Memento interface {
    GetMemento() any
}
```

<a name="Move"></a>
## type [Move](<https://github.com/formancehq/ledger/blob/main/internal/moves.go#L12-L24>)



```go
type Move struct {
    bun.BaseModel `bun:"table:moves"`

    TransactionID              uint64              `bun:"transactions_id,type:bigint"`
    IsSource                   bool                `bun:"is_source,type:bool"`
    Account                    string              `bun:"accounts_address,type:varchar"`
    Amount                     *bunpaginate.BigInt `bun:"amount,type:numeric"`
    Asset                      string              `bun:"asset,type:varchar"`
    InsertionDate              time.Time           `bun:"insertion_date,type:timestamp,nullzero"`
    EffectiveDate              time.Time           `bun:"effective_date,type:timestamp,nullzero"`
    PostCommitVolumes          *Volumes            `bun:"post_commit_volumes,type:jsonb"`
    PostCommitEffectiveVolumes *Volumes            `bun:"post_commit_effective_volumes,type:jsonb,scanonly"`
}
```

<a name="Moves"></a>
## type [Moves](<https://github.com/formancehq/ledger/blob/main/internal/moves.go#L26>)



```go
type Moves []*Move
```

<a name="Moves.ComputePostCommitEffectiveVolumes"></a>
### func \(Moves\) [ComputePostCommitEffectiveVolumes](<https://github.com/formancehq/ledger/blob/main/internal/moves.go#L28>)

```go
func (m Moves) ComputePostCommitEffectiveVolumes() PostCommitVolumes
```



<a name="Pipeline"></a>
## type [Pipeline](<https://github.com/formancehq/ledger/blob/main/internal/pipeline.go#L27-L36>)



```go
type Pipeline struct {
    bun.BaseModel `bun:"table:_system.pipelines"`

    PipelineConfiguration
    CreatedAt time.Time `json:"createdAt" bun:"created_at"`
    ID        string    `json:"id" bun:"id,pk"`
    Enabled   bool      `json:"enabled" bun:"enabled"`
    LastLogID *uint64   `json:"lastLogID,omitempty" bun:"last_log_id"`
    Error     string    `json:"error,omitempty" bun:"error"`
}
```

<a name="NewPipeline"></a>
### func [NewPipeline](<https://github.com/formancehq/ledger/blob/main/internal/pipeline.go#L38>)

```go
func NewPipeline(pipelineConfiguration PipelineConfiguration) Pipeline
```



<a name="PipelineConfiguration"></a>
## type [PipelineConfiguration](<https://github.com/formancehq/ledger/blob/main/internal/pipeline.go#L11-L14>)



```go
type PipelineConfiguration struct {
    Ledger     string `json:"ledger" bun:"ledger"`
    ExporterID string `json:"exporterID" bun:"exporter_id"`
}
```

<a name="NewPipelineConfiguration"></a>
### func [NewPipelineConfiguration](<https://github.com/formancehq/ledger/blob/main/internal/pipeline.go#L20>)

```go
func NewPipelineConfiguration(ledger, exporterID string) PipelineConfiguration
```



<a name="PipelineConfiguration.String"></a>
### func \(PipelineConfiguration\) [String](<https://github.com/formancehq/ledger/blob/main/internal/pipeline.go#L16>)

```go
func (p PipelineConfiguration) String() string
```



<a name="PostCommitVolumes"></a>
## type [PostCommitVolumes](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L118>)



```go
type PostCommitVolumes map[string]VolumesByAssets
```

<a name="PostCommitVolumes.AddInput"></a>
### func \(PostCommitVolumes\) [AddInput](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L133>)

```go
func (a PostCommitVolumes) AddInput(account, asset string, input *big.Int)
```



<a name="PostCommitVolumes.AddOutput"></a>
### func \(PostCommitVolumes\) [AddOutput](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L139>)

```go
func (a PostCommitVolumes) AddOutput(account, asset string, output *big.Int)
```



<a name="PostCommitVolumes.Copy"></a>
### func \(PostCommitVolumes\) [Copy](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L145>)

```go
func (a PostCommitVolumes) Copy() PostCommitVolumes
```



<a name="PostCommitVolumes.Merge"></a>
### func \(PostCommitVolumes\) [Merge](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L153>)

```go
func (a PostCommitVolumes) Merge(volumes PostCommitVolumes) PostCommitVolumes
```



<a name="PostCommitVolumes.SubtractPostings"></a>
### func \(PostCommitVolumes\) [SubtractPostings](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L120>)

```go
func (a PostCommitVolumes) SubtractPostings(postings Postings) PostCommitVolumes
```



<a name="Posting"></a>
## type [Posting](<https://github.com/formancehq/ledger/blob/main/internal/posting.go#L11-L16>)



```go
type Posting struct {
    Source      string   `json:"source"`
    Destination string   `json:"destination"`
    Amount      *big.Int `json:"amount"`
    Asset       string   `json:"asset"`
}
```

<a name="NewPosting"></a>
### func [NewPosting](<https://github.com/formancehq/ledger/blob/main/internal/posting.go#L26>)

```go
func NewPosting(source string, destination string, asset string, amount *big.Int) Posting
```



<a name="Posting.GetDestination"></a>
### func \(Posting\) [GetDestination](<https://github.com/formancehq/ledger/blob/main/internal/posting.go#L22>)

```go
func (p Posting) GetDestination() string
```



<a name="Posting.GetSource"></a>
### func \(Posting\) [GetSource](<https://github.com/formancehq/ledger/blob/main/internal/posting.go#L18>)

```go
func (p Posting) GetSource() string
```



<a name="Postings"></a>
## type [Postings](<https://github.com/formancehq/ledger/blob/main/internal/posting.go#L35>)



```go
type Postings []Posting
```

<a name="Postings.Reverse"></a>
### func \(Postings\) [Reverse](<https://github.com/formancehq/ledger/blob/main/internal/posting.go#L37>)

```go
func (p Postings) Reverse() Postings
```



<a name="Postings.Validate"></a>
### func \(Postings\) [Validate](<https://github.com/formancehq/ledger/blob/main/internal/posting.go#L52>)

```go
func (p Postings) Validate() (int, error)
```



<a name="RevertedTransaction"></a>
## type [RevertedTransaction](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L329-L332>)



```go
type RevertedTransaction struct {
    RevertedTransaction Transaction `json:"revertedTransaction"`
    RevertTransaction   Transaction `json:"transaction"`
}
```

<a name="RevertedTransaction.GetMemento"></a>
### func \(RevertedTransaction\) [GetMemento](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L340>)

```go
func (r RevertedTransaction) GetMemento() any
```



<a name="RevertedTransaction.Type"></a>
### func \(RevertedTransaction\) [Type](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L334>)

```go
func (r RevertedTransaction) Type() LogType
```



<a name="SavedMetadata"></a>
## type [SavedMetadata](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L239-L243>)



```go
type SavedMetadata struct {
    TargetType string            `json:"targetType"`
    TargetID   any               `json:"targetId"`
    Metadata   metadata.Metadata `json:"metadata"`
}
```

<a name="SavedMetadata.Type"></a>
### func \(SavedMetadata\) [Type](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L245>)

```go
func (s SavedMetadata) Type() LogType
```



<a name="SavedMetadata.UnmarshalJSON"></a>
### func \(\*SavedMetadata\) [UnmarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/log.go#L251>)

```go
func (s *SavedMetadata) UnmarshalJSON(data []byte) error
```



<a name="Transaction"></a>
## type [Transaction](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L36-L50>)



```go
type Transaction struct {
    bun.BaseModel `bun:"table:transactions,alias:transactions"`

    TransactionData
    ID         *uint64    `json:"id" bun:"id,type:numeric"`
    InsertedAt time.Time  `json:"insertedAt,omitempty" bun:"inserted_at,type:timestamp without time zone,nullzero"`
    UpdatedAt  time.Time  `json:"updatedAt,omitempty" bun:"updated_at,type:timestamp without time zone,nullzero"`
    RevertedAt *time.Time `json:"revertedAt,omitempty" bun:"reverted_at,type:timestamp without time zone"`
    // PostCommitVolumes are the volumes of each account/asset after a transaction has been committed.
    // Those volumes will never change as those are computed in flight.
    PostCommitVolumes PostCommitVolumes `json:"postCommitVolumes,omitempty" bun:"post_commit_volumes,type:jsonb"`
    // PostCommitEffectiveVolumes are the volumes of each account/asset after the transaction TransactionData.Timestamp.
    // Those volumes are also computed in flight, but can be updated if a transaction is inserted in the past.
    PostCommitEffectiveVolumes PostCommitVolumes `json:"postCommitEffectiveVolumes,omitempty" bun:"post_commit_effective_volumes,type:jsonb,scanonly"`
}
```

<a name="NewTransaction"></a>
### func [NewTransaction](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L227>)

```go
func NewTransaction() Transaction
```



<a name="Transaction.InvolvedAccounts"></a>
### func \(Transaction\) [InvolvedAccounts](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L111>)

```go
func (tx Transaction) InvolvedAccounts() []string
```



<a name="Transaction.InvolvedDestinations"></a>
### func \(Transaction\) [InvolvedDestinations](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L97>)

```go
func (tx Transaction) InvolvedDestinations() map[string][]string
```



<a name="Transaction.IsReverted"></a>
### func \(Transaction\) [IsReverted](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L200>)

```go
func (tx Transaction) IsReverted() bool
```



<a name="Transaction.JSONSchemaExtend"></a>
### func \(Transaction\) [JSONSchemaExtend](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L52>)

```go
func (Transaction) JSONSchemaExtend(schema *jsonschema.Schema)
```



<a name="Transaction.MarshalJSON"></a>
### func \(Transaction\) [MarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L183>)

```go
func (tx Transaction) MarshalJSON() ([]byte, error)
```



<a name="Transaction.Reverse"></a>
### func \(Transaction\) [Reverse](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L61>)

```go
func (tx Transaction) Reverse() Transaction
```



<a name="Transaction.VolumeUpdates"></a>
### func \(Transaction\) [VolumeUpdates](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L122>)

```go
func (tx Transaction) VolumeUpdates() []AccountsVolumes
```



<a name="Transaction.WithID"></a>
### func \(Transaction\) [WithID](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L66>)

```go
func (tx Transaction) WithID(id uint64) Transaction
```



<a name="Transaction.WithInsertedAt"></a>
### func \(Transaction\) [WithInsertedAt](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L91>)

```go
func (tx Transaction) WithInsertedAt(date time.Time) Transaction
```



<a name="Transaction.WithMetadata"></a>
### func \(Transaction\) [WithMetadata](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L86>)

```go
func (tx Transaction) WithMetadata(m metadata.Metadata) Transaction
```



<a name="Transaction.WithPostCommitEffectiveVolumes"></a>
### func \(Transaction\) [WithPostCommitEffectiveVolumes](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L215>)

```go
func (tx Transaction) WithPostCommitEffectiveVolumes(volumes PostCommitVolumes) Transaction
```



<a name="Transaction.WithPostCommitVolumes"></a>
### func \(Transaction\) [WithPostCommitVolumes](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L209>)

```go
func (tx Transaction) WithPostCommitVolumes(volumes PostCommitVolumes) Transaction
```



<a name="Transaction.WithPostings"></a>
### func \(Transaction\) [WithPostings](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L71>)

```go
func (tx Transaction) WithPostings(postings ...Posting) Transaction
```



<a name="Transaction.WithReference"></a>
### func \(Transaction\) [WithReference](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L76>)

```go
func (tx Transaction) WithReference(ref string) Transaction
```



<a name="Transaction.WithRevertedAt"></a>
### func \(Transaction\) [WithRevertedAt](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L204>)

```go
func (tx Transaction) WithRevertedAt(timestamp time.Time) Transaction
```



<a name="Transaction.WithTimestamp"></a>
### func \(Transaction\) [WithTimestamp](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L81>)

```go
func (tx Transaction) WithTimestamp(ts time.Time) Transaction
```



<a name="Transaction.WithUpdatedAt"></a>
### func \(Transaction\) [WithUpdatedAt](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L221>)

```go
func (tx Transaction) WithUpdatedAt(at time.Time) Transaction
```



<a name="TransactionData"></a>
## type [TransactionData](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L18-L23>)



```go
type TransactionData struct {
    Postings  Postings          `json:"postings" bun:"postings,type:jsonb"`
    Metadata  metadata.Metadata `json:"metadata" bun:"metadata,type:jsonb,default:'{}'"`
    Timestamp time.Time         `json:"timestamp" bun:"timestamp,type:timestamp without time zone,nullzero"`
    Reference string            `json:"reference,omitempty" bun:"reference,type:varchar,unique,nullzero"`
}
```

<a name="NewTransactionData"></a>
### func [NewTransactionData](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L30>)

```go
func NewTransactionData() TransactionData
```



<a name="TransactionData.WithPostings"></a>
### func \(TransactionData\) [WithPostings](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L25>)

```go
func (data TransactionData) WithPostings(postings ...Posting) TransactionData
```



<a name="Transactions"></a>
## type [Transactions](<https://github.com/formancehq/ledger/blob/main/internal/transaction.go#L14-L16>)



```go
type Transactions struct {
    Transactions []TransactionData `json:"transactions"`
}
```

<a name="Volumes"></a>
## type [Volumes](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L12-L15>)



```go
type Volumes struct {
    Input  *big.Int `json:"input"`
    Output *big.Int `json:"output"`
}
```

<a name="NewEmptyVolumes"></a>
### func [NewEmptyVolumes](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L52>)

```go
func NewEmptyVolumes() Volumes
```



<a name="NewVolumesInt64"></a>
### func [NewVolumesInt64](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L56>)

```go
func NewVolumesInt64(input, output int64) Volumes
```



<a name="Volumes.Balance"></a>
### func \(Volumes\) [Balance](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L85>)

```go
func (v Volumes) Balance() *big.Int
```



<a name="Volumes.Copy"></a>
### func \(Volumes\) [Copy](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L45>)

```go
func (v Volumes) Copy() Volumes
```



<a name="Volumes.JSONSchemaExtend"></a>
### func \(Volumes\) [JSONSchemaExtend](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L40>)

```go
func (Volumes) JSONSchemaExtend(schema *jsonschema.Schema)
```



<a name="Volumes.MarshalJSON"></a>
### func \(Volumes\) [MarshalJSON](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L77>)

```go
func (v Volumes) MarshalJSON() ([]byte, error)
```



<a name="Volumes.Scan"></a>
### func \(\*Volumes\) [Scan](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L21>)

```go
func (v *Volumes) Scan(src interface{}) error
```



<a name="Volumes.Value"></a>
### func \(Volumes\) [Value](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L17>)

```go
func (v Volumes) Value() (driver.Value, error)
```



<a name="VolumesByAssets"></a>
## type [VolumesByAssets](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L98>)



```go
type VolumesByAssets map[string]Volumes
```

<a name="VolumesByAssets.Balances"></a>
### func \(VolumesByAssets\) [Balances](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L102>)

```go
func (v VolumesByAssets) Balances() BalancesByAssets
```



<a name="VolumesWithBalance"></a>
## type [VolumesWithBalance](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L69-L73>)



```go
type VolumesWithBalance struct {
    Input   *big.Int `json:"input" bun:"input"`
    Output  *big.Int `json:"output" bun:"output"`
    Balance *big.Int `json:"balance" bun:"balance"`
}
```

<a name="VolumesWithBalanceByAssetByAccount"></a>
## type [VolumesWithBalanceByAssetByAccount](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L63-L67>)



```go
type VolumesWithBalanceByAssetByAccount struct {
    Account string `json:"account" bun:"account"`
    Asset   string `json:"asset" bun:"asset"`
    VolumesWithBalance
}
```

<a name="VolumesWithBalanceByAssets"></a>
## type [VolumesWithBalanceByAssets](<https://github.com/formancehq/ledger/blob/main/internal/volumes.go#L75>)



```go
type VolumesWithBalanceByAssets map[string]*VolumesWithBalance
```

Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
