// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"github.com/formancehq/ledger/pkg/client/models/components"
	"math/big"
)

type V2RevertTransactionRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// Transaction ID.
	ID *big.Int `pathParam:"style=simple,explode=false,name=id"`
	// Force revert
	Force *bool `queryParam:"style=form,explode=true,name=force"`
	// Revert transaction at effective date of the original tx
	AtEffectiveDate *bool `queryParam:"style=form,explode=true,name=atEffectiveDate"`
	// Set the dryRun mode. dry run mode doesn't add the logs to the database or publish a message to the message broker.
	DryRun *bool `queryParam:"style=form,explode=true,name=dryRun"`
	// Use an idempotency key
	IdempotencyKey             *string                                `header:"style=simple,explode=false,name=Idempotency-Key"`
	V2RevertTransactionRequest *components.V2RevertTransactionRequest `request:"mediaType=application/json"`
}

func (v V2RevertTransactionRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2RevertTransactionRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2RevertTransactionRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *V2RevertTransactionRequest) GetID() *big.Int {
	if o == nil {
		return big.NewInt(0)
	}
	return o.ID
}

func (o *V2RevertTransactionRequest) GetForce() *bool {
	if o == nil {
		return nil
	}
	return o.Force
}

func (o *V2RevertTransactionRequest) GetAtEffectiveDate() *bool {
	if o == nil {
		return nil
	}
	return o.AtEffectiveDate
}

func (o *V2RevertTransactionRequest) GetDryRun() *bool {
	if o == nil {
		return nil
	}
	return o.DryRun
}

func (o *V2RevertTransactionRequest) GetIdempotencyKey() *string {
	if o == nil {
		return nil
	}
	return o.IdempotencyKey
}

func (o *V2RevertTransactionRequest) GetV2RevertTransactionRequest() *components.V2RevertTransactionRequest {
	if o == nil {
		return nil
	}
	return o.V2RevertTransactionRequest
}

type V2RevertTransactionResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	V2CreateTransactionResponse *components.V2CreateTransactionResponse
	Headers                     map[string][]string
}

func (o *V2RevertTransactionResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V2RevertTransactionResponse) GetV2CreateTransactionResponse() *components.V2CreateTransactionResponse {
	if o == nil {
		return nil
	}
	return o.V2CreateTransactionResponse
}

func (o *V2RevertTransactionResponse) GetHeaders() map[string][]string {
	if o == nil {
		return map[string][]string{}
	}
	return o.Headers
}
