// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"github.com/formancehq/ledger/pkg/client/models/components"
	"time"
)

type V2GetVolumesWithBalancesRequest struct {
	// The maximum number of results to return per page.
	//
	PageSize *int64 `queryParam:"style=form,explode=true,name=pageSize"`
	// Parameter used in pagination requests. Maximum page size is set to 15.
	// Set to the value of next for the next page of results.
	// Set to the value of previous for the previous page of results.
	// No other parameters can be set when this parameter is set.
	//
	Cursor *string `queryParam:"style=form,explode=true,name=cursor"`
	// Name of the ledger.
	Ledger    string     `pathParam:"style=simple,explode=false,name=ledger"`
	EndTime   *time.Time `queryParam:"style=form,explode=true,name=endTime"`
	StartTime *time.Time `queryParam:"style=form,explode=true,name=startTime"`
	// Use insertion date instead of effective date
	InsertionDate *bool `queryParam:"style=form,explode=true,name=insertionDate"`
	// Group volumes and balance by the level of the segment of the address
	GroupBy *int64 `queryParam:"style=form,explode=true,name=groupBy"`
	// Sort results using a field name and order (ascending or descending).
	// Format: `<field>:<order>`, where `<field>` is the field name and `<order>` is either `asc` or `desc`.
	//
	Sort        *string        `queryParam:"style=form,explode=true,name=sort"`
	RequestBody map[string]any `request:"mediaType=application/json"`
}

func (v V2GetVolumesWithBalancesRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2GetVolumesWithBalancesRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2GetVolumesWithBalancesRequest) GetPageSize() *int64 {
	if o == nil {
		return nil
	}
	return o.PageSize
}

func (o *V2GetVolumesWithBalancesRequest) GetCursor() *string {
	if o == nil {
		return nil
	}
	return o.Cursor
}

func (o *V2GetVolumesWithBalancesRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *V2GetVolumesWithBalancesRequest) GetEndTime() *time.Time {
	if o == nil {
		return nil
	}
	return o.EndTime
}

func (o *V2GetVolumesWithBalancesRequest) GetStartTime() *time.Time {
	if o == nil {
		return nil
	}
	return o.StartTime
}

func (o *V2GetVolumesWithBalancesRequest) GetInsertionDate() *bool {
	if o == nil {
		return nil
	}
	return o.InsertionDate
}

func (o *V2GetVolumesWithBalancesRequest) GetGroupBy() *int64 {
	if o == nil {
		return nil
	}
	return o.GroupBy
}

func (o *V2GetVolumesWithBalancesRequest) GetSort() *string {
	if o == nil {
		return nil
	}
	return o.Sort
}

func (o *V2GetVolumesWithBalancesRequest) GetRequestBody() map[string]any {
	if o == nil {
		return map[string]any{}
	}
	return o.RequestBody
}

type V2GetVolumesWithBalancesResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	V2VolumesWithBalanceCursorResponse *components.V2VolumesWithBalanceCursorResponse
}

func (o *V2GetVolumesWithBalancesResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V2GetVolumesWithBalancesResponse) GetV2VolumesWithBalanceCursorResponse() *components.V2VolumesWithBalanceCursorResponse {
	if o == nil {
		return nil
	}
	return o.V2VolumesWithBalanceCursorResponse
}
