// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"github.com/formancehq/ledger/pkg/client/models/components"
	"time"
)

type ListTransactionsRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// The maximum number of results to return per page.
	//
	PageSize *int64 `queryParam:"style=form,explode=true,name=pageSize"`
	// Pagination cursor, will return transactions after given txid (in descending order).
	After *string `queryParam:"style=form,explode=true,name=after"`
	// Find transactions by reference field.
	Reference *string `queryParam:"style=form,explode=true,name=reference"`
	// Filter transactions with postings involving given account, either as source or destination (regular expression placed between ^ and $).
	Account *string `queryParam:"style=form,explode=true,name=account"`
	// Filter transactions with postings involving given account at source (regular expression placed between ^ and $).
	Source *string `queryParam:"style=form,explode=true,name=source"`
	// Filter transactions with postings involving given account at destination (regular expression placed between ^ and $).
	Destination *string `queryParam:"style=form,explode=true,name=destination"`
	// Filter transactions that occurred after this timestamp.
	// The format is RFC3339 and is inclusive (for example, "2023-01-02T15:04:01Z" includes the first second of 4th minute).
	//
	StartTime *time.Time `queryParam:"style=form,explode=true,name=startTime"`
	// Filter transactions that occurred before this timestamp.
	// The format is RFC3339 and is exclusive (for example, "2023-01-02T15:04:01Z" excludes the first second of 4th minute).
	//
	EndTime *time.Time `queryParam:"style=form,explode=true,name=endTime"`
	// Parameter used in pagination requests. Maximum page size is set to 1000.
	// Set to the value of next for the next page of results.
	// Set to the value of previous for the previous page of results.
	// No other parameters can be set when this parameter is set.
	//
	Cursor *string `queryParam:"style=form,explode=true,name=cursor"`
	// Filter transactions by metadata key value pairs. Nested objects can be used as seen in the example below.
	Metadata map[string]any `queryParam:"style=deepObject,explode=true,name=metadata"`
}

func (l ListTransactionsRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(l, "", false)
}

func (l *ListTransactionsRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &l, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *ListTransactionsRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *ListTransactionsRequest) GetPageSize() *int64 {
	if o == nil {
		return nil
	}
	return o.PageSize
}

func (o *ListTransactionsRequest) GetAfter() *string {
	if o == nil {
		return nil
	}
	return o.After
}

func (o *ListTransactionsRequest) GetReference() *string {
	if o == nil {
		return nil
	}
	return o.Reference
}

func (o *ListTransactionsRequest) GetAccount() *string {
	if o == nil {
		return nil
	}
	return o.Account
}

func (o *ListTransactionsRequest) GetSource() *string {
	if o == nil {
		return nil
	}
	return o.Source
}

func (o *ListTransactionsRequest) GetDestination() *string {
	if o == nil {
		return nil
	}
	return o.Destination
}

func (o *ListTransactionsRequest) GetStartTime() *time.Time {
	if o == nil {
		return nil
	}
	return o.StartTime
}

func (o *ListTransactionsRequest) GetEndTime() *time.Time {
	if o == nil {
		return nil
	}
	return o.EndTime
}

func (o *ListTransactionsRequest) GetCursor() *string {
	if o == nil {
		return nil
	}
	return o.Cursor
}

func (o *ListTransactionsRequest) GetMetadata() map[string]any {
	if o == nil {
		return nil
	}
	return o.Metadata
}

type ListTransactionsResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	TransactionsCursorResponse *components.TransactionsCursorResponse
}

func (o *ListTransactionsResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *ListTransactionsResponse) GetTransactionsCursorResponse() *components.TransactionsCursorResponse {
	if o == nil {
		return nil
	}
	return o.TransactionsCursorResponse
}
