// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/models/components"
)

type ListAccountsRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// The maximum number of results to return per page.
	//
	PageSize *int64 `queryParam:"style=form,explode=true,name=pageSize"`
	// Pagination cursor, will return accounts after given address, in descending order.
	After *string `queryParam:"style=form,explode=true,name=after"`
	// Filter accounts by address pattern (regular expression placed between ^ and $).
	Address *string `queryParam:"style=form,explode=true,name=address"`
	// Filter accounts by metadata key value pairs. Nested objects can be used as seen in the example below.
	Metadata map[string]any `queryParam:"style=deepObject,explode=true,name=metadata"`
	// Filter accounts by their balance (default operator is gte)
	Balance *int64 `queryParam:"style=form,explode=true,name=balance"`
	// Parameter used in pagination requests. Maximum page size is set to 1000.
	// Set to the value of next for the next page of results.
	// Set to the value of previous for the previous page of results.
	// No other parameters can be set when this parameter is set.
	//
	Cursor *string `queryParam:"style=form,explode=true,name=cursor"`
	// Parameter used in pagination requests. Maximum page size is set to 1000.
	// Set to the value of next for the next page of results.
	// Set to the value of previous for the previous page of results.
	// No other parameters can be set when this parameter is set.
	// Deprecated, please use `cursor` instead.
	//
	//
	// Deprecated: This will be removed in a future release, please migrate away from it as soon as possible.
	PaginationToken *string `queryParam:"style=form,explode=true,name=pagination_token"`
}

func (o *ListAccountsRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *ListAccountsRequest) GetPageSize() *int64 {
	if o == nil {
		return nil
	}
	return o.PageSize
}

func (o *ListAccountsRequest) GetAfter() *string {
	if o == nil {
		return nil
	}
	return o.After
}

func (o *ListAccountsRequest) GetAddress() *string {
	if o == nil {
		return nil
	}
	return o.Address
}

func (o *ListAccountsRequest) GetMetadata() map[string]any {
	if o == nil {
		return nil
	}
	return o.Metadata
}

func (o *ListAccountsRequest) GetBalance() *int64 {
	if o == nil {
		return nil
	}
	return o.Balance
}

func (o *ListAccountsRequest) GetCursor() *string {
	if o == nil {
		return nil
	}
	return o.Cursor
}

func (o *ListAccountsRequest) GetPaginationToken() *string {
	if o == nil {
		return nil
	}
	return o.PaginationToken
}

type ListAccountsResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	AccountsCursorResponse *components.AccountsCursorResponse
	// Not found
	ErrorResponse *components.ErrorResponse
}

func (o *ListAccountsResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *ListAccountsResponse) GetAccountsCursorResponse() *components.AccountsCursorResponse {
	if o == nil {
		return nil
	}
	return o.AccountsCursorResponse
}

func (o *ListAccountsResponse) GetErrorResponse() *components.ErrorResponse {
	if o == nil {
		return nil
	}
	return o.ErrorResponse
}
