// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/formancehq/ledger/pkg/client/models/components"
)

type CreateTransactionRequest struct {
	// Name of the ledger.
	Ledger string `pathParam:"style=simple,explode=false,name=ledger"`
	// Set the preview mode. Preview mode doesn't add the logs to the database or publish a message to the message broker.
	Preview *bool `queryParam:"style=form,explode=true,name=preview"`
	// The request body must contain at least one of the following objects:
	//   - `postings`: suitable for simple transactions
	//   - `script`: enabling more complex transactions with Numscript
	//
	PostTransaction components.PostTransaction `request:"mediaType=application/json"`
}

func (o *CreateTransactionRequest) GetLedger() string {
	if o == nil {
		return ""
	}
	return o.Ledger
}

func (o *CreateTransactionRequest) GetPreview() *bool {
	if o == nil {
		return nil
	}
	return o.Preview
}

func (o *CreateTransactionRequest) GetPostTransaction() components.PostTransaction {
	if o == nil {
		return components.PostTransaction{}
	}
	return o.PostTransaction
}

type CreateTransactionResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	TransactionsResponse *components.TransactionsResponse
	Headers              map[string][]string
}

func (o *CreateTransactionResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *CreateTransactionResponse) GetTransactionsResponse() *components.TransactionsResponse {
	if o == nil {
		return nil
	}
	return o.TransactionsResponse
}

func (o *CreateTransactionResponse) GetHeaders() map[string][]string {
	if o == nil {
		return map[string][]string{}
	}
	return o.Headers
}
