// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"time"
)

type V2PostTransactionScript struct {
	Plain string            `json:"plain"`
	Vars  map[string]string `json:"vars,omitempty"`
}

func (o *V2PostTransactionScript) GetPlain() string {
	if o == nil {
		return ""
	}
	return o.Plain
}

func (o *V2PostTransactionScript) GetVars() map[string]string {
	if o == nil {
		return nil
	}
	return o.Vars
}

// Runtime - The numscript runtime used to execute the script. Uses "machine" by default, unless the "--experimental-numscript-interpreter" feature flag is passed.
type Runtime string

const (
	RuntimeExperimentalInterpreter Runtime = "experimental-interpreter"
	RuntimeMachine                 Runtime = "machine"
)

func (e Runtime) ToPointer() *Runtime {
	return &e
}
func (e *Runtime) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "experimental-interpreter":
		fallthrough
	case "machine":
		*e = Runtime(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Runtime: %v", v)
	}
}

type V2PostTransaction struct {
	Timestamp *time.Time               `json:"timestamp,omitempty"`
	Postings  []V2Posting              `json:"postings,omitempty"`
	Script    *V2PostTransactionScript `json:"script,omitempty"`
	// The numscript runtime used to execute the script. Uses "machine" by default, unless the "--experimental-numscript-interpreter" feature flag is passed.
	Runtime         *Runtime                     `json:"runtime,omitempty"`
	Reference       *string                      `json:"reference,omitempty"`
	Metadata        map[string]string            `json:"metadata"`
	AccountMetadata map[string]map[string]string `json:"accountMetadata,omitempty"`
	Force           *bool                        `json:"force,omitempty"`
}

func (v V2PostTransaction) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2PostTransaction) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2PostTransaction) GetTimestamp() *time.Time {
	if o == nil {
		return nil
	}
	return o.Timestamp
}

func (o *V2PostTransaction) GetPostings() []V2Posting {
	if o == nil {
		return nil
	}
	return o.Postings
}

func (o *V2PostTransaction) GetScript() *V2PostTransactionScript {
	if o == nil {
		return nil
	}
	return o.Script
}

func (o *V2PostTransaction) GetRuntime() *Runtime {
	if o == nil {
		return nil
	}
	return o.Runtime
}

func (o *V2PostTransaction) GetReference() *string {
	if o == nil {
		return nil
	}
	return o.Reference
}

func (o *V2PostTransaction) GetMetadata() map[string]string {
	if o == nil {
		return map[string]string{}
	}
	return o.Metadata
}

func (o *V2PostTransaction) GetAccountMetadata() map[string]map[string]string {
	if o == nil {
		return nil
	}
	return o.AccountMetadata
}

func (o *V2PostTransaction) GetForce() *bool {
	if o == nil {
		return nil
	}
	return o.Force
}
