// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"time"
)

type V2MigrationInfoState string

const (
	V2MigrationInfoStateToDo     V2MigrationInfoState = "TO DO"
	V2MigrationInfoStateDone     V2MigrationInfoState = "DONE"
	V2MigrationInfoStateProgress V2MigrationInfoState = "PROGRESS"
)

func (e V2MigrationInfoState) ToPointer() *V2MigrationInfoState {
	return &e
}
func (e *V2MigrationInfoState) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "TO DO":
		fallthrough
	case "DONE":
		fallthrough
	case "PROGRESS":
		*e = V2MigrationInfoState(v)
		return nil
	default:
		return fmt.Errorf("invalid value for V2MigrationInfoState: %v", v)
	}
}

type V2MigrationInfo struct {
	Version *string               `json:"version,omitempty"`
	Name    *string               `json:"name,omitempty"`
	Date    *time.Time            `json:"date,omitempty"`
	State   *V2MigrationInfoState `json:"state,omitempty"`
}

func (v V2MigrationInfo) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2MigrationInfo) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2MigrationInfo) GetVersion() *string {
	if o == nil {
		return nil
	}
	return o.Version
}

func (o *V2MigrationInfo) GetName() *string {
	if o == nil {
		return nil
	}
	return o.Name
}

func (o *V2MigrationInfo) GetDate() *time.Time {
	if o == nil {
		return nil
	}
	return o.Date
}

func (o *V2MigrationInfo) GetState() *V2MigrationInfoState {
	if o == nil {
		return nil
	}
	return o.State
}
