// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"errors"
	"fmt"
	"github.com/formancehq/ledger/pkg/client/internal/utils"
)

type V2BulkElementResultError struct {
	ResponseType     string  `json:"responseType"`
	LogID            int64   `json:"logID"`
	ErrorCode        string  `json:"errorCode"`
	ErrorDescription string  `json:"errorDescription"`
	ErrorDetails     *string `json:"errorDetails,omitempty"`
}

func (o *V2BulkElementResultError) GetResponseType() string {
	if o == nil {
		return ""
	}
	return o.ResponseType
}

func (o *V2BulkElementResultError) GetLogID() int64 {
	if o == nil {
		return 0
	}
	return o.LogID
}

func (o *V2BulkElementResultError) GetErrorCode() string {
	if o == nil {
		return ""
	}
	return o.ErrorCode
}

func (o *V2BulkElementResultError) GetErrorDescription() string {
	if o == nil {
		return ""
	}
	return o.ErrorDescription
}

func (o *V2BulkElementResultError) GetErrorDetails() *string {
	if o == nil {
		return nil
	}
	return o.ErrorDetails
}

type V2BulkElementResultDeleteMetadata struct {
	ResponseType string `json:"responseType"`
	LogID        int64  `json:"logID"`
}

func (o *V2BulkElementResultDeleteMetadata) GetResponseType() string {
	if o == nil {
		return ""
	}
	return o.ResponseType
}

func (o *V2BulkElementResultDeleteMetadata) GetLogID() int64 {
	if o == nil {
		return 0
	}
	return o.LogID
}

type V2BulkElementResultRevertTransaction struct {
	ResponseType string        `json:"responseType"`
	LogID        int64         `json:"logID"`
	Data         V2Transaction `json:"data"`
}

func (o *V2BulkElementResultRevertTransaction) GetResponseType() string {
	if o == nil {
		return ""
	}
	return o.ResponseType
}

func (o *V2BulkElementResultRevertTransaction) GetLogID() int64 {
	if o == nil {
		return 0
	}
	return o.LogID
}

func (o *V2BulkElementResultRevertTransaction) GetData() V2Transaction {
	if o == nil {
		return V2Transaction{}
	}
	return o.Data
}

type V2BulkElementResultAddMetadata struct {
	ResponseType string `json:"responseType"`
	LogID        int64  `json:"logID"`
}

func (o *V2BulkElementResultAddMetadata) GetResponseType() string {
	if o == nil {
		return ""
	}
	return o.ResponseType
}

func (o *V2BulkElementResultAddMetadata) GetLogID() int64 {
	if o == nil {
		return 0
	}
	return o.LogID
}

type V2BulkElementResultCreateTransaction struct {
	ResponseType string        `json:"responseType"`
	LogID        int64         `json:"logID"`
	Data         V2Transaction `json:"data"`
}

func (o *V2BulkElementResultCreateTransaction) GetResponseType() string {
	if o == nil {
		return ""
	}
	return o.ResponseType
}

func (o *V2BulkElementResultCreateTransaction) GetLogID() int64 {
	if o == nil {
		return 0
	}
	return o.LogID
}

func (o *V2BulkElementResultCreateTransaction) GetData() V2Transaction {
	if o == nil {
		return V2Transaction{}
	}
	return o.Data
}

type V2BulkElementResultType string

const (
	V2BulkElementResultTypeCreateTransaction V2BulkElementResultType = "CREATE_TRANSACTION"
	V2BulkElementResultTypeAddMetadata       V2BulkElementResultType = "ADD_METADATA"
	V2BulkElementResultTypeRevertTransaction V2BulkElementResultType = "REVERT_TRANSACTION"
	V2BulkElementResultTypeDeleteMetadata    V2BulkElementResultType = "DELETE_METADATA"
	V2BulkElementResultTypeError             V2BulkElementResultType = "ERROR"
)

type V2BulkElementResult struct {
	V2BulkElementResultCreateTransaction *V2BulkElementResultCreateTransaction `queryParam:"inline"`
	V2BulkElementResultAddMetadata       *V2BulkElementResultAddMetadata       `queryParam:"inline"`
	V2BulkElementResultRevertTransaction *V2BulkElementResultRevertTransaction `queryParam:"inline"`
	V2BulkElementResultDeleteMetadata    *V2BulkElementResultDeleteMetadata    `queryParam:"inline"`
	V2BulkElementResultError             *V2BulkElementResultError             `queryParam:"inline"`

	Type V2BulkElementResultType
}

func CreateV2BulkElementResultCreateTransaction(createTransaction V2BulkElementResultCreateTransaction) V2BulkElementResult {
	typ := V2BulkElementResultTypeCreateTransaction

	typStr := string(typ)
	createTransaction.ResponseType = typStr

	return V2BulkElementResult{
		V2BulkElementResultCreateTransaction: &createTransaction,
		Type:                                 typ,
	}
}

func CreateV2BulkElementResultAddMetadata(addMetadata V2BulkElementResultAddMetadata) V2BulkElementResult {
	typ := V2BulkElementResultTypeAddMetadata

	typStr := string(typ)
	addMetadata.ResponseType = typStr

	return V2BulkElementResult{
		V2BulkElementResultAddMetadata: &addMetadata,
		Type:                           typ,
	}
}

func CreateV2BulkElementResultRevertTransaction(revertTransaction V2BulkElementResultRevertTransaction) V2BulkElementResult {
	typ := V2BulkElementResultTypeRevertTransaction

	typStr := string(typ)
	revertTransaction.ResponseType = typStr

	return V2BulkElementResult{
		V2BulkElementResultRevertTransaction: &revertTransaction,
		Type:                                 typ,
	}
}

func CreateV2BulkElementResultDeleteMetadata(deleteMetadata V2BulkElementResultDeleteMetadata) V2BulkElementResult {
	typ := V2BulkElementResultTypeDeleteMetadata

	typStr := string(typ)
	deleteMetadata.ResponseType = typStr

	return V2BulkElementResult{
		V2BulkElementResultDeleteMetadata: &deleteMetadata,
		Type:                              typ,
	}
}

func CreateV2BulkElementResultError(errorT V2BulkElementResultError) V2BulkElementResult {
	typ := V2BulkElementResultTypeError

	typStr := string(typ)
	errorT.ResponseType = typStr

	return V2BulkElementResult{
		V2BulkElementResultError: &errorT,
		Type:                     typ,
	}
}

func (u *V2BulkElementResult) UnmarshalJSON(data []byte) error {

	type discriminator struct {
		ResponseType string `json:"responseType"`
	}

	dis := new(discriminator)
	if err := json.Unmarshal(data, &dis); err != nil {
		return fmt.Errorf("could not unmarshal discriminator: %w", err)
	}

	switch dis.ResponseType {
	case "CREATE_TRANSACTION":
		v2BulkElementResultCreateTransaction := new(V2BulkElementResultCreateTransaction)
		if err := utils.UnmarshalJSON(data, &v2BulkElementResultCreateTransaction, "", true, false); err != nil {
			return fmt.Errorf("could not unmarshal `%s` into expected (ResponseType == CREATE_TRANSACTION) type V2BulkElementResultCreateTransaction within V2BulkElementResult: %w", string(data), err)
		}

		u.V2BulkElementResultCreateTransaction = v2BulkElementResultCreateTransaction
		u.Type = V2BulkElementResultTypeCreateTransaction
		return nil
	case "ADD_METADATA":
		v2BulkElementResultAddMetadata := new(V2BulkElementResultAddMetadata)
		if err := utils.UnmarshalJSON(data, &v2BulkElementResultAddMetadata, "", true, false); err != nil {
			return fmt.Errorf("could not unmarshal `%s` into expected (ResponseType == ADD_METADATA) type V2BulkElementResultAddMetadata within V2BulkElementResult: %w", string(data), err)
		}

		u.V2BulkElementResultAddMetadata = v2BulkElementResultAddMetadata
		u.Type = V2BulkElementResultTypeAddMetadata
		return nil
	case "REVERT_TRANSACTION":
		v2BulkElementResultRevertTransaction := new(V2BulkElementResultRevertTransaction)
		if err := utils.UnmarshalJSON(data, &v2BulkElementResultRevertTransaction, "", true, false); err != nil {
			return fmt.Errorf("could not unmarshal `%s` into expected (ResponseType == REVERT_TRANSACTION) type V2BulkElementResultRevertTransaction within V2BulkElementResult: %w", string(data), err)
		}

		u.V2BulkElementResultRevertTransaction = v2BulkElementResultRevertTransaction
		u.Type = V2BulkElementResultTypeRevertTransaction
		return nil
	case "DELETE_METADATA":
		v2BulkElementResultDeleteMetadata := new(V2BulkElementResultDeleteMetadata)
		if err := utils.UnmarshalJSON(data, &v2BulkElementResultDeleteMetadata, "", true, false); err != nil {
			return fmt.Errorf("could not unmarshal `%s` into expected (ResponseType == DELETE_METADATA) type V2BulkElementResultDeleteMetadata within V2BulkElementResult: %w", string(data), err)
		}

		u.V2BulkElementResultDeleteMetadata = v2BulkElementResultDeleteMetadata
		u.Type = V2BulkElementResultTypeDeleteMetadata
		return nil
	case "ERROR":
		v2BulkElementResultError := new(V2BulkElementResultError)
		if err := utils.UnmarshalJSON(data, &v2BulkElementResultError, "", true, false); err != nil {
			return fmt.Errorf("could not unmarshal `%s` into expected (ResponseType == ERROR) type V2BulkElementResultError within V2BulkElementResult: %w", string(data), err)
		}

		u.V2BulkElementResultError = v2BulkElementResultError
		u.Type = V2BulkElementResultTypeError
		return nil
	}

	return fmt.Errorf("could not unmarshal `%s` into any supported union types for V2BulkElementResult", string(data))
}

func (u V2BulkElementResult) MarshalJSON() ([]byte, error) {
	if u.V2BulkElementResultCreateTransaction != nil {
		return utils.MarshalJSON(u.V2BulkElementResultCreateTransaction, "", true)
	}

	if u.V2BulkElementResultAddMetadata != nil {
		return utils.MarshalJSON(u.V2BulkElementResultAddMetadata, "", true)
	}

	if u.V2BulkElementResultRevertTransaction != nil {
		return utils.MarshalJSON(u.V2BulkElementResultRevertTransaction, "", true)
	}

	if u.V2BulkElementResultDeleteMetadata != nil {
		return utils.MarshalJSON(u.V2BulkElementResultDeleteMetadata, "", true)
	}

	if u.V2BulkElementResultError != nil {
		return utils.MarshalJSON(u.V2BulkElementResultError, "", true)
	}

	return nil, errors.New("could not marshal union type V2BulkElementResult: all fields are null")
}
