// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"github.com/formancehq/ledger/pkg/client/internal/utils"
	"time"
)

type V2Account struct {
	Address          string              `json:"address"`
	Metadata         map[string]string   `json:"metadata"`
	InsertionDate    *time.Time          `json:"insertionDate,omitempty"`
	UpdatedAt        *time.Time          `json:"updatedAt,omitempty"`
	FirstUsage       *time.Time          `json:"firstUsage,omitempty"`
	Volumes          map[string]V2Volume `json:"volumes,omitempty"`
	EffectiveVolumes map[string]V2Volume `json:"effectiveVolumes,omitempty"`
}

func (v V2Account) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V2Account) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V2Account) GetAddress() string {
	if o == nil {
		return ""
	}
	return o.Address
}

func (o *V2Account) GetMetadata() map[string]string {
	if o == nil {
		return map[string]string{}
	}
	return o.Metadata
}

func (o *V2Account) GetInsertionDate() *time.Time {
	if o == nil {
		return nil
	}
	return o.InsertionDate
}

func (o *V2Account) GetUpdatedAt() *time.Time {
	if o == nil {
		return nil
	}
	return o.UpdatedAt
}

func (o *V2Account) GetFirstUsage() *time.Time {
	if o == nil {
		return nil
	}
	return o.FirstUsage
}

func (o *V2Account) GetVolumes() map[string]V2Volume {
	if o == nil {
		return nil
	}
	return o.Volumes
}

func (o *V2Account) GetEffectiveVolumes() map[string]V2Volume {
	if o == nil {
		return nil
	}
	return o.EffectiveVolumes
}
