do $$
	declare
		_offset integer := 0;
		_batch_size integer := 1000;
	begin
		set search_path = '{{ .Schema }}';

		drop table if exists moves_view;

		create table moves_view as
		select row_number() over (order by transactions_seq) as row_number,
		       transactions_seq, public.aggregate_objects(jsonb_build_object(accounts_address, volumes)) as volumes
		from (
			select transactions_seq, accounts_address, public.aggregate_objects(json_build_object(asset, json_build_object('input', (post_commit_volumes).inputs, 'output', (post_commit_volumes).outputs))::jsonb) as volumes
			from (
				SELECT DISTINCT ON (moves.transactions_seq, accounts_address, asset) moves.transactions_seq, accounts_address, asset,
							first_value(post_commit_volumes) OVER (
						PARTITION BY moves.transactions_seq, accounts_address, asset
						ORDER BY seq DESC
						) AS post_commit_volumes
				FROM moves
				where insertion_date < (
					select tstamp from goose_db_version where version_id = 12
				)
			) moves
			group by transactions_seq, accounts_address
		) data
		group by transactions_seq;

		create index moves_view_idx on moves_view(row_number) include (transactions_seq, volumes);
		-- speed up hash join when updating rows later
		alter table moves_view add foreign key(transactions_seq) references transactions(seq);

		if (select count(*) from moves_view) = 0 then
			drop table moves_view;
			return;
		end if;

		perform pg_notify('migrations-{{ .Schema }}', 'init: ' || (select count(*) from moves_view));

		loop
			with data as (
				select transactions_seq, volumes
				from moves_view
				where row_number > _offset and row_number <= _offset + _batch_size
			)
			update transactions
			set post_commit_volumes = data.volumes
			from data
			where transactions.seq = data.transactions_seq;

			if not found then
				drop table moves_view;
				exit;
			end if;

			_offset = _offset + _batch_size;

			perform pg_notify('migrations-{{ .Schema }}', 'continue: ' || _batch_size);

			commit;
		end loop;

		drop table if exists moves_view;
	end
$$;

