# Prime Directive Privacy Policy

_May 18, 2017_

Your privacy is an important factor that Prime Directive (that's us) considers in the
development of each of our products and services. We are committed to being
transparent and open. This Prime Directive Privacy Policy explains generally how we
receive information about you, and what we do with that information once we have
it.

## What do we mean by "personal information?"

For us, "personal information" means information which identifies you, like your
name or email address.

Any information that falls outside of this is "non-personal information."

If we store your personal information with information that is non-personal, we
will consider the combination as personal information. If we remove all personal
information from a set of data then the remaining is non-personal information.

## How do we learn information about you?

We learn information about you when:

- you give it to us directly (e.g., when you choose to send us crash reports);
- we collect it automatically through our products and services (e.g., when your
  Flynn cluster or Flynn CLI sends us usage statistics);
- someone else tells us information about you (e.g., when Flynn works with your
  cloud provider to set up your account); or
- when we try and understand more about you based on information you've given to
  us (e.g., when we use your IP address and operating system to direct you to
  a CLI download).

## What do we do with your information once we have it?

When you give us information, we will use it in the ways for which you've given
us permission. Generally, we use your information to help us provide and improve
our products and services for you.

## When do we share your information with others?

- When we have asked and received your permission to share it.
- For processing or providing products and services to you, but only if those
  entities receiving your information are contractually obligated to handle the
  data in ways that are approved by Prime Directive.
- When we release information to make our products better and foster an open
  community, but when we do so, we will remove your personal information and try
  to disclose it in a way that minimizes the risk of you being re-identified.
- When the law requires it. We follow the law whenever we receive requests about
  you from a government or related to a lawsuit. We'll notify you when we're
  asked to hand over your personal information in this way unless we're legally
  prohibited from doing so. When we receive requests like this, we'll only
  release your personal information if we have a good faith belief that the law
  requires us to do so. Nothing in this policy is intended to limit any legal
  defenses or objections that you may have to a third party's request to
  disclose your information.
- When we believe it is necessary to prevent harm to you or someone else. We
  will only share your information in this way if we have a good faith belief
  that it is reasonably necessary to protect the rights, property or safety of
  you, our other users, Prime Directive or the public.
- If our organizational structure or status changes (if we undergo
  a restructuring, are acquired, or go bankrupt) we may pass your information to
  a successor or affiliate.

## How do we store and protect your personal information?

We are committed to protecting your personal information once we have it. We
implement physical, business and technical security measures. Despite our
efforts, if we learn of a security breach, we'll notify you so that you can take
appropriate protective steps.

We also don't want your personal information for any longer than we need it, so
we only keep it long enough to do what we collected it for. Once we don't need
it, we take steps to destroy it unless we are required by law to keep it longer.

## What else should you know?

We're a global organization and our computers are in several different places
around the world. We also use service providers whose computers may also be in
various countries. This means that your information might end up on one of those
computers in another country, and that country may have a different level of
data protection regulation than yours. By giving us information, you consent to
this kind of transfer of your information. No matter what country your
information is in, we comply with applicable law and will also abide by the
commitments we make in this privacy policy.

If you are under 13, we don't want your personal information, and you must not
provide it to us. If you are a parent and believe that your child who is under
13 has provided us with personal information, please contact us to have your
child's information removed.

## What if we change this privacy policy or any of our privacy notices?

We may need to change this policy and our notices. The updates will be posted
online. If the changes are substantive, we will announce the update through
Prime Directive's usual channels for such announcements such as blog posts and emails.
Your continued use of the product or service after the effective date of such
changes constitutes your acceptance of such changes. To make your review more
convenient, we will post an effective date at the top of the page.

## Twitter Analytics

Some of our websites use Twitter Analytics to collect user data for the purposes
of conversion tracking and serving ads targeted to users’ interests. You can
avoid the collection of your data for this purpose and opt out by using one of
the methods [specified by
Twitter](https://support.twitter.com/articles/20170405).

## Usage Statistics

Flynn sends Prime Directive usage, performance, and configuration statistics.
Your IP address and randomly generated identifiers are also collected. These
statistics are transmitted using TLS and help us improve future versions of
Flynn. Once sent to Prime Directive, statistics may be aggregated and made
available to a broad range of developers, including both Prime Directive
employees and public contributors.

Collection of statistics may be disabled for a Flynn cluster by running this
command:

```text
flynn -a controller env set TELEMETRY_DISABLED=true
```

## Contact Prime Directive

If you want to make a correction to your information, or you have any questions
about our privacy policies, please get in touch with:

Prime Directive, Inc.<br>
Attn: Legal Notices - Privacy<br>
503 Paisley Place<br>
Newark, DE 19711

_This document is adapted from the [Mozilla Privacy
Policy](https://www.mozilla.org/en-US/privacy/) and licensed under the [Creative
Commons Attribution Share-Alike 3.0 Unported
license](https://creativecommons.org/licenses/by-sa/3.0/deed.en), or any later
version._
