<!--
Copyright 2025 The Flutter Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file or at https://developers.google.com/open-source/licenses/bsd.
-->
> [!NOTE]
> There are parts of this release process that can only be completed by Googlers
on the Dash team. If you are not a Googler on the Dash team, please reach out on the
[#hackers-devtools](https://discord.com/channels/608014603317936148/1106667330093723668)
Discord channel before trying to create a DevTools release.

# DevTools release process

![A diagram of the DevTools release process](./_markdown_images/release_diagram.png)

A new minor version of DevTools should be released into the Dart SDK **monthly**.
This release should be timed with the Dart / Flutter release code cutoff dates so
that we can ensure it is included with the next Flutter beta (see the
[Dash release schedule](http://go/dash-team-releases)). The minor DevTools releases
must be submitted to the Dart SDK before the Beta release cutoff date. Dev or patch
releases of DevTools may occur as needed between minor or major releases.

Before each minor or major DevTools release, the DevTools team will perform a bug
bash for quality assurance and to prevent regressions from slipping into the release.

# Pre-requisites

1. Ensure that you have access to `dt` by adding the `tool/bin` folder to your
`PATH` environment variable
  - **MacOS Users**
    - add the following to your `~/.bashrc` file.
    - `export PATH=$PATH:<DEVTOOLS_DIR>/tool/bin`
      > [!NOTE]  
      > Replace `<DEVTOOLS_DIR>` with the local path to your DevTools
      > repo path.
  - **Windows Users**
    - Open "Edit environment variables for your account" from Control Panel
    - Locate the `Path` variable and click **Edit**
    - Click the **New** button and paste in `<DEVTOOLS_DIR>/tool/bin`
      > [!NOTE]  
      > Replace `<DEVTOOLS_DIR>` with the local path to your DevTools
      > repo path.

2. Ensure your Dart SDK is configured:

   1. You have a local checkout of the Dart SDK
      (for getting started instructions, see 
      [sdk/CONTRIBUTING.md](https://github.com/dart-lang/sdk/blob/main/CONTRIBUTING.md)).

   2. Ensure your `.bashrc` sets `$LOCAL_DART_SDK`
      ```shell
      DART_SDK_REPO_DIR=<Path to cloned dart sdk>
      export LOCAL_DART_SDK=$DART_SDK_REPO_DIR/sdk
      ```

3. Ensure you have goma [configured](http://go/ma-mac-setup)

# How to release Dart DevTools

1. Release into the Dart SDK master branch
    -  [Full release](#full-release-into-the-dart-sdk-master-branch) (monthly cadence
    with the Dart / Flutter beta release schedule)
    -  [Dev release](#dev-release-into-the-dart-sdk-master-branch) (as needed)
2. [Cherry-pick releases into the Dart SDK stable / beta branches](#cherry-pick-releases)

## Full release into the Dart SDK master branch

### 1) Configure/Refresh environment

Make sure:

1. Your Dart SDK checkout is on the latest `main` branch:
   ```shell
   git checkout main; git rebase-update
   ```


2. Your Flutter SDK checkout is on the latest commit in specified in DevTools:
   ```shell
   dt update-flutter-sdk --update-on-path
   ```

### 2) Prepare the release

#### 2.1) Create a release PR

> [!NOTE]
> If you need to install the [Github CLI](https://cli.github.com/manual/installation) you
can run: `brew install gh`

From the `devtools/tool` directory, run the following:
```shell
dt release-helper
```
This command will automatically:
   - create a new branch using the tip of master and check out locally
   - create a PR for release changes

##### The following is required until https://github.com/flutter/devtools/issues/7939 is fixed:
   - Update the `flutter-candidate.txt` to the [latest Flutter candidate SHA in g3](http://go/flutter-rolls) (see instructions in DevTools Release Rotation email).
   - This change should get committed with the DevTools release PR so that we know which version it was released with.

> [!NOTE]  
> If there are failures caused by the latest Flutter SHA, this step can be skipped.

```shell
git commit -am "Update to latest Flutter candidate"
git push upstream <release-branch>
```

Finally, update your Flutter to the commit you just spcified.
```shell
dt update-flutter-sdk --update-on-path
```

#### 2.2) Verify the version changes for the Release PR

Verify the changes in the release PR contain:
1. an updated the `devtools_app` pubspec version
2. an updated version constant in `packages/devtools_app/lib/devtools.dart`

The other DevTools packages each have their own versioning strategy and are published
as needed on their own schedules. For `devtools_app_shared`, `devtools_extensions`,
and `devtools_shared`, we adhere to semantic versioning where breaking changes should
be versioned with a major version bump, and all other changes should be minor or patch
version bumps.

### 3) Test the release PR

1. Build DevTools in release mode and serve it from a locally running DevTools
server instance:
   ```shell
   dt serve
   ```

2. Launch DevTools and verify that everything generally works.
   - open the page in a browser (http://localhost:53432)
   - `flutter run` an application
   - connect to the running app from DevTools
   - verify:
      - pages generally work
      - there are no exceptions in the chrome devtools log
   - If you find any release blocking issues:
      - fix them before releasing.
      - Then grab the latest commit hash that includes
         - the release prep commit
         - the bug fixes,
      - use this commit hash for the following steps.

3. Once the build is in good shape,
   - revert any local changes.
      ```shell
      git checkout . && \
      git clean -f -d;
      ```

### 4) Submit the Release PR

Receive an LGTM for the PR, squash and commit.

### 5) Wait for the binary to be uploaded CIPD

On each DevTools commit, DevTools is built and uploaded to CIPD. You can check the
status of the builds on this
[dashboard](https://ci.chromium.org/ui/p/dart-internal/builders/flutter/devtools).
Within minutes, a build should be uploaded for the commit you just merged and tagged.

> [!NOTE]  
> If the CIPD build times out, instructions for re-triggering can be found at
[go/dart-engprod/release.md](http://go/dart-engprod/release.md)

### 6) Update the DevTools hash in the Dart SDK

Run the tool script with the commit hash you just merged and tagged:
```shell
dt update-sdk-deps -c <commit-hash>
```

This automatically creates a Gerrit CL with the DEPS update for DevTools.
Quickly test the build and then add a reviewer:

1. Build the Dart SDK locally

   ```shell
   cd $LOCAL_DART_SDK && \
   gclient sync -D && \
   ./tools/build.py -mrelease -ax64 create_sdk;
   ```

2. Verify that running `dart devtools` launches the version of DevTools you just released.
   - for OSX
      ```shell
      xcodebuild/ReleaseX64/dart-sdk/bin/dart devtools
      ```
   - For non-OSX
      ```shell
      out/ReleaseX64/dart-sdk/bin/dart devtools
      ```

3. If the version of DevTools you just published to CIPD does not load properly,
   you may need to hard reload and clear your browser cache.

4. Add a reviewer and submit once approved.

### 7) Tag the release

1. In your terminal from the `devtools` directory, checkout the commit that you
just released into the Dart SDK (the hash you updated the DEPS file with):
   ```shell
   git fetch upstream; git checkout <release-commit>`
   ```

2. Then, tag the release:
   ```shell
   dt tag-version
   ```
   This command creates a tag on the `flutter/devtools` repo for this release. The
   version for the tag is automatically determined from `packages/devtools/pubspec.yaml`
   so there is no need to manually enter the version.

### 8) Verify and Submit the release notes

1. Follow the instructions outlined in the release notes
[README.md](https://github.com/flutter/devtools/blob/master/packages/devtools_app/release_notes/README.md)
to add DevTools release notes to Flutter website and test them in DevTools.
2. Once release notes are submitted to the Flutter website, send an announcement to
[g/flutter-internal-announce](http://g/flutter-internal-announce) with a link to
the new release notes.

### 9) Prepare DevTools for the next beta release

**The `daily-dev-bump` workflow is currently broken: [#8558](https://github.com/flutter/devtools/issues/8558). Until it's fixed, manually update the DevTools version for the next release and open a PR with the changes:**
```shell
dt update-version auto --type minor
dt update-version auto --type dev
```

1. ~~Update the DevTools version for the next release:~~
   ```shell
   gh workflow run daily-dev-bump.yaml -f updateType=minor+dev
   ```
  ~~This will kick off a workflow that will automatically create a PR with a
   `minor` + `dev` version bump. That PR should then be auto-submitted.~~

2. ~~Make sure that the release PR goes through without issue:~~
   - ~~See the workflow run [here](https://github.com/flutter/devtools/actions/workflows/daily-dev-bump.yaml)~~
   - ~~Go to https://github.com/flutter/devtools/pulls to see the pull request that
   ends up being created~~

## Dev release into the Dart SDK master branch

To publish a dev release follow just section [Update the DevTools hash in the Dart SDK](#update-the-devtools-hash-in-the-dart-sdk)
of the full release process. 

## Cherry-pick releases

### 1) Prepare the release in the `flutter/devtools` repo

1. Find the [DevTools tag](https://github.com/flutter/devtools/tags) that you want
   to perform the cherry-pick release on top of.

   For example, if you want to perform a cherry pick release of DevTools into
   the Flutter / Dart beta branch, you can see what the current version of DevTools
   is on Flutter / Dart beta by doing the following:

   1. Find the latest [beta
      release](https://github.com/flutter/flutter/blob/beta/bin/internal/release-candidate-branch.version)
      candidate (or [stable
      release](https://github.com/flutter/flutter/blob/stable/bin/internal/release-candidate-branch.version)
      candidate) that you will cherry-pick into.

   2. In your terminal, in the flutter/flutter repository, run `git checkout
      <latest-beta-version>`.
      
   3. Run `flutter --version` to see which version _of DevTools_ is on current
      Flutter / Dart beta (assuming `which flutter` points to your local
      Flutter git repository). For example, you might see:

      > Tools • Dart 3.8.1 • DevTools 2.45.1
      
      indicating that DevTools version 2.45.1 is used in this Flutter version.

3. Checkout that tag in your local DevTools repo. For this
example, we'll use `v2.29.0` as the base branch and `2.29.1` as the cherry-pick branch.
   ```shell
   git fetch upstream 
   git checkout v2.29.0
   ```

4. Create a new branch for your cherry pick release. 
   ```shell
   git checkout -b 2.29.1
   ```

5. Cherry pick the commit(s) you want in this cherry-pick release, and bump the 
DevTools version number:
   ```shell
   git cherry-pick <commit>
   dt update-version auto -t patch
   ```

6. Commit your changes and push to the `upstream` remote.
   ```shell
   git add .;
   git commit -m "Prepare cherry-pick release - DevTools 2.29.1";
   git push upstream 2.29.1
   ```

**To move on to the next step, you will need to take note of two values:**
1) The name of the DevTools branch you just created (e.g. `2.29.1`)
2) The commit hash that is at the tip of this branch
   (see https://github.com/flutter/devtools/branches).

### 2) Manually run the DevTools Builder

Follow the instructions at
[go/dart-engprod/devtools.md#cherry-picks](http://go/dart-engprod/devtools.md#cherry-picks)
to trigger the DevTools builder.

### 3) Create the cherry-pick CL in the Dart SDK

Checkout the Dart SDK branch you want to perform the cherry-pick on top of
(e.g. `stable` or `beta`), and create a new branch:

```shell
git new-branch --upstream origin/<stable or beta> cherry-pick-devtools
```

From this branch:
1. Edit the `"devtools_rev"` entry in the Dart SDK
[DEPS](https://github.com/dart-lang/sdk/blob/main/DEPS#L104) file to point to the
cherry-pick release hash (the commit at the tip of the cherry-pick branch you created
above).

2. **[Only if cherry-picking to `stable`]** add a
[CHANGELOG entry](https://github.com/dart-lang/sdk/blob/main/docs/Cherry-picks-to-a-release-channel.md#changelog).

3. Commit your changes and upload your CL:
   ```shell
   git add .
   git commit -m "Cherry-pick DevTools 2.29.1"
   git cl upload -s
   ```

Once your CL is uploaded to Gerrit, modify your changelist commit message to meet
the cherry-pick
[requirements](https://github.com/dart-lang/sdk/blob/main/docs/Cherry-picks-to-a-release-channel.md#how-to-cherry-pick-a-changelist).

The CL description should look like this:

```none
[stable or beta] Cherry-pick DevTools <new version number> into the SDK <stable or beta> branch.

Issue description: When attempting to use foo under certain conditions, users are unable to
compile.
What is the fix: foo is now evaluated at runtime.
Why cherry-pick: Users of foo are no longer able to compile to bar.
Risk: Low, this fix has landed on the main channel and is tested on the same infrastructure. 
Issue link(s): https://github.com/dart-lang/sdk/issues/12345678
Cherry-pick: https://github.com/flutter/devtools/compare/<previous DevTools tag>...<new version number>
Change-Id: Id75075a7e697559263742bc25972ef47532c39cb
```

Then trigger a CQ Dry Run, add reviewers, and wait for approval. **DO NOT** merge
the CL yet.

**Do not move on to the next steps unless your cherry-pick CL has been approved
and merged.**

### 4) Create a DevTools tag for the cherry-pick release

> [!IMPORTANT]
> **If your cherry-pick CL has not been approved and merged, wait.**

Once your cherry-pick has been approved and merged, create a tag for this cherry-pick
release. This will ensure that we have a tag we can branch from if we need to
create another DevTools cherry-pick release from the tip of the one we just created. 

Check out the cherry-pick branch you created earlier, and create a git tag:
```sh
git checkout upstream/2.29.1
dt tag-version
```

### 5) Create the merge commit in the `flutter/devtools` repo

> [!IMPORTANT]
> **If your cherry-pick CL has not been approved and merged, wait.**

In order to ensure that the cherry-picked DevTools commit does not get GC'ed, we
need to perform a merge commit from the branch we just created (e.g. `2.29.1`)
onto the `flutter/devtools` protected branch (`master`).

1. Create a pull request in the GitHub UI from the cherry-pick branch to the
   `master` branch.
   1. Navigate to `https://github.com/flutter/devtools/compare/<cherry-pick-branch>`,
      where `<cherry-pick-branch>` is the branch you pushed up to the `upstream`
      remote with the cherry-picked commit(s) (e.g. `2.29.1`).
   2. Click "Create pull request", and then create a PR with a descriptive title:
      "Merge commit for cherry-pick release 2.29.1"
   3. Once created, you should see several merge conflicts at the bottom of the PR.
      Click "Resolve conflicts" in the GitHub UI, and resolve any merge conflicts by
      **accepting whatever is on master**. Once you do this, the PR should show changes
      in **zero** lines of code.
   4. Ask a member of the DevTools team for review, but **DO NOT** squash and merge yet.

2. Message @kenzieschmoll or @elliette directly with the following request. If you cannot
   message @kenzieschmoll or @elliette directly, create an
   [issue](https://github.com/flutter/devtools/issues/new) and assign it to
   @kenzieschmoll or @elliette.


   Title:

   > Create merge commit for flutter/devtools cherry-pick.
   
   Body:
    
   > 1\. Temporarily modify the settings of https://github.com/flutter/devtools to "allow merge
   >    commits at the repo level and remove `require linear history`".\
   > 2\. IMPORTANT: Merge <link to PR> as a MERGE COMMIT. When merging, use the merge button dropdown
   >    menu to select "Create a merge commit", NOT "Squash and merge".\
   > 3\. Revert the settings.

    If @kenzieschmoll is unavailable to complete the merge commit, please ask another member of the Dash
    team who has Admin access to the `flutter/devtools` repository settings (@piinks or @tvolkert).

### Additional resources

- `dart-lang/sdk` cherry-pick [docs](https://github.com/dart-lang/sdk/blob/main/docs/Cherry-picks-to-a-release-channel.md)
- Flutter cherry-pick [docs](https://github.com/flutter/flutter/blob/master/docs/releases/Flutter-Cherrypick-Process.md)
- Example cherry-pick cl: https://dart-review.googlesource.com/c/sdk/+/336827
- Example cherry-pick issue: https://github.com/dart-lang/sdk/issues/54085
- Example merge commit on `flutter/devtools`: https://github.com/flutter/devtools/pull/6812
