<!--
Copyright 2025 The Flutter Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file or at https://developers.google.com/open-source/licenses/bsd.
-->
## DevTools releases
For instructions on how to release DevTools, please see
[RELEASE_INSTRUCTIONS.md](https://github.com/flutter/devtools/blob/master/tool/RELEASE_INSTRUCTIONS.md).

## Debug Logs

Debug logs found in `Settings > Copy Logs` are saved such that they can be read by (lnav)[https://lnav.org/]

### Configuring `lnav` for linux and MacOS
> For Windows, you will need find a different program to parse and read these logs.

- Follow the installation instructions found at https://lnav.org/downloads
- After installation create a symbolic link to the `tool/devtools_lnav.json` file, inside the `lnav` formats:
   ```sh
      ln -s ${DEVTOOLS}/tool/devtools_lnav.json ~/.lnav/formats/installed/`
   ```
- Your `lnav` installation will now be able to format logs created by Dart DevTools.

### Reading logs using `lnav`
- Save your Dart DevTools [Debug Logs](#debug-logs) to a file.
  ```sh
  DEBUG_LOGS=/path/to/your/logs # Let DEBUG_LOGS represent the path to your log file.
  ```
- Open the logs
  ```sh
  lnav $DEBUG_LOGS
  ```
- You should now be navigating the nicely formatted Dart Devtools Logs inside `lnav`

### `lnav` tips

For a quick tutorial on how to navigate logs using `lnav`
you can give [ their tutorial ](https://lnav.org/tutorials) a try.

## Finding the Flutter version that a DevTools commit is compatible with

Latest Flutter candidate for this DevTools version: [flutter-candidate.txt](../flutter-candidate.txt)

If [flutter-candidate.txt](../flutter-candidate.txt) does not exist:
- Find the most recent commit date for your DevTools version:

  ` git show -s --format=%ci`

- Use the following table to find the closest Flutter candidate date before your date.
  - Try using that version of flutter.
<details>

<summary><H3> Flutter Candidate List </H3></summary>

| DATE | TAG | HASH |
| ----| --- | ---- |
| 2023-07-12 02:02:03 +0000 | refs/tags/3.13.0-2.0.pre |d77f918f8eaff6009d5b2e52f0f8529798db2de5|
| 2023-07-10 01:01:34 +0000 | refs/tags/3.13.0-1.0.pre |5345221701727284bc961e3fb12ccfd3fc616dc7|
| 2023-07-07 14:25:30 -0600 | refs/tags/3.13.0-0.0.pre |257a29931c6b25d1a9690b7004f44921487bedb7|
| 2023-07-05 15:47:57 +0000 | refs/tags/3.12.0-14.0.pre |35085c394dda124f720815251197012868cd13c9|
| 2023-06-29 22:44:57 +0200 | refs/tags/3.12.0-13.0.pre |7068a2088e285822e4716d3fd98189514c49e184|
| 2023-06-28 17:16:19 -0700 | refs/tags/3.12.0-12.0.pre |1b887c72b5a1f809d35fb0a4343e0e6fdd14afd1|
| 2023-06-26 16:02:07 +0000 | refs/tags/3.12.0-11.0.pre |bac0589539a1bea104c6fa3fb6abfc002e72ed58|
| 2023-06-24 02:40:55 +0000 | refs/tags/3.12.0-10.0.pre |1d5aeea47fc4aa92ccc6850d4ac97bff3f2a4d15|
| 2023-06-23 04:11:55 +0000 | refs/tags/3.12.0-9.0.pre |363e2f7e0b878cc6f211f02afb1cffa0513bb6c2|
| 2023-06-21 21:38:36 +0000 | refs/tags/3.12.0-8.0.pre |ae1e6f70d947ec389761c03363c2beefeddd9112|
| 2023-06-21 02:40:48 +0000 | refs/tags/3.12.0-7.0.pre |04ff86f020a7029909f407351957bf26980c476d|
| 2023-06-16 12:43:02 -0700 | refs/tags/3.12.0-6.0.pre |5a7ab5a147f6b50ba7dc8c82d3ea0040fc0f081f|
| 2023-06-09 01:57:25 +0000 | refs/tags/3.12.0-3.0.pre |e25eabd263bbcb2fb32e62afcd2b545cef2767cc|
| 2023-06-07 20:16:53 +0000 | refs/tags/3.12.0-2.0.pre |f18cb2d064fd60b3d154bf07f55eb2aa0c111278|
| 2023-06-06 23:22:58 +0000 | refs/tags/3.12.0-1.0.pre |24ee5c7c746ebe66556a1a1d253a0be7a7b657b8|
| 2023-06-05 22:18:37 +0000 | refs/tags/3.12.0-0.0.pre |68b18918db0bdf2dc062b88e63ed8146d5b57364|
| 2023-06-03 11:16:37 +0000 | refs/tags/3.11.0-19.0.pre |0b7415356e07211446aa7038b1eb06717c86ae6a|
| 2023-05-31 03:09:32 +0000 | refs/tags/3.11.0-17.0.pre |f4662beeb67937fea67d26768e58f3e25b7e12d8|
| 2023-05-30 04:15:34 +0000 | refs/tags/3.11.0-15.0.pre |c5f45d7121f08d35094cbc25fcea3c81f0b006f8|
| 2023-05-26 02:17:26 +0000 | refs/tags/3.11.0-14.0.pre |6c2041e1e9e699cdf25bb23a01b01a4cdd722e72|
| 2023-05-25 03:09:20 +0000 | refs/tags/3.11.0-13.0.pre |9e4104b094e4b6305cbe0779453c284bf385df0b|
| 2023-05-24 03:40:27 +0000 | refs/tags/3.11.0-12.0.pre |216605b60f678d9ec9be880078e1de1b9f6e536f|
| 2023-05-23 02:03:02 +0000 | refs/tags/3.11.0-11.0.pre |6549765296241146265b6705f57923b1a7df2b87|
| 2023-05-19 16:43:40 -0700 | refs/tags/3.11.0-10.0.pre |7b16cbcb579d39689bd6dadcfc021238ad1cb6da|
| 2023-05-18 09:27:52 -0700 | refs/tags/3.11.0-9.0.pre |4245883c6b196fc1e6be781afe9f3140a919f24c|
| 2023-05-08 17:22:10 +0000 | refs/tags/3.11.0-5.0.pre |472a0ab31479b8567ae89546727f57bb57a10cf9|
| 2023-05-08 09:51:28 +0200 | refs/tags/3.11.0-4.0.pre |65dfb555c0483cf2bfe5e3c35291c88634185117|
| 2023-05-04 06:57:14 +0000 | refs/tags/3.11.0-1.0.pre |d51c59c78e1d3561bb3a5abdc75282604bbd76fe|
| 2023-05-02 08:38:26 +0000 | refs/tags/3.11.0-0.0.pre |596531361ec21ae335f6b43f0344be35d098647d|
| 2023-05-01 20:33:06 +0000 | refs/tags/3.10.0-18.0.pre |828a04040e111e5eec07056e82037a930f5fd5a2|
| 2023-04-28 17:49:54 -0400 | refs/tags/3.10.0-17.0.pre |7d37f2a616a31cd60ad5e1d39730def9b0df8205|
| 2023-04-28 00:32:55 +0000 | refs/tags/3.10.0-16.0.pre |55c988fb453eddd97cb2e4d6df9ec28d72e2e899|
| 2023-04-26 23:08:02 +0000 | refs/tags/3.10.0-15.0.pre |b3f3a0324afadb364381cd7e88ed016edcfd560e|
| 2023-04-26 03:53:04 +0000 | refs/tags/3.10.0-14.0.pre |8de77e89b749dfe7a5bfb62f6f66e7cccd9ddd3c|
| 2023-04-24 23:25:28 +0000 | refs/tags/3.10.0-13.0.pre |457e98a1e70b74b27a209721484c28e73a80caef|
| 2023-04-21 00:32:31 +0000 | refs/tags/3.10.0-11.0.pre |7d2669b8e7046be8ce22b5a9ed0194216c38ff8a|
| 2023-04-19 16:43:29 +0000 | refs/tags/3.10.0-9.0.pre |03d725620ac3ef1c2282fd1aef034ac5112ef6c1|
| 2023-04-19 06:39:50 +0000 | refs/tags/3.10.0-8.0.pre |59230759be2f2bcf46fe7584fd61ff8e27196480|
| 2023-04-18 21:52:52 +0000 | refs/tags/3.10.0-7.0.pre |81c3bc56873a54560abbb1e64495d4f79a29f1c1|
| 2023-04-17 03:21:38 +0000 | refs/tags/3.10.0-6.0.pre |858d4ff6348732edd79f923c61f7d8841ca40bef|
| 2023-04-14 04:56:22 +0000 | refs/tags/3.10.0-5.0.pre |9465b7473e8dddb795af050a4aa71ef80eabe7c6|
| 2023-04-12 23:39:38 +0000 | refs/tags/3.10.0-4.0.pre |b95b86f820cc422ec1d832ea929fa1388038aa0c|
| 2023-04-12 00:35:46 +0000 | refs/tags/3.10.0-3.0.pre |56e4f8e0ff75f5b26b6fcb1427007ec657357b7e|
| 2023-04-08 02:45:14 +0000 | refs/tags/3.10.0-2.0.pre |3ea2d72446c6d045d24d8eeeb321c73c5e9764ae|
| 2023-04-07 01:46:06 +0000 | refs/tags/3.10.0-1.0.pre |e749db6f915c341d15b9cb81dc19bdc9e791c72f|
| 2023-04-04 04:58:34 +0000 | refs/tags/3.9.0-21.0.pre |f076b7bac36b97c5a3169529290835c91f445dca|
| 2023-04-03 00:19:22 +0000 | refs/tags/3.9.0-20.0.pre |6fe54f881106953d465a7249f6579ca29f401bdb|
| 2023-03-29 07:16:01 +0000 | refs/tags/3.9.0-19.0.pre |91311156e12232466f78ce6ba96a0404c4f9790e|
| 2023-03-27 22:49:35 +0000 | refs/tags/3.9.0-18.0.pre |d6287cc4172c927650ab225d917de0688f8d572a|
| 2023-03-24 22:18:54 +0000 | refs/tags/3.9.0-17.0.pre |d45c142f3db4d7af9f24c3f37a0b1e08e4267066|
| 2023-03-23 17:00:20 -0700 | refs/tags/3.9.0-16.0.pre |4e58370cbf8f202cf4243aec38d5036129380693|
| 2023-03-22 22:53:49 +0000 | refs/tags/3.9.0-15.0.pre |3736274a6d659cd0ce8a951d0d19900b1e11f9e9|
| 2023-03-22 07:05:08 +0000 | refs/tags/3.9.0-14.0.pre |c582c80dd62b9026b485397ec51e696e48a9980c|
| 2023-03-20 21:08:41 -0700 | refs/tags/3.9.0-12.0.pre |28f17d345b95478f543794594aa45c882d4527a8|
| 2023-03-20 07:53:14 +0000 | refs/tags/3.9.0-11.0.pre |21f60bbe0d77d1a0dd9a44722479009ae697c6fb|
| 2023-03-18 14:38:35 -0700 | refs/tags/3.9.0-10.0.pre |f5248bbc8c5db808efbb722603842515738695ec|
| 2023-03-17 01:11:44 +0000 | refs/tags/3.9.0-9.0.pre |61a2f9de51007999c8a3f50e98061d7138a694eb|
| 2023-03-15 23:10:36 +0000 | refs/tags/3.9.0-8.0.pre |267e8896c58644e05af015b0c99a359020203246|
| 2023-03-15 08:34:21 +0000 | refs/tags/3.9.0-7.0.pre |fb7e82826db36bcb627cd14707f739b6114ad6db|
| 2023-03-13 15:37:42 -0700 | refs/tags/3.9.0-6.0.pre |1306d7f1588c9de4c8534b90308494c3630a8c5a|
| 2023-03-01 20:37:41 +0000 | refs/tags/3.9.0-0.0.pre |844fc5fe2d2d31ee171df52b351f6ae42148db86|
| 2023-02-27 23:52:57 +0000 | refs/tags/3.8.0-18.0.pre |781c84a860a4d8c1a85b7a84b855560528a236b2|
| 2023-02-28 04:11:38 +0000 | refs/tags/3.8.0-17.0.pre |1d17caed66641b55a8e8faadf212398f746f8861|
| 2023-02-24 23:52:06 +0000 | refs/tags/3.8.0-16.0.pre |6b3f95832a94a3d613aeaaa83e3a7c9f5e1a4b7f|
| 2023-02-23 00:13:33 +0000 | refs/tags/3.8.0-15.0.pre |8f7ccd4c419a65aff9211b99cd6ec27f874f689a|
| 2023-02-21 23:16:23 +0000 | refs/tags/3.8.0-14.0.pre |dad9eb21f9c34ebbed1328d24bb9069168e14eae|
| 2023-02-19 23:08:26 +0000 | refs/tags/3.8.0-13.0.pre |d54d3b4d16f6003ea5a1481b7fef0693f0e30ea4|
| 2023-02-13 23:52:35 +0000 | refs/tags/3.8.0-12.0.pre |865422da200fd4b414693a6bfcc29e6d7215a012|
| 2023-02-10 14:03:01 -0600 | refs/tags/3.8.0-11.0.pre |780c9a8de15780094260232b3b8c97b2a9ef8088|
| 2023-02-08 22:51:04 -0800 | refs/tags/3.8.0-10.0.pre |dee226ef8a463e87edeed4115a27fb2743424e27|
| 2023-02-09 23:50:11 +0000 | refs/tags/3.8.0-9.0.pre |e3471f08d1d3f816fff8afd1ce9385dd3feb73d2|
| 2023-02-08 18:17:29 -0600 | refs/tags/3.8.0-8.0.pre |0fb4406c30d6427044fa8322a6278b92982cc22b|
| 2023-02-08 04:18:32 +0000 | refs/tags/3.8.0-7.0.pre |1e6e6d41e3f747640119cee8e58914547ec44377|
| 2023-02-07 03:10:30 +0000 | refs/tags/3.8.0-6.0.pre |845f7bb42a9e77f2192595abcccc9742428893c1|
| 2023-02-06 16:45:39 +0000 | refs/tags/3.8.0-5.0.pre |40b5e4cb5e7720cc5ab5edb59cb96eab5530d829|
| 2023-02-05 07:06:19 +0000 | refs/tags/3.8.0-4.0.pre |b8f5394a5ca6d2bce062d9d0a20aaffb4289fb4c|
| 2023-02-03 10:07:21 +0000 | refs/tags/3.8.0-3.0.pre |a5d8a4a7272ed86ed17cee443d40afde022e415f|
| 2023-02-02 17:11:19 +0000 | refs/tags/3.8.0-2.0.pre |1ee87990dc76044ba4b23395eb64ea1416f9c85c|
| 2023-02-01 19:19:13 +0000 | refs/tags/3.8.0-1.0.pre |5613ab010de7683bfb91b782b0005e3d3c52b53e|
| 2023-01-31 18:03:09 -0800 | refs/tags/3.8.0-0.0.pre |82df23539ffc962c850e5681522c020b01b9f8c0|
| 2023-01-31 07:28:09 +0000 | refs/tags/3.7.0-31.0.pre |2c34a88eb89628e6a80caa50dd03797f9b6aa5e5|
| 2023-01-30 10:19:14 +0000 | refs/tags/3.7.0-30.0.pre |530c3f2d13bae3c45510ae5e4a0d9a5cd987a5aa|
| 2023-01-28 10:20:52 +0000 | refs/tags/3.7.0-29.0.pre |f8d4de488b90a1bebc37820656784236a96b4ec6|
| 2023-01-27 01:36:56 +0000 | refs/tags/3.7.0-28.0.pre |8d03af3424db84a11f6d4335b250b957ab96fae2|
| 2023-01-25 23:43:00 +0000 | refs/tags/3.7.0-27.0.pre |766e4d28a4df84ea76ed6f3b1e8e9fd191f84201|
| 2023-01-25 12:35:25 +0000 | refs/tags/3.7.0-26.0.pre |eced23eaba8f64cb5ca733d2dd574dfe2a2c64cf|
| 2023-01-24 19:38:19 +0000 | refs/tags/3.7.0-25.0.pre |d20dd9e4bfecdaef84605296d0ba0fa26dee2714|
| 2023-01-23 21:45:07 +0000 | refs/tags/3.7.0-24.0.pre |332aed9c886cea820d1ba666eba5785b3da2b809|
| 2023-01-19 15:55:24 +0000 | refs/tags/3.7.0-23.0.pre |46c7fd14da027f71e2c300e392bd1976b56d30a4|
| 2023-01-18 00:55:33 +0000 | refs/tags/3.7.0-22.0.pre |780563ce05e4bdc8b73c8ecb9da4ccc575a2d5ac|
| 2023-01-17 06:09:06 +0000 | refs/tags/3.7.0-21.0.pre |f22280a0c851f97be76eedc13a4fd82e8a080f08|
| 2023-01-12 11:03:12 +0000 | refs/tags/3.7.0-20.0.pre |51c2af56c9f4b5728c771d229baa19a286c01aa0|
| 2023-01-11 20:19:26 +0000 | refs/tags/3.7.0-19.0.pre |b4a07de2aeb132ef983b21e173b15a3da7ecef40|
| 2023-01-11 09:04:39 +0000 | refs/tags/3.7.0-18.0.pre |957781a108ff3a555e4df36beb8c1ebe12c85051|
| 2023-01-10 23:29:09 +0000 | refs/tags/3.7.0-17.0.pre |b7881e5b64e28a84a66ab30b29d35484428ea062|
| 2023-01-10 02:08:34 +0000 | refs/tags/3.7.0-16.0.pre |4205357554d21a084d3ebfca0a8f0d20c80989e0|
| 2023-01-09 18:29:26 +0000 | refs/tags/3.7.0-15.0.pre |a02b9d2bff89e256d0639f7f908d09a64db12ee9|
| 2023-01-05 09:35:28 +0000 | refs/tags/3.7.0-14.0.pre |45886068cf84d36fe471f26f4f233e8699579e8c|
| 2022-12-30 06:21:25 +0000 | refs/tags/3.7.0-13.0.pre |3223972956595acc37727ed599ba5fa75d96b6a7|
| 2022-12-20 10:02:22 -0500 | refs/tags/3.7.0-12.0.pre |7f7a8778d8a823cabcdcb4c5ee27deb2c499af5e|
| 2022-12-14 21:53:20 +0000 | refs/tags/3.7.0-11.0.pre |dbc9306380d8a72273b478b8fcc934a6014f946d|
| 2022-12-13 23:47:06 +0000 | refs/tags/3.7.0-10.0.pre |a59dd83d721460b2fea09a6b332d5c761fcf5b38|
| 2022-12-15 09:13:36 -0800 | refs/tags/3.7.0-9.0.pre |dcd2170d14bdef22dacff5c750c578c01245bded|
| 2022-12-14 05:18:21 +0000 | refs/tags/3.7.0-8.0.pre |028c6e29e0ca049ab4b9bc9d966550d2c251050b|
| 2022-12-13 23:47:06 +0000 | refs/tags/3.7.0-7.0.pre |a59dd83d721460b2fea09a6b332d5c761fcf5b38|
| 2022-12-13 03:42:23 +0000 | refs/tags/3.7.0-6.0.pre |04ee5926a2a6aaabfa0dde0279223952d2de3e3e|
| 2022-12-12 06:46:41 +0000 | refs/tags/3.7.0-5.0.pre |437f6f86ec9a8158f0e6077fd0d1cde2fef01bae|
| 2022-12-08 22:29:14 +0000 | refs/tags/3.7.0-4.0.pre |117a83a4a7178c328d296748bd93ff388724cb67|
| 2022-12-05 23:26:26 +0000 | refs/tags/3.7.0-3.0.pre |e0a0190c5a063ca740adeb5a56a18f620c401985|
| 2022-12-02 23:32:24 +0000 | refs/tags/3.7.0-2.0.pre |b75f1a941b6d007c4bdcde8b3acc9670d2a85292|
| 2022-12-01 21:40:50 +0000 | refs/tags/3.7.0-1.0.pre |75f61903e02213b64fcb580cd35f3efa17474ae2|
| 2022-12-01 19:43:25 +0000 | refs/tags/3.7.0-0.0.pre |0bb71df75f10a9ad740836568c730ed8aaede2d8|
| 2022-12-01 02:24:18 +0000 | refs/tags/3.6.0-13.0.pre |014b441ddf56586eb1aeb179cf49f10fda93a495|
| 2022-11-30 03:57:31 +0000 | refs/tags/3.6.0-12.0.pre |02de12947ab01960ca810fee2c7e72a38d11091a|
| 2022-11-29 20:31:37 +0000 | refs/tags/3.6.0-11.0.pre |c37c0cc2edb40ff0a934b7e37f7c2726b9e366dc|
| 2022-11-29 05:24:25 +0000 | refs/tags/3.6.0-10.0.pre |853b3080e096abb0479f2b5023b4a389e65a27ae|
| 2022-11-28 23:24:24 +0000 | refs/tags/3.6.0-9.0.pre |db631f14969fbf68c8d346d84b6634f1aa84324f|
| 2022-11-24 23:08:30 +0000 | refs/tags/3.6.0-8.0.pre |ff59250dbeb02dfc30095dfe024c76b7cefeefe9|
| 2022-11-21 15:26:41 +0000 | refs/tags/3.6.0-7.0.pre |809ee44183540d770373ab43354947b92e30da91|
| 2022-11-21 15:58:11 +0000 | refs/tags/3.6.0-6.0.pre |a9858ec52495ecd45adc7bdda30c709d877e1416|
| 2022-11-18 15:14:53 +0000 | refs/tags/3.6.0-5.0.pre |87cb150c2062d770dae00306d17f07bd79e4c265|
| 2022-11-17 08:06:24 -0800 | refs/tags/3.6.0-4.0.pre |537f89ca0ef14aeb21f4f55149d72f227abb5017|
| 2022-11-16 05:50:28 +0000 | refs/tags/3.6.0-3.0.pre |58728c6a92eaad66dbfefd573ba20649845ba678|
| 2022-11-13 22:53:26 +0000 | refs/tags/3.6.0-2.0.pre |fa94a3c10e7e895e0a566ca4da0eafc84b073f13|
| 2022-11-12 09:39:32 +0000 | refs/tags/3.6.0-1.0.pre |61e927d22fe6d82c94c368d62aa81f733bd9218d|
| 2022-11-09 03:50:41 -0800 | refs/tags/3.6.0-0.0.pre |d3dcd7d532b61f43118ab8031bf732aea4a7a9f5|
| 2022-10-28 01:37:32 +0000 | refs/tags/3.5.0-11.0.pre |9b59a4e1f03cd0f4f4d452a59bb992f29e689194|
| 2022-10-19 19:13:12 +0000 | refs/tags/3.5.0-10.0.pre |38ef9410b4806266eaab2b21295f908b396d9b22|
| 2022-10-20 02:14:43 -0700 | refs/tags/3.5.0-9.0.pre |637e5bce662fb43459d409e13ba5a7fb2c3fa930|
| 2022-10-17 17:07:05 -0400 | refs/tags/3.5.0-8.0.pre |5d078badb90ae7e7d46daf7f671e19d4cfca376a|
| 2022-10-13 20:25:24 +0000 | refs/tags/3.5.0-7.0.pre |f9c1556e449151bab5b8ba1b13644284d5c2f141|
| 2022-10-10 22:38:06 +0000 | refs/tags/3.5.0-6.0.pre |4be0cfcb3f81a5636cfef65ef7936d7895da2984|
| 2022-10-11 00:07:24 +0000 | refs/tags/3.5.0-5.0.pre |883c1fe68c37614577ce329e14452d7c4ef37ee9|
| 2022-10-09 16:37:38 +0000 | refs/tags/3.5.0-4.0.pre |fe9b598c12646fa2cfe32bb4b4201df84ab3f28b|
| 2022-10-07 10:28:49 -0700 | refs/tags/3.5.0-3.0.pre |529184bcca0f019323df5930d3903b07136a5b87|
| 2022-10-06 23:12:06 +0000 | refs/tags/3.5.0-2.0.pre |26cf025966c6bb836a84642e4275970aa34add99|
| 2022-10-05 12:58:20 +0000 | refs/tags/3.5.0-1.0.pre |5c381254e37ff354261fe13be39243bc8d2d0bc4|
| 2022-10-04 22:12:01 +0000 | refs/tags/3.5.0-0.0.pre |208056f63e4e44a7b3ae68f55463561b39bcb482|
| 2022-10-04 14:06:31 +0000 | refs/tags/3.4.0-39.0.pre |55d67cc7d99226cd12d6c4a76de357fc2c92823e|
| 2022-10-04 05:19:24 +0000 | refs/tags/3.4.0-38.0.pre |b8784dd3055ac6782c105d677b0e58968335c180|
| 2022-10-04 01:41:23 +0000 | refs/tags/3.4.0-37.0.pre |35afe1bdac653c752c5794cf877b64238a4c9e4c|
| 2022-10-03 13:52:25 +0000 | refs/tags/3.4.0-36.0.pre |a4b246f2a88c3f5b838c5abff8063a4e7436d44b|
| 2022-10-01 11:55:35 +0000 | refs/tags/3.4.0-35.0.pre |cfd0f15d2906d0fa64f7b66718ff1423035bace2|
| 2022-09-29 23:38:08 +0000 | refs/tags/3.4.0-34.0.pre |fb8dcb8e279ff491b2c5eff876271cce75880019|
| 2022-09-28 23:10:27 +0000 | refs/tags/3.4.0-33.0.pre |90ff389f1b367f30e24ef9799d229bcd56ec925d|
| 2022-09-26 22:00:21 +0000 | refs/tags/3.4.0-32.0.pre |fb4dac385e60a2f842ebc94ed604aca8b5c404fa|
| 2022-09-26 21:21:58 +0000 | refs/tags/3.4.0-31.0.pre |2adee31ce8b5256462d553dfb8bd613856cc2d94|
| 2022-09-26 13:00:24 +0000 | refs/tags/3.4.0-30.0.pre |7b6074fbc542efb41da5618bc97711fac6ab7dee|
| 2022-09-23 20:31:04 +0000 | refs/tags/3.4.0-29.0.pre |8384f1ea6516fe9457bb610af8ad91817e3d497e|
| 2022-09-19 16:19:11 +0000 | refs/tags/3.4.0-28.0.pre |cb8c72545ca931b76c713b5e522c92ee790f23e5|
| 2022-09-19 01:11:34 +0000 | refs/tags/3.4.0-27.0.pre |085a187e047dde96b3f180f92c25159742f85ecd|
| 2022-08-31 01:20:09 +0000 | refs/tags/3.4.0-18.0.pre |069f5042973dc4aafbf76a44ca14af7c0e2c2ca1|
| 2022-08-28 18:41:27 +0000 | refs/tags/3.4.0-17.0.pre |0c6d786e3aa8f01191748a20b28d5bf20799b49b|
| 2022-07-18 18:59:23 -0700 | refs/tags/3.3.0-0.0.pre |f90da9b1672f7d006ba760fbb8fd1aa17af1a82a|
| 2022-06-14 13:39:33 -0500 | refs/tags/3.1.0-9.0.pre |f28e570c8cb12a004fae2d796d0d9cd46603bde9|
| 2022-04-05 15:20:48 -0700 | refs/tags/3.0.0-0.0.pre |3bf40fd9beb91fc097e3d406a5df51eaead2baf5|
| 2022-03-06 23:41:20 -0800 | refs/tags/2.12.0-4.0.pre |64a0138c937b1f7bd67e596571f4f33cd19c2b88|
| 2021-12-29 11:29:19 -0800 | refs/tags/2.10.0-0.0.pre |95e555344dc746ad46ada9de9cc475042c63ec55|
| 2021-12-07 17:39:04 -0800 | refs/tags/2.9.0-0.0.pre |a7917414dd919edb2e3198c2a8d2130e9275b414|
| 2021-10-19 10:58:42 -0700 | refs/tags/2.7.0-3.0.pre |c19845a8c347adebc2c672f5e51b74855e645be2|
| 2021-09-16 17:29:58 -0700 | refs/tags/2.6.0-11.0.pre |4b330ddbedab445481cc73d50a4695b9154b4e4f|
| 2021-09-04 08:36:02 -0700 | refs/tags/2.6.0-5.0.pre |2604ea711c6651820773f5403a0128d2d64f7b14|
| 2021-08-23 10:03:21 -0700 | refs/tags/2.6.0-0.0.pre |83b9e99cfbb8be5215514d7fa21191961b4a620d|
| 2021-08-05 11:32:48 -0700 | refs/tags/2.5.0-6.0.pre |225a43d941ddd1753765fec3682011e9ddffb11d|
| 2021-08-04 17:59:50 -0500 | refs/tags/2.5.0-5.0.pre |0f465e5b2a3ed2431321b490a614c3d15089854c|
| 2021-07-26 01:38:02 -0700 | refs/tags/2.5.0-1.0.pre |184e5871beea4a9b1cbd65dcc57118a7d97285f3|
| 2021-07-11 15:21:02 -0700 | refs/tags/2.4.0-4.0.pre |cc00e7e6bc281f6af9a257e7e33868ef782b1cf7|
| 2021-06-30 00:43:41 -0700 | refs/tags/2.4.0-0.0.pre |96bbcd006fafade4ad7a4abde77cec32df6846ea|
| 2021-06-11 22:11:53 -0700 | refs/tags/2.3.0-24.0.pre |2b9537c783063d0459b6282a218658a6955938d9|
| 2021-05-21 13:04:03 -0700 | refs/tags/2.3.0-16.0.pre |fa5883b78e566877613ad1ccb48dd92075cb5c23|
| 2021-05-17 11:59:02 -0700 | refs/tags/2.3.0-12.0.pre |0f031471381e135bfac3f42fed88a778267b819a|
| 2021-04-30 12:35:21 -0700 | refs/tags/2.3.0-1.0.pre |d97f41caed971d4668ffe56699367ec3978db8f6|
| 2021-04-21 13:29:09 -0700 | refs/tags/2.3.0-0.0.pre |21fd5cdd1a2b5e9a97b2df80e5c40f94c096748f|
| 2021-04-07 12:24:22 -0700 | refs/tags/2.2.0-10.0.pre |0efb28d7061b8d4126c48e72b9156bf2f0584ded|
| 2021-03-09 07:53:21 +0100 | refs/tags/2.1.0-12.0.pre |698d4389604ef1f0fecda9c93cfba6a2e5d06a7d|
| 2021-02-25 13:26:03 -0800 | refs/tags/2.1.0-10.0.pre |cc9b78fc5c4a4d2d51316d9626523336230a89a9|
| 2021-02-19 09:22:45 -0800 | refs/tags/1.27.0-8.0.pre |b7d4806243a4e906bf061f79a0e314ba28111aa6|
| 2021-02-16 11:24:17 -0800 | refs/tags/1.27.0-4.0.pre |f8cd24de95b16b5a1ce6ebc0716154271fbf6252|
| 2021-02-08 16:14:15 -0800 | refs/tags/1.27.0-1.0.pre |68c96f100e42ab3dbf43e61e9e2fc875a2d50cb8|
| 2021-01-26 10:58:48 -0800 | refs/tags/1.26.0-17.0.pre |384b4d1b83c0a5b7364ab7bcc5ce85f60d05e4a6|
| 2021-01-14 15:20:26 -0800 | refs/tags/1.26.0-12.0.pre |a706cd211240f27be3b61f06d70f958c7a4156fe|
| 2021-01-07 18:36:48 -0800 | refs/tags/1.26.0-8.0.pre |b9d06fffb2db263ab7021fc39adde7f2bf988a4a|
| 2020-12-13 23:19:13 +0800 | refs/tags/1.26.0-1.0.pre |63062a64432cce03315d6b5196fda7912866eb37|
| 2020-12-08 20:13:04 -0800 | refs/tags/1.25.0-8.0.pre |a12e2a473a3214b4556ca589d2d9bd311ac7c6f1|
| 2020-11-30 13:14:13 +0100 | refs/tags/1.25.0-4.0.pre |a7f5fd5360007518644597c60a1f2169eacccc2b|
| 2020-10-29 20:07:34 -0700 | refs/tags/1.24.0-7.0.pre |a0860f6e87ba4f9031bee4d6f56c08b970606bee|
| 2020-10-28 19:43:19 -0700 | refs/tags/1.24.0-6.0.pre |13896b3bd1858687a06b1639d60c877206170df8|
| 2020-10-22 09:36:06 -0700 | refs/tags/1.24.0-3.0.pre |2783f8e2e14efec8b7e08f668dde61c40d128c24|
| 2020-10-14 15:57:04 -0700 | refs/tags/1.24.0-1.0.pre |12bea61c2902784fec73b7f5f2ff3415f873fead|
| 2020-10-13 10:52:23 -0700 | refs/tags/1.23.0-18.0.pre |37ebe3d82a9d5faeda7d3c1a6ad193030210a2cc|
| 2020-10-06 12:31:25 -0700 | refs/tags/1.23.0-13.0.pre |4fa4f91d5cc65a5a98c7ccd91bb7d47814048a57|
| 2020-09-25 03:47:03 -0700 | refs/tags/1.23.0-7.0.pre |db6e2d8aa5bb9a0bd3e75fc7470268b5a56fd0b0|
| 2020-09-22 12:04:44 -0700 | refs/tags/1.23.0-4.0.pre |83dd176777cd04bd2aaca050f6bb6cb9edbf56a1|
| 2020-09-17 16:12:06 -0700 | refs/tags/1.23.0-3.0.pre |0cf1b407f2edeb16edcfb5b032140bb39a5e46c6|
| 2020-09-11 14:46:57 -0700 | refs/tags/1.22.0-12.0.pre |a27c242b0eea731317cfec5bbdd9d35452ab3ecb|
| 2020-08-28 20:18:04 -0700 | refs/tags/1.22.0-9.0.pre |7a4317519865146acda84702bba8775610598c0c|
| 2020-08-20 07:31:50 -0700 | refs/tags/1.22.0-1.0.pre |ce40de69b7b4f89c66d19c8dbd3bd86ae30f1bc6|
| 2020-08-09 07:31:03 -0700 | refs/tags/1.21.0-9.0.pre |7c6f9dd2396dfe7deb6fd11edc12c10786490083|
| 2020-08-03 10:33:07 -0700 | refs/tags/1.21.0-7.0.pre |5a6dfa35caaf7bccb35488dc03677c150ebf2d97|
| 2020-07-22 18:40:12 -0700 | refs/tags/1.21.0-5.0.pre |a19fd72db549ddc5d07998d38671a6843dcad6f9|
| 2020-07-14 17:26:01 -0700 | refs/tags/1.21.0-1.0.pre |f25bd9c55c48c139524139b477d04b13e9f36b2c|
| 2020-07-08 10:19:36 -0700 | refs/tags/1.20.0-7.0.pre |cc1af3afb62187cc37185afddc2d43bfef469db7|
| 2020-07-04 12:19:20 -0700 | refs/tags/1.20.0-3.0.pre |0af027f80543302c65f99e1c1a2f3b3cbb8d04f3|
| 2020-06-23 04:52:58 -0700 | refs/tags/1.20.0-2.0.pre |15a28159bcf4b3db13411cbc8d9b5fc51adc0a93|
| 2020-06-18 08:23:22 -0700 | refs/tags/1.20.0-1.0.pre |f73f498da1fe4224e29cf9692161575a3d994f8f|
| 2020-06-09 15:43:03 -0700 | refs/tags/1.20.0-0.0.pre |d9653445f4d1257b5f5adb4b271d1316469e8cf1|
| 2020-06-08 09:27:34 -0700 | refs/tags/1.19.0-5.0.pre |c264b70ec3b0cf9cd568eba5d65d0ce47fe57e1d|
| 2020-06-05 03:44:02 -0700 | refs/tags/1.19.0-4.0.pre |2f7a59a8da20b3a7fbdfb7ac783dbca977a81653|
| 2020-06-01 17:17:03 -0700 | refs/tags/1.19.0-3.0.pre |6135091de9f8f6befc2ec7f8835d28d43a21cd05|
| 2020-05-31 07:41:50 -0700 | refs/tags/1.19.0-2.0.pre |1d395c5e187370f2838bb043d3b438029b484bfc|
| 2020-05-11 08:45:03 -0700 | refs/tags/1.19.0-1.0.pre |456d80b9ddd74b4b5ca3b77bbfb70ab0e05d3fa8|
| 2020-05-07 18:59:02 -0700 | refs/tags/1.19.0-0.0.pre |a849daf2836d653ef80e01f428531b3f787671cb|
| 2020-05-06 17:36:01 -0700 | refs/tags/1.18.0-13.0.pre |8fbfe1cfbf6ac5c5c23930556e1019385005bf81|
| 2020-05-06 08:16:03 -0700 | refs/tags/1.18.0-12.0.pre |c2b7342ca470b11cfaad4fbfb094f73aa4c85320|
| 2020-05-05 16:10:41 -0700 | refs/tags/1.18.0-11.0.pre |8568eda15b2527afd48622257cee3811e0d9da04|
| 2020-05-05 12:09:51 -0700 | refs/tags/1.18.0-10.0.pre |9b7b9d795edfdd12c6ad8dd6495bed789c1bac05|
| 2020-05-05 13:08:49 -0700 | refs/tags/1.18.0-9.0.pre |445570ba1ae89eecaf9409fb5acde7e8b49ee975|
| 2020-04-23 19:29:01 -0700 | refs/tags/1.18.0-8.0.pre |e0c63cd35e15e407a80dc44281cc392535fcce25|
| 2020-04-23 11:57:18 -0700 | refs/tags/1.18.0-7.0.pre |d482163f59c49c32cb329beb2c3111c8e961d6b9|
| 2020-04-20 18:35:01 -0700 | refs/tags/1.18.0-6.0.pre |84c84fb24914e098667649be04614f6ea19d689c|



</details>
