// Copyright 2023 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file or at https://developers.google.com/open-source/licenses/bsd.

import 'dart:convert';

// We encode this as a JSON string rather than using a very large constant
// structured value because dart2wasm creates pathological/invalid wasm code
// to initialize those large data structures.
// See https://github.com/dart-lang/sdk/issues/56483
final Map<String, Object?> sampleCpuProfilerData = json.decode('''
{
  "devToolsSnapshot": true,
  "devToolsVersion": "2.30.0",
  "connectedApp": {
    "isFlutterApp": true,
    "isProfileBuild": false,
    "isDartWebApp": false,
    "isRunningOnDartVM": true,
    "operatingSystem": "android",
    "flutterVersion": "3.18.0-7.0.pre.10"
  },
  "activeScreenId": "cpu-profiler",
  "cpu-profiler": {
    "type": "_CpuProfileTimeline",
    "samplePeriod": 250,
    "sampleCount": 294,
    "stackDepth": 128,
    "timeOriginMicros": 0,
    "timeExtentMicros": 2383032,
    "stackFrames": {
      "isolates/4095163606998683-757": {
        "name": "PlatformDispatcher._dispatchPointerDataPacket",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///flutter/lib/ui/platform_dispatcher.dart",
        "packageUri": "dart:ui/platform_dispatcher.dart",
        "sourceLine": 407,
        "parent": "isolates/4095163606998683-756"
      },
      "isolates/4095163606998683-756": {
        "name": "_dispatchPointerDataPacket",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/hooks.dart",
        "packageUri": "dart:ui/hooks.dart",
        "sourceLine": 260,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-760": {
        "name": "_GrowableList._growToNextCapacity",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/growable_array.dart",
        "packageUri": "dart:core-patch/growable_array.dart",
        "sourceLine": 394,
        "parent": "isolates/4095163606998683-759"
      },
      "isolates/4095163606998683-759": {
        "name": "_GrowableList.add",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/growable_array.dart",
        "packageUri": "dart:core-patch/growable_array.dart",
        "sourceLine": 275,
        "parent": "isolates/4095163606998683-758"
      },
      "isolates/4095163606998683-758": {
        "name": "PlatformDispatcher._unpackPointerDataPacket",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///flutter/lib/ui/platform_dispatcher.dart",
        "packageUri": "dart:ui/platform_dispatcher.dart",
        "sourceLine": 424,
        "parent": "isolates/4095163606998683-757"
      },
      "isolates/4095163606998683-765": {
        "name": "MappedIterable.MappedIterable._",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/internal/iterable.dart",
        "packageUri": "dart:_internal/iterable.dart",
        "sourceLine": 373,
        "parent": "isolates/4095163606998683-764"
      },
      "isolates/4095163606998683-764": {
        "name": "WhereIterable.map",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/internal/iterable.dart",
        "packageUri": "dart:_internal/iterable.dart",
        "sourceLine": 439,
        "parent": "isolates/4095163606998683-763"
      },
      "isolates/4095163606998683-763": {
        "name": "PointerEventConverter.expand",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/converter.dart",
        "packageUri": "package:flutter/src/gestures/converter.dart",
        "sourceLine": 60,
        "parent": "isolates/4095163606998683-762"
      },
      "isolates/4095163606998683-762": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding._handlePointerDataPacket",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 293,
        "parent": "isolates/4095163606998683-761"
      },
      "isolates/4095163606998683-761": {
        "name": "_invoke1",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/hooks.dart",
        "packageUri": "dart:ui/hooks.dart",
        "sourceLine": 323,
        "parent": "isolates/4095163606998683-757"
      },
      "isolates/4095163606998683-771": {
        "name":
            "_PointerHoverEvent&PointerEvent&_PointerEventDescription&_CopyPointerHoverEvent._PointerHoverEvent&PointerEvent&_PointerEventDescription&_CopyPointerHoverEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/events.dart",
        "packageUri": "package:flutter/src/gestures/events.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-770"
      },
      "isolates/4095163606998683-770": {
        "name": "PointerHoverEvent.PointerHoverEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/events.dart",
        "packageUri": "package:flutter/src/gestures/events.dart",
        "sourceLine": 1023,
        "parent": "isolates/4095163606998683-769"
      },
      "isolates/4095163606998683-769": {
        "name": "PointerEventConverter.expand.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/converter.dart",
        "packageUri": "package:flutter/src/gestures/converter.dart",
        "sourceLine": 63,
        "parent": "isolates/4095163606998683-768"
      },
      "isolates/4095163606998683-768": {
        "name": "MappedIterator.moveNext",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/internal/iterable.dart",
        "packageUri": "dart:_internal/iterable.dart",
        "sourceLine": 401,
        "parent": "isolates/4095163606998683-767"
      },
      "isolates/4095163606998683-767": {
        "name": "WhereTypeIterator.moveNext",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/internal/iterable.dart",
        "packageUri": "dart:_internal/iterable.dart",
        "sourceLine": 881,
        "parent": "isolates/4095163606998683-766"
      },
      "isolates/4095163606998683-766": {
        "name": "ListQueue.addAll",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/collection/queue.dart",
        "packageUri": "dart:collection/queue.dart",
        "sourceLine": 728,
        "parent": "isolates/4095163606998683-762"
      },
      "isolates/4095163606998683-775": {
        "name":
            "_PointerDownEvent&PointerEvent&_PointerEventDescription&_CopyPointerDownEvent._PointerDownEvent&PointerEvent&_PointerEventDescription&_CopyPointerDownEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/events.dart",
        "packageUri": "package:flutter/src/gestures/events.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-774"
      },
      "isolates/4095163606998683-774": {
        "name": "PointerDownEvent.PointerDownEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/events.dart",
        "packageUri": "package:flutter/src/gestures/events.dart",
        "sourceLine": 1428,
        "parent": "isolates/4095163606998683-769"
      },
      "isolates/4095163606998683-1073": {
        "name": "_SuspendState._resume",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/async_patch.dart",
        "packageUri": "dart:async-patch/async_patch.dart",
        "sourceLine": 473,
        "parent": "isolates/4095163606998683-1072"
      },
      "isolates/4095163606998683-1072": {
        "name": "_SyncStarIterator.moveNext",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/async_patch.dart",
        "packageUri": "dart:async-patch/async_patch.dart",
        "sourceLine": 531,
        "parent": "isolates/4095163606998683-986"
      },
      "isolates/4095163606998683-986": {
        "name":
            "__RenderTheater&RenderBox&ContainerRenderObjectMixin&_RenderTheaterMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 920,
        "parent": "isolates/4095163606998683-985"
      },
      "isolates/4095163606998683-985": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-984"
      },
      "isolates/4095163606998683-984": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-983"
      },
      "isolates/4095163606998683-983": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-982"
      },
      "isolates/4095163606998683-982": {
        "name": "RenderAbsorbPointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3853,
        "parent": "isolates/4095163606998683-981"
      },
      "isolates/4095163606998683-981": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-980"
      },
      "isolates/4095163606998683-980": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-979"
      },
      "isolates/4095163606998683-979": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-978"
      },
      "isolates/4095163606998683-978": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-977"
      },
      "isolates/4095163606998683-977": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-976"
      },
      "isolates/4095163606998683-976": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-975"
      },
      "isolates/4095163606998683-975": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-974"
      },
      "isolates/4095163606998683-974": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-973"
      },
      "isolates/4095163606998683-973": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-972"
      },
      "isolates/4095163606998683-972": {
        "name": "RenderTapRegionSurface.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/tap_region.dart",
        "packageUri": "package:flutter/src/widgets/tap_region.dart",
        "sourceLine": 208,
        "parent": "isolates/4095163606998683-971"
      },
      "isolates/4095163606998683-971": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-970"
      },
      "isolates/4095163606998683-970": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-969"
      },
      "isolates/4095163606998683-969": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-968"
      },
      "isolates/4095163606998683-968": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-967"
      },
      "isolates/4095163606998683-967": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-966"
      },
      "isolates/4095163606998683-966": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-965"
      },
      "isolates/4095163606998683-965": {
        "name": "RenderView.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/view.dart",
        "packageUri": "package:flutter/src/rendering/view.dart",
        "sourceLine": 236,
        "parent": "isolates/4095163606998683-964"
      },
      "isolates/4095163606998683-964": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding&ServicesBinding&PaintingBinding&SemanticsBinding&RendererBinding.hitTestInView",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/binding.dart",
        "packageUri": "package:flutter/src/rendering/binding.dart",
        "sourceLine": 613,
        "parent": "isolates/4095163606998683-778"
      },
      "isolates/4095163606998683-778": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding._handlePointerEventImmediately",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 386,
        "parent": "isolates/4095163606998683-777"
      },
      "isolates/4095163606998683-777": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding.handlePointerEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 371,
        "parent": "isolates/4095163606998683-776"
      },
      "isolates/4095163606998683-776": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding._flushPointerEventQueue",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 326,
        "parent": "isolates/4095163606998683-762"
      },
      "isolates/4095163606998683-1071": {
        "name": "RenderShiftedBox.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/shifted_box.dart",
        "packageUri": "package:flutter/src/rendering/shifted_box.dart",
        "sourceLine": 78,
        "parent": "isolates/4095163606998683-1029"
      },
      "isolates/4095163606998683-1029": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1028"
      },
      "isolates/4095163606998683-1028": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-1027"
      },
      "isolates/4095163606998683-1027": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1026"
      },
      "isolates/4095163606998683-1026": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-1025"
      },
      "isolates/4095163606998683-1025": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-1024"
      },
      "isolates/4095163606998683-1024": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1023"
      },
      "isolates/4095163606998683-1023": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1022"
      },
      "isolates/4095163606998683-1022": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1021"
      },
      "isolates/4095163606998683-1021": {
        "name": "_RenderLayoutBuilder.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/layout_builder.dart",
        "packageUri": "package:flutter/src/widgets/layout_builder.dart",
        "sourceLine": 348,
        "parent": "isolates/4095163606998683-1020"
      },
      "isolates/4095163606998683-1020": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1019"
      },
      "isolates/4095163606998683-1019": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-1018"
      },
      "isolates/4095163606998683-1018": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1017"
      },
      "isolates/4095163606998683-1017": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-1016"
      },
      "isolates/4095163606998683-1016": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-1015"
      },
      "isolates/4095163606998683-1015": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1014"
      },
      "isolates/4095163606998683-1014": {
        "name": "_RenderLayoutBuilder.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/layout_builder.dart",
        "packageUri": "package:flutter/src/widgets/layout_builder.dart",
        "sourceLine": 348,
        "parent": "isolates/4095163606998683-1013"
      },
      "isolates/4095163606998683-1013": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1012"
      },
      "isolates/4095163606998683-1012": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1011"
      },
      "isolates/4095163606998683-1011": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1010"
      },
      "isolates/4095163606998683-1010": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1009"
      },
      "isolates/4095163606998683-1009": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1008"
      },
      "isolates/4095163606998683-1008": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1007"
      },
      "isolates/4095163606998683-1007": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1006"
      },
      "isolates/4095163606998683-1006": {
        "name": "RenderIgnorePointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3602,
        "parent": "isolates/4095163606998683-1005"
      },
      "isolates/4095163606998683-1005": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1004"
      },
      "isolates/4095163606998683-1004": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1003"
      },
      "isolates/4095163606998683-1003": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1002"
      },
      "isolates/4095163606998683-1002": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1001"
      },
      "isolates/4095163606998683-1001": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1000"
      },
      "isolates/4095163606998683-1000": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-999"
      },
      "isolates/4095163606998683-999": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-998"
      },
      "isolates/4095163606998683-998": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-997"
      },
      "isolates/4095163606998683-997": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-996"
      },
      "isolates/4095163606998683-996": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-995"
      },
      "isolates/4095163606998683-995": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-994"
      },
      "isolates/4095163606998683-994": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-993"
      },
      "isolates/4095163606998683-993": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-992"
      },
      "isolates/4095163606998683-992": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-991"
      },
      "isolates/4095163606998683-991": {
        "name": "RenderOffstage.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3732,
        "parent": "isolates/4095163606998683-990"
      },
      "isolates/4095163606998683-990": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-989"
      },
      "isolates/4095163606998683-989": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-988"
      },
      "isolates/4095163606998683-988": {
        "name": "childHitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 928,
        "parent": "isolates/4095163606998683-987"
      },
      "isolates/4095163606998683-987": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-986"
      },
      "isolates/4095163606998683-1070": {
        "name": "SliverGeometry.visible",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 780,
        "parent": "isolates/4095163606998683-1069"
      },
      "isolates/4095163606998683-1069": {
        "name": "RenderViewportBase.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/viewport.dart",
        "packageUri": "package:flutter/src/rendering/viewport.dart",
        "sourceLine": 787,
        "parent": "isolates/4095163606998683-1068"
      },
      "isolates/4095163606998683-1068": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1067"
      },
      "isolates/4095163606998683-1067": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1066"
      },
      "isolates/4095163606998683-1066": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1065"
      },
      "isolates/4095163606998683-1065": {
        "name": "RenderIgnorePointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3602,
        "parent": "isolates/4095163606998683-1064"
      },
      "isolates/4095163606998683-1064": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1063"
      },
      "isolates/4095163606998683-1063": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1062"
      },
      "isolates/4095163606998683-1062": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1061"
      },
      "isolates/4095163606998683-1061": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1060"
      },
      "isolates/4095163606998683-1060": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1059"
      },
      "isolates/4095163606998683-1059": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1058"
      },
      "isolates/4095163606998683-1058": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1057"
      },
      "isolates/4095163606998683-1057": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1056"
      },
      "isolates/4095163606998683-1056": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1055"
      },
      "isolates/4095163606998683-1055": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1054"
      },
      "isolates/4095163606998683-1054": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1053"
      },
      "isolates/4095163606998683-1053": {
        "name": "RenderTransform.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2521,
        "parent": "isolates/4095163606998683-1052"
      },
      "isolates/4095163606998683-1052": {
        "name": "BoxHitTestResult.addWithRawTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 833,
        "parent": "isolates/4095163606998683-1051"
      },
      "isolates/4095163606998683-1051": {
        "name": "BoxHitTestResult.addWithPaintTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 761,
        "parent": "isolates/4095163606998683-1050"
      },
      "isolates/4095163606998683-1050": {
        "name": "RenderTransform.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2515,
        "parent": "isolates/4095163606998683-1049"
      },
      "isolates/4095163606998683-1049": {
        "name": "RenderTransform.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2506,
        "parent": "isolates/4095163606998683-1048"
      },
      "isolates/4095163606998683-1048": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1047"
      },
      "isolates/4095163606998683-1047": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1046"
      },
      "isolates/4095163606998683-1046": {
        "name": "RenderClipRect.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1521,
        "parent": "isolates/4095163606998683-1045"
      },
      "isolates/4095163606998683-1045": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-1044"
      },
      "isolates/4095163606998683-1044": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1043"
      },
      "isolates/4095163606998683-1043": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-1042"
      },
      "isolates/4095163606998683-1042": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-1041"
      },
      "isolates/4095163606998683-1041": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1040"
      },
      "isolates/4095163606998683-1040": {
        "name":
            "_RenderCustomMultiChildLayoutBox&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-1039"
      },
      "isolates/4095163606998683-1039": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1038"
      },
      "isolates/4095163606998683-1038": {
        "name":
            "_RenderCustomMultiChildLayoutBox&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-1037"
      },
      "isolates/4095163606998683-1037": {
        "name": "RenderCustomMultiChildLayoutBox.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/custom_layout.dart",
        "packageUri": "package:flutter/src/rendering/custom_layout.dart",
        "sourceLine": 412,
        "parent": "isolates/4095163606998683-1036"
      },
      "isolates/4095163606998683-1036": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1035"
      },
      "isolates/4095163606998683-1035": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1034"
      },
      "isolates/4095163606998683-1034": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1033"
      },
      "isolates/4095163606998683-1033": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1032"
      },
      "isolates/4095163606998683-1032": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1031"
      },
      "isolates/4095163606998683-1031": {
        "name": "RenderPhysicalModel.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1981,
        "parent": "isolates/4095163606998683-1030"
      },
      "isolates/4095163606998683-1030": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1029"
      },
      "isolates/4095163606998683-1200": {
        "name": "_Float64List.[]",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/typed_data_patch.dart",
        "packageUri": "dart:typed_data-patch/typed_data_patch.dart",
        "sourceLine": 2845,
        "parent": "isolates/4095163606998683-1199"
      },
      "isolates/4095163606998683-1199": {
        "name": "Matrix4.setFrom",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/.pub-cache/hosted/pub.dev/vector_math-2.1.4/lib/src/vector_math_64/matrix4.dart",
        "packageUri": "package:vector_math/src/vector_math_64/matrix4.dart",
        "sourceLine": 401,
        "parent": "isolates/4095163606998683-1198"
      },
      "isolates/4095163606998683-1198": {
        "name": "Matrix4.Matrix4.copy",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/.pub-cache/hosted/pub.dev/vector_math-2.1.4/lib/src/vector_math_64/matrix4.dart",
        "packageUri": "package:vector_math/src/vector_math_64/matrix4.dart",
        "sourceLine": 230,
        "parent": "isolates/4095163606998683-1197"
      },
      "isolates/4095163606998683-1197": {
        "name": "Matrix4.clone",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/.pub-cache/hosted/pub.dev/vector_math-2.1.4/lib/src/vector_math_64/matrix4.dart",
        "packageUri": "package:vector_math/src/vector_math_64/matrix4.dart",
        "sourceLine": 613,
        "parent": "isolates/4095163606998683-1196"
      },
      "isolates/4095163606998683-1196": {
        "name": "_OffsetTransformPart.multiply",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/hit_test.dart",
        "packageUri": "package:flutter/src/gestures/hit_test.dart",
        "sourceLine": 102,
        "parent": "isolates/4095163606998683-1195"
      },
      "isolates/4095163606998683-1195": {
        "name": "HitTestResult._globalizeTransforms",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/hit_test.dart",
        "packageUri": "package:flutter/src/gestures/hit_test.dart",
        "sourceLine": 152,
        "parent": "isolates/4095163606998683-1194"
      },
      "isolates/4095163606998683-1194": {
        "name": "HitTestResult._lastTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/hit_test.dart",
        "packageUri": "package:flutter/src/gestures/hit_test.dart",
        "sourceLine": 164,
        "parent": "isolates/4095163606998683-1193"
      },
      "isolates/4095163606998683-1193": {
        "name": "HitTestResult.add",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/hit_test.dart",
        "packageUri": "package:flutter/src/gestures/hit_test.dart",
        "sourceLine": 175,
        "parent": "isolates/4095163606998683-1192"
      },
      "isolates/4095163606998683-1192": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1191"
      },
      "isolates/4095163606998683-1191": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1190"
      },
      "isolates/4095163606998683-1190": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1189"
      },
      "isolates/4095163606998683-1189": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1188"
      },
      "isolates/4095163606998683-1188": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1187"
      },
      "isolates/4095163606998683-1187": {
        "name": "RenderMouseRegion.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3161,
        "parent": "isolates/4095163606998683-1186"
      },
      "isolates/4095163606998683-1186": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1185"
      },
      "isolates/4095163606998683-1185": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1184"
      },
      "isolates/4095163606998683-1184": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1183"
      },
      "isolates/4095163606998683-1183": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1182"
      },
      "isolates/4095163606998683-1182": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1181"
      },
      "isolates/4095163606998683-1181": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1180"
      },
      "isolates/4095163606998683-1180": {
        "name": "RenderPhysicalModel.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1981,
        "parent": "isolates/4095163606998683-1179"
      },
      "isolates/4095163606998683-1179": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-1178"
      },
      "isolates/4095163606998683-1178": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1177"
      },
      "isolates/4095163606998683-1177": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-1176"
      },
      "isolates/4095163606998683-1176": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-1175"
      },
      "isolates/4095163606998683-1175": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1174"
      },
      "isolates/4095163606998683-1174": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1173"
      },
      "isolates/4095163606998683-1173": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1172"
      },
      "isolates/4095163606998683-1172": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1171"
      },
      "isolates/4095163606998683-1171": {
        "name": "RenderCustomPaint.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/custom_paint.dart",
        "packageUri": "package:flutter/src/rendering/custom_paint.dart",
        "sourceLine": 554,
        "parent": "isolates/4095163606998683-1170"
      },
      "isolates/4095163606998683-1170": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1169"
      },
      "isolates/4095163606998683-1169": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1168"
      },
      "isolates/4095163606998683-1168": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1167"
      },
      "isolates/4095163606998683-1167": {
        "name": "RenderPhysicalShape.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2095,
        "parent": "isolates/4095163606998683-1166"
      },
      "isolates/4095163606998683-1166": {
        "name": "RenderShiftedBox.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/shifted_box.dart",
        "packageUri": "package:flutter/src/rendering/shifted_box.dart",
        "sourceLine": 86,
        "parent": "isolates/4095163606998683-1165"
      },
      "isolates/4095163606998683-1165": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1164"
      },
      "isolates/4095163606998683-1164": {
        "name": "RenderShiftedBox.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/shifted_box.dart",
        "packageUri": "package:flutter/src/rendering/shifted_box.dart",
        "sourceLine": 78,
        "parent": "isolates/4095163606998683-1163"
      },
      "isolates/4095163606998683-1163": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1162"
      },
      "isolates/4095163606998683-1162": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1161"
      },
      "isolates/4095163606998683-1161": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1160"
      },
      "isolates/4095163606998683-1160": {
        "name": "RenderShiftedBox.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/shifted_box.dart",
        "packageUri": "package:flutter/src/rendering/shifted_box.dart",
        "sourceLine": 86,
        "parent": "isolates/4095163606998683-1159"
      },
      "isolates/4095163606998683-1159": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1158"
      },
      "isolates/4095163606998683-1158": {
        "name": "RenderShiftedBox.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/shifted_box.dart",
        "packageUri": "package:flutter/src/rendering/shifted_box.dart",
        "sourceLine": 78,
        "parent": "isolates/4095163606998683-1157"
      },
      "isolates/4095163606998683-1157": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1156"
      },
      "isolates/4095163606998683-1156": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1155"
      },
      "isolates/4095163606998683-1155": {
        "name": "RenderTransform.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2521,
        "parent": "isolates/4095163606998683-1154"
      },
      "isolates/4095163606998683-1154": {
        "name": "BoxHitTestResult.addWithRawTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 833,
        "parent": "isolates/4095163606998683-1153"
      },
      "isolates/4095163606998683-1153": {
        "name": "BoxHitTestResult.addWithPaintTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 761,
        "parent": "isolates/4095163606998683-1152"
      },
      "isolates/4095163606998683-1152": {
        "name": "RenderTransform.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2515,
        "parent": "isolates/4095163606998683-1151"
      },
      "isolates/4095163606998683-1151": {
        "name": "RenderTransform.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2506,
        "parent": "isolates/4095163606998683-1150"
      },
      "isolates/4095163606998683-1150": {
        "name": "RenderShiftedBox.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/shifted_box.dart",
        "packageUri": "package:flutter/src/rendering/shifted_box.dart",
        "sourceLine": 86,
        "parent": "isolates/4095163606998683-1149"
      },
      "isolates/4095163606998683-1149": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1148"
      },
      "isolates/4095163606998683-1148": {
        "name": "RenderShiftedBox.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/shifted_box.dart",
        "packageUri": "package:flutter/src/rendering/shifted_box.dart",
        "sourceLine": 78,
        "parent": "isolates/4095163606998683-1147"
      },
      "isolates/4095163606998683-1147": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1146"
      },
      "isolates/4095163606998683-1146": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1145"
      },
      "isolates/4095163606998683-1145": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1144"
      },
      "isolates/4095163606998683-1144": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1143"
      },
      "isolates/4095163606998683-1143": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1142"
      },
      "isolates/4095163606998683-1142": {
        "name":
            "_RenderSliverMultiBoxAdaptor&RenderSliver&ContainerRenderObjectMixin&RenderSliverHelpers.hitTestBoxChild.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1786,
        "parent": "isolates/4095163606998683-1141"
      },
      "isolates/4095163606998683-1141": {
        "name": "BoxHitTestResult.addWithOutOfBandPosition",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 878,
        "parent": "isolates/4095163606998683-1140"
      },
      "isolates/4095163606998683-1140": {
        "name":
            "_RenderSliverMultiBoxAdaptor&RenderSliver&ContainerRenderObjectMixin&RenderSliverHelpers.hitTestBoxChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1760,
        "parent": "isolates/4095163606998683-1139"
      },
      "isolates/4095163606998683-1139": {
        "name": "RenderSliverMultiBoxAdaptor.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_multi_box_adaptor.dart",
        "packageUri":
            "package:flutter/src/rendering/sliver_multi_box_adaptor.dart",
        "sourceLine": 553,
        "parent": "isolates/4095163606998683-1138"
      },
      "isolates/4095163606998683-1138": {
        "name": "RenderSliver.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1418,
        "parent": "isolates/4095163606998683-1137"
      },
      "isolates/4095163606998683-1137": {
        "name": "SliverHitTestResult.addWithAxisOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 967,
        "parent": "isolates/4095163606998683-1136"
      },
      "isolates/4095163606998683-1136": {
        "name": "RenderSliverEdgeInsetsPadding.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_padding.dart",
        "packageUri": "package:flutter/src/rendering/sliver_padding.dart",
        "sourceLine": 210,
        "parent": "isolates/4095163606998683-1135"
      },
      "isolates/4095163606998683-1135": {
        "name": "RenderSliver.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1418,
        "parent": "isolates/4095163606998683-1134"
      },
      "isolates/4095163606998683-1134": {
        "name": "RenderViewportBase.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/viewport.dart",
        "packageUri": "package:flutter/src/rendering/viewport.dart",
        "sourceLine": 807,
        "parent": "isolates/4095163606998683-1133"
      },
      "isolates/4095163606998683-1133": {
        "name": "BoxHitTestResult.addWithOutOfBandPosition",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 878,
        "parent": "isolates/4095163606998683-1132"
      },
      "isolates/4095163606998683-1132": {
        "name": "RenderViewportBase.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/viewport.dart",
        "packageUri": "package:flutter/src/rendering/viewport.dart",
        "sourceLine": 787,
        "parent": "isolates/4095163606998683-1131"
      },
      "isolates/4095163606998683-1131": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1130"
      },
      "isolates/4095163606998683-1130": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1129"
      },
      "isolates/4095163606998683-1129": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1128"
      },
      "isolates/4095163606998683-1128": {
        "name": "RenderIgnorePointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3602,
        "parent": "isolates/4095163606998683-1127"
      },
      "isolates/4095163606998683-1127": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1126"
      },
      "isolates/4095163606998683-1126": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1125"
      },
      "isolates/4095163606998683-1125": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1124"
      },
      "isolates/4095163606998683-1124": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1123"
      },
      "isolates/4095163606998683-1123": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1122"
      },
      "isolates/4095163606998683-1122": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1121"
      },
      "isolates/4095163606998683-1121": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1120"
      },
      "isolates/4095163606998683-1120": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1119"
      },
      "isolates/4095163606998683-1119": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1118"
      },
      "isolates/4095163606998683-1118": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1117"
      },
      "isolates/4095163606998683-1117": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1116"
      },
      "isolates/4095163606998683-1116": {
        "name": "RenderTransform.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2521,
        "parent": "isolates/4095163606998683-1115"
      },
      "isolates/4095163606998683-1115": {
        "name": "BoxHitTestResult.addWithRawTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 833,
        "parent": "isolates/4095163606998683-1114"
      },
      "isolates/4095163606998683-1114": {
        "name": "BoxHitTestResult.addWithPaintTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 761,
        "parent": "isolates/4095163606998683-1113"
      },
      "isolates/4095163606998683-1113": {
        "name": "RenderTransform.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2515,
        "parent": "isolates/4095163606998683-1112"
      },
      "isolates/4095163606998683-1112": {
        "name": "RenderTransform.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2506,
        "parent": "isolates/4095163606998683-1111"
      },
      "isolates/4095163606998683-1111": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1110"
      },
      "isolates/4095163606998683-1110": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1109"
      },
      "isolates/4095163606998683-1109": {
        "name": "RenderClipRect.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1521,
        "parent": "isolates/4095163606998683-1108"
      },
      "isolates/4095163606998683-1108": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1107"
      },
      "isolates/4095163606998683-1107": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1106"
      },
      "isolates/4095163606998683-1106": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-1105"
      },
      "isolates/4095163606998683-1105": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-1104"
      },
      "isolates/4095163606998683-1104": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-1103"
      },
      "isolates/4095163606998683-1103": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-1102"
      },
      "isolates/4095163606998683-1102": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1101"
      },
      "isolates/4095163606998683-1101": {
        "name": "_RenderLayoutBuilder.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/layout_builder.dart",
        "packageUri": "package:flutter/src/widgets/layout_builder.dart",
        "sourceLine": 348,
        "parent": "isolates/4095163606998683-1100"
      },
      "isolates/4095163606998683-1100": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1099"
      },
      "isolates/4095163606998683-1099": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1098"
      },
      "isolates/4095163606998683-1098": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1097"
      },
      "isolates/4095163606998683-1097": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1096"
      },
      "isolates/4095163606998683-1096": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1095"
      },
      "isolates/4095163606998683-1095": {
        "name":
            "_RenderSliverMultiBoxAdaptor&RenderSliver&ContainerRenderObjectMixin&RenderSliverHelpers.hitTestBoxChild.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1786,
        "parent": "isolates/4095163606998683-1094"
      },
      "isolates/4095163606998683-1094": {
        "name": "BoxHitTestResult.addWithOutOfBandPosition",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 878,
        "parent": "isolates/4095163606998683-1093"
      },
      "isolates/4095163606998683-1093": {
        "name":
            "_RenderSliverMultiBoxAdaptor&RenderSliver&ContainerRenderObjectMixin&RenderSliverHelpers.hitTestBoxChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1760,
        "parent": "isolates/4095163606998683-1092"
      },
      "isolates/4095163606998683-1092": {
        "name": "RenderSliverMultiBoxAdaptor.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_multi_box_adaptor.dart",
        "packageUri":
            "package:flutter/src/rendering/sliver_multi_box_adaptor.dart",
        "sourceLine": 553,
        "parent": "isolates/4095163606998683-1091"
      },
      "isolates/4095163606998683-1091": {
        "name": "RenderSliver.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1418,
        "parent": "isolates/4095163606998683-1090"
      },
      "isolates/4095163606998683-1090": {
        "name": "SliverHitTestResult.addWithAxisOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 967,
        "parent": "isolates/4095163606998683-1089"
      },
      "isolates/4095163606998683-1089": {
        "name": "RenderSliverEdgeInsetsPadding.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_padding.dart",
        "packageUri": "package:flutter/src/rendering/sliver_padding.dart",
        "sourceLine": 210,
        "parent": "isolates/4095163606998683-1088"
      },
      "isolates/4095163606998683-1088": {
        "name": "RenderSliver.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1418,
        "parent": "isolates/4095163606998683-1087"
      },
      "isolates/4095163606998683-1087": {
        "name": "RenderViewportBase.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/viewport.dart",
        "packageUri": "package:flutter/src/rendering/viewport.dart",
        "sourceLine": 807,
        "parent": "isolates/4095163606998683-1086"
      },
      "isolates/4095163606998683-1086": {
        "name": "BoxHitTestResult.addWithOutOfBandPosition",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 878,
        "parent": "isolates/4095163606998683-1085"
      },
      "isolates/4095163606998683-1085": {
        "name": "RenderViewportBase.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/viewport.dart",
        "packageUri": "package:flutter/src/rendering/viewport.dart",
        "sourceLine": 787,
        "parent": "isolates/4095163606998683-1084"
      },
      "isolates/4095163606998683-1084": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1083"
      },
      "isolates/4095163606998683-1083": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1082"
      },
      "isolates/4095163606998683-1082": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1081"
      },
      "isolates/4095163606998683-1081": {
        "name": "RenderIgnorePointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3602,
        "parent": "isolates/4095163606998683-1080"
      },
      "isolates/4095163606998683-1080": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1079"
      },
      "isolates/4095163606998683-1079": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-1078"
      },
      "isolates/4095163606998683-1078": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1077"
      },
      "isolates/4095163606998683-1077": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1076"
      },
      "isolates/4095163606998683-1076": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-1075"
      },
      "isolates/4095163606998683-1075": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-1074"
      },
      "isolates/4095163606998683-1074": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-876": {
        "name": "_Closure._hash",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/function.dart",
        "packageUri": "dart:core-patch/function.dart",
        "sourceLine": 54,
        "parent": "isolates/4095163606998683-875"
      },
      "isolates/4095163606998683-875": {
        "name": "_Closure.hashCode",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/function.dart",
        "packageUri": "dart:core-patch/function.dart",
        "sourceLine": 16,
        "parent": "isolates/4095163606998683-874"
      },
      "isolates/4095163606998683-874": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode._hashCode",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 254,
        "parent": "isolates/4095163606998683-873"
      },
      "isolates/4095163606998683-873": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode&_LinkedHashMapMixin.[]=",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 513,
        "parent": "isolates/4095163606998683-872"
      },
      "isolates/4095163606998683-872": {
        "name": "__Map&_HashVMBase&MapMixin.addAll.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/collection/maps.dart",
        "packageUri": "dart:collection/maps.dart",
        "sourceLine": 40,
        "parent": "isolates/4095163606998683-871"
      },
      "isolates/4095163606998683-871": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode&_LinkedHashMapMixin.forEach",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 624,
        "parent": "isolates/4095163606998683-870"
      },
      "isolates/4095163606998683-870": {
        "name": "__Map&_HashVMBase&MapMixin.addAll",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/collection/maps.dart",
        "packageUri": "dart:collection/maps.dart",
        "sourceLine": 39,
        "parent": "isolates/4095163606998683-869"
      },
      "isolates/4095163606998683-869": {
        "name": "_Map.addAll",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 311,
        "parent": "isolates/4095163606998683-868"
      },
      "isolates/4095163606998683-868": {
        "name": "LinkedHashMap.LinkedHashMap.of",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/collection/linked_hash_map.dart",
        "packageUri": "dart:collection/linked_hash_map.dart",
        "sourceLine": 199,
        "parent": "isolates/4095163606998683-806"
      },
      "isolates/4095163606998683-806": {
        "name": "PointerRouter.route",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/pointer_router.dart",
        "packageUri": "package:flutter/src/gestures/pointer_router.dart",
        "sourceLine": 123,
        "parent": "isolates/4095163606998683-805"
      },
      "isolates/4095163606998683-805": {
        "name": "_WidgetsFlutterBinding&BindingBase&GestureBinding.handleEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 493,
        "parent": "isolates/4095163606998683-780"
      },
      "isolates/4095163606998683-780": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding.dispatchEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 448,
        "parent": "isolates/4095163606998683-779"
      },
      "isolates/4095163606998683-779": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding&ServicesBinding&PaintingBinding&SemanticsBinding&RendererBinding.dispatchEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/binding.dart",
        "packageUri": "package:flutter/src/rendering/binding.dart",
        "sourceLine": 421,
        "parent": "isolates/4095163606998683-778"
      },
      "isolates/4095163606998683-9292": {
        "name": "Size.width",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/geometry.dart",
        "packageUri": "dart:ui/geometry.dart",
        "sourceLine": 381,
        "parent": "isolates/4095163606998683-9291"
      },
      "isolates/4095163606998683-9291": {
        "name": "Size.contains",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/geometry.dart",
        "packageUri": "dart:ui/geometry.dart",
        "sourceLine": 567,
        "parent": "isolates/4095163606998683-9290"
      },
      "isolates/4095163606998683-9290": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9289"
      },
      "isolates/4095163606998683-9289": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9288"
      },
      "isolates/4095163606998683-9288": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9287"
      },
      "isolates/4095163606998683-9287": {
        "name":
            "_RenderSliverMultiBoxAdaptor&RenderSliver&ContainerRenderObjectMixin&RenderSliverHelpers.hitTestBoxChild.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1786,
        "parent": "isolates/4095163606998683-9286"
      },
      "isolates/4095163606998683-9286": {
        "name": "BoxHitTestResult.addWithOutOfBandPosition",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 878,
        "parent": "isolates/4095163606998683-9285"
      },
      "isolates/4095163606998683-9285": {
        "name":
            "_RenderSliverMultiBoxAdaptor&RenderSliver&ContainerRenderObjectMixin&RenderSliverHelpers.hitTestBoxChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1760,
        "parent": "isolates/4095163606998683-9284"
      },
      "isolates/4095163606998683-9284": {
        "name": "RenderSliverMultiBoxAdaptor.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_multi_box_adaptor.dart",
        "packageUri":
            "package:flutter/src/rendering/sliver_multi_box_adaptor.dart",
        "sourceLine": 553,
        "parent": "isolates/4095163606998683-9283"
      },
      "isolates/4095163606998683-9283": {
        "name": "RenderSliver.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1418,
        "parent": "isolates/4095163606998683-9282"
      },
      "isolates/4095163606998683-9282": {
        "name": "SliverHitTestResult.addWithAxisOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 967,
        "parent": "isolates/4095163606998683-9281"
      },
      "isolates/4095163606998683-9281": {
        "name": "RenderSliverEdgeInsetsPadding.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_padding.dart",
        "packageUri": "package:flutter/src/rendering/sliver_padding.dart",
        "sourceLine": 210,
        "parent": "isolates/4095163606998683-9280"
      },
      "isolates/4095163606998683-9280": {
        "name": "RenderSliver.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver.dart",
        "packageUri": "package:flutter/src/rendering/sliver.dart",
        "sourceLine": 1418,
        "parent": "isolates/4095163606998683-9279"
      },
      "isolates/4095163606998683-9279": {
        "name": "RenderViewportBase.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/viewport.dart",
        "packageUri": "package:flutter/src/rendering/viewport.dart",
        "sourceLine": 807,
        "parent": "isolates/4095163606998683-9278"
      },
      "isolates/4095163606998683-9278": {
        "name": "BoxHitTestResult.addWithOutOfBandPosition",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 878,
        "parent": "isolates/4095163606998683-9277"
      },
      "isolates/4095163606998683-9277": {
        "name": "RenderViewportBase.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/viewport.dart",
        "packageUri": "package:flutter/src/rendering/viewport.dart",
        "sourceLine": 787,
        "parent": "isolates/4095163606998683-9276"
      },
      "isolates/4095163606998683-9276": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9275"
      },
      "isolates/4095163606998683-9275": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9274"
      },
      "isolates/4095163606998683-9274": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9273"
      },
      "isolates/4095163606998683-9273": {
        "name": "RenderIgnorePointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3602,
        "parent": "isolates/4095163606998683-9272"
      },
      "isolates/4095163606998683-9272": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9271"
      },
      "isolates/4095163606998683-9271": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9270"
      },
      "isolates/4095163606998683-9270": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9269"
      },
      "isolates/4095163606998683-9269": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-9268"
      },
      "isolates/4095163606998683-9268": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9267"
      },
      "isolates/4095163606998683-9267": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-9266"
      },
      "isolates/4095163606998683-9266": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9265"
      },
      "isolates/4095163606998683-9265": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-9264"
      },
      "isolates/4095163606998683-9264": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9263"
      },
      "isolates/4095163606998683-9263": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9262"
      },
      "isolates/4095163606998683-9262": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9261"
      },
      "isolates/4095163606998683-9261": {
        "name": "RenderTransform.hitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2521,
        "parent": "isolates/4095163606998683-9260"
      },
      "isolates/4095163606998683-9260": {
        "name": "BoxHitTestResult.addWithRawTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 833,
        "parent": "isolates/4095163606998683-9259"
      },
      "isolates/4095163606998683-9259": {
        "name": "BoxHitTestResult.addWithPaintTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 761,
        "parent": "isolates/4095163606998683-9258"
      },
      "isolates/4095163606998683-9258": {
        "name": "RenderTransform.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2515,
        "parent": "isolates/4095163606998683-9257"
      },
      "isolates/4095163606998683-9257": {
        "name": "RenderTransform.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2506,
        "parent": "isolates/4095163606998683-9256"
      },
      "isolates/4095163606998683-9256": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9255"
      },
      "isolates/4095163606998683-9255": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9254"
      },
      "isolates/4095163606998683-9254": {
        "name": "RenderClipRect.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1521,
        "parent": "isolates/4095163606998683-9253"
      },
      "isolates/4095163606998683-9253": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-9252"
      },
      "isolates/4095163606998683-9252": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-9251"
      },
      "isolates/4095163606998683-9251": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-9250"
      },
      "isolates/4095163606998683-9250": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-9249"
      },
      "isolates/4095163606998683-9249": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9248"
      },
      "isolates/4095163606998683-9248": {
        "name":
            "_RenderCustomMultiChildLayoutBox&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-9247"
      },
      "isolates/4095163606998683-9247": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-9246"
      },
      "isolates/4095163606998683-9246": {
        "name":
            "_RenderCustomMultiChildLayoutBox&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-9245"
      },
      "isolates/4095163606998683-9245": {
        "name": "RenderCustomMultiChildLayoutBox.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/custom_layout.dart",
        "packageUri": "package:flutter/src/rendering/custom_layout.dart",
        "sourceLine": 412,
        "parent": "isolates/4095163606998683-9244"
      },
      "isolates/4095163606998683-9244": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9243"
      },
      "isolates/4095163606998683-9243": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9242"
      },
      "isolates/4095163606998683-9242": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9241"
      },
      "isolates/4095163606998683-9241": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9240"
      },
      "isolates/4095163606998683-9240": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9239"
      },
      "isolates/4095163606998683-9239": {
        "name": "RenderPhysicalModel.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1981,
        "parent": "isolates/4095163606998683-9238"
      },
      "isolates/4095163606998683-9238": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9237"
      },
      "isolates/4095163606998683-9237": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9236"
      },
      "isolates/4095163606998683-9236": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-9235"
      },
      "isolates/4095163606998683-9235": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-9234"
      },
      "isolates/4095163606998683-9234": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-9233"
      },
      "isolates/4095163606998683-9233": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-9232"
      },
      "isolates/4095163606998683-9232": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9231"
      },
      "isolates/4095163606998683-9231": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9230"
      },
      "isolates/4095163606998683-9230": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9229"
      },
      "isolates/4095163606998683-9229": {
        "name": "_RenderLayoutBuilder.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/layout_builder.dart",
        "packageUri": "package:flutter/src/widgets/layout_builder.dart",
        "sourceLine": 348,
        "parent": "isolates/4095163606998683-9228"
      },
      "isolates/4095163606998683-9228": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9227"
      },
      "isolates/4095163606998683-9227": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2866,
        "parent": "isolates/4095163606998683-9226"
      },
      "isolates/4095163606998683-9226": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-9225"
      },
      "isolates/4095163606998683-9225": {
        "name":
            "_RenderStack&RenderBox&ContainerRenderObjectMixin&RenderBoxContainerDefaultsMixin.defaultHitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2858,
        "parent": "isolates/4095163606998683-9224"
      },
      "isolates/4095163606998683-9224": {
        "name": "RenderStack.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/stack.dart",
        "packageUri": "package:flutter/src/rendering/stack.dart",
        "sourceLine": 630,
        "parent": "isolates/4095163606998683-9223"
      },
      "isolates/4095163606998683-9223": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9222"
      },
      "isolates/4095163606998683-9222": {
        "name": "_RenderLayoutBuilder.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/layout_builder.dart",
        "packageUri": "package:flutter/src/widgets/layout_builder.dart",
        "sourceLine": 348,
        "parent": "isolates/4095163606998683-9221"
      },
      "isolates/4095163606998683-9221": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9220"
      },
      "isolates/4095163606998683-9220": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9219"
      },
      "isolates/4095163606998683-9219": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9218"
      },
      "isolates/4095163606998683-9218": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9217"
      },
      "isolates/4095163606998683-9217": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9216"
      },
      "isolates/4095163606998683-9216": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9215"
      },
      "isolates/4095163606998683-9215": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9214"
      },
      "isolates/4095163606998683-9214": {
        "name": "RenderIgnorePointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3602,
        "parent": "isolates/4095163606998683-9213"
      },
      "isolates/4095163606998683-9213": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9212"
      },
      "isolates/4095163606998683-9212": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9211"
      },
      "isolates/4095163606998683-9211": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9210"
      },
      "isolates/4095163606998683-9210": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9209"
      },
      "isolates/4095163606998683-9209": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9208"
      },
      "isolates/4095163606998683-9208": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9207"
      },
      "isolates/4095163606998683-9207": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9206"
      },
      "isolates/4095163606998683-9206": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9205"
      },
      "isolates/4095163606998683-9205": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9204"
      },
      "isolates/4095163606998683-9204": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9203"
      },
      "isolates/4095163606998683-9203": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9202"
      },
      "isolates/4095163606998683-9202": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9201"
      },
      "isolates/4095163606998683-9201": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9200"
      },
      "isolates/4095163606998683-9200": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9199"
      },
      "isolates/4095163606998683-9199": {
        "name": "RenderOffstage.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3732,
        "parent": "isolates/4095163606998683-9198"
      },
      "isolates/4095163606998683-9198": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9197"
      },
      "isolates/4095163606998683-9197": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9196"
      },
      "isolates/4095163606998683-9196": {
        "name": "childHitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 928,
        "parent": "isolates/4095163606998683-9195"
      },
      "isolates/4095163606998683-9195": {
        "name": "BoxHitTestResult.addWithPaintOffset",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 798,
        "parent": "isolates/4095163606998683-9194"
      },
      "isolates/4095163606998683-9194": {
        "name":
            "__RenderTheater&RenderBox&ContainerRenderObjectMixin&_RenderTheaterMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 920,
        "parent": "isolates/4095163606998683-9193"
      },
      "isolates/4095163606998683-9193": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9192"
      },
      "isolates/4095163606998683-9192": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9191"
      },
      "isolates/4095163606998683-9191": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9190"
      },
      "isolates/4095163606998683-9190": {
        "name": "RenderAbsorbPointer.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3853,
        "parent": "isolates/4095163606998683-9189"
      },
      "isolates/4095163606998683-9189": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9188"
      },
      "isolates/4095163606998683-9188": {
        "name": "RenderProxyBoxWithHitTestBehavior.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 169,
        "parent": "isolates/4095163606998683-9187"
      },
      "isolates/4095163606998683-9187": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9186"
      },
      "isolates/4095163606998683-9186": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9185"
      },
      "isolates/4095163606998683-9185": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9184"
      },
      "isolates/4095163606998683-9184": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9183"
      },
      "isolates/4095163606998683-9183": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9182"
      },
      "isolates/4095163606998683-9182": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9181"
      },
      "isolates/4095163606998683-9181": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9180"
      },
      "isolates/4095163606998683-9180": {
        "name": "RenderTapRegionSurface.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/tap_region.dart",
        "packageUri": "package:flutter/src/widgets/tap_region.dart",
        "sourceLine": 208,
        "parent": "isolates/4095163606998683-9179"
      },
      "isolates/4095163606998683-9179": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9178"
      },
      "isolates/4095163606998683-9178": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9177"
      },
      "isolates/4095163606998683-9177": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9176"
      },
      "isolates/4095163606998683-9176": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9175"
      },
      "isolates/4095163606998683-9175": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin.hitTestChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 116,
        "parent": "isolates/4095163606998683-9174"
      },
      "isolates/4095163606998683-9174": {
        "name": "RenderBox.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2452,
        "parent": "isolates/4095163606998683-9173"
      },
      "isolates/4095163606998683-9173": {
        "name": "RenderView.hitTest",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/view.dart",
        "packageUri": "package:flutter/src/rendering/view.dart",
        "sourceLine": 236,
        "parent": "isolates/4095163606998683-9172"
      },
      "isolates/4095163606998683-9172": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding&ServicesBinding&PaintingBinding&SemanticsBinding&RendererBinding.hitTestInView",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/binding.dart",
        "packageUri": "package:flutter/src/rendering/binding.dart",
        "sourceLine": 613,
        "parent": "isolates/4095163606998683-9171"
      },
      "isolates/4095163606998683-9171": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding._handlePointerEventImmediately",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 386,
        "parent": "isolates/4095163606998683-9170"
      },
      "isolates/4095163606998683-9170": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding.handlePointerEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 371,
        "parent": "isolates/4095163606998683-9169"
      },
      "isolates/4095163606998683-9169": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding._flushPointerEventQueue",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 326,
        "parent": "isolates/4095163606998683-9168"
      },
      "isolates/4095163606998683-9168": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding._handlePointerDataPacket",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/binding.dart",
        "packageUri": "package:flutter/src/gestures/binding.dart",
        "sourceLine": 293,
        "parent": "isolates/4095163606998683-9167"
      },
      "isolates/4095163606998683-9167": {
        "name": "_invoke1",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/hooks.dart",
        "packageUri": "dart:ui/hooks.dart",
        "sourceLine": 323,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-796": {
        "name": "DiagnosticsNode.toStringDeep.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1778,
        "parent": "isolates/4095163606998683-795"
      },
      "isolates/4095163606998683-795": {
        "name": "DiagnosticsNode.toStringDeep",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1771,
        "parent": "isolates/4095163606998683-794"
      },
      "isolates/4095163606998683-794": {
        "name": "DiagnosticsNode.toString.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1698,
        "parent": "isolates/4095163606998683-793"
      },
      "isolates/4095163606998683-793": {
        "name": "DiagnosticsNode.toString",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1691,
        "parent": "isolates/4095163606998683-792"
      },
      "isolates/4095163606998683-792": {
        "name":
            "_GestureRecognizer&GestureArenaMember&DiagnosticableTreeMixin.toString",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 3391,
        "parent": "isolates/4095163606998683-791"
      },
      "isolates/4095163606998683-791": {
        "name": "_StringBase._interpolate",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/string_patch.dart",
        "packageUri": "dart:core-patch/string_patch.dart",
        "sourceLine": 857,
        "parent": "isolates/4095163606998683-790"
      },
      "isolates/4095163606998683-790": {
        "name": "GestureArenaManager.add",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/arena.dart",
        "packageUri": "package:flutter/src/gestures/arena.dart",
        "sourceLine": 115,
        "parent": "isolates/4095163606998683-789"
      },
      "isolates/4095163606998683-789": {
        "name": "OneSequenceGestureRecognizer._addPointerToArena",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 463,
        "parent": "isolates/4095163606998683-788"
      },
      "isolates/4095163606998683-788": {
        "name": "OneSequenceGestureRecognizer.startTrackingPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 484,
        "parent": "isolates/4095163606998683-787"
      },
      "isolates/4095163606998683-787": {
        "name": "BaseTapGestureRecognizer.startTrackingPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 229,
        "parent": "isolates/4095163606998683-786"
      },
      "isolates/4095163606998683-786": {
        "name": "OneSequenceGestureRecognizer.addAllowedPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 364,
        "parent": "isolates/4095163606998683-785"
      },
      "isolates/4095163606998683-785": {
        "name": "PrimaryPointerGestureRecognizer.addAllowedPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 633,
        "parent": "isolates/4095163606998683-784"
      },
      "isolates/4095163606998683-784": {
        "name": "BaseTapGestureRecognizer.addAllowedPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 203,
        "parent": "isolates/4095163606998683-783"
      },
      "isolates/4095163606998683-783": {
        "name": "GestureRecognizer.addPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 214,
        "parent": "isolates/4095163606998683-782"
      },
      "isolates/4095163606998683-782": {
        "name": "RawGestureDetectorState._handlePointerDown",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/gesture_detector.dart",
        "packageUri": "package:flutter/src/widgets/gesture_detector.dart",
        "sourceLine": 1506,
        "parent": "isolates/4095163606998683-781"
      },
      "isolates/4095163606998683-781": {
        "name": "RenderPointerListener.handleEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 3071,
        "parent": "isolates/4095163606998683-780"
      },
      "isolates/4095163606998683-797": {
        "name": "TextTreeRenderer.render",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1116,
        "parent": "isolates/4095163606998683-796"
      },
      "isolates/4095163606998683-804": {
        "name": "_Set.toSet",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 977,
        "parent": "isolates/4095163606998683-803"
      },
      "isolates/4095163606998683-803": {
        "name": "__Set&_HashVMBase&SetMixin.difference",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/collection/set.dart",
        "packageUri": "dart:collection/set.dart",
        "sourceLine": 110,
        "parent": "isolates/4095163606998683-798"
      },
      "isolates/4095163606998683-798": {
        "name": "RenderTapRegionSurface.handleEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/tap_region.dart",
        "packageUri": "package:flutter/src/widgets/tap_region.dart",
        "sourceLine": 225,
        "parent": "isolates/4095163606998683-780"
      },
      "isolates/4095163606998683-867": {
        "name": "DiagnosticsProperty.isInteresting",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 2765,
        "parent": "isolates/4095163606998683-866"
      },
      "isolates/4095163606998683-866": {
        "name": "DiagnosticsProperty.level",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 2779,
        "parent": "isolates/4095163606998683-865"
      },
      "isolates/4095163606998683-865": {
        "name": "DiagnosticsNode.isFiltered",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1498,
        "parent": "isolates/4095163606998683-864"
      },
      "isolates/4095163606998683-864": {
        "name": "TextTreeRenderer._debugRender.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1253,
        "parent": "isolates/4095163606998683-863"
      },
      "isolates/4095163606998683-863": {
        "name": "WhereIterator.moveNext",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/internal/iterable.dart",
        "packageUri": "dart:_internal/iterable.dart",
        "sourceLine": 449,
        "parent": "isolates/4095163606998683-862"
      },
      "isolates/4095163606998683-862": {
        "name": "_GrowableList._GrowableList._ofOther",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/growable_array.dart",
        "packageUri": "dart:core-patch/growable_array.dart",
        "sourceLine": 200,
        "parent": "isolates/4095163606998683-861"
      },
      "isolates/4095163606998683-861": {
        "name": "_GrowableList._GrowableList.of",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/growable_array.dart",
        "packageUri": "dart:core-patch/growable_array.dart",
        "sourceLine": 142,
        "parent": "isolates/4095163606998683-860"
      },
      "isolates/4095163606998683-860": {
        "name": "List.List.of",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/array_patch.dart",
        "packageUri": "dart:core-patch/array_patch.dart",
        "sourceLine": 38,
        "parent": "isolates/4095163606998683-859"
      },
      "isolates/4095163606998683-859": {
        "name": "Iterable.toList",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/core/iterable.dart",
        "packageUri": "dart:core/iterable.dart",
        "sourceLine": 496,
        "parent": "isolates/4095163606998683-858"
      },
      "isolates/4095163606998683-858": {
        "name": "TextTreeRenderer._debugRender",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1134,
        "parent": "isolates/4095163606998683-857"
      },
      "isolates/4095163606998683-857": {
        "name": "TextTreeRenderer.render",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1116,
        "parent": "isolates/4095163606998683-856"
      },
      "isolates/4095163606998683-856": {
        "name": "DiagnosticsNode.toStringDeep.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1778,
        "parent": "isolates/4095163606998683-855"
      },
      "isolates/4095163606998683-855": {
        "name": "DiagnosticsNode.toStringDeep",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1771,
        "parent": "isolates/4095163606998683-854"
      },
      "isolates/4095163606998683-854": {
        "name": "DiagnosticsNode.toString.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1698,
        "parent": "isolates/4095163606998683-853"
      },
      "isolates/4095163606998683-853": {
        "name": "DiagnosticsNode.toString",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1691,
        "parent": "isolates/4095163606998683-852"
      },
      "isolates/4095163606998683-852": {
        "name":
            "_GestureRecognizer&GestureArenaMember&DiagnosticableTreeMixin.toString",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 3391,
        "parent": "isolates/4095163606998683-851"
      },
      "isolates/4095163606998683-851": {
        "name": "_StringBase._interpolate",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/string_patch.dart",
        "packageUri": "dart:core-patch/string_patch.dart",
        "sourceLine": 857,
        "parent": "isolates/4095163606998683-850"
      },
      "isolates/4095163606998683-850": {
        "name": "GestureArenaManager._resolve",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/arena.dart",
        "packageUri": "package:flutter/src/gestures/arena.dart",
        "sourceLine": 220,
        "parent": "isolates/4095163606998683-849"
      },
      "isolates/4095163606998683-849": {
        "name": "GestureArenaEntry.resolve",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/arena.dart",
        "packageUri": "package:flutter/src/gestures/arena.dart",
        "sourceLine": 52,
        "parent": "isolates/4095163606998683-848"
      },
      "isolates/4095163606998683-848": {
        "name": "OneSequenceGestureRecognizer.resolve",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 409,
        "parent": "isolates/4095163606998683-847"
      },
      "isolates/4095163606998683-847": {
        "name": "DragGestureRecognizer.didStopTrackingLastPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/monodrag.dart",
        "packageUri": "package:flutter/src/gestures/monodrag.dart",
        "sourceLine": 471,
        "parent": "isolates/4095163606998683-846"
      },
      "isolates/4095163606998683-846": {
        "name": "OneSequenceGestureRecognizer.stopTrackingPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 499,
        "parent": "isolates/4095163606998683-845"
      },
      "isolates/4095163606998683-845": {
        "name": "DragGestureRecognizer._giveUpPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/monodrag.dart",
        "packageUri": "package:flutter/src/gestures/monodrag.dart",
        "sourceLine": 491,
        "parent": "isolates/4095163606998683-844"
      },
      "isolates/4095163606998683-844": {
        "name": "DragGestureRecognizer.handleEvent",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/monodrag.dart",
        "packageUri": "package:flutter/src/gestures/monodrag.dart",
        "sourceLine": 394,
        "parent": "isolates/4095163606998683-810"
      },
      "isolates/4095163606998683-810": {
        "name": "PointerRouter._dispatch",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/pointer_router.dart",
        "packageUri": "package:flutter/src/gestures/pointer_router.dart",
        "sourceLine": 94,
        "parent": "isolates/4095163606998683-809"
      },
      "isolates/4095163606998683-809": {
        "name": "PointerRouter._dispatchEventToRoutes.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/pointer_router.dart",
        "packageUri": "package:flutter/src/gestures/pointer_router.dart",
        "sourceLine": 141,
        "parent": "isolates/4095163606998683-808"
      },
      "isolates/4095163606998683-808": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode&_LinkedHashMapMixin.forEach",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 624,
        "parent": "isolates/4095163606998683-807"
      },
      "isolates/4095163606998683-807": {
        "name": "PointerRouter._dispatchEventToRoutes",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/pointer_router.dart",
        "packageUri": "package:flutter/src/gestures/pointer_router.dart",
        "sourceLine": 136,
        "parent": "isolates/4095163606998683-806"
      },
      "isolates/4095163606998683-891": {
        "name": "_StringBase._concatRange",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/string_patch.dart",
        "packageUri": "dart:core-patch/string_patch.dart",
        "sourceLine": 967,
        "parent": "isolates/4095163606998683-890"
      },
      "isolates/4095163606998683-890": {
        "name": "StringBuffer.toString",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/string_buffer_patch.dart",
        "packageUri": "dart:core-patch/string_buffer_patch.dart",
        "sourceLine": 126,
        "parent": "isolates/4095163606998683-889"
      },
      "isolates/4095163606998683-889": {
        "name": "_PrefixedStringBuilder._finalizeLine",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 826,
        "parent": "isolates/4095163606998683-888"
      },
      "isolates/4095163606998683-888": {
        "name": "_PrefixedStringBuilder.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1048,
        "parent": "isolates/4095163606998683-887"
      },
      "isolates/4095163606998683-887": {
        "name": "TextTreeRenderer._debugRender",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1134,
        "parent": "isolates/4095163606998683-886"
      },
      "isolates/4095163606998683-886": {
        "name": "TextTreeRenderer.render",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1116,
        "parent": "isolates/4095163606998683-885"
      },
      "isolates/4095163606998683-885": {
        "name": "TextTreeRenderer._debugRender",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1134,
        "parent": "isolates/4095163606998683-884"
      },
      "isolates/4095163606998683-884": {
        "name": "TextTreeRenderer.render",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1116,
        "parent": "isolates/4095163606998683-883"
      },
      "isolates/4095163606998683-883": {
        "name": "DiagnosticsNode.toStringDeep.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1778,
        "parent": "isolates/4095163606998683-882"
      },
      "isolates/4095163606998683-882": {
        "name": "DiagnosticsNode.toStringDeep",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1771,
        "parent": "isolates/4095163606998683-881"
      },
      "isolates/4095163606998683-881": {
        "name": "DiagnosticsNode.toString.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1698,
        "parent": "isolates/4095163606998683-880"
      },
      "isolates/4095163606998683-880": {
        "name": "DiagnosticsNode.toString",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 1691,
        "parent": "isolates/4095163606998683-879"
      },
      "isolates/4095163606998683-879": {
        "name":
            "_GestureRecognizer&GestureArenaMember&DiagnosticableTreeMixin.toString",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/diagnostics.dart",
        "packageUri": "package:flutter/src/foundation/diagnostics.dart",
        "sourceLine": 3391,
        "parent": "isolates/4095163606998683-878"
      },
      "isolates/4095163606998683-878": {
        "name": "_StringBase._interpolate",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/string_patch.dart",
        "packageUri": "dart:core-patch/string_patch.dart",
        "sourceLine": 857,
        "parent": "isolates/4095163606998683-877"
      },
      "isolates/4095163606998683-877": {
        "name": "GestureArenaManager.sweep",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/arena.dart",
        "packageUri": "package:flutter/src/gestures/arena.dart",
        "sourceLine": 151,
        "parent": "isolates/4095163606998683-805"
      },
      "isolates/4095163606998683-958": {
        "name": "ChangeNotifier.notifyListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/change_notifier.dart",
        "packageUri": "package:flutter/src/foundation/change_notifier.dart",
        "sourceLine": 408,
        "parent": "isolates/4095163606998683-957"
      },
      "isolates/4095163606998683-957": {
        "name": "MaterialStatesController.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/material_state.dart",
        "packageUri": "package:flutter/src/material/material_state.dart",
        "sourceLine": 759,
        "parent": "isolates/4095163606998683-936"
      },
      "isolates/4095163606998683-936": {
        "name": "_InkResponseState._startNewSplash",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_well.dart",
        "packageUri": "package:flutter/src/material/ink_well.dart",
        "sourceLine": 1154,
        "parent": "isolates/4095163606998683-935"
      },
      "isolates/4095163606998683-935": {
        "name": "_InkResponseState.handleAnyTapDown",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_well.dart",
        "packageUri": "package:flutter/src/material/ink_well.dart",
        "sourceLine": 1129,
        "parent": "isolates/4095163606998683-934"
      },
      "isolates/4095163606998683-934": {
        "name": "_InkResponseState.handleTapDown",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_well.dart",
        "packageUri": "package:flutter/src/material/ink_well.dart",
        "sourceLine": 1136,
        "parent": "isolates/4095163606998683-933"
      },
      "isolates/4095163606998683-933": {
        "name": "TapGestureRecognizer.handleTapDown.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 624,
        "parent": "isolates/4095163606998683-932"
      },
      "isolates/4095163606998683-932": {
        "name": "GestureRecognizer.invokeCallback",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 300,
        "parent": "isolates/4095163606998683-931"
      },
      "isolates/4095163606998683-931": {
        "name": "TapGestureRecognizer.handleTapDown",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 613,
        "parent": "isolates/4095163606998683-930"
      },
      "isolates/4095163606998683-930": {
        "name": "BaseTapGestureRecognizer._checkDown",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 296,
        "parent": "isolates/4095163606998683-892"
      },
      "isolates/4095163606998683-892": {
        "name": "BaseTapGestureRecognizer.acceptGesture",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 273,
        "parent": "isolates/4095163606998683-877"
      },
      "isolates/4095163606998683-963": {
        "name": "Element._dirty",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4996,
        "parent": "isolates/4095163606998683-962"
      },
      "isolates/4095163606998683-962": {
        "name": "Element.dirty",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4995,
        "parent": "isolates/4095163606998683-961"
      },
      "isolates/4095163606998683-961": {
        "name": "Element.markNeedsBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5012,
        "parent": "isolates/4095163606998683-960"
      },
      "isolates/4095163606998683-960": {
        "name": "State.setState",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 1163,
        "parent": "isolates/4095163606998683-959"
      },
      "isolates/4095163606998683-959": {
        "name": "_InkResponseState.handleStatesControllerChange",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_well.dart",
        "packageUri": "package:flutter/src/material/ink_well.dart",
        "sourceLine": 864,
        "parent": "isolates/4095163606998683-958"
      },
      "isolates/4095163606998683-942": {
        "name": "RenderSliverMultiBoxAdaptor._keepAliveBucket",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_multi_box_adaptor.dart",
        "packageUri":
            "package:flutter/src/rendering/sliver_multi_box_adaptor.dart",
        "sourceLine": 214,
        "parent": "isolates/4095163606998683-941"
      },
      "isolates/4095163606998683-941": {
        "name": "RenderSliverMultiBoxAdaptor.paintsChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_multi_box_adaptor.dart",
        "packageUri":
            "package:flutter/src/rendering/sliver_multi_box_adaptor.dart",
        "sourceLine": 578,
        "parent": "isolates/4095163606998683-940"
      },
      "isolates/4095163606998683-940": {
        "name": "RenderSliverMultiBoxAdaptor.applyPaintTransform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/sliver_multi_box_adaptor.dart",
        "packageUri":
            "package:flutter/src/rendering/sliver_multi_box_adaptor.dart",
        "sourceLine": 585,
        "parent": "isolates/4095163606998683-939"
      },
      "isolates/4095163606998683-939": {
        "name": "RenderObject.getTransformTo",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/object.dart",
        "packageUri": "package:flutter/src/rendering/object.dart",
        "sourceLine": 3333,
        "parent": "isolates/4095163606998683-938"
      },
      "isolates/4095163606998683-938": {
        "name": "RenderBox.globalToLocal",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": 2589,
        "parent": "isolates/4095163606998683-937"
      },
      "isolates/4095163606998683-937": {
        "name": "_InkResponseState._createSplash",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_well.dart",
        "packageUri": "package:flutter/src/material/ink_well.dart",
        "sourceLine": 1049,
        "parent": "isolates/4095163606998683-936"
      },
      "isolates/4095163606998683-946": {
        "name": "AnimationController._ticker=",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/animation_controller.dart",
        "packageUri": "package:flutter/src/animation/animation_controller.dart",
        "sourceLine": 349,
        "parent": "isolates/4095163606998683-945"
      },
      "isolates/4095163606998683-945": {
        "name": "AnimationController.AnimationController",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/animation_controller.dart",
        "packageUri": "package:flutter/src/animation/animation_controller.dart",
        "sourceLine": 251,
        "parent": "isolates/4095163606998683-944"
      },
      "isolates/4095163606998683-944": {
        "name": "InkSparkle.InkSparkle",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_sparkle.dart",
        "packageUri": "package:flutter/src/material/ink_sparkle.dart",
        "sourceLine": 97,
        "parent": "isolates/4095163606998683-943"
      },
      "isolates/4095163606998683-943": {
        "name": "_InkSparkleFactory.create",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_sparkle.dart",
        "packageUri": "package:flutter/src/material/ink_sparkle.dart",
        "sourceLine": 459,
        "parent": "isolates/4095163606998683-937"
      },
      "isolates/4095163606998683-956": {
        "name": "_AutomaticKeepAliveState._keepingAlive",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/automatic_keep_alive.dart",
        "packageUri": "package:flutter/src/widgets/automatic_keep_alive.dart",
        "sourceLine": 48,
        "parent": "isolates/4095163606998683-955"
      },
      "isolates/4095163606998683-955": {
        "name": "_AutomaticKeepAliveState._addClient",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/automatic_keep_alive.dart",
        "packageUri": "package:flutter/src/widgets/automatic_keep_alive.dart",
        "sourceLine": 79,
        "parent": "isolates/4095163606998683-954"
      },
      "isolates/4095163606998683-954": {
        "name": "_NotificationElement.onNotification",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/notification_listener.dart",
        "packageUri": "package:flutter/src/widgets/notification_listener.dart",
        "sourceLine": 126,
        "parent": "isolates/4095163606998683-953"
      },
      "isolates/4095163606998683-953": {
        "name": "_NotificationNode.dispatchNotification",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3319,
        "parent": "isolates/4095163606998683-952"
      },
      "isolates/4095163606998683-952": {
        "name": "_NotificationNode.dispatchNotification",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3319,
        "parent": "isolates/4095163606998683-951"
      },
      "isolates/4095163606998683-951": {
        "name": "_NotificationNode.dispatchNotification",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3319,
        "parent": "isolates/4095163606998683-950"
      },
      "isolates/4095163606998683-950": {
        "name": "Element.dispatchNotification",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4940,
        "parent": "isolates/4095163606998683-949"
      },
      "isolates/4095163606998683-949": {
        "name": "Notification.dispatch",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/notification_listener.dart",
        "packageUri": "package:flutter/src/widgets/notification_listener.dart",
        "sourceLine": 59,
        "parent": "isolates/4095163606998683-948"
      },
      "isolates/4095163606998683-948": {
        "name":
            "__InkResponseState&State&AutomaticKeepAliveClientMixin._ensureKeepAlive",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/automatic_keep_alive.dart",
        "packageUri": "package:flutter/src/widgets/automatic_keep_alive.dart",
        "sourceLine": 362,
        "parent": "isolates/4095163606998683-947"
      },
      "isolates/4095163606998683-947": {
        "name":
            "__InkResponseState&State&AutomaticKeepAliveClientMixin.updateKeepAlive",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/automatic_keep_alive.dart",
        "packageUri": "package:flutter/src/widgets/automatic_keep_alive.dart",
        "sourceLine": 383,
        "parent": "isolates/4095163606998683-936"
      },
      "isolates/4095163606998683-899": {
        "name": "Theme.of",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/theme.dart",
        "packageUri": "package:flutter/src/material/theme.dart",
        "sourceLine": 104,
        "parent": "isolates/4095163606998683-898"
      },
      "isolates/4095163606998683-898": {
        "name": "Feedback._platform",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/feedback.dart",
        "packageUri": "package:flutter/src/material/feedback.dart",
        "sourceLine": 171,
        "parent": "isolates/4095163606998683-897"
      },
      "isolates/4095163606998683-897": {
        "name": "Feedback.forTap",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/feedback.dart",
        "packageUri": "package:flutter/src/material/feedback.dart",
        "sourceLine": 93,
        "parent": "isolates/4095163606998683-896"
      },
      "isolates/4095163606998683-896": {
        "name": "_InkResponseState.handleTap",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_well.dart",
        "packageUri": "package:flutter/src/material/ink_well.dart",
        "sourceLine": 1175,
        "parent": "isolates/4095163606998683-895"
      },
      "isolates/4095163606998683-895": {
        "name": "GestureRecognizer.invokeCallback",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/recognizer.dart",
        "packageUri": "package:flutter/src/gestures/recognizer.dart",
        "sourceLine": 300,
        "parent": "isolates/4095163606998683-894"
      },
      "isolates/4095163606998683-894": {
        "name": "TapGestureRecognizer.handleTapUp",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 638,
        "parent": "isolates/4095163606998683-893"
      },
      "isolates/4095163606998683-893": {
        "name": "BaseTapGestureRecognizer._checkUp",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/gestures/tap.dart",
        "packageUri": "package:flutter/src/gestures/tap.dart",
        "sourceLine": 304,
        "parent": "isolates/4095163606998683-892"
      },
      "isolates/4095163606998683-900": {
        "name": "_CarouselCard.build.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/gallery/lib/pages/home.dart",
        "packageUri": "package:gallery/pages/home.dart",
        "sourceLine": 1119,
        "parent": "isolates/4095163606998683-896"
      },
      "isolates/4095163606998683-905": {
        "name": "NavigatorState._debugLocked",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 3511,
        "parent": "isolates/4095163606998683-904"
      },
      "isolates/4095163606998683-904": {
        "name": "NavigatorState._routeNamed",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 4425,
        "parent": "isolates/4095163606998683-903"
      },
      "isolates/4095163606998683-903": {
        "name": "_NamedRestorationInformation.createRoute",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 5677,
        "parent": "isolates/4095163606998683-902"
      },
      "isolates/4095163606998683-902": {
        "name": "_RestorationInformation.toRouteEntry",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 5635,
        "parent": "isolates/4095163606998683-901"
      },
      "isolates/4095163606998683-901": {
        "name": "NavigatorState.restorablePushNamed",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 4529,
        "parent": "isolates/4095163606998683-900"
      },
      "isolates/4095163606998683-908": {
        "name": "Iterable.length",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/core/iterable.dart",
        "packageUri": "dart:core/iterable.dart",
        "sourceLine": 520,
        "parent": "isolates/4095163606998683-907"
      },
      "isolates/4095163606998683-907": {
        "name": "NavigatorState._flushHistoryUpdates",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 4206,
        "parent": "isolates/4095163606998683-906"
      },
      "isolates/4095163606998683-906": {
        "name": "NavigatorState._pushEntry",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 4820,
        "parent": "isolates/4095163606998683-901"
      },
      "isolates/4095163606998683-926": {
        "name": "Completer.Completer",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/future.dart",
        "packageUri": "dart:async/future.dart",
        "sourceLine": 1183,
        "parent": "isolates/4095163606998683-925"
      },
      "isolates/4095163606998683-925": {
        "name": "TickerFuture.orCancel",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/ticker.dart",
        "packageUri": "package:flutter/src/scheduler/ticker.dart",
        "sourceLine": 448,
        "parent": "isolates/4095163606998683-924"
      },
      "isolates/4095163606998683-924": {
        "name": "TickerFuture.whenCompleteOrCancel",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/ticker.dart",
        "packageUri": "package:flutter/src/scheduler/ticker.dart",
        "sourceLine": 433,
        "parent": "isolates/4095163606998683-923"
      },
      "isolates/4095163606998683-923": {
        "name": "_RouteEntry.handlePush",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 2990,
        "parent": "isolates/4095163606998683-907"
      },
      "isolates/4095163606998683-909": {
        "name": "NavigatorState._flushRouteAnnouncement",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 4381,
        "parent": "isolates/4095163606998683-907"
      },
      "isolates/4095163606998683-922": {
        "name": "ProxyAnimation.didStopListening",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/animations.dart",
        "packageUri": "package:flutter/src/animation/animations.dart",
        "sourceLine": 230,
        "parent": "isolates/4095163606998683-921"
      },
      "isolates/4095163606998683-921": {
        "name": "ProxyAnimation.parent=",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/animations.dart",
        "packageUri": "package:flutter/src/animation/animations.dart",
        "sourceLine": 195,
        "parent": "isolates/4095163606998683-920"
      },
      "isolates/4095163606998683-920": {
        "name": "_DualTransitionBuilderState._updateAnimations",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/dual_transition_builder.dart",
        "packageUri":
            "package:flutter/src/widgets/dual_transition_builder.dart",
        "sourceLine": 157,
        "parent": "isolates/4095163606998683-919"
      },
      "isolates/4095163606998683-919": {
        "name": "_DualTransitionBuilderState._animationListener",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/dual_transition_builder.dart",
        "packageUri":
            "package:flutter/src/widgets/dual_transition_builder.dart",
        "sourceLine": 103,
        "parent": "isolates/4095163606998683-918"
      },
      "isolates/4095163606998683-918": {
        "name":
            "_ReverseAnimation&Animation&AnimationLazyListenerMixin&AnimationLocalStatusListenersMixin.notifyStatusListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/listener_helpers.dart",
        "packageUri": "package:flutter/src/animation/listener_helpers.dart",
        "sourceLine": 233,
        "parent": "isolates/4095163606998683-917"
      },
      "isolates/4095163606998683-917": {
        "name": "ReverseAnimation._statusChangeHandler",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/animations.dart",
        "packageUri": "package:flutter/src/animation/animations.dart",
        "sourceLine": 299,
        "parent": "isolates/4095163606998683-916"
      },
      "isolates/4095163606998683-916": {
        "name":
            "_ProxyAnimation&Animation&AnimationLazyListenerMixin&AnimationLocalListenersMixin&AnimationLocalStatusListenersMixin.notifyStatusListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/listener_helpers.dart",
        "packageUri": "package:flutter/src/animation/listener_helpers.dart",
        "sourceLine": 233,
        "parent": "isolates/4095163606998683-915"
      },
      "isolates/4095163606998683-915": {
        "name":
            "_ProxyAnimation&Animation&AnimationLazyListenerMixin&AnimationLocalListenersMixin&AnimationLocalStatusListenersMixin.notifyStatusListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/listener_helpers.dart",
        "packageUri": "package:flutter/src/animation/listener_helpers.dart",
        "sourceLine": 233,
        "parent": "isolates/4095163606998683-914"
      },
      "isolates/4095163606998683-914": {
        "name": "ProxyAnimation.parent=",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/animations.dart",
        "packageUri": "package:flutter/src/animation/animations.dart",
        "sourceLine": 195,
        "parent": "isolates/4095163606998683-913"
      },
      "isolates/4095163606998683-913": {
        "name": "TransitionRoute._setSecondaryAnimation",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/routes.dart",
        "packageUri": "package:flutter/src/widgets/routes.dart",
        "sourceLine": 414,
        "parent": "isolates/4095163606998683-912"
      },
      "isolates/4095163606998683-912": {
        "name": "TransitionRoute._updateSecondaryAnimation",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/routes.dart",
        "packageUri": "package:flutter/src/widgets/routes.dart",
        "sourceLine": 332,
        "parent": "isolates/4095163606998683-911"
      },
      "isolates/4095163606998683-911": {
        "name": "TransitionRoute.didChangeNext",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/routes.dart",
        "packageUri": "package:flutter/src/widgets/routes.dart",
        "sourceLine": 317,
        "parent": "isolates/4095163606998683-910"
      },
      "isolates/4095163606998683-910": {
        "name": "ModalRoute.didChangeNext",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/routes.dart",
        "packageUri": "package:flutter/src/widgets/routes.dart",
        "sourceLine": 1711,
        "parent": "isolates/4095163606998683-909"
      },
      "isolates/4095163606998683-929": {
        "name": "_GrowableList.length",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/growable_array.dart",
        "packageUri": "dart:core-patch/growable_array.dart",
        "sourceLine": 220,
        "parent": "isolates/4095163606998683-928"
      },
      "isolates/4095163606998683-928": {
        "name": "listEquals",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/collections.dart",
        "packageUri": "package:flutter/src/foundation/collections.dart",
        "sourceLine": 55,
        "parent": "isolates/4095163606998683-927"
      },
      "isolates/4095163606998683-927": {
        "name": "OverlayState.rearrange",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 697,
        "parent": "isolates/4095163606998683-907"
      },
      "isolates/4095163606998683-11543": {
        "name": "FocusNode.canRequestFocus",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/focus_manager.dart",
        "packageUri": "package:flutter/src/widgets/focus_manager.dart",
        "sourceLine": 511,
        "parent": "isolates/4095163606998683-11542"
      },
      "isolates/4095163606998683-11542": {
        "name": "FocusScopeNode._doRequestFocus",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/focus_manager.dart",
        "packageUri": "package:flutter/src/widgets/focus_manager.dart",
        "sourceLine": 1355,
        "parent": "isolates/4095163606998683-11541"
      },
      "isolates/4095163606998683-11541": {
        "name": "FocusNode.requestFocus",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/focus_manager.dart",
        "packageUri": "package:flutter/src/widgets/focus_manager.dart",
        "sourceLine": 1092,
        "parent": "isolates/4095163606998683-11540"
      },
      "isolates/4095163606998683-11540": {
        "name": "Route.didPush.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 237,
        "parent": "isolates/4095163606998683-11529"
      },
      "isolates/4095163606998683-11529": {
        "name": "_FutureListener.handleValue",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/future_impl.dart",
        "packageUri": "dart:async/future_impl.dart",
        "sourceLine": 159,
        "parent": "isolates/4095163606998683-11528"
      },
      "isolates/4095163606998683-11528": {
        "name": "handleValueCallback",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/future_impl.dart",
        "packageUri": "dart:async/future_impl.dart",
        "sourceLine": 836,
        "parent": "isolates/4095163606998683-11527"
      },
      "isolates/4095163606998683-11527": {
        "name": "_Future._propagateToListeners",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/future_impl.dart",
        "packageUri": "dart:async/future_impl.dart",
        "sourceLine": 743,
        "parent": "isolates/4095163606998683-11526"
      },
      "isolates/4095163606998683-11526": {
        "name": "_Future._completeWithValue",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/future_impl.dart",
        "packageUri": "dart:async/future_impl.dart",
        "sourceLine": 638,
        "parent": "isolates/4095163606998683-11525"
      },
      "isolates/4095163606998683-11525": {
        "name": "_Future._asyncCompleteWithValue.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/future_impl.dart",
        "packageUri": "dart:async/future_impl.dart",
        "sourceLine": 712,
        "parent": "isolates/4095163606998683-11498"
      },
      "isolates/4095163606998683-11498": {
        "name": "_microtaskLoop",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/schedule_microtask.dart",
        "packageUri": "dart:async/schedule_microtask.dart",
        "sourceLine": 34,
        "parent": "isolates/4095163606998683-11497"
      },
      "isolates/4095163606998683-11497": {
        "name": "_startMicrotaskLoop",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/async/schedule_microtask.dart",
        "packageUri": "dart:async/schedule_microtask.dart",
        "sourceLine": 44,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-9120": {
        "name": "_AnimatedState._handleChange",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/transitions.dart",
        "packageUri": "package:flutter/src/widgets/transitions.dart",
        "sourceLine": 128,
        "parent": "isolates/4095163606998683-9110"
      },
      "isolates/4095163606998683-9110": {
        "name":
            "_ProxyAnimation&Animation&AnimationLazyListenerMixin&AnimationLocalListenersMixin.notifyListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/listener_helpers.dart",
        "packageUri": "package:flutter/src/animation/listener_helpers.dart",
        "sourceLine": 143,
        "parent": "isolates/4095163606998683-9109"
      },
      "isolates/4095163606998683-9109": {
        "name":
            "_ProxyAnimation&Animation&AnimationLazyListenerMixin&AnimationLocalListenersMixin.notifyListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/listener_helpers.dart",
        "packageUri": "package:flutter/src/animation/listener_helpers.dart",
        "sourceLine": 143,
        "parent": "isolates/4095163606998683-9104"
      },
      "isolates/4095163606998683-9104": {
        "name":
            "_AnimationController&Animation&AnimationEagerListenerMixin&AnimationLocalListenersMixin.notifyListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/listener_helpers.dart",
        "packageUri": "package:flutter/src/animation/listener_helpers.dart",
        "sourceLine": 143,
        "parent": "isolates/4095163606998683-9101"
      },
      "isolates/4095163606998683-9101": {
        "name": "AnimationController._tick",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/animation/animation_controller.dart",
        "packageUri": "package:flutter/src/animation/animation_controller.dart",
        "sourceLine": 854,
        "parent": "isolates/4095163606998683-9098"
      },
      "isolates/4095163606998683-9098": {
        "name": "Ticker._tick",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/ticker.dart",
        "packageUri": "package:flutter/src/scheduler/ticker.dart",
        "sourceLine": 252,
        "parent": "isolates/4095163606998683-9097"
      },
      "isolates/4095163606998683-9097": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding._invokeFrameCallback",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/binding.dart",
        "packageUri": "package:flutter/src/scheduler/binding.dart",
        "sourceLine": 1378,
        "parent": "isolates/4095163606998683-9096"
      },
      "isolates/4095163606998683-9096": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding.handleBeginFrame.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/binding.dart",
        "packageUri": "package:flutter/src/scheduler/binding.dart",
        "sourceLine": 1231,
        "parent": "isolates/4095163606998683-9095"
      },
      "isolates/4095163606998683-9095": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode&_LinkedHashMapMixin.forEach",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 624,
        "parent": "isolates/4095163606998683-9088"
      },
      "isolates/4095163606998683-9088": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding.handleBeginFrame",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/binding.dart",
        "packageUri": "package:flutter/src/scheduler/binding.dart",
        "sourceLine": 1197,
        "parent": "isolates/4095163606998683-9087"
      },
      "isolates/4095163606998683-9087": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding._handleBeginFrame",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/binding.dart",
        "packageUri": "package:flutter/src/scheduler/binding.dart",
        "sourceLine": 1139,
        "parent": "isolates/4095163606998683-9086"
      },
      "isolates/4095163606998683-9086": {
        "name": "_invoke1",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/hooks.dart",
        "packageUri": "dart:ui/hooks.dart",
        "sourceLine": 323,
        "parent": "isolates/4095163606998683-9085"
      },
      "isolates/4095163606998683-9085": {
        "name": "PlatformDispatcher._beginFrame",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///flutter/lib/ui/platform_dispatcher.dart",
        "packageUri": "dart:ui/platform_dispatcher.dart",
        "sourceLine": 345,
        "parent": "isolates/4095163606998683-9084"
      },
      "isolates/4095163606998683-9084": {
        "name": "_beginFrame",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/hooks.dart",
        "packageUri": "dart:ui/hooks.dart",
        "sourceLine": 270,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-11324": {
        "name": "InheritedNotifier.notifier",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/inherited_notifier.dart",
        "packageUri": "package:flutter/src/widgets/inherited_notifier.dart",
        "sourceLine": 79,
        "parent": "isolates/4095163606998683-11323"
      },
      "isolates/4095163606998683-11323": {
        "name": "Focus.maybeOf",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/focus_scope.dart",
        "packageUri": "package:flutter/src/widgets/focus_scope.dart",
        "sourceLine": 428,
        "parent": "isolates/4095163606998683-11322"
      },
      "isolates/4095163606998683-11322": {
        "name": "FocusTraversalGroup.maybeOf",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/focus_traversal.dart",
        "packageUri": "package:flutter/src/widgets/focus_traversal.dart",
        "sourceLine": 1858,
        "parent": "isolates/4095163606998683-11321"
      },
      "isolates/4095163606998683-11321": {
        "name": "NavigatorState.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/navigator.dart",
        "packageUri": "package:flutter/src/widgets/navigator.dart",
        "sourceLine": 5532,
        "parent": "isolates/4095163606998683-11317"
      },
      "isolates/4095163606998683-11317": {
        "name": "StatefulElement.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5591,
        "parent": "isolates/4095163606998683-10443"
      },
      "isolates/4095163606998683-10443": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10442"
      },
      "isolates/4095163606998683-10442": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10441"
      },
      "isolates/4095163606998683-10441": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10434"
      },
      "isolates/4095163606998683-10434": {
        "name": "BuildOwner.buildScope",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 2799,
        "parent": "isolates/4095163606998683-9329"
      },
      "isolates/4095163606998683-9329": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding&ServicesBinding&PaintingBinding&SemanticsBinding&RendererBinding&WidgetsBinding.drawFrame",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/binding.dart",
        "packageUri": "package:flutter/src/widgets/binding.dart",
        "sourceLine": 954,
        "parent": "isolates/4095163606998683-9328"
      },
      "isolates/4095163606998683-9328": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding&ServicesBinding&PaintingBinding&SemanticsBinding&RendererBinding._handlePersistentFrameCallback",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/binding.dart",
        "packageUri": "package:flutter/src/rendering/binding.dart",
        "sourceLine": 447,
        "parent": "isolates/4095163606998683-9299"
      },
      "isolates/4095163606998683-9299": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding._invokeFrameCallback",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/binding.dart",
        "packageUri": "package:flutter/src/scheduler/binding.dart",
        "sourceLine": 1378,
        "parent": "isolates/4095163606998683-9297"
      },
      "isolates/4095163606998683-9297": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding.handleDrawFrame",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/binding.dart",
        "packageUri": "package:flutter/src/scheduler/binding.dart",
        "sourceLine": 1304,
        "parent": "isolates/4095163606998683-9296"
      },
      "isolates/4095163606998683-9296": {
        "name":
            "_WidgetsFlutterBinding&BindingBase&GestureBinding&SchedulerBinding._handleDrawFrame",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/scheduler/binding.dart",
        "packageUri": "package:flutter/src/scheduler/binding.dart",
        "sourceLine": 1151,
        "parent": "isolates/4095163606998683-9295"
      },
      "isolates/4095163606998683-9295": {
        "name": "_invoke",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/hooks.dart",
        "packageUri": "dart:ui/hooks.dart",
        "sourceLine": 307,
        "parent": "isolates/4095163606998683-9294"
      },
      "isolates/4095163606998683-9294": {
        "name": "PlatformDispatcher._drawFrame",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///flutter/lib/ui/platform_dispatcher.dart",
        "packageUri": "dart:ui/platform_dispatcher.dart",
        "sourceLine": 376,
        "parent": "isolates/4095163606998683-9293"
      },
      "isolates/4095163606998683-9293": {
        "name": "_drawFrame",
        "category": "Dart",
        "resolvedUrl": "org-dartlang-sdk:///flutter/lib/ui/hooks.dart",
        "packageUri": "dart:ui/hooks.dart",
        "sourceLine": 281,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-11325": {
        "name": "AbsorbPointer.AbsorbPointer",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/basic.dart",
        "packageUri": "package:flutter/src/widgets/basic.dart",
        "sourceLine": 6951,
        "parent": "isolates/4095163606998683-11321"
      },
      "isolates/4095163606998683-10505": {
        "name": "_RenderTheater._clipBehavior",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 1056,
        "parent": "isolates/4095163606998683-10504"
      },
      "isolates/4095163606998683-10504": {
        "name": "_RenderTheater.clipBehavior=",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 1057,
        "parent": "isolates/4095163606998683-10503"
      },
      "isolates/4095163606998683-10503": {
        "name": "_Theater.updateRenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 835,
        "parent": "isolates/4095163606998683-10502"
      },
      "isolates/4095163606998683-10502": {
        "name": "RenderObjectElement._performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6485,
        "parent": "isolates/4095163606998683-10501"
      },
      "isolates/4095163606998683-10501": {
        "name": "RenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6462,
        "parent": "isolates/4095163606998683-10500"
      },
      "isolates/4095163606998683-10500": {
        "name": "MultiChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6912,
        "parent": "isolates/4095163606998683-10499"
      },
      "isolates/4095163606998683-10499": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10498"
      },
      "isolates/4095163606998683-10498": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10497"
      },
      "isolates/4095163606998683-10497": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10496"
      },
      "isolates/4095163606998683-10496": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10495"
      },
      "isolates/4095163606998683-10495": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10494"
      },
      "isolates/4095163606998683-10494": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10493"
      },
      "isolates/4095163606998683-10493": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10492"
      },
      "isolates/4095163606998683-10492": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10491"
      },
      "isolates/4095163606998683-10491": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10490"
      },
      "isolates/4095163606998683-10490": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10489"
      },
      "isolates/4095163606998683-10489": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10488"
      },
      "isolates/4095163606998683-10488": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10487"
      },
      "isolates/4095163606998683-10487": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10486"
      },
      "isolates/4095163606998683-10486": {
        "name": "_InheritedNotifierElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/inherited_notifier.dart",
        "packageUri": "package:flutter/src/widgets/inherited_notifier.dart",
        "sourceLine": 97,
        "parent": "isolates/4095163606998683-10485"
      },
      "isolates/4095163606998683-10485": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10484"
      },
      "isolates/4095163606998683-10484": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10483"
      },
      "isolates/4095163606998683-10483": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10482"
      },
      "isolates/4095163606998683-10482": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10481"
      },
      "isolates/4095163606998683-10481": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10480"
      },
      "isolates/4095163606998683-10480": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10479"
      },
      "isolates/4095163606998683-10479": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10478"
      },
      "isolates/4095163606998683-10478": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10477"
      },
      "isolates/4095163606998683-10477": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10476"
      },
      "isolates/4095163606998683-10476": {
        "name": "_InheritedNotifierElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/inherited_notifier.dart",
        "packageUri": "package:flutter/src/widgets/inherited_notifier.dart",
        "sourceLine": 97,
        "parent": "isolates/4095163606998683-10475"
      },
      "isolates/4095163606998683-10475": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10474"
      },
      "isolates/4095163606998683-10474": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10473"
      },
      "isolates/4095163606998683-10473": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10472"
      },
      "isolates/4095163606998683-10472": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10471"
      },
      "isolates/4095163606998683-10471": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10470"
      },
      "isolates/4095163606998683-10470": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10469"
      },
      "isolates/4095163606998683-10469": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10468"
      },
      "isolates/4095163606998683-10468": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10467"
      },
      "isolates/4095163606998683-10467": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10466"
      },
      "isolates/4095163606998683-10466": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10465"
      },
      "isolates/4095163606998683-10465": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10464"
      },
      "isolates/4095163606998683-10464": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10463"
      },
      "isolates/4095163606998683-10463": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10462"
      },
      "isolates/4095163606998683-10462": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10461"
      },
      "isolates/4095163606998683-10461": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10460"
      },
      "isolates/4095163606998683-10460": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10459"
      },
      "isolates/4095163606998683-10459": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10458"
      },
      "isolates/4095163606998683-10458": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10457"
      },
      "isolates/4095163606998683-10457": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10456"
      },
      "isolates/4095163606998683-10456": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10455"
      },
      "isolates/4095163606998683-10455": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10454"
      },
      "isolates/4095163606998683-10454": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10444"
      },
      "isolates/4095163606998683-10444": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10443"
      },
      "isolates/4095163606998683-10557": {
        "name": "_List._List",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm/lib/array.dart",
        "packageUri": "dart:core-patch/array.dart",
        "sourceLine": 87,
        "parent": "isolates/4095163606998683-10556"
      },
      "isolates/4095163606998683-10556": {
        "name": "_HashSet.clear",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/collection_patch.dart",
        "packageUri": "dart:collection-patch/collection_patch.dart",
        "sourceLine": 744,
        "parent": "isolates/4095163606998683-10555"
      },
      "isolates/4095163606998683-10555": {
        "name": "Element.update.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4144,
        "parent": "isolates/4095163606998683-10554"
      },
      "isolates/4095163606998683-10554": {
        "name": "Element.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4130,
        "parent": "isolates/4095163606998683-10553"
      },
      "isolates/4095163606998683-10553": {
        "name": "RenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6462,
        "parent": "isolates/4095163606998683-10552"
      },
      "isolates/4095163606998683-10552": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10551"
      },
      "isolates/4095163606998683-10551": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10550"
      },
      "isolates/4095163606998683-10550": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10549"
      },
      "isolates/4095163606998683-10549": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10548"
      },
      "isolates/4095163606998683-10548": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10547"
      },
      "isolates/4095163606998683-10547": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10546"
      },
      "isolates/4095163606998683-10546": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10545"
      },
      "isolates/4095163606998683-10545": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10544"
      },
      "isolates/4095163606998683-10544": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10540"
      },
      "isolates/4095163606998683-10540": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10539"
      },
      "isolates/4095163606998683-10539": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10538"
      },
      "isolates/4095163606998683-10538": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10537"
      },
      "isolates/4095163606998683-10537": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10536"
      },
      "isolates/4095163606998683-10536": {
        "name": "StatelessElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5552,
        "parent": "isolates/4095163606998683-10535"
      },
      "isolates/4095163606998683-10535": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10534"
      },
      "isolates/4095163606998683-10534": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10533"
      },
      "isolates/4095163606998683-10533": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10532"
      },
      "isolates/4095163606998683-10532": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10531"
      },
      "isolates/4095163606998683-10531": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10530"
      },
      "isolates/4095163606998683-10530": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10529"
      },
      "isolates/4095163606998683-10529": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10528"
      },
      "isolates/4095163606998683-10528": {
        "name": "StatelessElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5552,
        "parent": "isolates/4095163606998683-10527"
      },
      "isolates/4095163606998683-10527": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10526"
      },
      "isolates/4095163606998683-10526": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10525"
      },
      "isolates/4095163606998683-10525": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10524"
      },
      "isolates/4095163606998683-10524": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10523"
      },
      "isolates/4095163606998683-10523": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10522"
      },
      "isolates/4095163606998683-10522": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10521"
      },
      "isolates/4095163606998683-10521": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10520"
      },
      "isolates/4095163606998683-10520": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10519"
      },
      "isolates/4095163606998683-10519": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10518"
      },
      "isolates/4095163606998683-10518": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10517"
      },
      "isolates/4095163606998683-10517": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10516"
      },
      "isolates/4095163606998683-10516": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10515"
      },
      "isolates/4095163606998683-10515": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10514"
      },
      "isolates/4095163606998683-10514": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10513"
      },
      "isolates/4095163606998683-10513": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10512"
      },
      "isolates/4095163606998683-10512": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10511"
      },
      "isolates/4095163606998683-10511": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10510"
      },
      "isolates/4095163606998683-10510": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10509"
      },
      "isolates/4095163606998683-10509": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10508"
      },
      "isolates/4095163606998683-10508": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10507"
      },
      "isolates/4095163606998683-10507": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10506"
      },
      "isolates/4095163606998683-10506": {
        "name": "Element.updateChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3911,
        "parent": "isolates/4095163606998683-10500"
      },
      "isolates/4095163606998683-10579": {
        "name": "PersistentHashMap.put",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/persistent_hash_map.dart",
        "packageUri": "package:flutter/src/foundation/persistent_hash_map.dart",
        "sourceLine": 37,
        "parent": "isolates/4095163606998683-10578"
      },
      "isolates/4095163606998683-10578": {
        "name": "InheritedElement._updateInheritance",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5915,
        "parent": "isolates/4095163606998683-10577"
      },
      "isolates/4095163606998683-10577": {
        "name": "Element.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4093,
        "parent": "isolates/4095163606998683-10576"
      },
      "isolates/4095163606998683-10576": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-10575"
      },
      "isolates/4095163606998683-10575": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-10574"
      },
      "isolates/4095163606998683-10574": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10573"
      },
      "isolates/4095163606998683-10573": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10572"
      },
      "isolates/4095163606998683-10572": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10571"
      },
      "isolates/4095163606998683-10571": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10570"
      },
      "isolates/4095163606998683-10570": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-10569"
      },
      "isolates/4095163606998683-10569": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-10568"
      },
      "isolates/4095163606998683-10568": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-10567"
      },
      "isolates/4095163606998683-10567": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-10566"
      },
      "isolates/4095163606998683-10566": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10565"
      },
      "isolates/4095163606998683-10565": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10564"
      },
      "isolates/4095163606998683-10564": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10563"
      },
      "isolates/4095163606998683-10563": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10562"
      },
      "isolates/4095163606998683-10562": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-10561"
      },
      "isolates/4095163606998683-10561": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-10560"
      },
      "isolates/4095163606998683-10560": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-10559"
      },
      "isolates/4095163606998683-10559": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-10558"
      },
      "isolates/4095163606998683-10558": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-10507"
      },
      "isolates/4095163606998683-10604": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin.debugValidateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/object.dart",
        "packageUri": "package:flutter/src/rendering/object.dart",
        "sourceLine": 4012,
        "parent": "isolates/4095163606998683-10603"
      },
      "isolates/4095163606998683-10603": {
        "name": "SingleChildRenderObjectElement.insertRenderObjectChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6768,
        "parent": "isolates/4095163606998683-10602"
      },
      "isolates/4095163606998683-10602": {
        "name": "RenderObjectElement.attachRenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6567,
        "parent": "isolates/4095163606998683-10601"
      },
      "isolates/4095163606998683-10601": {
        "name": "RenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6440,
        "parent": "isolates/4095163606998683-10600"
      },
      "isolates/4095163606998683-10600": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-10599"
      },
      "isolates/4095163606998683-10599": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-10598"
      },
      "isolates/4095163606998683-10598": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10597"
      },
      "isolates/4095163606998683-10597": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10596"
      },
      "isolates/4095163606998683-10596": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10595"
      },
      "isolates/4095163606998683-10595": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-10594"
      },
      "isolates/4095163606998683-10594": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-10593"
      },
      "isolates/4095163606998683-10593": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-10592"
      },
      "isolates/4095163606998683-10592": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10591"
      },
      "isolates/4095163606998683-10591": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-10590"
      },
      "isolates/4095163606998683-10590": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-10589"
      },
      "isolates/4095163606998683-10589": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10588"
      },
      "isolates/4095163606998683-10588": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10587"
      },
      "isolates/4095163606998683-10587": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10586"
      },
      "isolates/4095163606998683-10586": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-10585"
      },
      "isolates/4095163606998683-10585": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-10584"
      },
      "isolates/4095163606998683-10584": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-10583"
      },
      "isolates/4095163606998683-10583": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10582"
      },
      "isolates/4095163606998683-10582": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10581"
      },
      "isolates/4095163606998683-10581": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10580"
      },
      "isolates/4095163606998683-10580": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-10576"
      },
      "isolates/4095163606998683-10608": {
        "name": "Semantics.Semantics",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/basic.dart",
        "packageUri": "package:flutter/src/widgets/basic.dart",
        "sourceLine": 7094,
        "parent": "isolates/4095163606998683-10607"
      },
      "isolates/4095163606998683-10607": {
        "name": "ModalRoute._buildModalScope",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/routes.dart",
        "packageUri": "package:flutter/src/widgets/routes.dart",
        "sourceLine": 1832,
        "parent": "isolates/4095163606998683-10606"
      },
      "isolates/4095163606998683-10606": {
        "name": "_OverlayEntryWidgetState.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/overlay.dart",
        "packageUri": "package:flutter/src/widgets/overlay.dart",
        "sourceLine": 371,
        "parent": "isolates/4095163606998683-10605"
      },
      "isolates/4095163606998683-10605": {
        "name": "StatefulElement.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5591,
        "parent": "isolates/4095163606998683-10565"
      },
      "isolates/4095163606998683-1462": {
        "name": "_ActionsState._ActionsState",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/actions.dart",
        "packageUri": "package:flutter/src/widgets/actions.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-1461"
      },
      "isolates/4095163606998683-1461": {
        "name": "Actions.createState",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/actions.dart",
        "packageUri": "package:flutter/src/widgets/actions.dart",
        "sourceLine": 1021,
        "parent": "isolates/4095163606998683-1460"
      },
      "isolates/4095163606998683-1460": {
        "name": "StatefulElement.StatefulElement",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5563,
        "parent": "isolates/4095163606998683-1459"
      },
      "isolates/4095163606998683-1459": {
        "name": "StatefulWidget.createElement",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 775,
        "parent": "isolates/4095163606998683-1458"
      },
      "isolates/4095163606998683-1458": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1457"
      },
      "isolates/4095163606998683-1457": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1456"
      },
      "isolates/4095163606998683-1456": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1455"
      },
      "isolates/4095163606998683-1455": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1454"
      },
      "isolates/4095163606998683-1454": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1453"
      },
      "isolates/4095163606998683-1453": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1452"
      },
      "isolates/4095163606998683-1452": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1451"
      },
      "isolates/4095163606998683-1451": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1450"
      },
      "isolates/4095163606998683-1450": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1449"
      },
      "isolates/4095163606998683-1449": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1448"
      },
      "isolates/4095163606998683-1448": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1447"
      },
      "isolates/4095163606998683-1447": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1446"
      },
      "isolates/4095163606998683-1446": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1445"
      },
      "isolates/4095163606998683-1445": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1444"
      },
      "isolates/4095163606998683-1444": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-1443"
      },
      "isolates/4095163606998683-1443": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1442"
      },
      "isolates/4095163606998683-1442": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1441"
      },
      "isolates/4095163606998683-1441": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1440"
      },
      "isolates/4095163606998683-1440": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1439"
      },
      "isolates/4095163606998683-1439": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1438"
      },
      "isolates/4095163606998683-1438": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1437"
      },
      "isolates/4095163606998683-1437": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1436"
      },
      "isolates/4095163606998683-1436": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1435"
      },
      "isolates/4095163606998683-1435": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1434"
      },
      "isolates/4095163606998683-1434": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1433"
      },
      "isolates/4095163606998683-1433": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1432"
      },
      "isolates/4095163606998683-1432": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1431"
      },
      "isolates/4095163606998683-1431": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1430"
      },
      "isolates/4095163606998683-1430": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1429"
      },
      "isolates/4095163606998683-1429": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1428"
      },
      "isolates/4095163606998683-1428": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1427"
      },
      "isolates/4095163606998683-1427": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1426"
      },
      "isolates/4095163606998683-1426": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1425"
      },
      "isolates/4095163606998683-1425": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-1424"
      },
      "isolates/4095163606998683-1424": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1423"
      },
      "isolates/4095163606998683-1423": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1422"
      },
      "isolates/4095163606998683-1422": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1421"
      },
      "isolates/4095163606998683-1421": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1420"
      },
      "isolates/4095163606998683-1420": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1419"
      },
      "isolates/4095163606998683-1419": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1418"
      },
      "isolates/4095163606998683-1418": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1417"
      },
      "isolates/4095163606998683-1417": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-1416"
      },
      "isolates/4095163606998683-1416": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1415"
      },
      "isolates/4095163606998683-1415": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1414"
      },
      "isolates/4095163606998683-1414": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1413"
      },
      "isolates/4095163606998683-1413": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1412"
      },
      "isolates/4095163606998683-1412": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1411"
      },
      "isolates/4095163606998683-1411": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1410"
      },
      "isolates/4095163606998683-1410": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1409"
      },
      "isolates/4095163606998683-1409": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-1408"
      },
      "isolates/4095163606998683-1408": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1407"
      },
      "isolates/4095163606998683-1407": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1406"
      },
      "isolates/4095163606998683-1406": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1405"
      },
      "isolates/4095163606998683-1405": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-1404"
      },
      "isolates/4095163606998683-1404": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1403"
      },
      "isolates/4095163606998683-1403": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1402"
      },
      "isolates/4095163606998683-1402": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1401"
      },
      "isolates/4095163606998683-1401": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1400"
      },
      "isolates/4095163606998683-1400": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1399"
      },
      "isolates/4095163606998683-1399": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1398"
      },
      "isolates/4095163606998683-1398": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1397"
      },
      "isolates/4095163606998683-1397": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1396"
      },
      "isolates/4095163606998683-1396": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1395"
      },
      "isolates/4095163606998683-1395": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1394"
      },
      "isolates/4095163606998683-1394": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1393"
      },
      "isolates/4095163606998683-1393": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1392"
      },
      "isolates/4095163606998683-1392": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1391"
      },
      "isolates/4095163606998683-1391": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1390"
      },
      "isolates/4095163606998683-1390": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1389"
      },
      "isolates/4095163606998683-1389": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1388"
      },
      "isolates/4095163606998683-1388": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1387"
      },
      "isolates/4095163606998683-1387": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1386"
      },
      "isolates/4095163606998683-1386": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-1385"
      },
      "isolates/4095163606998683-1385": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1384"
      },
      "isolates/4095163606998683-1384": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1383"
      },
      "isolates/4095163606998683-1383": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1382"
      },
      "isolates/4095163606998683-1382": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1381"
      },
      "isolates/4095163606998683-1381": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1380"
      },
      "isolates/4095163606998683-1380": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1379"
      },
      "isolates/4095163606998683-1379": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-1378"
      },
      "isolates/4095163606998683-1378": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-1377"
      },
      "isolates/4095163606998683-1377": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-1376"
      },
      "isolates/4095163606998683-1376": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-1375"
      },
      "isolates/4095163606998683-1375": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-1374"
      },
      "isolates/4095163606998683-1374": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1373"
      },
      "isolates/4095163606998683-1373": {
        "name": "Element.updateChildren",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3911,
        "parent": "isolates/4095163606998683-1372"
      },
      "isolates/4095163606998683-1372": {
        "name": "MultiChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6912,
        "parent": "isolates/4095163606998683-1371"
      },
      "isolates/4095163606998683-1371": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1370"
      },
      "isolates/4095163606998683-1370": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1369"
      },
      "isolates/4095163606998683-1369": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1368"
      },
      "isolates/4095163606998683-1368": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1367"
      },
      "isolates/4095163606998683-1367": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-1366"
      },
      "isolates/4095163606998683-1366": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1365"
      },
      "isolates/4095163606998683-1365": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1364"
      },
      "isolates/4095163606998683-1364": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1363"
      },
      "isolates/4095163606998683-1363": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-1362"
      },
      "isolates/4095163606998683-1362": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1361"
      },
      "isolates/4095163606998683-1361": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1360"
      },
      "isolates/4095163606998683-1360": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1359"
      },
      "isolates/4095163606998683-1359": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-1358"
      },
      "isolates/4095163606998683-1358": {
        "name": "_InheritedNotifierElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/inherited_notifier.dart",
        "packageUri": "package:flutter/src/widgets/inherited_notifier.dart",
        "sourceLine": 97,
        "parent": "isolates/4095163606998683-1357"
      },
      "isolates/4095163606998683-1357": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1356"
      },
      "isolates/4095163606998683-1356": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1355"
      },
      "isolates/4095163606998683-1355": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1354"
      },
      "isolates/4095163606998683-1354": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1353"
      },
      "isolates/4095163606998683-1353": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-1352"
      },
      "isolates/4095163606998683-1352": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1351"
      },
      "isolates/4095163606998683-1351": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1350"
      },
      "isolates/4095163606998683-1350": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1349"
      },
      "isolates/4095163606998683-1349": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-1348"
      },
      "isolates/4095163606998683-1348": {
        "name": "_InheritedNotifierElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/inherited_notifier.dart",
        "packageUri": "package:flutter/src/widgets/inherited_notifier.dart",
        "sourceLine": 97,
        "parent": "isolates/4095163606998683-1347"
      },
      "isolates/4095163606998683-1347": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1346"
      },
      "isolates/4095163606998683-1346": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1345"
      },
      "isolates/4095163606998683-1345": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1344"
      },
      "isolates/4095163606998683-1344": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1343"
      },
      "isolates/4095163606998683-1343": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-1342"
      },
      "isolates/4095163606998683-1342": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1341"
      },
      "isolates/4095163606998683-1341": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-1340"
      },
      "isolates/4095163606998683-1340": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-1339"
      },
      "isolates/4095163606998683-1339": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-1338"
      },
      "isolates/4095163606998683-1338": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-1337"
      },
      "isolates/4095163606998683-1337": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1336"
      },
      "isolates/4095163606998683-1336": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-1335"
      },
      "isolates/4095163606998683-1335": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-1334"
      },
      "isolates/4095163606998683-1334": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-6306": {
        "name": "_ZoomEnterTransitionPainter._ZoomEnterTransitionPainter",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/page_transitions_theme.dart",
        "packageUri":
            "package:flutter/src/material/page_transitions_theme.dart",
        "sourceLine": 887,
        "parent": "isolates/4095163606998683-6305"
      },
      "isolates/4095163606998683-6305": {
        "name": "_ZoomEnterTransitionState.initState",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/page_transitions_theme.dart",
        "packageUri":
            "package:flutter/src/material/page_transitions_theme.dart",
        "sourceLine": 343,
        "parent": "isolates/4095163606998683-6304"
      },
      "isolates/4095163606998683-6304": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6303"
      },
      "isolates/4095163606998683-6303": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6302"
      },
      "isolates/4095163606998683-6302": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6301"
      },
      "isolates/4095163606998683-6301": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6300"
      },
      "isolates/4095163606998683-6300": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6299"
      },
      "isolates/4095163606998683-6299": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6298"
      },
      "isolates/4095163606998683-6298": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6297"
      },
      "isolates/4095163606998683-6297": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6296"
      },
      "isolates/4095163606998683-6296": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6295"
      },
      "isolates/4095163606998683-6295": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6294"
      },
      "isolates/4095163606998683-6294": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6293"
      },
      "isolates/4095163606998683-6293": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6292"
      },
      "isolates/4095163606998683-6292": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6291"
      },
      "isolates/4095163606998683-6291": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6290"
      },
      "isolates/4095163606998683-6290": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6289"
      },
      "isolates/4095163606998683-6289": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6288"
      },
      "isolates/4095163606998683-6288": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6287"
      },
      "isolates/4095163606998683-6287": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6286"
      },
      "isolates/4095163606998683-6286": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6285"
      },
      "isolates/4095163606998683-6285": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6284"
      },
      "isolates/4095163606998683-6284": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6283"
      },
      "isolates/4095163606998683-6283": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6282"
      },
      "isolates/4095163606998683-6282": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6281"
      },
      "isolates/4095163606998683-6281": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6280"
      },
      "isolates/4095163606998683-6280": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6279"
      },
      "isolates/4095163606998683-6279": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6278"
      },
      "isolates/4095163606998683-6278": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6277"
      },
      "isolates/4095163606998683-6277": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6276"
      },
      "isolates/4095163606998683-6276": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6275"
      },
      "isolates/4095163606998683-6275": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6274"
      },
      "isolates/4095163606998683-6274": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6273"
      },
      "isolates/4095163606998683-6273": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6272"
      },
      "isolates/4095163606998683-6272": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6271"
      },
      "isolates/4095163606998683-6271": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6270"
      },
      "isolates/4095163606998683-6270": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6269"
      },
      "isolates/4095163606998683-6269": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6268"
      },
      "isolates/4095163606998683-6268": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6267"
      },
      "isolates/4095163606998683-6267": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6266"
      },
      "isolates/4095163606998683-6266": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6265"
      },
      "isolates/4095163606998683-6265": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6264"
      },
      "isolates/4095163606998683-6264": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6263"
      },
      "isolates/4095163606998683-6263": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6262"
      },
      "isolates/4095163606998683-6262": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6261"
      },
      "isolates/4095163606998683-6261": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6260"
      },
      "isolates/4095163606998683-6260": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6259"
      },
      "isolates/4095163606998683-6259": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6258"
      },
      "isolates/4095163606998683-6258": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6257"
      },
      "isolates/4095163606998683-6257": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6256"
      },
      "isolates/4095163606998683-6256": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6255"
      },
      "isolates/4095163606998683-6255": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6254"
      },
      "isolates/4095163606998683-6254": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6253"
      },
      "isolates/4095163606998683-6253": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6252"
      },
      "isolates/4095163606998683-6252": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6251"
      },
      "isolates/4095163606998683-6251": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6250"
      },
      "isolates/4095163606998683-6250": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6249"
      },
      "isolates/4095163606998683-6249": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6248"
      },
      "isolates/4095163606998683-6248": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6247"
      },
      "isolates/4095163606998683-6247": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6246"
      },
      "isolates/4095163606998683-6246": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6245"
      },
      "isolates/4095163606998683-6245": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6244"
      },
      "isolates/4095163606998683-6244": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6243"
      },
      "isolates/4095163606998683-6243": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6242"
      },
      "isolates/4095163606998683-6242": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6241"
      },
      "isolates/4095163606998683-6241": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6240"
      },
      "isolates/4095163606998683-6240": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6239"
      },
      "isolates/4095163606998683-6239": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6238"
      },
      "isolates/4095163606998683-6238": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6237"
      },
      "isolates/4095163606998683-6237": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6236"
      },
      "isolates/4095163606998683-6236": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6235"
      },
      "isolates/4095163606998683-6235": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6234"
      },
      "isolates/4095163606998683-6234": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6233"
      },
      "isolates/4095163606998683-6233": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6232"
      },
      "isolates/4095163606998683-6232": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6231"
      },
      "isolates/4095163606998683-6231": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6230"
      },
      "isolates/4095163606998683-6230": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6229"
      },
      "isolates/4095163606998683-6229": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6228"
      },
      "isolates/4095163606998683-6228": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6227"
      },
      "isolates/4095163606998683-6227": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6226"
      },
      "isolates/4095163606998683-6226": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6225"
      },
      "isolates/4095163606998683-6225": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6224"
      },
      "isolates/4095163606998683-6224": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6223"
      },
      "isolates/4095163606998683-6223": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6222"
      },
      "isolates/4095163606998683-6222": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6221"
      },
      "isolates/4095163606998683-6221": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6220"
      },
      "isolates/4095163606998683-6220": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6219"
      },
      "isolates/4095163606998683-6219": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6218"
      },
      "isolates/4095163606998683-6218": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6217"
      },
      "isolates/4095163606998683-6217": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6216"
      },
      "isolates/4095163606998683-6216": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6215"
      },
      "isolates/4095163606998683-6215": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6214"
      },
      "isolates/4095163606998683-6214": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6213"
      },
      "isolates/4095163606998683-6213": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6212"
      },
      "isolates/4095163606998683-6212": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6211"
      },
      "isolates/4095163606998683-6211": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6210"
      },
      "isolates/4095163606998683-6210": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6209"
      },
      "isolates/4095163606998683-6209": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6208"
      },
      "isolates/4095163606998683-6208": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6207"
      },
      "isolates/4095163606998683-6207": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6206"
      },
      "isolates/4095163606998683-6206": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6205"
      },
      "isolates/4095163606998683-6205": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6204"
      },
      "isolates/4095163606998683-6204": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6203"
      },
      "isolates/4095163606998683-6203": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6202"
      },
      "isolates/4095163606998683-6202": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6201"
      },
      "isolates/4095163606998683-6201": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6200"
      },
      "isolates/4095163606998683-6200": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6199"
      },
      "isolates/4095163606998683-6199": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6198"
      },
      "isolates/4095163606998683-6198": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6197"
      },
      "isolates/4095163606998683-6197": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6196"
      },
      "isolates/4095163606998683-6196": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6195"
      },
      "isolates/4095163606998683-6195": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6194"
      },
      "isolates/4095163606998683-6194": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6193"
      },
      "isolates/4095163606998683-6193": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6192"
      },
      "isolates/4095163606998683-6192": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6191"
      },
      "isolates/4095163606998683-6191": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6190"
      },
      "isolates/4095163606998683-6190": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6189"
      },
      "isolates/4095163606998683-6189": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6188"
      },
      "isolates/4095163606998683-6188": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6187"
      },
      "isolates/4095163606998683-6187": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6186"
      },
      "isolates/4095163606998683-6186": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6185"
      },
      "isolates/4095163606998683-6185": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6184"
      },
      "isolates/4095163606998683-6184": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6183"
      },
      "isolates/4095163606998683-6183": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6182"
      },
      "isolates/4095163606998683-6182": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6181"
      },
      "isolates/4095163606998683-6181": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6053"
      },
      "isolates/4095163606998683-6053": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-7506": {
        "name": "RenderObject.RenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/object.dart",
        "packageUri": "package:flutter/src/rendering/object.dart",
        "sourceLine": 1657,
        "parent": "isolates/4095163606998683-7505"
      },
      "isolates/4095163606998683-7505": {
        "name": "RenderBox.RenderBox",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-7504"
      },
      "isolates/4095163606998683-7504": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin._RenderProxyBox&RenderBox&RenderObjectWithChildMixin",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-7503"
      },
      "isolates/4095163606998683-7503": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin._RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-7502"
      },
      "isolates/4095163606998683-7502": {
        "name": "RenderProxyBox.RenderProxyBox",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 47,
        "parent": "isolates/4095163606998683-7501"
      },
      "isolates/4095163606998683-7501": {
        "name": "_RenderSnapshotWidget._RenderSnapshotWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/snapshot_widget.dart",
        "packageUri": "package:flutter/src/widgets/snapshot_widget.dart",
        "sourceLine": 166,
        "parent": "isolates/4095163606998683-7500"
      },
      "isolates/4095163606998683-7500": {
        "name": "SnapshotWidget.createRenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/snapshot_widget.dart",
        "packageUri": "package:flutter/src/widgets/snapshot_widget.dart",
        "sourceLine": 138,
        "parent": "isolates/4095163606998683-7499"
      },
      "isolates/4095163606998683-7499": {
        "name": "RenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6440,
        "parent": "isolates/4095163606998683-7498"
      },
      "isolates/4095163606998683-7498": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7497"
      },
      "isolates/4095163606998683-7497": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7496"
      },
      "isolates/4095163606998683-7496": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7495"
      },
      "isolates/4095163606998683-7495": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7494"
      },
      "isolates/4095163606998683-7494": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7493"
      },
      "isolates/4095163606998683-7493": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7492"
      },
      "isolates/4095163606998683-7492": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7491"
      },
      "isolates/4095163606998683-7491": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7490"
      },
      "isolates/4095163606998683-7490": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7489"
      },
      "isolates/4095163606998683-7489": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7488"
      },
      "isolates/4095163606998683-7488": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7487"
      },
      "isolates/4095163606998683-7487": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7486"
      },
      "isolates/4095163606998683-7486": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7485"
      },
      "isolates/4095163606998683-7485": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7484"
      },
      "isolates/4095163606998683-7484": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7483"
      },
      "isolates/4095163606998683-7483": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7482"
      },
      "isolates/4095163606998683-7482": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7481"
      },
      "isolates/4095163606998683-7481": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7480"
      },
      "isolates/4095163606998683-7480": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7479"
      },
      "isolates/4095163606998683-7479": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7478"
      },
      "isolates/4095163606998683-7478": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7477"
      },
      "isolates/4095163606998683-7477": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7476"
      },
      "isolates/4095163606998683-7476": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7475"
      },
      "isolates/4095163606998683-7475": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7474"
      },
      "isolates/4095163606998683-7474": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7473"
      },
      "isolates/4095163606998683-7473": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7472"
      },
      "isolates/4095163606998683-7472": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7471"
      },
      "isolates/4095163606998683-7471": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7470"
      },
      "isolates/4095163606998683-7470": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7469"
      },
      "isolates/4095163606998683-7469": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7468"
      },
      "isolates/4095163606998683-7468": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7467"
      },
      "isolates/4095163606998683-7467": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7466"
      },
      "isolates/4095163606998683-7466": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7465"
      },
      "isolates/4095163606998683-7465": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7464"
      },
      "isolates/4095163606998683-7464": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7463"
      },
      "isolates/4095163606998683-7463": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7462"
      },
      "isolates/4095163606998683-7462": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7461"
      },
      "isolates/4095163606998683-7461": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7460"
      },
      "isolates/4095163606998683-7460": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7459"
      },
      "isolates/4095163606998683-7459": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7458"
      },
      "isolates/4095163606998683-7458": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7457"
      },
      "isolates/4095163606998683-7457": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7456"
      },
      "isolates/4095163606998683-7456": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7455"
      },
      "isolates/4095163606998683-7455": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7454"
      },
      "isolates/4095163606998683-7454": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7453"
      },
      "isolates/4095163606998683-7453": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7452"
      },
      "isolates/4095163606998683-7452": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7451"
      },
      "isolates/4095163606998683-7451": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7450"
      },
      "isolates/4095163606998683-7450": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7449"
      },
      "isolates/4095163606998683-7449": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7448"
      },
      "isolates/4095163606998683-7448": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7447"
      },
      "isolates/4095163606998683-7447": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7446"
      },
      "isolates/4095163606998683-7446": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7445"
      },
      "isolates/4095163606998683-7445": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7444"
      },
      "isolates/4095163606998683-7444": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7443"
      },
      "isolates/4095163606998683-7443": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7442"
      },
      "isolates/4095163606998683-7442": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7441"
      },
      "isolates/4095163606998683-7441": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7440"
      },
      "isolates/4095163606998683-7440": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7439"
      },
      "isolates/4095163606998683-7439": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7438"
      },
      "isolates/4095163606998683-7438": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7437"
      },
      "isolates/4095163606998683-7437": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7436"
      },
      "isolates/4095163606998683-7436": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7435"
      },
      "isolates/4095163606998683-7435": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7434"
      },
      "isolates/4095163606998683-7434": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7433"
      },
      "isolates/4095163606998683-7433": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7432"
      },
      "isolates/4095163606998683-7432": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7431"
      },
      "isolates/4095163606998683-7431": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7430"
      },
      "isolates/4095163606998683-7430": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7429"
      },
      "isolates/4095163606998683-7429": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7428"
      },
      "isolates/4095163606998683-7428": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7427"
      },
      "isolates/4095163606998683-7427": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7426"
      },
      "isolates/4095163606998683-7426": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7425"
      },
      "isolates/4095163606998683-7425": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7424"
      },
      "isolates/4095163606998683-7424": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7423"
      },
      "isolates/4095163606998683-7423": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7422"
      },
      "isolates/4095163606998683-7422": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7421"
      },
      "isolates/4095163606998683-7421": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7420"
      },
      "isolates/4095163606998683-7420": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7419"
      },
      "isolates/4095163606998683-7419": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7418"
      },
      "isolates/4095163606998683-7418": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7417"
      },
      "isolates/4095163606998683-7417": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7416"
      },
      "isolates/4095163606998683-7416": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7415"
      },
      "isolates/4095163606998683-7415": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7414"
      },
      "isolates/4095163606998683-7414": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7413"
      },
      "isolates/4095163606998683-7413": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7412"
      },
      "isolates/4095163606998683-7412": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7411"
      },
      "isolates/4095163606998683-7411": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7410"
      },
      "isolates/4095163606998683-7410": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7409"
      },
      "isolates/4095163606998683-7409": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7408"
      },
      "isolates/4095163606998683-7408": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7407"
      },
      "isolates/4095163606998683-7407": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7406"
      },
      "isolates/4095163606998683-7406": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7405"
      },
      "isolates/4095163606998683-7405": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7404"
      },
      "isolates/4095163606998683-7404": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7403"
      },
      "isolates/4095163606998683-7403": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7402"
      },
      "isolates/4095163606998683-7402": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7401"
      },
      "isolates/4095163606998683-7401": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7400"
      },
      "isolates/4095163606998683-7400": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7399"
      },
      "isolates/4095163606998683-7399": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7398"
      },
      "isolates/4095163606998683-7398": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7397"
      },
      "isolates/4095163606998683-7397": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7396"
      },
      "isolates/4095163606998683-7396": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7395"
      },
      "isolates/4095163606998683-7395": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7394"
      },
      "isolates/4095163606998683-7394": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7393"
      },
      "isolates/4095163606998683-7393": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7392"
      },
      "isolates/4095163606998683-7392": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7391"
      },
      "isolates/4095163606998683-7391": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7390"
      },
      "isolates/4095163606998683-7390": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7389"
      },
      "isolates/4095163606998683-7389": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7388"
      },
      "isolates/4095163606998683-7388": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7387"
      },
      "isolates/4095163606998683-7387": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7386"
      },
      "isolates/4095163606998683-7386": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7385"
      },
      "isolates/4095163606998683-7385": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7384"
      },
      "isolates/4095163606998683-7384": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7383"
      },
      "isolates/4095163606998683-7383": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7382"
      },
      "isolates/4095163606998683-7382": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7381"
      },
      "isolates/4095163606998683-7381": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7380"
      },
      "isolates/4095163606998683-7380": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7379"
      },
      "isolates/4095163606998683-7379": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-6052": {
        "name": "EdgeInsets.EdgeInsets.symmetric",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/painting/edge_insets.dart",
        "packageUri": "package:flutter/src/painting/edge_insets.dart",
        "sourceLine": 392,
        "parent": "isolates/4095163606998683-6051"
      },
      "isolates/4095163606998683-6051": {
        "name": "_StudyWrapperState.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/gallery/lib/pages/home.dart",
        "packageUri": "package:gallery/pages/home.dart",
        "sourceLine": 1159,
        "parent": "isolates/4095163606998683-6050"
      },
      "isolates/4095163606998683-6050": {
        "name": "StatefulElement.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5591,
        "parent": "isolates/4095163606998683-6049"
      },
      "isolates/4095163606998683-6049": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6048"
      },
      "isolates/4095163606998683-6048": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6047"
      },
      "isolates/4095163606998683-6047": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6046"
      },
      "isolates/4095163606998683-6046": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6045"
      },
      "isolates/4095163606998683-6045": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6037"
      },
      "isolates/4095163606998683-6037": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6036"
      },
      "isolates/4095163606998683-6036": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6035"
      },
      "isolates/4095163606998683-6035": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6034"
      },
      "isolates/4095163606998683-6034": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6033"
      },
      "isolates/4095163606998683-6033": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6032"
      },
      "isolates/4095163606998683-6032": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6031"
      },
      "isolates/4095163606998683-6031": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6030"
      },
      "isolates/4095163606998683-6030": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6029"
      },
      "isolates/4095163606998683-6029": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6028"
      },
      "isolates/4095163606998683-6028": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6027"
      },
      "isolates/4095163606998683-6027": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6026"
      },
      "isolates/4095163606998683-6026": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6025"
      },
      "isolates/4095163606998683-6025": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6024"
      },
      "isolates/4095163606998683-6024": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6023"
      },
      "isolates/4095163606998683-6023": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6022"
      },
      "isolates/4095163606998683-6022": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6021"
      },
      "isolates/4095163606998683-6021": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6020"
      },
      "isolates/4095163606998683-6020": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6019"
      },
      "isolates/4095163606998683-6019": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6018"
      },
      "isolates/4095163606998683-6018": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6017"
      },
      "isolates/4095163606998683-6017": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6016"
      },
      "isolates/4095163606998683-6016": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6015"
      },
      "isolates/4095163606998683-6015": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6014"
      },
      "isolates/4095163606998683-6014": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6013"
      },
      "isolates/4095163606998683-6013": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6012"
      },
      "isolates/4095163606998683-6012": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6011"
      },
      "isolates/4095163606998683-6011": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6010"
      },
      "isolates/4095163606998683-6010": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6009"
      },
      "isolates/4095163606998683-6009": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6008"
      },
      "isolates/4095163606998683-6008": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6007"
      },
      "isolates/4095163606998683-6007": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6006"
      },
      "isolates/4095163606998683-6006": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6005"
      },
      "isolates/4095163606998683-6005": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6004"
      },
      "isolates/4095163606998683-6004": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6003"
      },
      "isolates/4095163606998683-6003": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6002"
      },
      "isolates/4095163606998683-6002": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6001"
      },
      "isolates/4095163606998683-6001": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6000"
      },
      "isolates/4095163606998683-6000": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5999"
      },
      "isolates/4095163606998683-5999": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5998"
      },
      "isolates/4095163606998683-5998": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5997"
      },
      "isolates/4095163606998683-5997": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5996"
      },
      "isolates/4095163606998683-5996": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5995"
      },
      "isolates/4095163606998683-5995": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5994"
      },
      "isolates/4095163606998683-5994": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5993"
      },
      "isolates/4095163606998683-5993": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5992"
      },
      "isolates/4095163606998683-5992": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5991"
      },
      "isolates/4095163606998683-5991": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5990"
      },
      "isolates/4095163606998683-5990": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5989"
      },
      "isolates/4095163606998683-5989": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5988"
      },
      "isolates/4095163606998683-5988": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5987"
      },
      "isolates/4095163606998683-5987": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5986"
      },
      "isolates/4095163606998683-5986": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5985"
      },
      "isolates/4095163606998683-5985": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5984"
      },
      "isolates/4095163606998683-5984": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5983"
      },
      "isolates/4095163606998683-5983": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5982"
      },
      "isolates/4095163606998683-5982": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5981"
      },
      "isolates/4095163606998683-5981": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5980"
      },
      "isolates/4095163606998683-5980": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5979"
      },
      "isolates/4095163606998683-5979": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5978"
      },
      "isolates/4095163606998683-5978": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5977"
      },
      "isolates/4095163606998683-5977": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5976"
      },
      "isolates/4095163606998683-5976": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5975"
      },
      "isolates/4095163606998683-5975": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5974"
      },
      "isolates/4095163606998683-5974": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5973"
      },
      "isolates/4095163606998683-5973": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5972"
      },
      "isolates/4095163606998683-5972": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5971"
      },
      "isolates/4095163606998683-5971": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5970"
      },
      "isolates/4095163606998683-5970": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5969"
      },
      "isolates/4095163606998683-5969": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5968"
      },
      "isolates/4095163606998683-5968": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5967"
      },
      "isolates/4095163606998683-5967": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5966"
      },
      "isolates/4095163606998683-5966": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5965"
      },
      "isolates/4095163606998683-5965": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5964"
      },
      "isolates/4095163606998683-5964": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5963"
      },
      "isolates/4095163606998683-5963": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5962"
      },
      "isolates/4095163606998683-5962": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5961"
      },
      "isolates/4095163606998683-5961": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5960"
      },
      "isolates/4095163606998683-5960": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5959"
      },
      "isolates/4095163606998683-5959": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5958"
      },
      "isolates/4095163606998683-5958": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5957"
      },
      "isolates/4095163606998683-5957": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5956"
      },
      "isolates/4095163606998683-5956": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5955"
      },
      "isolates/4095163606998683-5955": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5954"
      },
      "isolates/4095163606998683-5954": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5953"
      },
      "isolates/4095163606998683-5953": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5952"
      },
      "isolates/4095163606998683-5952": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5951"
      },
      "isolates/4095163606998683-5951": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5950"
      },
      "isolates/4095163606998683-5950": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5949"
      },
      "isolates/4095163606998683-5949": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5948"
      },
      "isolates/4095163606998683-5948": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5947"
      },
      "isolates/4095163606998683-5947": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5946"
      },
      "isolates/4095163606998683-5946": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5945"
      },
      "isolates/4095163606998683-5945": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5944"
      },
      "isolates/4095163606998683-5944": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5943"
      },
      "isolates/4095163606998683-5943": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5942"
      },
      "isolates/4095163606998683-5942": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5941"
      },
      "isolates/4095163606998683-5941": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5940"
      },
      "isolates/4095163606998683-5940": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5939"
      },
      "isolates/4095163606998683-5939": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5938"
      },
      "isolates/4095163606998683-5938": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5937"
      },
      "isolates/4095163606998683-5937": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5936"
      },
      "isolates/4095163606998683-5936": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5935"
      },
      "isolates/4095163606998683-5935": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5934"
      },
      "isolates/4095163606998683-5934": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5933"
      },
      "isolates/4095163606998683-5933": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5932"
      },
      "isolates/4095163606998683-5932": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5931"
      },
      "isolates/4095163606998683-5931": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5930"
      },
      "isolates/4095163606998683-5930": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5929"
      },
      "isolates/4095163606998683-5929": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5928"
      },
      "isolates/4095163606998683-5928": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5927"
      },
      "isolates/4095163606998683-5927": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5926"
      },
      "isolates/4095163606998683-5926": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5925"
      },
      "isolates/4095163606998683-5925": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5924"
      },
      "isolates/4095163606998683-5924": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5923"
      },
      "isolates/4095163606998683-5923": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5922"
      },
      "isolates/4095163606998683-5922": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5921"
      },
      "isolates/4095163606998683-5921": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5560"
      },
      "isolates/4095163606998683-5560": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5194"
      },
      "isolates/4095163606998683-5194": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5065"
      },
      "isolates/4095163606998683-5065": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-6894": {
        "name": "RenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6440,
        "parent": "isolates/4095163606998683-6893"
      },
      "isolates/4095163606998683-6893": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6892"
      },
      "isolates/4095163606998683-6892": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6891"
      },
      "isolates/4095163606998683-6891": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-6890"
      },
      "isolates/4095163606998683-6890": {
        "name": "MultiChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6898,
        "parent": "isolates/4095163606998683-6889"
      },
      "isolates/4095163606998683-6889": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6888"
      },
      "isolates/4095163606998683-6888": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6887"
      },
      "isolates/4095163606998683-6887": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6886"
      },
      "isolates/4095163606998683-6886": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6885"
      },
      "isolates/4095163606998683-6885": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6884"
      },
      "isolates/4095163606998683-6884": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6883"
      },
      "isolates/4095163606998683-6883": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6882"
      },
      "isolates/4095163606998683-6882": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6881"
      },
      "isolates/4095163606998683-6881": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6880"
      },
      "isolates/4095163606998683-6880": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6879"
      },
      "isolates/4095163606998683-6879": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6878"
      },
      "isolates/4095163606998683-6878": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6877"
      },
      "isolates/4095163606998683-6877": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6876"
      },
      "isolates/4095163606998683-6876": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6875"
      },
      "isolates/4095163606998683-6875": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6874"
      },
      "isolates/4095163606998683-6874": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6873"
      },
      "isolates/4095163606998683-6873": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6872"
      },
      "isolates/4095163606998683-6872": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6871"
      },
      "isolates/4095163606998683-6871": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6870"
      },
      "isolates/4095163606998683-6870": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6869"
      },
      "isolates/4095163606998683-6869": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6868"
      },
      "isolates/4095163606998683-6868": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6867"
      },
      "isolates/4095163606998683-6867": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6866"
      },
      "isolates/4095163606998683-6866": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6865"
      },
      "isolates/4095163606998683-6865": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6864"
      },
      "isolates/4095163606998683-6864": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6863"
      },
      "isolates/4095163606998683-6863": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6862"
      },
      "isolates/4095163606998683-6862": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6861"
      },
      "isolates/4095163606998683-6861": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6860"
      },
      "isolates/4095163606998683-6860": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6859"
      },
      "isolates/4095163606998683-6859": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6858"
      },
      "isolates/4095163606998683-6858": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6857"
      },
      "isolates/4095163606998683-6857": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6856"
      },
      "isolates/4095163606998683-6856": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6855"
      },
      "isolates/4095163606998683-6855": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6854"
      },
      "isolates/4095163606998683-6854": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6853"
      },
      "isolates/4095163606998683-6853": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6852"
      },
      "isolates/4095163606998683-6852": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6851"
      },
      "isolates/4095163606998683-6851": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6850"
      },
      "isolates/4095163606998683-6850": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6849"
      },
      "isolates/4095163606998683-6849": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6848"
      },
      "isolates/4095163606998683-6848": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6847"
      },
      "isolates/4095163606998683-6847": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6846"
      },
      "isolates/4095163606998683-6846": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6845"
      },
      "isolates/4095163606998683-6845": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6844"
      },
      "isolates/4095163606998683-6844": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6843"
      },
      "isolates/4095163606998683-6843": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6842"
      },
      "isolates/4095163606998683-6842": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6841"
      },
      "isolates/4095163606998683-6841": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6840"
      },
      "isolates/4095163606998683-6840": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6839"
      },
      "isolates/4095163606998683-6839": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6838"
      },
      "isolates/4095163606998683-6838": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6837"
      },
      "isolates/4095163606998683-6837": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6836"
      },
      "isolates/4095163606998683-6836": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6835"
      },
      "isolates/4095163606998683-6835": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6834"
      },
      "isolates/4095163606998683-6834": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6833"
      },
      "isolates/4095163606998683-6833": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6832"
      },
      "isolates/4095163606998683-6832": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6831"
      },
      "isolates/4095163606998683-6831": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6830"
      },
      "isolates/4095163606998683-6830": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6829"
      },
      "isolates/4095163606998683-6829": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6828"
      },
      "isolates/4095163606998683-6828": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6827"
      },
      "isolates/4095163606998683-6827": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6826"
      },
      "isolates/4095163606998683-6826": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6825"
      },
      "isolates/4095163606998683-6825": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6824"
      },
      "isolates/4095163606998683-6824": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6823"
      },
      "isolates/4095163606998683-6823": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6822"
      },
      "isolates/4095163606998683-6822": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6821"
      },
      "isolates/4095163606998683-6821": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6820"
      },
      "isolates/4095163606998683-6820": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6819"
      },
      "isolates/4095163606998683-6819": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6818"
      },
      "isolates/4095163606998683-6818": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6817"
      },
      "isolates/4095163606998683-6817": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6816"
      },
      "isolates/4095163606998683-6816": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6815"
      },
      "isolates/4095163606998683-6815": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6814"
      },
      "isolates/4095163606998683-6814": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6813"
      },
      "isolates/4095163606998683-6813": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6812"
      },
      "isolates/4095163606998683-6812": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6811"
      },
      "isolates/4095163606998683-6811": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6810"
      },
      "isolates/4095163606998683-6810": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6809"
      },
      "isolates/4095163606998683-6809": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6808"
      },
      "isolates/4095163606998683-6808": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6807"
      },
      "isolates/4095163606998683-6807": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6806"
      },
      "isolates/4095163606998683-6806": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6805"
      },
      "isolates/4095163606998683-6805": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6804"
      },
      "isolates/4095163606998683-6804": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6803"
      },
      "isolates/4095163606998683-6803": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6802"
      },
      "isolates/4095163606998683-6802": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6801"
      },
      "isolates/4095163606998683-6801": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6800"
      },
      "isolates/4095163606998683-6800": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6799"
      },
      "isolates/4095163606998683-6799": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6798"
      },
      "isolates/4095163606998683-6798": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6797"
      },
      "isolates/4095163606998683-6797": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6796"
      },
      "isolates/4095163606998683-6796": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6795"
      },
      "isolates/4095163606998683-6795": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6794"
      },
      "isolates/4095163606998683-6794": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6793"
      },
      "isolates/4095163606998683-6793": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6792"
      },
      "isolates/4095163606998683-6792": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6791"
      },
      "isolates/4095163606998683-6791": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6790"
      },
      "isolates/4095163606998683-6790": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6789"
      },
      "isolates/4095163606998683-6789": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6788"
      },
      "isolates/4095163606998683-6788": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6787"
      },
      "isolates/4095163606998683-6787": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6786"
      },
      "isolates/4095163606998683-6786": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6785"
      },
      "isolates/4095163606998683-6785": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6784"
      },
      "isolates/4095163606998683-6784": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6783"
      },
      "isolates/4095163606998683-6783": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6782"
      },
      "isolates/4095163606998683-6782": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6781"
      },
      "isolates/4095163606998683-6781": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6780"
      },
      "isolates/4095163606998683-6780": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6779"
      },
      "isolates/4095163606998683-6779": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6778"
      },
      "isolates/4095163606998683-6778": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6777"
      },
      "isolates/4095163606998683-6777": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6776"
      },
      "isolates/4095163606998683-6776": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6775"
      },
      "isolates/4095163606998683-6775": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6774"
      },
      "isolates/4095163606998683-6774": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6773"
      },
      "isolates/4095163606998683-6773": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6772"
      },
      "isolates/4095163606998683-6772": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6771"
      },
      "isolates/4095163606998683-6771": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6770"
      },
      "isolates/4095163606998683-6770": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6769"
      },
      "isolates/4095163606998683-6769": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6768"
      },
      "isolates/4095163606998683-6768": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6767"
      },
      "isolates/4095163606998683-6767": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-5444": {
        "name": "ThemeData.floatingActionButtonTheme",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/theme_data.dart",
        "packageUri": "package:flutter/src/material/theme_data.dart",
        "sourceLine": 1408,
        "parent": "isolates/4095163606998683-5443"
      },
      "isolates/4095163606998683-5443": {
        "name": "FloatingActionButton.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/floating_action_button.dart",
        "packageUri":
            "package:flutter/src/material/floating_action_button.dart",
        "sourceLine": 484,
        "parent": "isolates/4095163606998683-5442"
      },
      "isolates/4095163606998683-5442": {
        "name": "StatelessElement.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5549,
        "parent": "isolates/4095163606998683-5441"
      },
      "isolates/4095163606998683-5441": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5440"
      },
      "isolates/4095163606998683-5440": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5439"
      },
      "isolates/4095163606998683-5439": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5438"
      },
      "isolates/4095163606998683-5438": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5437"
      },
      "isolates/4095163606998683-5437": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5436"
      },
      "isolates/4095163606998683-5436": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5435"
      },
      "isolates/4095163606998683-5435": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5434"
      },
      "isolates/4095163606998683-5434": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5433"
      },
      "isolates/4095163606998683-5433": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5432"
      },
      "isolates/4095163606998683-5432": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5431"
      },
      "isolates/4095163606998683-5431": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5430"
      },
      "isolates/4095163606998683-5430": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5429"
      },
      "isolates/4095163606998683-5429": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5428"
      },
      "isolates/4095163606998683-5428": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5427"
      },
      "isolates/4095163606998683-5427": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5426"
      },
      "isolates/4095163606998683-5426": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5425"
      },
      "isolates/4095163606998683-5425": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5424"
      },
      "isolates/4095163606998683-5424": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5423"
      },
      "isolates/4095163606998683-5423": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5422"
      },
      "isolates/4095163606998683-5422": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5421"
      },
      "isolates/4095163606998683-5421": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5420"
      },
      "isolates/4095163606998683-5420": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5419"
      },
      "isolates/4095163606998683-5419": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5418"
      },
      "isolates/4095163606998683-5418": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5417"
      },
      "isolates/4095163606998683-5417": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5416"
      },
      "isolates/4095163606998683-5416": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5415"
      },
      "isolates/4095163606998683-5415": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5414"
      },
      "isolates/4095163606998683-5414": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5413"
      },
      "isolates/4095163606998683-5413": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5412"
      },
      "isolates/4095163606998683-5412": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-5411"
      },
      "isolates/4095163606998683-5411": {
        "name": "MultiChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6898,
        "parent": "isolates/4095163606998683-5410"
      },
      "isolates/4095163606998683-5410": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5409"
      },
      "isolates/4095163606998683-5409": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5408"
      },
      "isolates/4095163606998683-5408": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5407"
      },
      "isolates/4095163606998683-5407": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5406"
      },
      "isolates/4095163606998683-5406": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5405"
      },
      "isolates/4095163606998683-5405": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5404"
      },
      "isolates/4095163606998683-5404": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5403"
      },
      "isolates/4095163606998683-5403": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5402"
      },
      "isolates/4095163606998683-5402": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5401"
      },
      "isolates/4095163606998683-5401": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5400"
      },
      "isolates/4095163606998683-5400": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5399"
      },
      "isolates/4095163606998683-5399": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5398"
      },
      "isolates/4095163606998683-5398": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5397"
      },
      "isolates/4095163606998683-5397": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5396"
      },
      "isolates/4095163606998683-5396": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5395"
      },
      "isolates/4095163606998683-5395": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5394"
      },
      "isolates/4095163606998683-5394": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5393"
      },
      "isolates/4095163606998683-5393": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5392"
      },
      "isolates/4095163606998683-5392": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5391"
      },
      "isolates/4095163606998683-5391": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5390"
      },
      "isolates/4095163606998683-5390": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5389"
      },
      "isolates/4095163606998683-5389": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5388"
      },
      "isolates/4095163606998683-5388": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5387"
      },
      "isolates/4095163606998683-5387": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5386"
      },
      "isolates/4095163606998683-5386": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5385"
      },
      "isolates/4095163606998683-5385": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5384"
      },
      "isolates/4095163606998683-5384": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5383"
      },
      "isolates/4095163606998683-5383": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5382"
      },
      "isolates/4095163606998683-5382": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5381"
      },
      "isolates/4095163606998683-5381": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5380"
      },
      "isolates/4095163606998683-5380": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5379"
      },
      "isolates/4095163606998683-5379": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5378"
      },
      "isolates/4095163606998683-5378": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5377"
      },
      "isolates/4095163606998683-5377": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5376"
      },
      "isolates/4095163606998683-5376": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5375"
      },
      "isolates/4095163606998683-5375": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5374"
      },
      "isolates/4095163606998683-5374": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5373"
      },
      "isolates/4095163606998683-5373": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5372"
      },
      "isolates/4095163606998683-5372": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5371"
      },
      "isolates/4095163606998683-5371": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5370"
      },
      "isolates/4095163606998683-5370": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5369"
      },
      "isolates/4095163606998683-5369": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5368"
      },
      "isolates/4095163606998683-5368": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5367"
      },
      "isolates/4095163606998683-5367": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5366"
      },
      "isolates/4095163606998683-5366": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5365"
      },
      "isolates/4095163606998683-5365": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5364"
      },
      "isolates/4095163606998683-5364": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5363"
      },
      "isolates/4095163606998683-5363": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5362"
      },
      "isolates/4095163606998683-5362": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5361"
      },
      "isolates/4095163606998683-5361": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5360"
      },
      "isolates/4095163606998683-5360": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5359"
      },
      "isolates/4095163606998683-5359": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5358"
      },
      "isolates/4095163606998683-5358": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5357"
      },
      "isolates/4095163606998683-5357": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5356"
      },
      "isolates/4095163606998683-5356": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5355"
      },
      "isolates/4095163606998683-5355": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5354"
      },
      "isolates/4095163606998683-5354": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5353"
      },
      "isolates/4095163606998683-5353": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5352"
      },
      "isolates/4095163606998683-5352": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5351"
      },
      "isolates/4095163606998683-5351": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5350"
      },
      "isolates/4095163606998683-5350": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5349"
      },
      "isolates/4095163606998683-5349": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5348"
      },
      "isolates/4095163606998683-5348": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5347"
      },
      "isolates/4095163606998683-5347": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5346"
      },
      "isolates/4095163606998683-5346": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5345"
      },
      "isolates/4095163606998683-5345": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5344"
      },
      "isolates/4095163606998683-5344": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5343"
      },
      "isolates/4095163606998683-5343": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5342"
      },
      "isolates/4095163606998683-5342": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5341"
      },
      "isolates/4095163606998683-5341": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5340"
      },
      "isolates/4095163606998683-5340": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5339"
      },
      "isolates/4095163606998683-5339": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5338"
      },
      "isolates/4095163606998683-5338": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5337"
      },
      "isolates/4095163606998683-5337": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5336"
      },
      "isolates/4095163606998683-5336": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5335"
      },
      "isolates/4095163606998683-5335": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5334"
      },
      "isolates/4095163606998683-5334": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5333"
      },
      "isolates/4095163606998683-5333": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5332"
      },
      "isolates/4095163606998683-5332": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5331"
      },
      "isolates/4095163606998683-5331": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5330"
      },
      "isolates/4095163606998683-5330": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5329"
      },
      "isolates/4095163606998683-5329": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5328"
      },
      "isolates/4095163606998683-5328": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5327"
      },
      "isolates/4095163606998683-5327": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5326"
      },
      "isolates/4095163606998683-5326": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5325"
      },
      "isolates/4095163606998683-5325": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5324"
      },
      "isolates/4095163606998683-5324": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5323"
      },
      "isolates/4095163606998683-5323": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5322"
      },
      "isolates/4095163606998683-5322": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5198"
      },
      "isolates/4095163606998683-5198": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5197"
      },
      "isolates/4095163606998683-5197": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5196"
      },
      "isolates/4095163606998683-5196": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5195"
      },
      "isolates/4095163606998683-5195": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5194"
      },
      "isolates/4095163606998683-8708": {
        "name": "_EffectiveMouseCursor.resolve",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/floating_action_button.dart",
        "packageUri":
            "package:flutter/src/material/floating_action_button.dart",
        "sourceLine": 645,
        "parent": "isolates/4095163606998683-8707"
      },
      "isolates/4095163606998683-8707": {
        "name": "MaterialStateProperty.resolveAs",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/material_state.dart",
        "packageUri": "package:flutter/src/material/material_state.dart",
        "sourceLine": 648,
        "parent": "isolates/4095163606998683-8706"
      },
      "isolates/4095163606998683-8706": {
        "name": "_RawMaterialButtonState.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/button.dart",
        "packageUri": "package:flutter/src/material/button.dart",
        "sourceLine": 344,
        "parent": "isolates/4095163606998683-8705"
      },
      "isolates/4095163606998683-8705": {
        "name": "StatefulElement.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5591,
        "parent": "isolates/4095163606998683-8704"
      },
      "isolates/4095163606998683-8704": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8703"
      },
      "isolates/4095163606998683-8703": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8702"
      },
      "isolates/4095163606998683-8702": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8701"
      },
      "isolates/4095163606998683-8701": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8700"
      },
      "isolates/4095163606998683-8700": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8699"
      },
      "isolates/4095163606998683-8699": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8698"
      },
      "isolates/4095163606998683-8698": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8697"
      },
      "isolates/4095163606998683-8697": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8696"
      },
      "isolates/4095163606998683-8696": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8695"
      },
      "isolates/4095163606998683-8695": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8694"
      },
      "isolates/4095163606998683-8694": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8693"
      },
      "isolates/4095163606998683-8693": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8692"
      },
      "isolates/4095163606998683-8692": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8691"
      },
      "isolates/4095163606998683-8691": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8690"
      },
      "isolates/4095163606998683-8690": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8689"
      },
      "isolates/4095163606998683-8689": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8688"
      },
      "isolates/4095163606998683-8688": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8687"
      },
      "isolates/4095163606998683-8687": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8686"
      },
      "isolates/4095163606998683-8686": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8685"
      },
      "isolates/4095163606998683-8685": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8684"
      },
      "isolates/4095163606998683-8684": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8683"
      },
      "isolates/4095163606998683-8683": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8682"
      },
      "isolates/4095163606998683-8682": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8681"
      },
      "isolates/4095163606998683-8681": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8680"
      },
      "isolates/4095163606998683-8680": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8679"
      },
      "isolates/4095163606998683-8679": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8678"
      },
      "isolates/4095163606998683-8678": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8677"
      },
      "isolates/4095163606998683-8677": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8676"
      },
      "isolates/4095163606998683-8676": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8675"
      },
      "isolates/4095163606998683-8675": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8674"
      },
      "isolates/4095163606998683-8674": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8673"
      },
      "isolates/4095163606998683-8673": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8672"
      },
      "isolates/4095163606998683-8672": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8671"
      },
      "isolates/4095163606998683-8671": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8670"
      },
      "isolates/4095163606998683-8670": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8669"
      },
      "isolates/4095163606998683-8669": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8668"
      },
      "isolates/4095163606998683-8668": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8667"
      },
      "isolates/4095163606998683-8667": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8666"
      },
      "isolates/4095163606998683-8666": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8665"
      },
      "isolates/4095163606998683-8665": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8664"
      },
      "isolates/4095163606998683-8664": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8663"
      },
      "isolates/4095163606998683-8663": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8662"
      },
      "isolates/4095163606998683-8662": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8661"
      },
      "isolates/4095163606998683-8661": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8660"
      },
      "isolates/4095163606998683-8660": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8659"
      },
      "isolates/4095163606998683-8659": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8658"
      },
      "isolates/4095163606998683-8658": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8657"
      },
      "isolates/4095163606998683-8657": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8656"
      },
      "isolates/4095163606998683-8656": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8655"
      },
      "isolates/4095163606998683-8655": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8654"
      },
      "isolates/4095163606998683-8654": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8653"
      },
      "isolates/4095163606998683-8653": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8652"
      },
      "isolates/4095163606998683-8652": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8651"
      },
      "isolates/4095163606998683-8651": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8650"
      },
      "isolates/4095163606998683-8650": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8649"
      },
      "isolates/4095163606998683-8649": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8648"
      },
      "isolates/4095163606998683-8648": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8647"
      },
      "isolates/4095163606998683-8647": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8646"
      },
      "isolates/4095163606998683-8646": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8645"
      },
      "isolates/4095163606998683-8645": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8644"
      },
      "isolates/4095163606998683-8644": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8643"
      },
      "isolates/4095163606998683-8643": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8642"
      },
      "isolates/4095163606998683-8642": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8641"
      },
      "isolates/4095163606998683-8641": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8640"
      },
      "isolates/4095163606998683-8640": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8639"
      },
      "isolates/4095163606998683-8639": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8638"
      },
      "isolates/4095163606998683-8638": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8637"
      },
      "isolates/4095163606998683-8637": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8636"
      },
      "isolates/4095163606998683-8636": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8635"
      },
      "isolates/4095163606998683-8635": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8634"
      },
      "isolates/4095163606998683-8634": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8633"
      },
      "isolates/4095163606998683-8633": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8632"
      },
      "isolates/4095163606998683-8632": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8631"
      },
      "isolates/4095163606998683-8631": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8630"
      },
      "isolates/4095163606998683-8630": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-8629"
      },
      "isolates/4095163606998683-8629": {
        "name": "MultiChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6898,
        "parent": "isolates/4095163606998683-8628"
      },
      "isolates/4095163606998683-8628": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8627"
      },
      "isolates/4095163606998683-8627": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8626"
      },
      "isolates/4095163606998683-8626": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8625"
      },
      "isolates/4095163606998683-8625": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8624"
      },
      "isolates/4095163606998683-8624": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8623"
      },
      "isolates/4095163606998683-8623": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8622"
      },
      "isolates/4095163606998683-8622": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8621"
      },
      "isolates/4095163606998683-8621": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8620"
      },
      "isolates/4095163606998683-8620": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8619"
      },
      "isolates/4095163606998683-8619": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8618"
      },
      "isolates/4095163606998683-8618": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8617"
      },
      "isolates/4095163606998683-8617": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8616"
      },
      "isolates/4095163606998683-8616": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8615"
      },
      "isolates/4095163606998683-8615": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8614"
      },
      "isolates/4095163606998683-8614": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8613"
      },
      "isolates/4095163606998683-8613": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8612"
      },
      "isolates/4095163606998683-8612": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8611"
      },
      "isolates/4095163606998683-8611": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8610"
      },
      "isolates/4095163606998683-8610": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8609"
      },
      "isolates/4095163606998683-8609": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8608"
      },
      "isolates/4095163606998683-8608": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8607"
      },
      "isolates/4095163606998683-8607": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8606"
      },
      "isolates/4095163606998683-8606": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8605"
      },
      "isolates/4095163606998683-8605": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8604"
      },
      "isolates/4095163606998683-8604": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8603"
      },
      "isolates/4095163606998683-8603": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8602"
      },
      "isolates/4095163606998683-8602": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8601"
      },
      "isolates/4095163606998683-8601": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8600"
      },
      "isolates/4095163606998683-8600": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8599"
      },
      "isolates/4095163606998683-8599": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8598"
      },
      "isolates/4095163606998683-8598": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8597"
      },
      "isolates/4095163606998683-8597": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8596"
      },
      "isolates/4095163606998683-8596": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8595"
      },
      "isolates/4095163606998683-8595": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8594"
      },
      "isolates/4095163606998683-8594": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8593"
      },
      "isolates/4095163606998683-8593": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8592"
      },
      "isolates/4095163606998683-8592": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8591"
      },
      "isolates/4095163606998683-8591": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8590"
      },
      "isolates/4095163606998683-8590": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8589"
      },
      "isolates/4095163606998683-8589": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8588"
      },
      "isolates/4095163606998683-8588": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8587"
      },
      "isolates/4095163606998683-8587": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8586"
      },
      "isolates/4095163606998683-8586": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8585"
      },
      "isolates/4095163606998683-8585": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8584"
      },
      "isolates/4095163606998683-8584": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8583"
      },
      "isolates/4095163606998683-8583": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8582"
      },
      "isolates/4095163606998683-8582": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8581"
      },
      "isolates/4095163606998683-8581": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-5805": {
        "name": "RenderObject.RenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/object.dart",
        "packageUri": "package:flutter/src/rendering/object.dart",
        "sourceLine": 1657,
        "parent": "isolates/4095163606998683-5804"
      },
      "isolates/4095163606998683-5804": {
        "name": "RenderBox.RenderBox",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-5803"
      },
      "isolates/4095163606998683-5803": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin._RenderProxyBox&RenderBox&RenderObjectWithChildMixin",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-5802"
      },
      "isolates/4095163606998683-5802": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin._RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-5801"
      },
      "isolates/4095163606998683-5801": {
        "name": "RenderProxyBox.RenderProxyBox",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 47,
        "parent": "isolates/4095163606998683-5800"
      },
      "isolates/4095163606998683-5800": {
        "name": "_RenderCustomClip._RenderCustomClip",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1378,
        "parent": "isolates/4095163606998683-5799"
      },
      "isolates/4095163606998683-5799": {
        "name": "_RenderPhysicalModelBase._RenderPhysicalModelBase",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 1845,
        "parent": "isolates/4095163606998683-5798"
      },
      "isolates/4095163606998683-5798": {
        "name": "RenderPhysicalShape.RenderPhysicalShape",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 2083,
        "parent": "isolates/4095163606998683-5797"
      },
      "isolates/4095163606998683-5797": {
        "name": "PhysicalShape.createRenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/basic.dart",
        "packageUri": "package:flutter/src/widgets/basic.dart",
        "sourceLine": 1224,
        "parent": "isolates/4095163606998683-5796"
      },
      "isolates/4095163606998683-5796": {
        "name": "RenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6440,
        "parent": "isolates/4095163606998683-5795"
      },
      "isolates/4095163606998683-5795": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5794"
      },
      "isolates/4095163606998683-5794": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5793"
      },
      "isolates/4095163606998683-5793": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5792"
      },
      "isolates/4095163606998683-5792": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5791"
      },
      "isolates/4095163606998683-5791": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5790"
      },
      "isolates/4095163606998683-5790": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5789"
      },
      "isolates/4095163606998683-5789": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5788"
      },
      "isolates/4095163606998683-5788": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5787"
      },
      "isolates/4095163606998683-5787": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5786"
      },
      "isolates/4095163606998683-5786": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5785"
      },
      "isolates/4095163606998683-5785": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5784"
      },
      "isolates/4095163606998683-5784": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5783"
      },
      "isolates/4095163606998683-5783": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5782"
      },
      "isolates/4095163606998683-5782": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5781"
      },
      "isolates/4095163606998683-5781": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5780"
      },
      "isolates/4095163606998683-5780": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5779"
      },
      "isolates/4095163606998683-5779": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5778"
      },
      "isolates/4095163606998683-5778": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5777"
      },
      "isolates/4095163606998683-5777": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5776"
      },
      "isolates/4095163606998683-5776": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5775"
      },
      "isolates/4095163606998683-5775": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5774"
      },
      "isolates/4095163606998683-5774": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5773"
      },
      "isolates/4095163606998683-5773": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5772"
      },
      "isolates/4095163606998683-5772": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5771"
      },
      "isolates/4095163606998683-5771": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5770"
      },
      "isolates/4095163606998683-5770": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5769"
      },
      "isolates/4095163606998683-5769": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5768"
      },
      "isolates/4095163606998683-5768": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5767"
      },
      "isolates/4095163606998683-5767": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5766"
      },
      "isolates/4095163606998683-5766": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5765"
      },
      "isolates/4095163606998683-5765": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5764"
      },
      "isolates/4095163606998683-5764": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5763"
      },
      "isolates/4095163606998683-5763": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5762"
      },
      "isolates/4095163606998683-5762": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5761"
      },
      "isolates/4095163606998683-5761": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5760"
      },
      "isolates/4095163606998683-5760": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5759"
      },
      "isolates/4095163606998683-5759": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5758"
      },
      "isolates/4095163606998683-5758": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5757"
      },
      "isolates/4095163606998683-5757": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5756"
      },
      "isolates/4095163606998683-5756": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5755"
      },
      "isolates/4095163606998683-5755": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5754"
      },
      "isolates/4095163606998683-5754": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5753"
      },
      "isolates/4095163606998683-5753": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5752"
      },
      "isolates/4095163606998683-5752": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5751"
      },
      "isolates/4095163606998683-5751": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5750"
      },
      "isolates/4095163606998683-5750": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5749"
      },
      "isolates/4095163606998683-5749": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5748"
      },
      "isolates/4095163606998683-5748": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5747"
      },
      "isolates/4095163606998683-5747": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5746"
      },
      "isolates/4095163606998683-5746": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5745"
      },
      "isolates/4095163606998683-5745": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5744"
      },
      "isolates/4095163606998683-5744": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5743"
      },
      "isolates/4095163606998683-5743": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5742"
      },
      "isolates/4095163606998683-5742": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5741"
      },
      "isolates/4095163606998683-5741": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5740"
      },
      "isolates/4095163606998683-5740": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5739"
      },
      "isolates/4095163606998683-5739": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5738"
      },
      "isolates/4095163606998683-5738": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5737"
      },
      "isolates/4095163606998683-5737": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5736"
      },
      "isolates/4095163606998683-5736": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5735"
      },
      "isolates/4095163606998683-5735": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5734"
      },
      "isolates/4095163606998683-5734": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5733"
      },
      "isolates/4095163606998683-5733": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5732"
      },
      "isolates/4095163606998683-5732": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5731"
      },
      "isolates/4095163606998683-5731": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5730"
      },
      "isolates/4095163606998683-5730": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5729"
      },
      "isolates/4095163606998683-5729": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5728"
      },
      "isolates/4095163606998683-5728": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5727"
      },
      "isolates/4095163606998683-5727": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5726"
      },
      "isolates/4095163606998683-5726": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5725"
      },
      "isolates/4095163606998683-5725": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5724"
      },
      "isolates/4095163606998683-5724": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5723"
      },
      "isolates/4095163606998683-5723": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5722"
      },
      "isolates/4095163606998683-5722": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5721"
      },
      "isolates/4095163606998683-5721": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5720"
      },
      "isolates/4095163606998683-5720": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5719"
      },
      "isolates/4095163606998683-5719": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5718"
      },
      "isolates/4095163606998683-5718": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5717"
      },
      "isolates/4095163606998683-5717": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5716"
      },
      "isolates/4095163606998683-5716": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5715"
      },
      "isolates/4095163606998683-5715": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5714"
      },
      "isolates/4095163606998683-5714": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5713"
      },
      "isolates/4095163606998683-5713": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5712"
      },
      "isolates/4095163606998683-5712": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5711"
      },
      "isolates/4095163606998683-5711": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5710"
      },
      "isolates/4095163606998683-5710": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5709"
      },
      "isolates/4095163606998683-5709": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5708"
      },
      "isolates/4095163606998683-5708": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5707"
      },
      "isolates/4095163606998683-5707": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5706"
      },
      "isolates/4095163606998683-5706": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5705"
      },
      "isolates/4095163606998683-5705": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5704"
      },
      "isolates/4095163606998683-5704": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5703"
      },
      "isolates/4095163606998683-5703": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5702"
      },
      "isolates/4095163606998683-5702": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5701"
      },
      "isolates/4095163606998683-5701": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5700"
      },
      "isolates/4095163606998683-5700": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5699"
      },
      "isolates/4095163606998683-5699": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5698"
      },
      "isolates/4095163606998683-5698": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5697"
      },
      "isolates/4095163606998683-5697": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5696"
      },
      "isolates/4095163606998683-5696": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5695"
      },
      "isolates/4095163606998683-5695": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5694"
      },
      "isolates/4095163606998683-5694": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5693"
      },
      "isolates/4095163606998683-5693": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-5692"
      },
      "isolates/4095163606998683-5692": {
        "name": "MultiChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6898,
        "parent": "isolates/4095163606998683-5691"
      },
      "isolates/4095163606998683-5691": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5690"
      },
      "isolates/4095163606998683-5690": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5689"
      },
      "isolates/4095163606998683-5689": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5688"
      },
      "isolates/4095163606998683-5688": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5687"
      },
      "isolates/4095163606998683-5687": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5686"
      },
      "isolates/4095163606998683-5686": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5565"
      },
      "isolates/4095163606998683-5565": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5564"
      },
      "isolates/4095163606998683-5564": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5563"
      },
      "isolates/4095163606998683-5563": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5562"
      },
      "isolates/4095163606998683-5562": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5561"
      },
      "isolates/4095163606998683-5561": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5560"
      },
      "isolates/4095163606998683-5685": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode&_LinkedHashMapMixin._insert",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 470,
        "parent": "isolates/4095163606998683-5684"
      },
      "isolates/4095163606998683-5684": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode&_LinkedHashMapMixin._set",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 518,
        "parent": "isolates/4095163606998683-5683"
      },
      "isolates/4095163606998683-5683": {
        "name":
            "__Map&_HashVMBase&MapMixin&_HashBase&_OperatorEqualsAndHashCode&_LinkedHashMapMixin.[]=",
        "category": "Dart",
        "resolvedUrl":
            "org-dartlang-sdk:///third_party/dart/sdk/lib/_internal/vm_shared/lib/compact_hash.dart",
        "packageUri": "dart:collection-patch/compact_hash.dart",
        "sourceLine": 513,
        "parent": "isolates/4095163606998683-5682"
      },
      "isolates/4095163606998683-5682": {
        "name": "HashedObserverList.add",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/observer_list.dart",
        "packageUri": "package:flutter/src/foundation/observer_list.dart",
        "sourceLine": 107,
        "parent": "isolates/4095163606998683-5681"
      },
      "isolates/4095163606998683-5681": {
        "name": "_HighlightModeManager.addListener",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/focus_manager.dart",
        "packageUri": "package:flutter/src/widgets/focus_manager.dart",
        "sourceLine": 1848,
        "parent": "isolates/4095163606998683-5680"
      },
      "isolates/4095163606998683-5680": {
        "name": "FocusManager.addHighlightModeListener",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/focus_manager.dart",
        "packageUri": "package:flutter/src/widgets/focus_manager.dart",
        "sourceLine": 1563,
        "parent": "isolates/4095163606998683-5679"
      },
      "isolates/4095163606998683-5679": {
        "name": "_InkResponseState.initState",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/ink_well.dart",
        "packageUri": "package:flutter/src/material/ink_well.dart",
        "sourceLine": 879,
        "parent": "isolates/4095163606998683-5678"
      },
      "isolates/4095163606998683-5678": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5677"
      },
      "isolates/4095163606998683-5677": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5676"
      },
      "isolates/4095163606998683-5676": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5675"
      },
      "isolates/4095163606998683-5675": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5674"
      },
      "isolates/4095163606998683-5674": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5673"
      },
      "isolates/4095163606998683-5673": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5672"
      },
      "isolates/4095163606998683-5672": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5671"
      },
      "isolates/4095163606998683-5671": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5670"
      },
      "isolates/4095163606998683-5670": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5669"
      },
      "isolates/4095163606998683-5669": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5668"
      },
      "isolates/4095163606998683-5668": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5667"
      },
      "isolates/4095163606998683-5667": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5666"
      },
      "isolates/4095163606998683-5666": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5665"
      },
      "isolates/4095163606998683-5665": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5664"
      },
      "isolates/4095163606998683-5664": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5663"
      },
      "isolates/4095163606998683-5663": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5662"
      },
      "isolates/4095163606998683-5662": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5661"
      },
      "isolates/4095163606998683-5661": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5660"
      },
      "isolates/4095163606998683-5660": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5659"
      },
      "isolates/4095163606998683-5659": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5658"
      },
      "isolates/4095163606998683-5658": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5657"
      },
      "isolates/4095163606998683-5657": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5656"
      },
      "isolates/4095163606998683-5656": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5655"
      },
      "isolates/4095163606998683-5655": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5654"
      },
      "isolates/4095163606998683-5654": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5653"
      },
      "isolates/4095163606998683-5653": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5652"
      },
      "isolates/4095163606998683-5652": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5651"
      },
      "isolates/4095163606998683-5651": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5650"
      },
      "isolates/4095163606998683-5650": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5649"
      },
      "isolates/4095163606998683-5649": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5648"
      },
      "isolates/4095163606998683-5648": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5647"
      },
      "isolates/4095163606998683-5647": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5646"
      },
      "isolates/4095163606998683-5646": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5645"
      },
      "isolates/4095163606998683-5645": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5644"
      },
      "isolates/4095163606998683-5644": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5643"
      },
      "isolates/4095163606998683-5643": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5642"
      },
      "isolates/4095163606998683-5642": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5641"
      },
      "isolates/4095163606998683-5641": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5640"
      },
      "isolates/4095163606998683-5640": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5639"
      },
      "isolates/4095163606998683-5639": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5638"
      },
      "isolates/4095163606998683-5638": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5637"
      },
      "isolates/4095163606998683-5637": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5636"
      },
      "isolates/4095163606998683-5636": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5635"
      },
      "isolates/4095163606998683-5635": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5634"
      },
      "isolates/4095163606998683-5634": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5633"
      },
      "isolates/4095163606998683-5633": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5632"
      },
      "isolates/4095163606998683-5632": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5631"
      },
      "isolates/4095163606998683-5631": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5630"
      },
      "isolates/4095163606998683-5630": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5629"
      },
      "isolates/4095163606998683-5629": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5628"
      },
      "isolates/4095163606998683-5628": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5627"
      },
      "isolates/4095163606998683-5627": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5626"
      },
      "isolates/4095163606998683-5626": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5625"
      },
      "isolates/4095163606998683-5625": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5624"
      },
      "isolates/4095163606998683-5624": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5623"
      },
      "isolates/4095163606998683-5623": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5622"
      },
      "isolates/4095163606998683-5622": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5621"
      },
      "isolates/4095163606998683-5621": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5620"
      },
      "isolates/4095163606998683-5620": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5619"
      },
      "isolates/4095163606998683-5619": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5618"
      },
      "isolates/4095163606998683-5618": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5617"
      },
      "isolates/4095163606998683-5617": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5616"
      },
      "isolates/4095163606998683-5616": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5615"
      },
      "isolates/4095163606998683-5615": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5614"
      },
      "isolates/4095163606998683-5614": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5613"
      },
      "isolates/4095163606998683-5613": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5612"
      },
      "isolates/4095163606998683-5612": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5611"
      },
      "isolates/4095163606998683-5611": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5610"
      },
      "isolates/4095163606998683-5610": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5609"
      },
      "isolates/4095163606998683-5609": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5608"
      },
      "isolates/4095163606998683-5608": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5607"
      },
      "isolates/4095163606998683-5607": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5606"
      },
      "isolates/4095163606998683-5606": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5605"
      },
      "isolates/4095163606998683-5605": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5604"
      },
      "isolates/4095163606998683-5604": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5603"
      },
      "isolates/4095163606998683-5603": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5602"
      },
      "isolates/4095163606998683-5602": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5601"
      },
      "isolates/4095163606998683-5601": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5600"
      },
      "isolates/4095163606998683-5600": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5599"
      },
      "isolates/4095163606998683-5599": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5598"
      },
      "isolates/4095163606998683-5598": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5597"
      },
      "isolates/4095163606998683-5597": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5596"
      },
      "isolates/4095163606998683-5596": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5595"
      },
      "isolates/4095163606998683-5595": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5594"
      },
      "isolates/4095163606998683-5594": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5593"
      },
      "isolates/4095163606998683-5593": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5592"
      },
      "isolates/4095163606998683-5592": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5591"
      },
      "isolates/4095163606998683-5591": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5590"
      },
      "isolates/4095163606998683-5590": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5589"
      },
      "isolates/4095163606998683-5589": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5588"
      },
      "isolates/4095163606998683-5588": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5587"
      },
      "isolates/4095163606998683-5587": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5586"
      },
      "isolates/4095163606998683-5586": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5585"
      },
      "isolates/4095163606998683-5585": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5584"
      },
      "isolates/4095163606998683-5584": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5583"
      },
      "isolates/4095163606998683-5583": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5582"
      },
      "isolates/4095163606998683-5582": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5581"
      },
      "isolates/4095163606998683-5581": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5580"
      },
      "isolates/4095163606998683-5580": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5579"
      },
      "isolates/4095163606998683-5579": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5578"
      },
      "isolates/4095163606998683-5578": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5577"
      },
      "isolates/4095163606998683-5577": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5576"
      },
      "isolates/4095163606998683-5576": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5575"
      },
      "isolates/4095163606998683-5575": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5574"
      },
      "isolates/4095163606998683-5574": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-5573"
      },
      "isolates/4095163606998683-5573": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-5572"
      },
      "isolates/4095163606998683-5572": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-5571"
      },
      "isolates/4095163606998683-5571": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-5570"
      },
      "isolates/4095163606998683-5570": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-5569"
      },
      "isolates/4095163606998683-5569": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-5568"
      },
      "isolates/4095163606998683-5568": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-5567"
      },
      "isolates/4095163606998683-5567": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-5566"
      },
      "isolates/4095163606998683-5566": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-5565"
      },
      "isolates/4095163606998683-6655": {
        "name": "MemoryAllocations.hasListeners",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/memory_allocations.dart",
        "packageUri": "package:flutter/src/foundation/memory_allocations.dart",
        "sourceLine": 206,
        "parent": "isolates/4095163606998683-6654"
      },
      "isolates/4095163606998683-6654": {
        "name": "MemoryAllocations.dispatchObjectCreated",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/foundation/memory_allocations.dart",
        "packageUri": "package:flutter/src/foundation/memory_allocations.dart",
        "sourceLine": 267,
        "parent": "isolates/4095163606998683-6653"
      },
      "isolates/4095163606998683-6653": {
        "name": "RenderObject.RenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/object.dart",
        "packageUri": "package:flutter/src/rendering/object.dart",
        "sourceLine": 1657,
        "parent": "isolates/4095163606998683-6652"
      },
      "isolates/4095163606998683-6652": {
        "name": "RenderBox.RenderBox",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/box.dart",
        "packageUri": "package:flutter/src/rendering/box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-6651"
      },
      "isolates/4095163606998683-6651": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin._RenderProxyBox&RenderBox&RenderObjectWithChildMixin",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-6650"
      },
      "isolates/4095163606998683-6650": {
        "name":
            "_RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin._RenderProxyBox&RenderBox&RenderObjectWithChildMixin&RenderProxyBoxMixin",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": null,
        "parent": "isolates/4095163606998683-6649"
      },
      "isolates/4095163606998683-6649": {
        "name": "RenderProxyBox.RenderProxyBox",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 47,
        "parent": "isolates/4095163606998683-6648"
      },
      "isolates/4095163606998683-6648": {
        "name": "RenderSemanticsAnnotations.RenderSemanticsAnnotations",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/proxy_box.dart",
        "packageUri": "package:flutter/src/rendering/proxy_box.dart",
        "sourceLine": 4112,
        "parent": "isolates/4095163606998683-6647"
      },
      "isolates/4095163606998683-6647": {
        "name": "Semantics.createRenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/basic.dart",
        "packageUri": "package:flutter/src/widgets/basic.dart",
        "sourceLine": 7321,
        "parent": "isolates/4095163606998683-6646"
      },
      "isolates/4095163606998683-6646": {
        "name": "RenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6440,
        "parent": "isolates/4095163606998683-6645"
      },
      "isolates/4095163606998683-6645": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6644"
      },
      "isolates/4095163606998683-6644": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6643"
      },
      "isolates/4095163606998683-6643": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6642"
      },
      "isolates/4095163606998683-6642": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6641"
      },
      "isolates/4095163606998683-6641": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6640"
      },
      "isolates/4095163606998683-6640": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6639"
      },
      "isolates/4095163606998683-6639": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6638"
      },
      "isolates/4095163606998683-6638": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6637"
      },
      "isolates/4095163606998683-6637": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6636"
      },
      "isolates/4095163606998683-6636": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6635"
      },
      "isolates/4095163606998683-6635": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6634"
      },
      "isolates/4095163606998683-6634": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6633"
      },
      "isolates/4095163606998683-6633": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6632"
      },
      "isolates/4095163606998683-6632": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6631"
      },
      "isolates/4095163606998683-6631": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6630"
      },
      "isolates/4095163606998683-6630": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6629"
      },
      "isolates/4095163606998683-6629": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6628"
      },
      "isolates/4095163606998683-6628": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6627"
      },
      "isolates/4095163606998683-6627": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6626"
      },
      "isolates/4095163606998683-6626": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6625"
      },
      "isolates/4095163606998683-6625": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6624"
      },
      "isolates/4095163606998683-6624": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6623"
      },
      "isolates/4095163606998683-6623": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6622"
      },
      "isolates/4095163606998683-6622": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6621"
      },
      "isolates/4095163606998683-6621": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6620"
      },
      "isolates/4095163606998683-6620": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6619"
      },
      "isolates/4095163606998683-6619": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6618"
      },
      "isolates/4095163606998683-6618": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6617"
      },
      "isolates/4095163606998683-6617": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6616"
      },
      "isolates/4095163606998683-6616": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6615"
      },
      "isolates/4095163606998683-6615": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6614"
      },
      "isolates/4095163606998683-6614": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6613"
      },
      "isolates/4095163606998683-6613": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6612"
      },
      "isolates/4095163606998683-6612": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6611"
      },
      "isolates/4095163606998683-6611": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6610"
      },
      "isolates/4095163606998683-6610": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6609"
      },
      "isolates/4095163606998683-6609": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6608"
      },
      "isolates/4095163606998683-6608": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6607"
      },
      "isolates/4095163606998683-6607": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6606"
      },
      "isolates/4095163606998683-6606": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6605"
      },
      "isolates/4095163606998683-6605": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6604"
      },
      "isolates/4095163606998683-6604": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6603"
      },
      "isolates/4095163606998683-6603": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6602"
      },
      "isolates/4095163606998683-6602": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6601"
      },
      "isolates/4095163606998683-6601": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6600"
      },
      "isolates/4095163606998683-6600": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6599"
      },
      "isolates/4095163606998683-6599": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6598"
      },
      "isolates/4095163606998683-6598": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6597"
      },
      "isolates/4095163606998683-6597": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6596"
      },
      "isolates/4095163606998683-6596": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6595"
      },
      "isolates/4095163606998683-6595": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6594"
      },
      "isolates/4095163606998683-6594": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6593"
      },
      "isolates/4095163606998683-6593": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6592"
      },
      "isolates/4095163606998683-6592": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6591"
      },
      "isolates/4095163606998683-6591": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6590"
      },
      "isolates/4095163606998683-6590": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6589"
      },
      "isolates/4095163606998683-6589": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6588"
      },
      "isolates/4095163606998683-6588": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6587"
      },
      "isolates/4095163606998683-6587": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6586"
      },
      "isolates/4095163606998683-6586": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6585"
      },
      "isolates/4095163606998683-6585": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6584"
      },
      "isolates/4095163606998683-6584": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6583"
      },
      "isolates/4095163606998683-6583": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6582"
      },
      "isolates/4095163606998683-6582": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6581"
      },
      "isolates/4095163606998683-6581": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6580"
      },
      "isolates/4095163606998683-6580": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6579"
      },
      "isolates/4095163606998683-6579": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6578"
      },
      "isolates/4095163606998683-6578": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6577"
      },
      "isolates/4095163606998683-6577": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6576"
      },
      "isolates/4095163606998683-6576": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6575"
      },
      "isolates/4095163606998683-6575": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6574"
      },
      "isolates/4095163606998683-6574": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6573"
      },
      "isolates/4095163606998683-6573": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6572"
      },
      "isolates/4095163606998683-6572": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6571"
      },
      "isolates/4095163606998683-6571": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6570"
      },
      "isolates/4095163606998683-6570": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6569"
      },
      "isolates/4095163606998683-6569": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6568"
      },
      "isolates/4095163606998683-6568": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6567"
      },
      "isolates/4095163606998683-6567": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6566"
      },
      "isolates/4095163606998683-6566": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6565"
      },
      "isolates/4095163606998683-6565": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6564"
      },
      "isolates/4095163606998683-6564": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6563"
      },
      "isolates/4095163606998683-6563": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6562"
      },
      "isolates/4095163606998683-6562": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6561"
      },
      "isolates/4095163606998683-6561": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6560"
      },
      "isolates/4095163606998683-6560": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6559"
      },
      "isolates/4095163606998683-6559": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6558"
      },
      "isolates/4095163606998683-6558": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6557"
      },
      "isolates/4095163606998683-6557": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6556"
      },
      "isolates/4095163606998683-6556": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6555"
      },
      "isolates/4095163606998683-6555": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6554"
      },
      "isolates/4095163606998683-6554": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6553"
      },
      "isolates/4095163606998683-6553": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6552"
      },
      "isolates/4095163606998683-6552": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6551"
      },
      "isolates/4095163606998683-6551": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6550"
      },
      "isolates/4095163606998683-6550": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6549"
      },
      "isolates/4095163606998683-6549": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6548"
      },
      "isolates/4095163606998683-6548": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6547"
      },
      "isolates/4095163606998683-6547": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6546"
      },
      "isolates/4095163606998683-6546": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6545"
      },
      "isolates/4095163606998683-6545": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6544"
      },
      "isolates/4095163606998683-6544": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-6543"
      },
      "isolates/4095163606998683-6543": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6542"
      },
      "isolates/4095163606998683-6542": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6541"
      },
      "isolates/4095163606998683-6541": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6540"
      },
      "isolates/4095163606998683-6540": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6539"
      },
      "isolates/4095163606998683-6539": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6538"
      },
      "isolates/4095163606998683-6538": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6537"
      },
      "isolates/4095163606998683-6537": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6536"
      },
      "isolates/4095163606998683-6536": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-6313"
      },
      "isolates/4095163606998683-6313": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-6312"
      },
      "isolates/4095163606998683-6312": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-6311"
      },
      "isolates/4095163606998683-6311": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-6310"
      },
      "isolates/4095163606998683-6310": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6309"
      },
      "isolates/4095163606998683-6309": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6308"
      },
      "isolates/4095163606998683-6308": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-6307"
      },
      "isolates/4095163606998683-6307": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-6181"
      },
      "isolates/4095163606998683-7378": {
        "name": "RawGestureDetectorState._syncAll",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/gesture_detector.dart",
        "packageUri": "package:flutter/src/widgets/gesture_detector.dart",
        "sourceLine": 1487,
        "parent": "isolates/4095163606998683-7377"
      },
      "isolates/4095163606998683-7377": {
        "name": "RawGestureDetectorState.initState",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/gesture_detector.dart",
        "packageUri": "package:flutter/src/widgets/gesture_detector.dart",
        "sourceLine": 1397,
        "parent": "isolates/4095163606998683-7376"
      },
      "isolates/4095163606998683-7376": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7375"
      },
      "isolates/4095163606998683-7375": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7374"
      },
      "isolates/4095163606998683-7374": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7373"
      },
      "isolates/4095163606998683-7373": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7372"
      },
      "isolates/4095163606998683-7372": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7371"
      },
      "isolates/4095163606998683-7371": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7370"
      },
      "isolates/4095163606998683-7370": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7369"
      },
      "isolates/4095163606998683-7369": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7368"
      },
      "isolates/4095163606998683-7368": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7367"
      },
      "isolates/4095163606998683-7367": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7366"
      },
      "isolates/4095163606998683-7366": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7365"
      },
      "isolates/4095163606998683-7365": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7364"
      },
      "isolates/4095163606998683-7364": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7363"
      },
      "isolates/4095163606998683-7363": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7362"
      },
      "isolates/4095163606998683-7362": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7361"
      },
      "isolates/4095163606998683-7361": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7360"
      },
      "isolates/4095163606998683-7360": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7359"
      },
      "isolates/4095163606998683-7359": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7358"
      },
      "isolates/4095163606998683-7358": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7357"
      },
      "isolates/4095163606998683-7357": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7356"
      },
      "isolates/4095163606998683-7356": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7355"
      },
      "isolates/4095163606998683-7355": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7354"
      },
      "isolates/4095163606998683-7354": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7353"
      },
      "isolates/4095163606998683-7353": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7352"
      },
      "isolates/4095163606998683-7352": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7351"
      },
      "isolates/4095163606998683-7351": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7350"
      },
      "isolates/4095163606998683-7350": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7349"
      },
      "isolates/4095163606998683-7349": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7348"
      },
      "isolates/4095163606998683-7348": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7347"
      },
      "isolates/4095163606998683-7347": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7346"
      },
      "isolates/4095163606998683-7346": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7345"
      },
      "isolates/4095163606998683-7345": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7344"
      },
      "isolates/4095163606998683-7344": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7343"
      },
      "isolates/4095163606998683-7343": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7342"
      },
      "isolates/4095163606998683-7342": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7341"
      },
      "isolates/4095163606998683-7341": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7340"
      },
      "isolates/4095163606998683-7340": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7339"
      },
      "isolates/4095163606998683-7339": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7338"
      },
      "isolates/4095163606998683-7338": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7337"
      },
      "isolates/4095163606998683-7337": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7336"
      },
      "isolates/4095163606998683-7336": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7335"
      },
      "isolates/4095163606998683-7335": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7334"
      },
      "isolates/4095163606998683-7334": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7333"
      },
      "isolates/4095163606998683-7333": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7332"
      },
      "isolates/4095163606998683-7332": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7331"
      },
      "isolates/4095163606998683-7331": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7330"
      },
      "isolates/4095163606998683-7330": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7329"
      },
      "isolates/4095163606998683-7329": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7328"
      },
      "isolates/4095163606998683-7328": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7327"
      },
      "isolates/4095163606998683-7327": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7326"
      },
      "isolates/4095163606998683-7326": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7325"
      },
      "isolates/4095163606998683-7325": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7324"
      },
      "isolates/4095163606998683-7324": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7323"
      },
      "isolates/4095163606998683-7323": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7322"
      },
      "isolates/4095163606998683-7322": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7321"
      },
      "isolates/4095163606998683-7321": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7320"
      },
      "isolates/4095163606998683-7320": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7319"
      },
      "isolates/4095163606998683-7319": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7318"
      },
      "isolates/4095163606998683-7318": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7317"
      },
      "isolates/4095163606998683-7317": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7316"
      },
      "isolates/4095163606998683-7316": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7315"
      },
      "isolates/4095163606998683-7315": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7314"
      },
      "isolates/4095163606998683-7314": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7313"
      },
      "isolates/4095163606998683-7313": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7312"
      },
      "isolates/4095163606998683-7312": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7311"
      },
      "isolates/4095163606998683-7311": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7310"
      },
      "isolates/4095163606998683-7310": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7309"
      },
      "isolates/4095163606998683-7309": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7308"
      },
      "isolates/4095163606998683-7308": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7307"
      },
      "isolates/4095163606998683-7307": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7306"
      },
      "isolates/4095163606998683-7306": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7305"
      },
      "isolates/4095163606998683-7305": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7304"
      },
      "isolates/4095163606998683-7304": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7303"
      },
      "isolates/4095163606998683-7303": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7302"
      },
      "isolates/4095163606998683-7302": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7301"
      },
      "isolates/4095163606998683-7301": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7300"
      },
      "isolates/4095163606998683-7300": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7299"
      },
      "isolates/4095163606998683-7299": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7298"
      },
      "isolates/4095163606998683-7298": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7297"
      },
      "isolates/4095163606998683-7297": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7296"
      },
      "isolates/4095163606998683-7296": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7295"
      },
      "isolates/4095163606998683-7295": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7294"
      },
      "isolates/4095163606998683-7294": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7293"
      },
      "isolates/4095163606998683-7293": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7292"
      },
      "isolates/4095163606998683-7292": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7291"
      },
      "isolates/4095163606998683-7291": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7290"
      },
      "isolates/4095163606998683-7290": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7289"
      },
      "isolates/4095163606998683-7289": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7288"
      },
      "isolates/4095163606998683-7288": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7287"
      },
      "isolates/4095163606998683-7287": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7286"
      },
      "isolates/4095163606998683-7286": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7285"
      },
      "isolates/4095163606998683-7285": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7284"
      },
      "isolates/4095163606998683-7284": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7283"
      },
      "isolates/4095163606998683-7283": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7282"
      },
      "isolates/4095163606998683-7282": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7281"
      },
      "isolates/4095163606998683-7281": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7280"
      },
      "isolates/4095163606998683-7280": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7279"
      },
      "isolates/4095163606998683-7279": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7278"
      },
      "isolates/4095163606998683-7278": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7277"
      },
      "isolates/4095163606998683-7277": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7276"
      },
      "isolates/4095163606998683-7276": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7275"
      },
      "isolates/4095163606998683-7275": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7274"
      },
      "isolates/4095163606998683-7274": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7273"
      },
      "isolates/4095163606998683-7273": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7272"
      },
      "isolates/4095163606998683-7272": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7271"
      },
      "isolates/4095163606998683-7271": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7270"
      },
      "isolates/4095163606998683-7270": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7269"
      },
      "isolates/4095163606998683-7269": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7268"
      },
      "isolates/4095163606998683-7268": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7267"
      },
      "isolates/4095163606998683-7267": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7266"
      },
      "isolates/4095163606998683-7266": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7265"
      },
      "isolates/4095163606998683-7265": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-7264"
      },
      "isolates/4095163606998683-7264": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7263"
      },
      "isolates/4095163606998683-7263": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7262"
      },
      "isolates/4095163606998683-7262": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7261"
      },
      "isolates/4095163606998683-7261": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-7260"
      },
      "isolates/4095163606998683-7260": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-7259"
      },
      "isolates/4095163606998683-7259": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-7258"
      },
      "isolates/4095163606998683-7258": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-7136"
      },
      "isolates/4095163606998683-7136": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7135"
      },
      "isolates/4095163606998683-7135": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7134"
      },
      "isolates/4095163606998683-7134": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7133"
      },
      "isolates/4095163606998683-7133": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-7132"
      },
      "isolates/4095163606998683-7132": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-6896"
      },
      "isolates/4095163606998683-6896": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-6895"
      },
      "isolates/4095163606998683-6895": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-8957": {
        "name": "MaterialLocalizationEn.backButtonTooltip",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter_localizations/lib/src/l10n/generated_material_localizations.dart",
        "packageUri":
            "package:flutter_localizations/src/l10n/generated_material_localizations.dart",
        "sourceLine": 7464,
        "parent": "isolates/4095163606998683-8956"
      },
      "isolates/4095163606998683-8956": {
        "name": "BackButtonIcon.build.<anonymous closure>",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/action_buttons.dart",
        "packageUri": "package:flutter/src/material/action_buttons.dart",
        "sourceLine": 159,
        "parent": "isolates/4095163606998683-8955"
      },
      "isolates/4095163606998683-8955": {
        "name": "_ActionIcon.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/material/action_buttons.dart",
        "packageUri": "package:flutter/src/material/action_buttons.dart",
        "sourceLine": 93,
        "parent": "isolates/4095163606998683-8954"
      },
      "isolates/4095163606998683-8954": {
        "name": "StatelessElement.build",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5549,
        "parent": "isolates/4095163606998683-8953"
      },
      "isolates/4095163606998683-8953": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8952"
      },
      "isolates/4095163606998683-8952": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8951"
      },
      "isolates/4095163606998683-8951": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8950"
      },
      "isolates/4095163606998683-8950": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8949"
      },
      "isolates/4095163606998683-8949": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8948"
      },
      "isolates/4095163606998683-8948": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8947"
      },
      "isolates/4095163606998683-8947": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8946"
      },
      "isolates/4095163606998683-8946": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8945"
      },
      "isolates/4095163606998683-8945": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8944"
      },
      "isolates/4095163606998683-8944": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8943"
      },
      "isolates/4095163606998683-8943": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8942"
      },
      "isolates/4095163606998683-8942": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8941"
      },
      "isolates/4095163606998683-8941": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8940"
      },
      "isolates/4095163606998683-8940": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8939"
      },
      "isolates/4095163606998683-8939": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8938"
      },
      "isolates/4095163606998683-8938": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8937"
      },
      "isolates/4095163606998683-8937": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8936"
      },
      "isolates/4095163606998683-8936": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-8935"
      },
      "isolates/4095163606998683-8935": {
        "name": "MultiChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6898,
        "parent": "isolates/4095163606998683-8934"
      },
      "isolates/4095163606998683-8934": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8933"
      },
      "isolates/4095163606998683-8933": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8932"
      },
      "isolates/4095163606998683-8932": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8931"
      },
      "isolates/4095163606998683-8931": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8930"
      },
      "isolates/4095163606998683-8930": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8929"
      },
      "isolates/4095163606998683-8929": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8928"
      },
      "isolates/4095163606998683-8928": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8927"
      },
      "isolates/4095163606998683-8927": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8926"
      },
      "isolates/4095163606998683-8926": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8925"
      },
      "isolates/4095163606998683-8925": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8924"
      },
      "isolates/4095163606998683-8924": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8923"
      },
      "isolates/4095163606998683-8923": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8922"
      },
      "isolates/4095163606998683-8922": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8921"
      },
      "isolates/4095163606998683-8921": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8920"
      },
      "isolates/4095163606998683-8920": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8919"
      },
      "isolates/4095163606998683-8919": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8918"
      },
      "isolates/4095163606998683-8918": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8917"
      },
      "isolates/4095163606998683-8917": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8916"
      },
      "isolates/4095163606998683-8916": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8915"
      },
      "isolates/4095163606998683-8915": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8914"
      },
      "isolates/4095163606998683-8914": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8913"
      },
      "isolates/4095163606998683-8913": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8912"
      },
      "isolates/4095163606998683-8912": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8911"
      },
      "isolates/4095163606998683-8911": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8910"
      },
      "isolates/4095163606998683-8910": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8909"
      },
      "isolates/4095163606998683-8909": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8908"
      },
      "isolates/4095163606998683-8908": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8907"
      },
      "isolates/4095163606998683-8907": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8906"
      },
      "isolates/4095163606998683-8906": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8905"
      },
      "isolates/4095163606998683-8905": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8904"
      },
      "isolates/4095163606998683-8904": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8903"
      },
      "isolates/4095163606998683-8903": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8902"
      },
      "isolates/4095163606998683-8902": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8901"
      },
      "isolates/4095163606998683-8901": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8900"
      },
      "isolates/4095163606998683-8900": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8899"
      },
      "isolates/4095163606998683-8899": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8898"
      },
      "isolates/4095163606998683-8898": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8897"
      },
      "isolates/4095163606998683-8897": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8896"
      },
      "isolates/4095163606998683-8896": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8895"
      },
      "isolates/4095163606998683-8895": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8894"
      },
      "isolates/4095163606998683-8894": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8893"
      },
      "isolates/4095163606998683-8893": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8892"
      },
      "isolates/4095163606998683-8892": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8891"
      },
      "isolates/4095163606998683-8891": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8890"
      },
      "isolates/4095163606998683-8890": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8889"
      },
      "isolates/4095163606998683-8889": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8888"
      },
      "isolates/4095163606998683-8888": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8887"
      },
      "isolates/4095163606998683-8887": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8886"
      },
      "isolates/4095163606998683-8886": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8885"
      },
      "isolates/4095163606998683-8885": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8884"
      },
      "isolates/4095163606998683-8884": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8883"
      },
      "isolates/4095163606998683-8883": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8882"
      },
      "isolates/4095163606998683-8882": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8881"
      },
      "isolates/4095163606998683-8881": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8880"
      },
      "isolates/4095163606998683-8880": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8879"
      },
      "isolates/4095163606998683-8879": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8878"
      },
      "isolates/4095163606998683-8878": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8877"
      },
      "isolates/4095163606998683-8877": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8876"
      },
      "isolates/4095163606998683-8876": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8875"
      },
      "isolates/4095163606998683-8875": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8874"
      },
      "isolates/4095163606998683-8874": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8873"
      },
      "isolates/4095163606998683-8873": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8872"
      },
      "isolates/4095163606998683-8872": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8871"
      },
      "isolates/4095163606998683-8871": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8870"
      },
      "isolates/4095163606998683-8870": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8869"
      },
      "isolates/4095163606998683-8869": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8868"
      },
      "isolates/4095163606998683-8868": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8867"
      },
      "isolates/4095163606998683-8867": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8866"
      },
      "isolates/4095163606998683-8866": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8865"
      },
      "isolates/4095163606998683-8865": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8864"
      },
      "isolates/4095163606998683-8864": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8863"
      },
      "isolates/4095163606998683-8863": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8862"
      },
      "isolates/4095163606998683-8862": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8861"
      },
      "isolates/4095163606998683-8861": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8860"
      },
      "isolates/4095163606998683-8860": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8859"
      },
      "isolates/4095163606998683-8859": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8858"
      },
      "isolates/4095163606998683-8858": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8857"
      },
      "isolates/4095163606998683-8857": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8856"
      },
      "isolates/4095163606998683-8856": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8855"
      },
      "isolates/4095163606998683-8855": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8854"
      },
      "isolates/4095163606998683-8854": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8853"
      },
      "isolates/4095163606998683-8853": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8852"
      },
      "isolates/4095163606998683-8852": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8851"
      },
      "isolates/4095163606998683-8851": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8850"
      },
      "isolates/4095163606998683-8850": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8849"
      },
      "isolates/4095163606998683-8849": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8848"
      },
      "isolates/4095163606998683-8848": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8847"
      },
      "isolates/4095163606998683-8847": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8846"
      },
      "isolates/4095163606998683-8846": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8845"
      },
      "isolates/4095163606998683-8845": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8844"
      },
      "isolates/4095163606998683-8844": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8843"
      },
      "isolates/4095163606998683-8843": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8842"
      },
      "isolates/4095163606998683-8842": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8841"
      },
      "isolates/4095163606998683-8841": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8840"
      },
      "isolates/4095163606998683-8840": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8839"
      },
      "isolates/4095163606998683-8839": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8838"
      },
      "isolates/4095163606998683-8838": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8837"
      },
      "isolates/4095163606998683-8837": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8836"
      },
      "isolates/4095163606998683-8836": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8835"
      },
      "isolates/4095163606998683-8835": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8834"
      },
      "isolates/4095163606998683-8834": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8833"
      },
      "isolates/4095163606998683-8833": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8832"
      },
      "isolates/4095163606998683-8832": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8831"
      },
      "isolates/4095163606998683-8831": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8830"
      },
      "isolates/4095163606998683-8830": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8829"
      },
      "isolates/4095163606998683-8829": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-8366": {
        "name": "_RenderParagraph&RenderBox&ContainerRenderObjectMixin.addAll",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/rendering/object.dart",
        "packageUri": "package:flutter/src/rendering/object.dart",
        "sourceLine": 4263,
        "parent": "isolates/4095163606998683-8365"
      },
      "isolates/4095163606998683-8365": {
        "name": "RichText.createRenderObject",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/basic.dart",
        "packageUri": "package:flutter/src/widgets/basic.dart",
        "sourceLine": 5875,
        "parent": "isolates/4095163606998683-8364"
      },
      "isolates/4095163606998683-8364": {
        "name": "RenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6440,
        "parent": "isolates/4095163606998683-8363"
      },
      "isolates/4095163606998683-8363": {
        "name": "MultiChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6898,
        "parent": "isolates/4095163606998683-8362"
      },
      "isolates/4095163606998683-8362": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8361"
      },
      "isolates/4095163606998683-8361": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8360"
      },
      "isolates/4095163606998683-8360": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8359"
      },
      "isolates/4095163606998683-8359": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8358"
      },
      "isolates/4095163606998683-8358": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8357"
      },
      "isolates/4095163606998683-8357": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8356"
      },
      "isolates/4095163606998683-8356": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8355"
      },
      "isolates/4095163606998683-8355": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8354"
      },
      "isolates/4095163606998683-8354": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8353"
      },
      "isolates/4095163606998683-8353": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8352"
      },
      "isolates/4095163606998683-8352": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8351"
      },
      "isolates/4095163606998683-8351": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8350"
      },
      "isolates/4095163606998683-8350": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8349"
      },
      "isolates/4095163606998683-8349": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8348"
      },
      "isolates/4095163606998683-8348": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8347"
      },
      "isolates/4095163606998683-8347": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8346"
      },
      "isolates/4095163606998683-8346": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8345"
      },
      "isolates/4095163606998683-8345": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8344"
      },
      "isolates/4095163606998683-8344": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8343"
      },
      "isolates/4095163606998683-8343": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8342"
      },
      "isolates/4095163606998683-8342": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8341"
      },
      "isolates/4095163606998683-8341": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8340"
      },
      "isolates/4095163606998683-8340": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8339"
      },
      "isolates/4095163606998683-8339": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8338"
      },
      "isolates/4095163606998683-8338": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8337"
      },
      "isolates/4095163606998683-8337": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8336"
      },
      "isolates/4095163606998683-8336": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8335"
      },
      "isolates/4095163606998683-8335": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8334"
      },
      "isolates/4095163606998683-8334": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8333"
      },
      "isolates/4095163606998683-8333": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8332"
      },
      "isolates/4095163606998683-8332": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8331"
      },
      "isolates/4095163606998683-8331": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8330"
      },
      "isolates/4095163606998683-8330": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8329"
      },
      "isolates/4095163606998683-8329": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8328"
      },
      "isolates/4095163606998683-8328": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8327"
      },
      "isolates/4095163606998683-8327": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8326"
      },
      "isolates/4095163606998683-8326": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8325"
      },
      "isolates/4095163606998683-8325": {
        "name": "MultiChildRenderObjectElement.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6891,
        "parent": "isolates/4095163606998683-8324"
      },
      "isolates/4095163606998683-8324": {
        "name": "MultiChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6898,
        "parent": "isolates/4095163606998683-8323"
      },
      "isolates/4095163606998683-8323": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8322"
      },
      "isolates/4095163606998683-8322": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8321"
      },
      "isolates/4095163606998683-8321": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8320"
      },
      "isolates/4095163606998683-8320": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8319"
      },
      "isolates/4095163606998683-8319": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8318"
      },
      "isolates/4095163606998683-8318": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8317"
      },
      "isolates/4095163606998683-8317": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8316"
      },
      "isolates/4095163606998683-8316": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8315"
      },
      "isolates/4095163606998683-8315": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8314"
      },
      "isolates/4095163606998683-8314": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8313"
      },
      "isolates/4095163606998683-8313": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8312"
      },
      "isolates/4095163606998683-8312": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8311"
      },
      "isolates/4095163606998683-8311": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8310"
      },
      "isolates/4095163606998683-8310": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8309"
      },
      "isolates/4095163606998683-8309": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8308"
      },
      "isolates/4095163606998683-8308": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8307"
      },
      "isolates/4095163606998683-8307": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8306"
      },
      "isolates/4095163606998683-8306": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8305"
      },
      "isolates/4095163606998683-8305": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8304"
      },
      "isolates/4095163606998683-8304": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8303"
      },
      "isolates/4095163606998683-8303": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8302"
      },
      "isolates/4095163606998683-8302": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8301"
      },
      "isolates/4095163606998683-8301": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8300"
      },
      "isolates/4095163606998683-8300": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8299"
      },
      "isolates/4095163606998683-8299": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8298"
      },
      "isolates/4095163606998683-8298": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8297"
      },
      "isolates/4095163606998683-8297": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8296"
      },
      "isolates/4095163606998683-8296": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8295"
      },
      "isolates/4095163606998683-8295": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8294"
      },
      "isolates/4095163606998683-8294": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8293"
      },
      "isolates/4095163606998683-8293": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8292"
      },
      "isolates/4095163606998683-8292": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8291"
      },
      "isolates/4095163606998683-8291": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8290"
      },
      "isolates/4095163606998683-8290": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8289"
      },
      "isolates/4095163606998683-8289": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8288"
      },
      "isolates/4095163606998683-8288": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8287"
      },
      "isolates/4095163606998683-8287": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8286"
      },
      "isolates/4095163606998683-8286": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8285"
      },
      "isolates/4095163606998683-8285": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8284"
      },
      "isolates/4095163606998683-8284": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8283"
      },
      "isolates/4095163606998683-8283": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8282"
      },
      "isolates/4095163606998683-8282": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8281"
      },
      "isolates/4095163606998683-8281": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8280"
      },
      "isolates/4095163606998683-8280": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8279"
      },
      "isolates/4095163606998683-8279": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8278"
      },
      "isolates/4095163606998683-8278": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8277"
      },
      "isolates/4095163606998683-8277": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8276"
      },
      "isolates/4095163606998683-8276": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8275"
      },
      "isolates/4095163606998683-8275": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8274"
      },
      "isolates/4095163606998683-8274": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8273"
      },
      "isolates/4095163606998683-8273": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8272"
      },
      "isolates/4095163606998683-8272": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8271"
      },
      "isolates/4095163606998683-8271": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8270"
      },
      "isolates/4095163606998683-8270": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8269"
      },
      "isolates/4095163606998683-8269": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8268"
      },
      "isolates/4095163606998683-8268": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8267"
      },
      "isolates/4095163606998683-8267": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8266"
      },
      "isolates/4095163606998683-8266": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8265"
      },
      "isolates/4095163606998683-8265": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8264"
      },
      "isolates/4095163606998683-8264": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8263"
      },
      "isolates/4095163606998683-8263": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8262"
      },
      "isolates/4095163606998683-8262": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8261"
      },
      "isolates/4095163606998683-8261": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8260"
      },
      "isolates/4095163606998683-8260": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8259"
      },
      "isolates/4095163606998683-8259": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8258"
      },
      "isolates/4095163606998683-8258": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8257"
      },
      "isolates/4095163606998683-8257": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8256"
      },
      "isolates/4095163606998683-8256": {
        "name": "SingleChildRenderObjectElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6755,
        "parent": "isolates/4095163606998683-8255"
      },
      "isolates/4095163606998683-8255": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8254"
      },
      "isolates/4095163606998683-8254": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8253"
      },
      "isolates/4095163606998683-8253": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8252"
      },
      "isolates/4095163606998683-8252": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8251"
      },
      "isolates/4095163606998683-8251": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8250"
      },
      "isolates/4095163606998683-8250": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-8249"
      },
      "isolates/4095163606998683-8249": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-8248"
      },
      "isolates/4095163606998683-8248": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-8247"
      },
      "isolates/4095163606998683-8247": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-8246"
      },
      "isolates/4095163606998683-8246": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-8245"
      },
      "isolates/4095163606998683-8245": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-8244"
      },
      "isolates/4095163606998683-8244": {
        "name": "ComponentElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5460,
        "parent": "isolates/4095163606998683-8243"
      },
      "isolates/4095163606998683-8243": {
        "name": "StatefulElement._firstBuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5608,
        "parent": "isolates/4095163606998683-8118"
      },
      "isolates/4095163606998683-8118": {
        "name": "ComponentElement.mount",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5451,
        "parent": "isolates/4095163606998683-7992"
      },
      "isolates/4095163606998683-7992": {
        "name": "Element.inflateWidget",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4286,
        "parent": "isolates/4095163606998683-7991"
      },
      "isolates/4095163606998683-7991": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-7990"
      },
      "isolates/4095163606998683-7990": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "cpuProfileRoot"
      },
      "isolates/4095163606998683-10907": {
        "name": "debugWidgetBuilderValue",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/debug.dart",
        "packageUri": "package:flutter/src/widgets/debug.dart",
        "sourceLine": 383,
        "parent": "isolates/4095163606998683-10799"
      },
      "isolates/4095163606998683-10799": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10798"
      },
      "isolates/4095163606998683-10798": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10797"
      },
      "isolates/4095163606998683-10797": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10794"
      },
      "isolates/4095163606998683-10794": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10444"
      },
      "isolates/4095163606998683-10895": {
        "name": "Element.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 4130,
        "parent": "isolates/4095163606998683-10894"
      },
      "isolates/4095163606998683-10894": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10893"
      },
      "isolates/4095163606998683-10893": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10885"
      },
      "isolates/4095163606998683-10885": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10884"
      },
      "isolates/4095163606998683-10884": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10883"
      },
      "isolates/4095163606998683-10883": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10882"
      },
      "isolates/4095163606998683-10882": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10881"
      },
      "isolates/4095163606998683-10881": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10880"
      },
      "isolates/4095163606998683-10880": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10879"
      },
      "isolates/4095163606998683-10879": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10870"
      },
      "isolates/4095163606998683-10870": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10869"
      },
      "isolates/4095163606998683-10869": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10868"
      },
      "isolates/4095163606998683-10868": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10867"
      },
      "isolates/4095163606998683-10867": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10866"
      },
      "isolates/4095163606998683-10866": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10865"
      },
      "isolates/4095163606998683-10865": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10864"
      },
      "isolates/4095163606998683-10864": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10863"
      },
      "isolates/4095163606998683-10863": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10862"
      },
      "isolates/4095163606998683-10862": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10861"
      },
      "isolates/4095163606998683-10861": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10860"
      },
      "isolates/4095163606998683-10860": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10859"
      },
      "isolates/4095163606998683-10859": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10858"
      },
      "isolates/4095163606998683-10858": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10857"
      },
      "isolates/4095163606998683-10857": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10856"
      },
      "isolates/4095163606998683-10856": {
        "name": "StatelessElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5552,
        "parent": "isolates/4095163606998683-10855"
      },
      "isolates/4095163606998683-10855": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10854"
      },
      "isolates/4095163606998683-10854": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10853"
      },
      "isolates/4095163606998683-10853": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10852"
      },
      "isolates/4095163606998683-10852": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10851"
      },
      "isolates/4095163606998683-10851": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10850"
      },
      "isolates/4095163606998683-10850": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10849"
      },
      "isolates/4095163606998683-10849": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10848"
      },
      "isolates/4095163606998683-10848": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10847"
      },
      "isolates/4095163606998683-10847": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10846"
      },
      "isolates/4095163606998683-10846": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10845"
      },
      "isolates/4095163606998683-10845": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10844"
      },
      "isolates/4095163606998683-10844": {
        "name": "_InheritedNotifierElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/inherited_notifier.dart",
        "packageUri": "package:flutter/src/widgets/inherited_notifier.dart",
        "sourceLine": 97,
        "parent": "isolates/4095163606998683-10843"
      },
      "isolates/4095163606998683-10843": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10842"
      },
      "isolates/4095163606998683-10842": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10841"
      },
      "isolates/4095163606998683-10841": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10840"
      },
      "isolates/4095163606998683-10840": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10839"
      },
      "isolates/4095163606998683-10839": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10838"
      },
      "isolates/4095163606998683-10838": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10837"
      },
      "isolates/4095163606998683-10837": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10836"
      },
      "isolates/4095163606998683-10836": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10835"
      },
      "isolates/4095163606998683-10835": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10834"
      },
      "isolates/4095163606998683-10834": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10833"
      },
      "isolates/4095163606998683-10833": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10832"
      },
      "isolates/4095163606998683-10832": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10831"
      },
      "isolates/4095163606998683-10831": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10830"
      },
      "isolates/4095163606998683-10830": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10829"
      },
      "isolates/4095163606998683-10829": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10828"
      },
      "isolates/4095163606998683-10828": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10827"
      },
      "isolates/4095163606998683-10827": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10826"
      },
      "isolates/4095163606998683-10826": {
        "name": "StatefulElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5637,
        "parent": "isolates/4095163606998683-10825"
      },
      "isolates/4095163606998683-10825": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10824"
      },
      "isolates/4095163606998683-10824": {
        "name": "StatefulElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5646,
        "parent": "isolates/4095163606998683-10823"
      },
      "isolates/4095163606998683-10823": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10822"
      },
      "isolates/4095163606998683-10822": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10821"
      },
      "isolates/4095163606998683-10821": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10820"
      },
      "isolates/4095163606998683-10820": {
        "name": "StatelessElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5552,
        "parent": "isolates/4095163606998683-10819"
      },
      "isolates/4095163606998683-10819": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10818"
      },
      "isolates/4095163606998683-10818": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10817"
      },
      "isolates/4095163606998683-10817": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10816"
      },
      "isolates/4095163606998683-10816": {
        "name": "StatelessElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5552,
        "parent": "isolates/4095163606998683-10815"
      },
      "isolates/4095163606998683-10815": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10814"
      },
      "isolates/4095163606998683-10814": {
        "name": "SingleChildRenderObjectElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 6761,
        "parent": "isolates/4095163606998683-10813"
      },
      "isolates/4095163606998683-10813": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10812"
      },
      "isolates/4095163606998683-10812": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10811"
      },
      "isolates/4095163606998683-10811": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10810"
      },
      "isolates/4095163606998683-10810": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10809"
      },
      "isolates/4095163606998683-10809": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10808"
      },
      "isolates/4095163606998683-10808": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5471,
        "parent": "isolates/4095163606998683-10807"
      },
      "isolates/4095163606998683-10807": {
        "name": "Element.rebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5169,
        "parent": "isolates/4095163606998683-10806"
      },
      "isolates/4095163606998683-10806": {
        "name": "ProxyElement.update",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 5802,
        "parent": "isolates/4095163606998683-10805"
      },
      "isolates/4095163606998683-10805": {
        "name": "Element.updateChild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/flutter/lib/src/widgets/framework.dart",
        "packageUri": "package:flutter/src/widgets/framework.dart",
        "sourceLine": 3764,
        "parent": "isolates/4095163606998683-10804"
      },
      "isolates/4095163606998683-10804": {
        "name": "ComponentElement.performRebuild",
        "category": "Dart",
        "resolvedUrl":
            "file:///Users/kenzieschmoll/develop/flutter/packages/fl