// Copyright 2024 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file or at https://developers.google.com/open-source/licenses/bsd.

import 'package:devtools_app/src/shared/memory/class_name.dart';
import 'package:devtools_app/src/shared/memory/classes.dart';
import 'package:devtools_app/src/shared/memory/heap_data.dart';
import 'package:vm_service/vm_service.dart';

import 'heap_graph_fakes.dart';

Future<HeapData> testHeapData([FakeHeapSnapshotGraph? graph]) async {
  final heapData = HeapData(
    graph ?? FakeHeapSnapshotGraph(),
    created: DateTime.now(),
  );
  await heapData.calculate;
  return heapData;
}

SingleClassData testClassData(
  HeapClassName className,
  List<int> indexes,
  HeapSnapshotGraph graph,
) {
  final result = SingleClassData(className: className);
  for (final index in indexes) {
    result.countInstance(
      graph,
      index: index,
      retainers: null,
      retainedSizes: null,
    );
  }
  return result;
}
